/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ContractActionCodesEnum {
    ACTION_A("action-a", "http://www.hl7.org/fhir/contractaction"),
    ACTION_B("action-b", "http://www.hl7.org/fhir/contractaction");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Contract Action Codes";
    private static Map<String, ContractActionCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ContractActionCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ContractActionCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ContractActionCodesEnum forCode(String theCode) {
        ContractActionCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ContractActionCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ContractActionCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ContractActionCodesEnum>>();
        for (ContractActionCodesEnum next : ContractActionCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ContractActionCodesEnum>(){

            public String toCodeString(ContractActionCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ContractActionCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ContractActionCodesEnum fromCodeString(String theCodeString) {
                return (ContractActionCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ContractActionCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ContractActionCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

