/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.dstu2.valueset.SupplyRequestStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="SupplyRequest", profile="http://hl7.org/fhir/profiles/SupplyRequest", id="supplyrequest")
public class SupplyRequest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="kind", path="SupplyRequest.kind", description="", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="identifier", path="SupplyRequest.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="SupplyRequest.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="patient", path="SupplyRequest.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="source", path="SupplyRequest.source", description="", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    @SearchParamDefinition(name="date", path="SupplyRequest.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="supplier", path="SupplyRequest.supplier", description="", type="reference")
    public static final String SP_SUPPLIER = "supplier";
    public static final ReferenceClientParam SUPPLIER = new ReferenceClientParam("supplier");
    public static final Include INCLUDE_PATIENT = new Include("SupplyRequest:patient");
    public static final Include INCLUDE_SOURCE = new Include("SupplyRequest:source");
    public static final Include INCLUDE_SUPPLIER = new Include("SupplyRequest:supplier");
    @Child(name="patient", order=0, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="A link to a resource representing the person whom the ordered item is for")
    private ResourceReferenceDt myPatient;
    @Child(name="source", order=1, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class, Patient.class})
    @Description(shortDefinition="", formalDefinition="The Practitioner , Organization or Patient who initiated this order for the supply")
    private ResourceReferenceDt mySource;
    @Child(name="date", type={DateTimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="When the request was made")
    private DateTimeDt myDate;
    @Child(name="identifier", type={IdentifierDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Unique identifier for this supply request")
    private IdentifierDt myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=4, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="Status of the supply request")
    private BoundCodeDt<SupplyRequestStatusEnum> myStatus;
    @Child(name="kind", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process")
    private CodeableConceptDt myKind;
    @Child(name="orderedItem", order=6, min=0, max=1, summary=false, modifier=false, type={Medication.class, Substance.class, Device.class})
    @Description(shortDefinition="", formalDefinition="The item that is requested to be supplied")
    private ResourceReferenceDt myOrderedItem;
    @Child(name="supplier", order=7, min=0, max=-1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="Who is intended to fulfill the request")
    private List<ResourceReferenceDt> mySupplier;
    @Child(name="reason", order=8, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, IResource.class})
    @Description(shortDefinition="", formalDefinition="Why the supply item was requested")
    private IDatatype myReason;
    @Child(name="when", order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="When the request should be fulfilled")
    private When myWhen;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPatient, this.mySource, this.myDate, this.myIdentifier, this.myStatus, this.myKind, this.myOrderedItem, this.mySupplier, this.myReason, this.myWhen});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPatient, this.mySource, this.myDate, this.myIdentifier, this.myStatus, this.myKind, this.myOrderedItem, this.mySupplier, this.myReason, this.myWhen});
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public SupplyRequest setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public SupplyRequest setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public SupplyRequest setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public SupplyRequest setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public SupplyRequest setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public SupplyRequest setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public BoundCodeDt<SupplyRequestStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(SupplyRequestStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public SupplyRequest setStatus(BoundCodeDt<SupplyRequestStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public SupplyRequest setStatus(SupplyRequestStatusEnum theValue) {
        this.setStatus((BoundCodeDt<SupplyRequestStatusEnum>)new BoundCodeDt(SupplyRequestStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeableConceptDt getKind() {
        if (this.myKind == null) {
            this.myKind = new CodeableConceptDt();
        }
        return this.myKind;
    }

    public SupplyRequest setKind(CodeableConceptDt theValue) {
        this.myKind = theValue;
        return this;
    }

    public ResourceReferenceDt getOrderedItem() {
        if (this.myOrderedItem == null) {
            this.myOrderedItem = new ResourceReferenceDt();
        }
        return this.myOrderedItem;
    }

    public SupplyRequest setOrderedItem(ResourceReferenceDt theValue) {
        this.myOrderedItem = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getSupplier() {
        if (this.mySupplier == null) {
            this.mySupplier = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySupplier;
    }

    public SupplyRequest setSupplier(List<ResourceReferenceDt> theValue) {
        this.mySupplier = theValue;
        return this;
    }

    public ResourceReferenceDt addSupplier() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSupplier().add(newType);
        return newType;
    }

    public IDatatype getReason() {
        return this.myReason;
    }

    public SupplyRequest setReason(IDatatype theValue) {
        this.myReason = theValue;
        return this;
    }

    public When getWhen() {
        if (this.myWhen == null) {
            this.myWhen = new When();
        }
        return this.myWhen;
    }

    public SupplyRequest setWhen(When theValue) {
        this.myWhen = theValue;
        return this;
    }

    public String getResourceName() {
        return "SupplyRequest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class When
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code indicating when the request should be fulfilled.")
        private CodeableConceptDt myCode;
        @Child(name="schedule", type={TimingDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Formal fulfillment schedule")
        private TimingDt mySchedule;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.mySchedule});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.mySchedule});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public When setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public TimingDt getSchedule() {
            if (this.mySchedule == null) {
                this.mySchedule = new TimingDt();
            }
            return this.mySchedule;
        }

        public When setSchedule(TimingDt theValue) {
            this.mySchedule = theValue;
            return this;
        }
    }
}

