/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.valueset.SubscriptionChannelTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.SubscriptionStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Subscription", profile="http://hl7.org/fhir/profiles/Subscription", id="subscription")
public class Subscription
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="status", path="Subscription.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="type", path="Subscription.channel.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="Subscription.channel.endpoint", description="", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="criteria", path="Subscription.criteria", description="", type="string")
    public static final String SP_CRITERIA = "criteria";
    public static final StringClientParam CRITERIA = new StringClientParam("criteria");
    @SearchParamDefinition(name="payload", path="Subscription.channel.payload", description="", type="string")
    public static final String SP_PAYLOAD = "payload";
    public static final StringClientParam PAYLOAD = new StringClientParam("payload");
    @SearchParamDefinition(name="contact", path="Subscription.contact", description="", type="token")
    public static final String SP_CONTACT = "contact";
    public static final TokenClientParam CONTACT = new TokenClientParam("contact");
    @SearchParamDefinition(name="tag", path="Subscription.tag", description="", type="token")
    public static final String SP_TAG = "tag";
    public static final TokenClientParam TAG = new TokenClientParam("tag");
    @Child(name="criteria", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The rules that the server should use to determine when to generate notifications for this subscription")
    private StringDt myCriteria;
    @Child(name="contact", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="who.focus", formalDefinition="Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting")
    private List<ContactPointDt> myContact;
    @Child(name="reason", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="why", formalDefinition="A description of why this subscription is defined")
    private StringDt myReason;
    @Child(name="status", type={CodeDt.class}, order=3, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The status of the subscription, which marks the server state for managing the subscription")
    private BoundCodeDt<SubscriptionStatusEnum> myStatus;
    @Child(name="error", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A record of the last error that occurred when the server processed a notification")
    private StringDt myError;
    @Child(name="channel", order=5, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Details where to send notifications when resources are received that meet the criteria")
    private Channel myChannel;
    @Child(name="end", type={InstantDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="The time for the server to turn the subscription off")
    private InstantDt myEnd;
    @Child(name="tag", type={CodingDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A tag to add to any resource that matches the criteria, after the subscription is processed")
    private List<CodingDt> myTag;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCriteria, this.myContact, this.myReason, this.myStatus, this.myError, this.myChannel, this.myEnd, this.myTag});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCriteria, this.myContact, this.myReason, this.myStatus, this.myError, this.myChannel, this.myEnd, this.myTag});
    }

    public StringDt getCriteriaElement() {
        if (this.myCriteria == null) {
            this.myCriteria = new StringDt();
        }
        return this.myCriteria;
    }

    public String getCriteria() {
        return (String)this.getCriteriaElement().getValue();
    }

    public Subscription setCriteria(StringDt theValue) {
        this.myCriteria = theValue;
        return this;
    }

    public Subscription setCriteria(String theString) {
        this.myCriteria = new StringDt(theString);
        return this;
    }

    public List<ContactPointDt> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactPointDt>();
        }
        return this.myContact;
    }

    public Subscription setContact(List<ContactPointDt> theValue) {
        this.myContact = theValue;
        return this;
    }

    public ContactPointDt addContact() {
        ContactPointDt newType = new ContactPointDt();
        this.getContact().add(newType);
        return newType;
    }

    public Subscription addContact(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public ContactPointDt getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public StringDt getReasonElement() {
        if (this.myReason == null) {
            this.myReason = new StringDt();
        }
        return this.myReason;
    }

    public String getReason() {
        return (String)this.getReasonElement().getValue();
    }

    public Subscription setReason(StringDt theValue) {
        this.myReason = theValue;
        return this;
    }

    public Subscription setReason(String theString) {
        this.myReason = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<SubscriptionStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(SubscriptionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Subscription setStatus(BoundCodeDt<SubscriptionStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Subscription setStatus(SubscriptionStatusEnum theValue) {
        this.setStatus((BoundCodeDt<SubscriptionStatusEnum>)new BoundCodeDt(SubscriptionStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getErrorElement() {
        if (this.myError == null) {
            this.myError = new StringDt();
        }
        return this.myError;
    }

    public String getError() {
        return (String)this.getErrorElement().getValue();
    }

    public Subscription setError(StringDt theValue) {
        this.myError = theValue;
        return this;
    }

    public Subscription setError(String theString) {
        this.myError = new StringDt(theString);
        return this;
    }

    public Channel getChannel() {
        if (this.myChannel == null) {
            this.myChannel = new Channel();
        }
        return this.myChannel;
    }

    public Subscription setChannel(Channel theValue) {
        this.myChannel = theValue;
        return this;
    }

    public InstantDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public Date getEnd() {
        return (Date)this.getEndElement().getValue();
    }

    public Subscription setEnd(InstantDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public Subscription setEndWithMillisPrecision(Date theDate) {
        this.myEnd = new InstantDt(theDate);
        return this;
    }

    public Subscription setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myEnd = new InstantDt(theDate, thePrecision);
        return this;
    }

    public List<CodingDt> getTag() {
        if (this.myTag == null) {
            this.myTag = new ArrayList<CodingDt>();
        }
        return this.myTag;
    }

    public Subscription setTag(List<CodingDt> theValue) {
        this.myTag = theValue;
        return this;
    }

    public CodingDt addTag() {
        CodingDt newType = new CodingDt();
        this.getTag().add(newType);
        return newType;
    }

    public Subscription addTag(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTag().add(theValue);
        return this;
    }

    public CodingDt getTagFirstRep() {
        if (this.getTag().isEmpty()) {
            return this.addTag();
        }
        return this.getTag().get(0);
    }

    public String getResourceName() {
        return "Subscription";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Channel
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of channel to send notifications on")
        private BoundCodeDt<SubscriptionChannelTypeEnum> myType;
        @Child(name="endpoint", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The uri that describes the actual end-point to send messages to")
        private UriDt myEndpoint;
        @Child(name="payload", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The mime type to send the payload in - either application/xml+fhir, or application/json+fhir. If the mime type is blank, then there is no payload in the notification, just a notification")
        private StringDt myPayload;
        @Child(name="header", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional headers / information to send as part of the notification")
        private StringDt myHeader;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myEndpoint, this.myPayload, this.myHeader});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myEndpoint, this.myPayload, this.myHeader});
        }

        public BoundCodeDt<SubscriptionChannelTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SubscriptionChannelTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public Channel setType(BoundCodeDt<SubscriptionChannelTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Channel setType(SubscriptionChannelTypeEnum theValue) {
            this.setType((BoundCodeDt<SubscriptionChannelTypeEnum>)new BoundCodeDt(SubscriptionChannelTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public UriDt getEndpointElement() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public String getEndpoint() {
            return (String)this.getEndpointElement().getValue();
        }

        public Channel setEndpoint(UriDt theValue) {
            this.myEndpoint = theValue;
            return this;
        }

        public Channel setEndpoint(String theUri) {
            this.myEndpoint = new UriDt(theUri);
            return this;
        }

        public StringDt getPayloadElement() {
            if (this.myPayload == null) {
                this.myPayload = new StringDt();
            }
            return this.myPayload;
        }

        public String getPayload() {
            return (String)this.getPayloadElement().getValue();
        }

        public Channel setPayload(StringDt theValue) {
            this.myPayload = theValue;
            return this;
        }

        public Channel setPayload(String theString) {
            this.myPayload = new StringDt(theString);
            return this;
        }

        public StringDt getHeaderElement() {
            if (this.myHeader == null) {
                this.myHeader = new StringDt();
            }
            return this.myHeader;
        }

        public String getHeader() {
            return (String)this.getHeaderElement().getValue();
        }

        public Channel setHeader(StringDt theValue) {
            this.myHeader = theValue;
            return this;
        }

        public Channel setHeader(String theString) {
            this.myHeader = new StringDt(theString);
            return this;
        }
    }
}

