/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.HealthcareService;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Schedule", profile="http://hl7.org/fhir/profiles/Schedule", id="schedule")
public class Schedule
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="actor", path="Schedule.actor", description="The individual(HealthcareService, Practitioner, Location, ...) to find a Schedule for", type="reference")
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    @SearchParamDefinition(name="type", path="Schedule.type", description="The type of appointments that can be booked into associated slot(s)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="date", path="Schedule.planningHorizon", description="Search for Schedule resources that have a period that contains this date specified", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Schedule.identifier", description="A Schedule Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_ACTOR = new Include("Schedule:actor");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="")
    private List<IdentifierDt> myIdentifier;
    @Child(name="type", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="")
    private List<CodeableConceptDt> myType;
    @Child(name="actor", order=2, min=1, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class})
    @Description(shortDefinition="who.focus", formalDefinition="")
    private ResourceReferenceDt myActor;
    @Child(name="planningHorizon", type={PeriodDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.planned", formalDefinition="")
    private PeriodDt myPlanningHorizon;
    @Child(name="comment", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private StringDt myComment;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.myActor, this.myPlanningHorizon, this.myComment});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.myActor, this.myPlanningHorizon, this.myComment});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Schedule setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Schedule addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CodeableConceptDt> getType() {
        if (this.myType == null) {
            this.myType = new ArrayList<CodeableConceptDt>();
        }
        return this.myType;
    }

    public Schedule setType(List<CodeableConceptDt> theValue) {
        this.myType = theValue;
        return this;
    }

    public CodeableConceptDt addType() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getType().add(newType);
        return newType;
    }

    public Schedule addType(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getType().add(theValue);
        return this;
    }

    public CodeableConceptDt getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            return this.addType();
        }
        return this.getType().get(0);
    }

    public ResourceReferenceDt getActor() {
        if (this.myActor == null) {
            this.myActor = new ResourceReferenceDt();
        }
        return this.myActor;
    }

    public Schedule setActor(ResourceReferenceDt theValue) {
        this.myActor = theValue;
        return this;
    }

    public PeriodDt getPlanningHorizon() {
        if (this.myPlanningHorizon == null) {
            this.myPlanningHorizon = new PeriodDt();
        }
        return this.myPlanningHorizon;
    }

    public Schedule setPlanningHorizon(PeriodDt theValue) {
        this.myPlanningHorizon = theValue;
        return this;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public String getComment() {
        return (String)this.getCommentElement().getValue();
    }

    public Schedule setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public Schedule setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "Schedule";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

