/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="RiskAssessment", profile="http://hl7.org/fhir/profiles/RiskAssessment", id="riskassessment")
public class RiskAssessment
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="RiskAssessment.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="date", path="RiskAssessment.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="RiskAssessment.encounter", description="", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="performer", path="RiskAssessment.performer", description="", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    @SearchParamDefinition(name="subject", path="RiskAssessment.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="condition", path="RiskAssessment.condition", description="", type="reference")
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    @SearchParamDefinition(name="method", path="RiskAssessment.method", description="", type="token")
    public static final String SP_METHOD = "method";
    public static final TokenClientParam METHOD = new TokenClientParam("method");
    @SearchParamDefinition(name="patient", path="RiskAssessment.subject", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_CONDITION = new Include("RiskAssessment:condition");
    public static final Include INCLUDE_ENCOUNTER = new Include("RiskAssessment:encounter");
    public static final Include INCLUDE_PATIENT = new Include("RiskAssessment:patient");
    public static final Include INCLUDE_PERFORMER = new Include("RiskAssessment:performer");
    public static final Include INCLUDE_SUBJECT = new Include("RiskAssessment:subject");
    @Child(name="subject", order=0, min=0, max=1, summary=true, modifier=false, type={Patient.class, Group.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient or group the risk assessment applies to")
    private ResourceReferenceDt mySubject;
    @Child(name="date", type={DateTimeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date (and possibly time) the risk assessment was performed")
    private DateTimeDt myDate;
    @Child(name="condition", order=2, min=0, max=1, summary=true, modifier=false, type={Condition.class})
    @Description(shortDefinition="", formalDefinition="For assessments or prognosis specific to a particular condition, indicates the condition being assessed.")
    private ResourceReferenceDt myCondition;
    @Child(name="encounter", order=3, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The encounter where the assessment was performed")
    private ResourceReferenceDt myEncounter;
    @Child(name="performer", order=4, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Device.class})
    @Description(shortDefinition="who.author", formalDefinition="The provider or software application that performed the assessment")
    private ResourceReferenceDt myPerformer;
    @Child(name="identifier", type={IdentifierDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Business identifier assigned to the risk assessment")
    private IdentifierDt myIdentifier;
    @Child(name="method", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="The algorithm, process or mechanism used to evaluate the risk")
    private CodeableConceptDt myMethod;
    @Child(name="basis", order=7, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Indicates the source data considered as part of the assessment (FamilyHistory, Observations, Procedures, Conditions, etc.)")
    private List<ResourceReferenceDt> myBasis;
    @Child(name="prediction", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the expected outcome for the subject")
    private List<Prediction> myPrediction;
    @Child(name="mitigation", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the steps that might be taken to reduce the identified risk(s).")
    private StringDt myMitigation;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.myDate, this.myCondition, this.myEncounter, this.myPerformer, this.myIdentifier, this.myMethod, this.myBasis, this.myPrediction, this.myMitigation});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myDate, this.myCondition, this.myEncounter, this.myPerformer, this.myIdentifier, this.myMethod, this.myBasis, this.myPrediction, this.myMitigation});
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public RiskAssessment setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public RiskAssessment setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public RiskAssessment setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public RiskAssessment setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getCondition() {
        if (this.myCondition == null) {
            this.myCondition = new ResourceReferenceDt();
        }
        return this.myCondition;
    }

    public RiskAssessment setCondition(ResourceReferenceDt theValue) {
        this.myCondition = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public RiskAssessment setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ResourceReferenceDt();
        }
        return this.myPerformer;
    }

    public RiskAssessment setPerformer(ResourceReferenceDt theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public RiskAssessment setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public CodeableConceptDt getMethod() {
        if (this.myMethod == null) {
            this.myMethod = new CodeableConceptDt();
        }
        return this.myMethod;
    }

    public RiskAssessment setMethod(CodeableConceptDt theValue) {
        this.myMethod = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getBasis() {
        if (this.myBasis == null) {
            this.myBasis = new ArrayList<ResourceReferenceDt>();
        }
        return this.myBasis;
    }

    public RiskAssessment setBasis(List<ResourceReferenceDt> theValue) {
        this.myBasis = theValue;
        return this;
    }

    public ResourceReferenceDt addBasis() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getBasis().add(newType);
        return newType;
    }

    public List<Prediction> getPrediction() {
        if (this.myPrediction == null) {
            this.myPrediction = new ArrayList<Prediction>();
        }
        return this.myPrediction;
    }

    public RiskAssessment setPrediction(List<Prediction> theValue) {
        this.myPrediction = theValue;
        return this;
    }

    public Prediction addPrediction() {
        Prediction newType = new Prediction();
        this.getPrediction().add(newType);
        return newType;
    }

    public RiskAssessment addPrediction(Prediction theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPrediction().add(theValue);
        return this;
    }

    public Prediction getPredictionFirstRep() {
        if (this.getPrediction().isEmpty()) {
            return this.addPrediction();
        }
        return this.getPrediction().get(0);
    }

    public StringDt getMitigationElement() {
        if (this.myMitigation == null) {
            this.myMitigation = new StringDt();
        }
        return this.myMitigation;
    }

    public String getMitigation() {
        return (String)this.getMitigationElement().getValue();
    }

    public RiskAssessment setMitigation(StringDt theValue) {
        this.myMitigation = theValue;
        return this;
    }

    public RiskAssessment setMitigation(String theString) {
        this.myMitigation = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "RiskAssessment";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Prediction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="outcome", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="One of the potential outcomes for the patient (e.g. remission, death,  a particular condition)")
        private CodeableConceptDt myOutcome;
        @Child(name="probability", order=1, min=0, max=1, summary=false, modifier=false, type={DecimalDt.class, RangeDt.class, CodeableConceptDt.class})
        @Description(shortDefinition="", formalDefinition="How likely is the outcome (in the specified timeframe)")
        private IDatatype myProbability;
        @Child(name="relativeRisk", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the risk for this particular subject (with their specific characteristics) divided by the risk of the population in general.  (Numbers greater than 1 = higher risk than the population, numbers less than 1 = lower risk.)")
        private DecimalDt myRelativeRisk;
        @Child(name="when", order=3, min=0, max=1, summary=false, modifier=false, type={PeriodDt.class, RangeDt.class})
        @Description(shortDefinition="", formalDefinition="Indicates the period of time or age range of the subject to which the specified probability applies")
        private IDatatype myWhen;
        @Child(name="rationale", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional information explaining the basis for the prediction")
        private StringDt myRationale;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myOutcome, this.myProbability, this.myRelativeRisk, this.myWhen, this.myRationale});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myOutcome, this.myProbability, this.myRelativeRisk, this.myWhen, this.myRationale});
        }

        public CodeableConceptDt getOutcome() {
            if (this.myOutcome == null) {
                this.myOutcome = new CodeableConceptDt();
            }
            return this.myOutcome;
        }

        public Prediction setOutcome(CodeableConceptDt theValue) {
            this.myOutcome = theValue;
            return this;
        }

        public IDatatype getProbability() {
            return this.myProbability;
        }

        public Prediction setProbability(IDatatype theValue) {
            this.myProbability = theValue;
            return this;
        }

        public DecimalDt getRelativeRiskElement() {
            if (this.myRelativeRisk == null) {
                this.myRelativeRisk = new DecimalDt();
            }
            return this.myRelativeRisk;
        }

        public BigDecimal getRelativeRisk() {
            return (BigDecimal)this.getRelativeRiskElement().getValue();
        }

        public Prediction setRelativeRisk(DecimalDt theValue) {
            this.myRelativeRisk = theValue;
            return this;
        }

        public Prediction setRelativeRisk(long theValue) {
            this.myRelativeRisk = new DecimalDt(theValue);
            return this;
        }

        public Prediction setRelativeRisk(double theValue) {
            this.myRelativeRisk = new DecimalDt(theValue);
            return this;
        }

        public Prediction setRelativeRisk(BigDecimal theValue) {
            this.myRelativeRisk = new DecimalDt(theValue);
            return this;
        }

        public IDatatype getWhen() {
            return this.myWhen;
        }

        public Prediction setWhen(IDatatype theValue) {
            this.myWhen = theValue;
            return this;
        }

        public StringDt getRationaleElement() {
            if (this.myRationale == null) {
                this.myRationale = new StringDt();
            }
            return this.myRationale;
        }

        public String getRationale() {
            return (String)this.getRationaleElement().getValue();
        }

        public Prediction setRationale(StringDt theValue) {
            this.myRationale = theValue;
            return this;
        }

        public Prediction setRationale(String theString) {
            this.myRationale = new StringDt(theString);
            return this;
        }
    }
}

