/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AddressDt;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.valueset.AdministrativeGenderEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="RelatedPerson", profile="http://hl7.org/fhir/profiles/RelatedPerson", id="relatedperson")
public class RelatedPerson
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="RelatedPerson.identifier", description="A patient Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="RelatedPerson.name", description="A portion of name in any name part", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="phonetic", path="RelatedPerson.name", description="A portion of name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="RelatedPerson.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="phone", path="RelatedPerson.telecom(system=phone)", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="email", path="RelatedPerson.telecom(system=email)", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="address", path="RelatedPerson.address", description="An address in any kind of address/part", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-city", path="RelatedPerson.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-state", path="RelatedPerson.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="address-postalcode", path="RelatedPerson.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="RelatedPerson.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="address-use", path="RelatedPerson.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="birthdate", path="RelatedPerson.birthDate", description="The Related Person's date of birth", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    public static final DateClientParam BIRTHDATE = new DateClientParam("birthdate");
    @SearchParamDefinition(name="gender", path="RelatedPerson.gender", description="Gender of the person", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="patient", path="RelatedPerson.patient", description="The patient this person is related to", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("RelatedPerson:patient");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifier for a person within a particular scope.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="patient", order=1, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="The patient this person is related to")
    private ResourceReferenceDt myPatient;
    @Child(name="relationship", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="The nature of the relationship between a patient and the related person")
    private CodeableConceptDt myRelationship;
    @Child(name="name", type={HumanNameDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A name associated with the person")
    private HumanNameDt myName;
    @Child(name="telecom", type={ContactPointDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
    private List<ContactPointDt> myTelecom;
    @Child(name="gender", type={CodeDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
    private BoundCodeDt<AdministrativeGenderEnum> myGender;
    @Child(name="birthDate", type={DateDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private DateDt myBirthDate;
    @Child(name="address", type={AddressDt.class}, order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Address where the related person can be contacted or visited")
    private List<AddressDt> myAddress;
    @Child(name="photo", type={AttachmentDt.class}, order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Image of the person")
    private List<AttachmentDt> myPhoto;
    @Child(name="period", type={PeriodDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="The period of time that this relationship is considered to be valid. If there are no dates defined, then the interval is unknown.")
    private PeriodDt myPeriod;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myPatient, this.myRelationship, this.myName, this.myTelecom, this.myGender, this.myBirthDate, this.myAddress, this.myPhoto, this.myPeriod});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myPatient, this.myRelationship, this.myName, this.myTelecom, this.myGender, this.myBirthDate, this.myAddress, this.myPhoto, this.myPeriod});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public RelatedPerson setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public RelatedPerson addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public RelatedPerson setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public CodeableConceptDt getRelationship() {
        if (this.myRelationship == null) {
            this.myRelationship = new CodeableConceptDt();
        }
        return this.myRelationship;
    }

    public RelatedPerson setRelationship(CodeableConceptDt theValue) {
        this.myRelationship = theValue;
        return this;
    }

    public HumanNameDt getName() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public RelatedPerson setName(HumanNameDt theValue) {
        this.myName = theValue;
        return this;
    }

    public List<ContactPointDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactPointDt>();
        }
        return this.myTelecom;
    }

    public RelatedPerson setTelecom(List<ContactPointDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactPointDt addTelecom() {
        ContactPointDt newType = new ContactPointDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public RelatedPerson addTelecom(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTelecom().add(theValue);
        return this;
    }

    public ContactPointDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public BoundCodeDt<AdministrativeGenderEnum> getGenderElement() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public String getGender() {
        return (String)this.getGenderElement().getValue();
    }

    public RelatedPerson setGender(BoundCodeDt<AdministrativeGenderEnum> theValue) {
        this.myGender = theValue;
        return this;
    }

    public RelatedPerson setGender(AdministrativeGenderEnum theValue) {
        this.setGender((BoundCodeDt<AdministrativeGenderEnum>)new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public DateDt getBirthDateElement() {
        if (this.myBirthDate == null) {
            this.myBirthDate = new DateDt();
        }
        return this.myBirthDate;
    }

    public Date getBirthDate() {
        return (Date)this.getBirthDateElement().getValue();
    }

    public RelatedPerson setBirthDate(DateDt theValue) {
        this.myBirthDate = theValue;
        return this;
    }

    public RelatedPerson setBirthDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myBirthDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public RelatedPerson setBirthDateWithDayPrecision(Date theDate) {
        this.myBirthDate = new DateDt(theDate);
        return this;
    }

    public List<AddressDt> getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public RelatedPerson setAddress(List<AddressDt> theValue) {
        this.myAddress = theValue;
        return this;
    }

    public AddressDt addAddress() {
        AddressDt newType = new AddressDt();
        this.getAddress().add(newType);
        return newType;
    }

    public RelatedPerson addAddress(AddressDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAddress().add(theValue);
        return this;
    }

    public AddressDt getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            return this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public List<AttachmentDt> getPhoto() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public RelatedPerson setPhoto(List<AttachmentDt> theValue) {
        this.myPhoto = theValue;
        return this;
    }

    public AttachmentDt addPhoto() {
        AttachmentDt newType = new AttachmentDt();
        this.getPhoto().add(newType);
        return newType;
    }

    public RelatedPerson addPhoto(AttachmentDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPhoto().add(theValue);
        return this;
    }

    public AttachmentDt getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            return this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public RelatedPerson setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public String getResourceName() {
        return "RelatedPerson";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

