/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SignatureDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.ProvenanceEntityRoleEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Provenance", profile="http://hl7.org/fhir/profiles/Provenance", id="provenance")
public class Provenance
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="target", path="Provenance.target", description="", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    @SearchParamDefinition(name="start", path="Provenance.period.start", description="", type="date")
    public static final String SP_START = "start";
    public static final DateClientParam START = new DateClientParam("start");
    @SearchParamDefinition(name="end", path="Provenance.period.end", description="", type="date")
    public static final String SP_END = "end";
    public static final DateClientParam END = new DateClientParam("end");
    @SearchParamDefinition(name="location", path="Provenance.location", description="", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="agent", path="Provenance.agent.actor", description="", type="reference")
    public static final String SP_AGENT = "agent";
    public static final ReferenceClientParam AGENT = new ReferenceClientParam("agent");
    @SearchParamDefinition(name="userid", path="Provenance.agent.userId", description="", type="token")
    public static final String SP_USERID = "userid";
    public static final TokenClientParam USERID = new TokenClientParam("userid");
    @SearchParamDefinition(name="patient", path="Provenance.target", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="sigtype", path="Provenance.signature.type", description="", type="token")
    public static final String SP_SIGTYPE = "sigtype";
    public static final TokenClientParam SIGTYPE = new TokenClientParam("sigtype");
    @SearchParamDefinition(name="entitytype", path="Provenance.entity.type", description="", type="token")
    public static final String SP_ENTITYTYPE = "entitytype";
    public static final TokenClientParam ENTITYTYPE = new TokenClientParam("entitytype");
    @SearchParamDefinition(name="entity", path="Provenance.entity.reference", description="", type="uri")
    public static final String SP_ENTITY = "entity";
    public static final UriClientParam ENTITY = new UriClientParam("entity");
    public static final Include INCLUDE_AGENT = new Include("Provenance:agent");
    public static final Include INCLUDE_LOCATION = new Include("Provenance:location");
    public static final Include INCLUDE_PATIENT = new Include("Provenance:patient");
    public static final Include INCLUDE_TARGET = new Include("Provenance:target");
    @Child(name="target", order=0, min=1, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="what", formalDefinition="The Reference(s) that were generated or updated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity")
    private List<ResourceReferenceDt> myTarget;
    @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="The period during which the activity occurred")
    private PeriodDt myPeriod;
    @Child(name="recorded", type={InstantDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The instant of time at which the activity was recorded")
    private InstantDt myRecorded;
    @Child(name="reason", type={CodeableConceptDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="why", formalDefinition="The reason that the activity was taking place")
    private List<CodeableConceptDt> myReason;
    @Child(name="activity", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="why", formalDefinition="An activity is something that occurs over a period of time and acts upon or with entities; it may include consuming, processing, transforming, modifying, relocating, using, or generating entities")
    private CodeableConceptDt myActivity;
    @Child(name="location", order=5, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="where", formalDefinition="Where the activity occurred, if relevant")
    private ResourceReferenceDt myLocation;
    @Child(name="policy", type={UriDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.")
    private List<UriDt> myPolicy;
    @Child(name="agent", order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="who", formalDefinition="An agent takes a role in an activity such that the agent can be assigned some degree of responsibility for the activity taking place. An agent can be a person, an organization, software, or other entities that may be ascribed responsibility")
    private List<Agent> myAgent;
    @Child(name="entity", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="An entity used in this activity")
    private List<Entity> myEntity;
    @Child(name="signature", type={SignatureDt.class}, order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A digital signature on the target Reference(s). The signer should match a Provenance.agent. The purpose of the signature is indicated.")
    private List<SignatureDt> mySignature;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myTarget, this.myPeriod, this.myRecorded, this.myReason, this.myActivity, this.myLocation, this.myPolicy, this.myAgent, this.myEntity, this.mySignature});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTarget, this.myPeriod, this.myRecorded, this.myReason, this.myActivity, this.myLocation, this.myPolicy, this.myAgent, this.myEntity, this.mySignature});
    }

    public List<ResourceReferenceDt> getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ArrayList<ResourceReferenceDt>();
        }
        return this.myTarget;
    }

    public Provenance setTarget(List<ResourceReferenceDt> theValue) {
        this.myTarget = theValue;
        return this;
    }

    public ResourceReferenceDt addTarget() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getTarget().add(newType);
        return newType;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Provenance setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public InstantDt getRecordedElement() {
        if (this.myRecorded == null) {
            this.myRecorded = new InstantDt();
        }
        return this.myRecorded;
    }

    public Date getRecorded() {
        return (Date)this.getRecordedElement().getValue();
    }

    public Provenance setRecorded(InstantDt theValue) {
        this.myRecorded = theValue;
        return this;
    }

    public Provenance setRecordedWithMillisPrecision(Date theDate) {
        this.myRecorded = new InstantDt(theDate);
        return this;
    }

    public Provenance setRecorded(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRecorded = new InstantDt(theDate, thePrecision);
        return this;
    }

    public List<CodeableConceptDt> getReason() {
        if (this.myReason == null) {
            this.myReason = new ArrayList<CodeableConceptDt>();
        }
        return this.myReason;
    }

    public Provenance setReason(List<CodeableConceptDt> theValue) {
        this.myReason = theValue;
        return this;
    }

    public CodeableConceptDt addReason() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReason().add(newType);
        return newType;
    }

    public Provenance addReason(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReason().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            return this.addReason();
        }
        return this.getReason().get(0);
    }

    public CodeableConceptDt getActivity() {
        if (this.myActivity == null) {
            this.myActivity = new CodeableConceptDt();
        }
        return this.myActivity;
    }

    public Provenance setActivity(CodeableConceptDt theValue) {
        this.myActivity = theValue;
        return this;
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public Provenance setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public List<UriDt> getPolicy() {
        if (this.myPolicy == null) {
            this.myPolicy = new ArrayList<UriDt>();
        }
        return this.myPolicy;
    }

    public Provenance setPolicy(List<UriDt> theValue) {
        this.myPolicy = theValue;
        return this;
    }

    public UriDt addPolicy() {
        UriDt newType = new UriDt();
        this.getPolicy().add(newType);
        return newType;
    }

    public Provenance addPolicy(UriDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPolicy().add(theValue);
        return this;
    }

    public UriDt getPolicyFirstRep() {
        if (this.getPolicy().isEmpty()) {
            return this.addPolicy();
        }
        return this.getPolicy().get(0);
    }

    public Provenance addPolicy(String theUri) {
        if (this.myPolicy == null) {
            this.myPolicy = new ArrayList<UriDt>();
        }
        this.myPolicy.add(new UriDt(theUri));
        return this;
    }

    public List<Agent> getAgent() {
        if (this.myAgent == null) {
            this.myAgent = new ArrayList<Agent>();
        }
        return this.myAgent;
    }

    public Provenance setAgent(List<Agent> theValue) {
        this.myAgent = theValue;
        return this;
    }

    public Agent addAgent() {
        Agent newType = new Agent();
        this.getAgent().add(newType);
        return newType;
    }

    public Provenance addAgent(Agent theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAgent().add(theValue);
        return this;
    }

    public Agent getAgentFirstRep() {
        if (this.getAgent().isEmpty()) {
            return this.addAgent();
        }
        return this.getAgent().get(0);
    }

    public List<Entity> getEntity() {
        if (this.myEntity == null) {
            this.myEntity = new ArrayList<Entity>();
        }
        return this.myEntity;
    }

    public Provenance setEntity(List<Entity> theValue) {
        this.myEntity = theValue;
        return this;
    }

    public Entity addEntity() {
        Entity newType = new Entity();
        this.getEntity().add(newType);
        return newType;
    }

    public Provenance addEntity(Entity theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getEntity().add(theValue);
        return this;
    }

    public Entity getEntityFirstRep() {
        if (this.getEntity().isEmpty()) {
            return this.addEntity();
        }
        return this.getEntity().get(0);
    }

    public List<SignatureDt> getSignature() {
        if (this.mySignature == null) {
            this.mySignature = new ArrayList<SignatureDt>();
        }
        return this.mySignature;
    }

    public Provenance setSignature(List<SignatureDt> theValue) {
        this.mySignature = theValue;
        return this;
    }

    public SignatureDt addSignature() {
        SignatureDt newType = new SignatureDt();
        this.getSignature().add(newType);
        return newType;
    }

    public Provenance addSignature(SignatureDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getSignature().add(theValue);
        return this;
    }

    public SignatureDt getSignatureFirstRep() {
        if (this.getSignature().isEmpty()) {
            return this.addSignature();
        }
        return this.getSignature().get(0);
    }

    public String getResourceName() {
        return "Provenance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Entity
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="How the entity was used during the activity")
        private BoundCodeDt<ProvenanceEntityRoleEnum> myRole;
        @Child(name="type", type={CodingDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of the entity. If the entity is a resource, then this is a resource type")
        private CodingDt myType;
        @Child(name="reference", type={UriDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identity of the  Entity used. May be a logical or physical uri and maybe absolute or relative")
        private UriDt myReference;
        @Child(name="display", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Human-readable description of the entity")
        private StringDt myDisplay;
        @Child(name="agent", type={Agent.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which generated the entity")
        private Agent myAgent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myRole, this.myType, this.myReference, this.myDisplay, this.myAgent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myType, this.myReference, this.myDisplay, this.myAgent});
        }

        public BoundCodeDt<ProvenanceEntityRoleEnum> getRoleElement() {
            if (this.myRole == null) {
                this.myRole = new BoundCodeDt(ProvenanceEntityRoleEnum.VALUESET_BINDER);
            }
            return this.myRole;
        }

        public String getRole() {
            return (String)this.getRoleElement().getValue();
        }

        public Entity setRole(BoundCodeDt<ProvenanceEntityRoleEnum> theValue) {
            this.myRole = theValue;
            return this;
        }

        public Entity setRole(ProvenanceEntityRoleEnum theValue) {
            this.setRole((BoundCodeDt<ProvenanceEntityRoleEnum>)new BoundCodeDt(ProvenanceEntityRoleEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Entity setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public UriDt getReferenceElement() {
            if (this.myReference == null) {
                this.myReference = new UriDt();
            }
            return this.myReference;
        }

        public String getReference() {
            return (String)this.getReferenceElement().getValue();
        }

        public Entity setReference(UriDt theValue) {
            this.myReference = theValue;
            return this;
        }

        public Entity setReference(String theUri) {
            this.myReference = new UriDt(theUri);
            return this;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public String getDisplay() {
            return (String)this.getDisplayElement().getValue();
        }

        public Entity setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public Entity setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }

        public Agent getAgent() {
            if (this.myAgent == null) {
                this.myAgent = new Agent();
            }
            return this.myAgent;
        }

        public Entity setAgent(Agent theValue) {
            this.myAgent = theValue;
            return this;
        }
    }

    @Block
    public static class AgentRelatedAgent
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of relationship between agents")
        private CodeableConceptDt myType;
        @Child(name="target", type={UriDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An internal reference to another agent listed in this provenance by its identifier")
        private UriDt myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myTarget});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public AgentRelatedAgent setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public UriDt getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new UriDt();
            }
            return this.myTarget;
        }

        public String getTarget() {
            return (String)this.getTargetElement().getValue();
        }

        public AgentRelatedAgent setTarget(UriDt theValue) {
            this.myTarget = theValue;
            return this;
        }

        public AgentRelatedAgent setTarget(String theUri) {
            this.myTarget = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Agent
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The function of the agent with respect to the activity.")
        private CodingDt myRole;
        @Child(name="actor", order=1, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, RelatedPerson.class, Patient.class, Device.class, Organization.class})
        @Description(shortDefinition="who.actor", formalDefinition="The individual, device or organization that participated in the event")
        private ResourceReferenceDt myActor;
        @Child(name="userId", type={IdentifierDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="who.actor", formalDefinition="The identity of the agent as known by the authorization system")
        private IdentifierDt myUserId;
        @Child(name="relatedAgent", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A relationship between two the agents referenced in this resource. This is defined to allow for explicit description of the delegation between agents.  For example, this human author used this device, or one person acted on another's behest")
        private List<AgentRelatedAgent> myRelatedAgent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myRole, this.myActor, this.myUserId, this.myRelatedAgent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myActor, this.myUserId, this.myRelatedAgent});
        }

        public CodingDt getRole() {
            if (this.myRole == null) {
                this.myRole = new CodingDt();
            }
            return this.myRole;
        }

        public Agent setRole(CodingDt theValue) {
            this.myRole = theValue;
            return this;
        }

        public ResourceReferenceDt getActor() {
            if (this.myActor == null) {
                this.myActor = new ResourceReferenceDt();
            }
            return this.myActor;
        }

        public Agent setActor(ResourceReferenceDt theValue) {
            this.myActor = theValue;
            return this;
        }

        public IdentifierDt getUserId() {
            if (this.myUserId == null) {
                this.myUserId = new IdentifierDt();
            }
            return this.myUserId;
        }

        public Agent setUserId(IdentifierDt theValue) {
            this.myUserId = theValue;
            return this;
        }

        public List<AgentRelatedAgent> getRelatedAgent() {
            if (this.myRelatedAgent == null) {
                this.myRelatedAgent = new ArrayList<AgentRelatedAgent>();
            }
            return this.myRelatedAgent;
        }

        public Agent setRelatedAgent(List<AgentRelatedAgent> theValue) {
            this.myRelatedAgent = theValue;
            return this;
        }

        public AgentRelatedAgent addRelatedAgent() {
            AgentRelatedAgent newType = new AgentRelatedAgent();
            this.getRelatedAgent().add(newType);
            return newType;
        }

        public Agent addRelatedAgent(AgentRelatedAgent theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getRelatedAgent().add(theValue);
            return this;
        }

        public AgentRelatedAgent getRelatedAgentFirstRep() {
            if (this.getRelatedAgent().isEmpty()) {
                return this.addRelatedAgent();
            }
            return this.getRelatedAgent().get(0);
        }
    }
}

