/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.ActionListEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ProcessRequest", profile="http://hl7.org/fhir/profiles/ProcessRequest", id="processrequest")
public class ProcessRequest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="ProcessRequest.identifier", description="The business identifier of the ProcessRequest", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="organization", path="ProcessRequest.organization", description="The organization who generated this request", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    @SearchParamDefinition(name="provider", path="ProcessRequest.provider", description="The provider who regenerated this request", type="reference")
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    @SearchParamDefinition(name="action", path="ProcessRequest.action", description="The action requested by this resource", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    public static final Include INCLUDE_ORGANIZATION = new Include("ProcessRequest:organization");
    public static final Include INCLUDE_PROVIDER = new Include("ProcessRequest:provider");
    @Child(name="action", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The type of processing action being requested, for example Reversal, Readjudication, StatusRequest,PendedRequest")
    private BoundCodeDt<ActionListEnum> myAction;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The ProcessRequest business identifier")
    private List<IdentifierDt> myIdentifier;
    @Child(name="ruleset", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    private CodingDt myOriginalRuleset;
    @Child(name="created", type={DateTimeDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when this resource was created.")
    private DateTimeDt myCreated;
    @Child(name="target", order=5, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is the target of the request.")
    private ResourceReferenceDt myTarget;
    @Child(name="provider", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the action specified in thise request.")
    private ResourceReferenceDt myProvider;
    @Child(name="organization", order=7, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the action speccified in thise request.")
    private ResourceReferenceDt myOrganization;
    @Child(name="request", order=8, min=0, max=1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Reference of resource which is the target or subject of this action.")
    private ResourceReferenceDt myRequest;
    @Child(name="response", order=9, min=0, max=1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Reference of a prior response to resource which is the target or subject of this action.")
    private ResourceReferenceDt myResponse;
    @Child(name="nullify", type={BooleanDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="If true remove all history excluding audit.")
    private BooleanDt myNullify;
    @Child(name="reference", type={StringDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A reference to supply which authenticates the process.")
    private StringDt myReference;
    @Child(name="item", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of top level items to be re-adjudicated, if none specified then the entire submission is re-adjudicated.")
    private List<Item> myItem;
    @Child(name="include", type={StringDt.class}, order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Names of resource types to include")
    private List<StringDt> myInclude;
    @Child(name="exclude", type={StringDt.class}, order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Names of resource types to exclude")
    private List<StringDt> myExclude;
    @Child(name="period", type={PeriodDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A period of time during which the fulfilling resources would have been created.")
    private PeriodDt myPeriod;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myAction, this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myTarget, this.myProvider, this.myOrganization, this.myRequest, this.myResponse, this.myNullify, this.myReference, this.myItem, this.myInclude, this.myExclude, this.myPeriod});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAction, this.myIdentifier, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myTarget, this.myProvider, this.myOrganization, this.myRequest, this.myResponse, this.myNullify, this.myReference, this.myItem, this.myInclude, this.myExclude, this.myPeriod});
    }

    public BoundCodeDt<ActionListEnum> getActionElement() {
        if (this.myAction == null) {
            this.myAction = new BoundCodeDt(ActionListEnum.VALUESET_BINDER);
        }
        return this.myAction;
    }

    public String getAction() {
        return (String)this.getActionElement().getValue();
    }

    public ProcessRequest setAction(BoundCodeDt<ActionListEnum> theValue) {
        this.myAction = theValue;
        return this;
    }

    public ProcessRequest setAction(ActionListEnum theValue) {
        this.setAction((BoundCodeDt<ActionListEnum>)new BoundCodeDt(ActionListEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ProcessRequest setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public ProcessRequest addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public ProcessRequest setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public ProcessRequest setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public ProcessRequest setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public ProcessRequest setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ProcessRequest setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public ProcessRequest setTarget(ResourceReferenceDt theValue) {
        this.myTarget = theValue;
        return this;
    }

    public ResourceReferenceDt getProvider() {
        if (this.myProvider == null) {
            this.myProvider = new ResourceReferenceDt();
        }
        return this.myProvider;
    }

    public ProcessRequest setProvider(ResourceReferenceDt theValue) {
        this.myProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public ProcessRequest setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public ProcessRequest setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public ResourceReferenceDt getResponse() {
        if (this.myResponse == null) {
            this.myResponse = new ResourceReferenceDt();
        }
        return this.myResponse;
    }

    public ProcessRequest setResponse(ResourceReferenceDt theValue) {
        this.myResponse = theValue;
        return this;
    }

    public BooleanDt getNullifyElement() {
        if (this.myNullify == null) {
            this.myNullify = new BooleanDt();
        }
        return this.myNullify;
    }

    public Boolean getNullify() {
        return (Boolean)this.getNullifyElement().getValue();
    }

    public ProcessRequest setNullify(BooleanDt theValue) {
        this.myNullify = theValue;
        return this;
    }

    public ProcessRequest setNullify(boolean theBoolean) {
        this.myNullify = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getReferenceElement() {
        if (this.myReference == null) {
            this.myReference = new StringDt();
        }
        return this.myReference;
    }

    public String getReference() {
        return (String)this.getReferenceElement().getValue();
    }

    public ProcessRequest setReference(StringDt theValue) {
        this.myReference = theValue;
        return this;
    }

    public ProcessRequest setReference(String theString) {
        this.myReference = new StringDt(theString);
        return this;
    }

    public List<Item> getItem() {
        if (this.myItem == null) {
            this.myItem = new ArrayList<Item>();
        }
        return this.myItem;
    }

    public ProcessRequest setItem(List<Item> theValue) {
        this.myItem = theValue;
        return this;
    }

    public Item addItem() {
        Item newType = new Item();
        this.getItem().add(newType);
        return newType;
    }

    public ProcessRequest addItem(Item theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getItem().add(theValue);
        return this;
    }

    public Item getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            return this.addItem();
        }
        return this.getItem().get(0);
    }

    public List<StringDt> getInclude() {
        if (this.myInclude == null) {
            this.myInclude = new ArrayList<StringDt>();
        }
        return this.myInclude;
    }

    public ProcessRequest setInclude(List<StringDt> theValue) {
        this.myInclude = theValue;
        return this;
    }

    public StringDt addInclude() {
        StringDt newType = new StringDt();
        this.getInclude().add(newType);
        return newType;
    }

    public ProcessRequest addInclude(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getInclude().add(theValue);
        return this;
    }

    public StringDt getIncludeFirstRep() {
        if (this.getInclude().isEmpty()) {
            return this.addInclude();
        }
        return this.getInclude().get(0);
    }

    public ProcessRequest addInclude(String theString) {
        if (this.myInclude == null) {
            this.myInclude = new ArrayList<StringDt>();
        }
        this.myInclude.add(new StringDt(theString));
        return this;
    }

    public List<StringDt> getExclude() {
        if (this.myExclude == null) {
            this.myExclude = new ArrayList<StringDt>();
        }
        return this.myExclude;
    }

    public ProcessRequest setExclude(List<StringDt> theValue) {
        this.myExclude = theValue;
        return this;
    }

    public StringDt addExclude() {
        StringDt newType = new StringDt();
        this.getExclude().add(newType);
        return newType;
    }

    public ProcessRequest addExclude(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getExclude().add(theValue);
        return this;
    }

    public StringDt getExcludeFirstRep() {
        if (this.getExclude().isEmpty()) {
            return this.addExclude();
        }
        return this.getExclude().get(0);
    }

    public ProcessRequest addExclude(String theString) {
        if (this.myExclude == null) {
            this.myExclude = new ArrayList<StringDt>();
        }
        this.myExclude.add(new StringDt(theString));
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public ProcessRequest setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public String getResourceName() {
        return "ProcessRequest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Item
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequenceLinkId", type={IntegerDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A service line number.")
        private IntegerDt mySequenceLinkId;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySequenceLinkId});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequenceLinkId});
        }

        public IntegerDt getSequenceLinkIdElement() {
            if (this.mySequenceLinkId == null) {
                this.mySequenceLinkId = new IntegerDt();
            }
            return this.mySequenceLinkId;
        }

        public Integer getSequenceLinkId() {
            return (Integer)this.getSequenceLinkIdElement().getValue();
        }

        public Item setSequenceLinkId(IntegerDt theValue) {
            this.mySequenceLinkId = theValue;
            return this;
        }

        public Item setSequenceLinkId(int theInteger) {
            this.mySequenceLinkId = new IntegerDt(theInteger);
            return this;
        }
    }
}

