/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.CarePlan;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.DiagnosticOrder;
import ca.uhn.fhir.model.dstu2.resource.DiagnosticReport;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.ProcedureRequest;
import ca.uhn.fhir.model.dstu2.resource.ReferralRequest;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.dstu2.valueset.ProcedureStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Procedure", profile="http://hl7.org/fhir/profiles/Procedure", id="procedure")
public class Procedure
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="code", path="Procedure.code", description="A code to identify a  procedure", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="identifier", path="Procedure.identifier", description="A unique identifier for a procedure", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="date", path="Procedure.performed[x]", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="performer", path="Procedure.performer.actor", description="", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    @SearchParamDefinition(name="location", path="Procedure.location", description="", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="encounter", path="Procedure.encounter", description="", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="subject", path="Procedure.subject", description="Search by subject", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="Procedure.subject", description="Search by subject - a patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_ENCOUNTER = new Include("Procedure:encounter");
    public static final Include INCLUDE_LOCATION = new Include("Procedure:location");
    public static final Include INCLUDE_PATIENT = new Include("Procedure:patient");
    public static final Include INCLUDE_PERFORMER = new Include("Procedure:performer");
    public static final Include INCLUDE_SUBJECT = new Include("Procedure:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="This records identifiers associated with this procedure that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=1, min=1, max=1, summary=true, modifier=false, type={Patient.class, Group.class})
    @Description(shortDefinition="who.focus", formalDefinition="The person, animal or group on which the procedure was performed")
    private ResourceReferenceDt mySubject;
    @Child(name="status", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="A code specifying the state of the procedure. Generally this will be in-progress or completed state.")
    private BoundCodeDt<ProcedureStatusEnum> myStatus;
    @Child(name="category", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\")")
    private CodeableConceptDt myCategory;
    @Child(name="code", type={CodeableConceptDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded (e.g. \"Laparoscopic Appendectomy\")")
    private CodeableConceptDt myCode;
    @Child(name="notPerformed", type={BooleanDt.class}, order=5, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="Set this to true if the record is saying that the procedure was NOT performed")
    private BooleanDt myNotPerformed;
    @Child(name="reasonNotPerformed", type={CodeableConceptDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A code indicating why the procedure was not performed.")
    private List<CodeableConceptDt> myReasonNotPerformed;
    @Child(name="bodySite", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion")
    private List<CodeableConceptDt> myBodySite;
    @Child(name="reason", order=8, min=0, max=1, summary=true, modifier=false, type={CodeableConceptDt.class, Condition.class})
    @Description(shortDefinition="", formalDefinition="The reason why the procedure was performed. This may be due to a Condition, may be coded entity of some type, or may simply be present as text")
    private IDatatype myReason;
    @Child(name="performer", order=9, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Limited to 'real' people rather than equipment")
    private List<Performer> myPerformer;
    @Child(name="performed", order=10, min=0, max=1, summary=true, modifier=false, type={DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="when.done", formalDefinition="The date(time)/period over which the procedure was performed. Allows a period to support complex procedures that span more than one date, and also allows for the length of the procedure to be captured.")
    private IDatatype myPerformed;
    @Child(name="encounter", order=11, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The encounter during which the procedure was performed")
    private ResourceReferenceDt myEncounter;
    @Child(name="location", order=12, min=0, max=1, summary=true, modifier=false, type={Location.class})
    @Description(shortDefinition="where", formalDefinition="The location where the procedure actually happened.  E.g. a newborn at home, a tracheostomy at a restaurant")
    private ResourceReferenceDt myLocation;
    @Child(name="outcome", type={CodeableConceptDt.class}, order=13, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The outcome of the procedure - did it resolve reasons for the procedure being performed?")
    private CodeableConceptDt myOutcome;
    @Child(name="report", order=14, min=0, max=-1, summary=false, modifier=false, type={DiagnosticReport.class})
    @Description(shortDefinition="", formalDefinition="This could be a histology result, pathology report, surgical report, etc..")
    private List<ResourceReferenceDt> myReport;
    @Child(name="complication", type={CodeableConceptDt.class}, order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the notes, which will typically describe the procedure itself rather than any 'post procedure' issues")
    private List<CodeableConceptDt> myComplication;
    @Child(name="followUp", type={CodeableConceptDt.class}, order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="If the procedure required specific follow up - e.g. removal of sutures. The followup may be represented as a simple note, or could potentially be more complex in which case the CarePlan resource can be used")
    private List<CodeableConceptDt> myFollowUp;
    @Child(name="request", order=17, min=0, max=1, summary=false, modifier=false, type={CarePlan.class, DiagnosticOrder.class, ProcedureRequest.class, ReferralRequest.class})
    @Description(shortDefinition="", formalDefinition="A reference to a resource that contains details of the request for this procedure.")
    private ResourceReferenceDt myRequest;
    @Child(name="notes", type={AnnotationDt.class}, order=18, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Any other notes about the procedure.  E.g. the operative notes")
    private List<AnnotationDt> myNotes;
    @Child(name="focalDevice", order=19, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A device that is implanted, removed or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.")
    private List<FocalDevice> myFocalDevice;
    @Child(name="used", order=20, min=0, max=-1, summary=false, modifier=false, type={Device.class, Medication.class, Substance.class})
    @Description(shortDefinition="", formalDefinition="Identifies medications, devices and any other substance used as part of the procedure")
    private List<ResourceReferenceDt> myUsed;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.mySubject, this.myStatus, this.myCategory, this.myCode, this.myNotPerformed, this.myReasonNotPerformed, this.myBodySite, this.myReason, this.myPerformer, this.myPerformed, this.myEncounter, this.myLocation, this.myOutcome, this.myReport, this.myComplication, this.myFollowUp, this.myRequest, this.myNotes, this.myFocalDevice, this.myUsed});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.mySubject, this.myStatus, this.myCategory, this.myCode, this.myNotPerformed, this.myReasonNotPerformed, this.myBodySite, this.myReason, this.myPerformer, this.myPerformed, this.myEncounter, this.myLocation, this.myOutcome, this.myReport, this.myComplication, this.myFollowUp, this.myRequest, this.myNotes, this.myFocalDevice, this.myUsed});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Procedure setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Procedure addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Procedure setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public BoundCodeDt<ProcedureStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ProcedureStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Procedure setStatus(BoundCodeDt<ProcedureStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Procedure setStatus(ProcedureStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ProcedureStatusEnum>)new BoundCodeDt(ProcedureStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeableConceptDt getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public Procedure setCategory(CodeableConceptDt theValue) {
        this.myCategory = theValue;
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Procedure setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public BooleanDt getNotPerformedElement() {
        if (this.myNotPerformed == null) {
            this.myNotPerformed = new BooleanDt();
        }
        return this.myNotPerformed;
    }

    public Boolean getNotPerformed() {
        return (Boolean)this.getNotPerformedElement().getValue();
    }

    public Procedure setNotPerformed(BooleanDt theValue) {
        this.myNotPerformed = theValue;
        return this;
    }

    public Procedure setNotPerformed(boolean theBoolean) {
        this.myNotPerformed = new BooleanDt(theBoolean);
        return this;
    }

    public List<CodeableConceptDt> getReasonNotPerformed() {
        if (this.myReasonNotPerformed == null) {
            this.myReasonNotPerformed = new ArrayList<CodeableConceptDt>();
        }
        return this.myReasonNotPerformed;
    }

    public Procedure setReasonNotPerformed(List<CodeableConceptDt> theValue) {
        this.myReasonNotPerformed = theValue;
        return this;
    }

    public CodeableConceptDt addReasonNotPerformed() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReasonNotPerformed().add(newType);
        return newType;
    }

    public Procedure addReasonNotPerformed(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReasonNotPerformed().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonNotPerformedFirstRep() {
        if (this.getReasonNotPerformed().isEmpty()) {
            return this.addReasonNotPerformed();
        }
        return this.getReasonNotPerformed().get(0);
    }

    public List<CodeableConceptDt> getBodySite() {
        if (this.myBodySite == null) {
            this.myBodySite = new ArrayList<CodeableConceptDt>();
        }
        return this.myBodySite;
    }

    public Procedure setBodySite(List<CodeableConceptDt> theValue) {
        this.myBodySite = theValue;
        return this;
    }

    public CodeableConceptDt addBodySite() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getBodySite().add(newType);
        return newType;
    }

    public Procedure addBodySite(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getBodySite().add(theValue);
        return this;
    }

    public CodeableConceptDt getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            return this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public IDatatype getReason() {
        return this.myReason;
    }

    public Procedure setReason(IDatatype theValue) {
        this.myReason = theValue;
        return this;
    }

    public List<Performer> getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ArrayList<Performer>();
        }
        return this.myPerformer;
    }

    public Procedure setPerformer(List<Performer> theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public Performer addPerformer() {
        Performer newType = new Performer();
        this.getPerformer().add(newType);
        return newType;
    }

    public Procedure addPerformer(Performer theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPerformer().add(theValue);
        return this;
    }

    public Performer getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            return this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public IDatatype getPerformed() {
        return this.myPerformed;
    }

    public Procedure setPerformed(IDatatype theValue) {
        this.myPerformed = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Procedure setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public Procedure setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public CodeableConceptDt getOutcome() {
        if (this.myOutcome == null) {
            this.myOutcome = new CodeableConceptDt();
        }
        return this.myOutcome;
    }

    public Procedure setOutcome(CodeableConceptDt theValue) {
        this.myOutcome = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getReport() {
        if (this.myReport == null) {
            this.myReport = new ArrayList<ResourceReferenceDt>();
        }
        return this.myReport;
    }

    public Procedure setReport(List<ResourceReferenceDt> theValue) {
        this.myReport = theValue;
        return this;
    }

    public ResourceReferenceDt addReport() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getReport().add(newType);
        return newType;
    }

    public List<CodeableConceptDt> getComplication() {
        if (this.myComplication == null) {
            this.myComplication = new ArrayList<CodeableConceptDt>();
        }
        return this.myComplication;
    }

    public Procedure setComplication(List<CodeableConceptDt> theValue) {
        this.myComplication = theValue;
        return this;
    }

    public CodeableConceptDt addComplication() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getComplication().add(newType);
        return newType;
    }

    public Procedure addComplication(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getComplication().add(theValue);
        return this;
    }

    public CodeableConceptDt getComplicationFirstRep() {
        if (this.getComplication().isEmpty()) {
            return this.addComplication();
        }
        return this.getComplication().get(0);
    }

    public List<CodeableConceptDt> getFollowUp() {
        if (this.myFollowUp == null) {
            this.myFollowUp = new ArrayList<CodeableConceptDt>();
        }
        return this.myFollowUp;
    }

    public Procedure setFollowUp(List<CodeableConceptDt> theValue) {
        this.myFollowUp = theValue;
        return this;
    }

    public CodeableConceptDt addFollowUp() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getFollowUp().add(newType);
        return newType;
    }

    public Procedure addFollowUp(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getFollowUp().add(theValue);
        return this;
    }

    public CodeableConceptDt getFollowUpFirstRep() {
        if (this.getFollowUp().isEmpty()) {
            return this.addFollowUp();
        }
        return this.getFollowUp().get(0);
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public Procedure setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public List<AnnotationDt> getNotes() {
        if (this.myNotes == null) {
            this.myNotes = new ArrayList<AnnotationDt>();
        }
        return this.myNotes;
    }

    public Procedure setNotes(List<AnnotationDt> theValue) {
        this.myNotes = theValue;
        return this;
    }

    public AnnotationDt addNotes() {
        AnnotationDt newType = new AnnotationDt();
        this.getNotes().add(newType);
        return newType;
    }

    public Procedure addNotes(AnnotationDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNotes().add(theValue);
        return this;
    }

    public AnnotationDt getNotesFirstRep() {
        if (this.getNotes().isEmpty()) {
            return this.addNotes();
        }
        return this.getNotes().get(0);
    }

    public List<FocalDevice> getFocalDevice() {
        if (this.myFocalDevice == null) {
            this.myFocalDevice = new ArrayList<FocalDevice>();
        }
        return this.myFocalDevice;
    }

    public Procedure setFocalDevice(List<FocalDevice> theValue) {
        this.myFocalDevice = theValue;
        return this;
    }

    public FocalDevice addFocalDevice() {
        FocalDevice newType = new FocalDevice();
        this.getFocalDevice().add(newType);
        return newType;
    }

    public Procedure addFocalDevice(FocalDevice theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getFocalDevice().add(theValue);
        return this;
    }

    public FocalDevice getFocalDeviceFirstRep() {
        if (this.getFocalDevice().isEmpty()) {
            return this.addFocalDevice();
        }
        return this.getFocalDevice().get(0);
    }

    public List<ResourceReferenceDt> getUsed() {
        if (this.myUsed == null) {
            this.myUsed = new ArrayList<ResourceReferenceDt>();
        }
        return this.myUsed;
    }

    public Procedure setUsed(List<ResourceReferenceDt> theValue) {
        this.myUsed = theValue;
        return this;
    }

    public ResourceReferenceDt addUsed() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getUsed().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "Procedure";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class FocalDevice
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="action", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The kind of change that happened to the device during the procedure")
        private CodeableConceptDt myAction;
        @Child(name="manipulated", order=1, min=1, max=1, summary=false, modifier=false, type={Device.class})
        @Description(shortDefinition="", formalDefinition="The device that was manipulated (changed) during the procedure")
        private ResourceReferenceDt myManipulated;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myAction, this.myManipulated});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAction, this.myManipulated});
        }

        public CodeableConceptDt getAction() {
            if (this.myAction == null) {
                this.myAction = new CodeableConceptDt();
            }
            return this.myAction;
        }

        public FocalDevice setAction(CodeableConceptDt theValue) {
            this.myAction = theValue;
            return this;
        }

        public ResourceReferenceDt getManipulated() {
            if (this.myManipulated == null) {
                this.myManipulated = new ResourceReferenceDt();
            }
            return this.myManipulated;
        }

        public FocalDevice setManipulated(ResourceReferenceDt theValue) {
            this.myManipulated = theValue;
            return this;
        }
    }

    @Block
    public static class Performer
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="actor", order=0, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class})
        @Description(shortDefinition="who.actor", formalDefinition="The practitioner who was involved in the procedure")
        private ResourceReferenceDt myActor;
        @Child(name="role", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="For example: surgeon, anaethetist, endoscopist")
        private CodeableConceptDt myRole;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myActor, this.myRole});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myActor, this.myRole});
        }

        public ResourceReferenceDt getActor() {
            if (this.myActor == null) {
                this.myActor = new ResourceReferenceDt();
            }
            return this.myActor;
        }

        public Performer setActor(ResourceReferenceDt theValue) {
            this.myActor = theValue;
            return this;
        }

        public CodeableConceptDt getRole() {
            if (this.myRole == null) {
                this.myRole = new CodeableConceptDt();
            }
            return this.myRole;
        }

        public Performer setRole(CodeableConceptDt theValue) {
            this.myRole = theValue;
            return this;
        }
    }
}

