/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AddressDt;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.AdministrativeGenderEnum;
import ca.uhn.fhir.model.dstu2.valueset.AnimalSpeciesEnum;
import ca.uhn.fhir.model.dstu2.valueset.LinkTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.MaritalStatusCodesEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Patient", profile="http://hl7.org/fhir/profiles/Patient", id="patient")
public class Patient
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Patient.identifier", description="A patient identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Patient.name", description="A portion of either family or given name of the patient", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="family", path="Patient.name.family", description="A portion of the family name of the patient", type="string")
    public static final String SP_FAMILY = "family";
    public static final StringClientParam FAMILY = new StringClientParam("family");
    @SearchParamDefinition(name="given", path="Patient.name.given", description="A portion of the given name of the patient", type="string")
    public static final String SP_GIVEN = "given";
    public static final StringClientParam GIVEN = new StringClientParam("given");
    @SearchParamDefinition(name="phonetic", path="Patient.name", description="A portion of either family or given name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="Patient.telecom", description="The value in any kind of telecom details of the patient", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="phone", path="Patient.telecom(system=phone)", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="email", path="Patient.telecom(system=email)", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="address", path="Patient.address", description="An address in any kind of address/part of the patient", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-city", path="Patient.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-state", path="Patient.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="address-postalcode", path="Patient.address.postalCode", description="A postalCode specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="Patient.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="address-use", path="Patient.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="gender", path="Patient.gender", description="Gender of the patient", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="language", path="Patient.communication.language", description="Language code (irrespective of use value)", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="birthdate", path="Patient.birthDate", description="The patient's date of birth", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    public static final DateClientParam BIRTHDATE = new DateClientParam("birthdate");
    @SearchParamDefinition(name="organization", path="Patient.managingOrganization", description="The organization at which this person is a patient", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    @SearchParamDefinition(name="careprovider", path="Patient.careProvider", description="Patient's nominated care provider, could be a care manager, not the organization that manages the record", type="reference")
    public static final String SP_CAREPROVIDER = "careprovider";
    public static final ReferenceClientParam CAREPROVIDER = new ReferenceClientParam("careprovider");
    @SearchParamDefinition(name="active", path="Patient.active", description="Whether the patient record is active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="animal-species", path="Patient.animal.species", description="The species for animal patients", type="token")
    public static final String SP_ANIMAL_SPECIES = "animal-species";
    public static final TokenClientParam ANIMAL_SPECIES = new TokenClientParam("animal-species");
    @SearchParamDefinition(name="animal-breed", path="Patient.animal.breed", description="The breed for animal patients", type="token")
    public static final String SP_ANIMAL_BREED = "animal-breed";
    public static final TokenClientParam ANIMAL_BREED = new TokenClientParam("animal-breed");
    @SearchParamDefinition(name="link", path="Patient.link.other", description="All patients linked to the given patient", type="reference")
    public static final String SP_LINK = "link";
    public static final ReferenceClientParam LINK = new ReferenceClientParam("link");
    @SearchParamDefinition(name="deceased", path="Patient.deceased[x]", description="This patient has been marked as deceased, or as a death date entered", type="token")
    public static final String SP_DECEASED = "deceased";
    public static final TokenClientParam DECEASED = new TokenClientParam("deceased");
    @SearchParamDefinition(name="deathdate", path="Patient.deceasedDateTime", description="The date of death has been provided and satisfies this search value", type="date")
    public static final String SP_DEATHDATE = "deathdate";
    public static final DateClientParam DEATHDATE = new DateClientParam("deathdate");
    public static final Include INCLUDE_CAREPROVIDER = new Include("Patient:careprovider");
    public static final Include INCLUDE_LINK = new Include("Patient:link");
    public static final Include INCLUDE_ORGANIZATION = new Include("Patient:organization");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="An identifier for this patient")
    private List<IdentifierDt> myIdentifier;
    @Child(name="active", type={BooleanDt.class}, order=1, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Whether this patient record is in active use")
    private BooleanDt myActive;
    @Child(name="name", type={HumanNameDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A name associated with the individual.")
    private List<HumanNameDt> myName;
    @Child(name="telecom", type={ContactPointDt.class}, order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.")
    private List<ContactPointDt> myTelecom;
    @Child(name="gender", type={CodeDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Administrative Gender - the gender that the patient is considered to have for administration and record keeping purposes.")
    private BoundCodeDt<AdministrativeGenderEnum> myGender;
    @Child(name="birthDate", type={DateDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date of birth for the individual")
    private DateDt myBirthDate;
    @Child(name="deceased", order=6, min=0, max=1, summary=true, modifier=true, type={BooleanDt.class, DateTimeDt.class})
    @Description(shortDefinition="", formalDefinition="Indicates if the individual is deceased or not")
    private IDatatype myDeceased;
    @Child(name="address", type={AddressDt.class}, order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Addresses for the individual")
    private List<AddressDt> myAddress;
    @Child(name="maritalStatus", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="This field contains a patient's most recent marital (civil) status.")
    private BoundCodeableConceptDt<MaritalStatusCodesEnum> myMaritalStatus;
    @Child(name="multipleBirth", order=9, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, IntegerDt.class})
    @Description(shortDefinition="", formalDefinition="Indicates whether the patient is part of a multiple or indicates the actual birth order.")
    private IDatatype myMultipleBirth;
    @Child(name="photo", type={AttachmentDt.class}, order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Image of the patient")
    private List<AttachmentDt> myPhoto;
    @Child(name="contact", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A contact party (e.g. guardian, partner, friend) for the patient")
    private List<Contact> myContact;
    @Child(name="animal", order=12, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="", formalDefinition="This patient is known to be an animal")
    private Animal myAnimal;
    @Child(name="communication", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Languages which may be used to communicate with the patient about his or her health")
    private List<Communication> myCommunication;
    @Child(name="careProvider", order=14, min=0, max=-1, summary=false, modifier=false, type={Organization.class, Practitioner.class})
    @Description(shortDefinition="", formalDefinition="Patient's nominated care provider")
    private List<ResourceReferenceDt> myCareProvider;
    @Child(name="managingOrganization", order=15, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="Organization that is the custodian of the patient record")
    private ResourceReferenceDt myManagingOrganization;
    @Child(name="link", order=16, min=0, max=-1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="Link to another patient resource that concerns the same actual patient")
    private List<Link> myLink;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myActive, this.myName, this.myTelecom, this.myGender, this.myBirthDate, this.myDeceased, this.myAddress, this.myMaritalStatus, this.myMultipleBirth, this.myPhoto, this.myContact, this.myAnimal, this.myCommunication, this.myCareProvider, this.myManagingOrganization, this.myLink});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myActive, this.myName, this.myTelecom, this.myGender, this.myBirthDate, this.myDeceased, this.myAddress, this.myMaritalStatus, this.myMultipleBirth, this.myPhoto, this.myContact, this.myAnimal, this.myCommunication, this.myCareProvider, this.myManagingOrganization, this.myLink});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Patient setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Patient addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanDt getActiveElement() {
        if (this.myActive == null) {
            this.myActive = new BooleanDt();
        }
        return this.myActive;
    }

    public Boolean getActive() {
        return (Boolean)this.getActiveElement().getValue();
    }

    public Patient setActive(BooleanDt theValue) {
        this.myActive = theValue;
        return this;
    }

    public Patient setActive(boolean theBoolean) {
        this.myActive = new BooleanDt(theBoolean);
        return this;
    }

    public List<HumanNameDt> getName() {
        if (this.myName == null) {
            this.myName = new ArrayList<HumanNameDt>();
        }
        return this.myName;
    }

    public Patient setName(List<HumanNameDt> theValue) {
        this.myName = theValue;
        return this;
    }

    public HumanNameDt addName() {
        HumanNameDt newType = new HumanNameDt();
        this.getName().add(newType);
        return newType;
    }

    public Patient addName(HumanNameDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getName().add(theValue);
        return this;
    }

    public HumanNameDt getNameFirstRep() {
        if (this.getName().isEmpty()) {
            return this.addName();
        }
        return this.getName().get(0);
    }

    public List<ContactPointDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactPointDt>();
        }
        return this.myTelecom;
    }

    public Patient setTelecom(List<ContactPointDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactPointDt addTelecom() {
        ContactPointDt newType = new ContactPointDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public Patient addTelecom(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTelecom().add(theValue);
        return this;
    }

    public ContactPointDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public BoundCodeDt<AdministrativeGenderEnum> getGenderElement() {
        if (this.myGender == null) {
            this.myGender = new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER);
        }
        return this.myGender;
    }

    public String getGender() {
        return (String)this.getGenderElement().getValue();
    }

    public Patient setGender(BoundCodeDt<AdministrativeGenderEnum> theValue) {
        this.myGender = theValue;
        return this;
    }

    public Patient setGender(AdministrativeGenderEnum theValue) {
        this.setGender((BoundCodeDt<AdministrativeGenderEnum>)new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public DateDt getBirthDateElement() {
        if (this.myBirthDate == null) {
            this.myBirthDate = new DateDt();
        }
        return this.myBirthDate;
    }

    public Date getBirthDate() {
        return (Date)this.getBirthDateElement().getValue();
    }

    public Patient setBirthDate(DateDt theValue) {
        this.myBirthDate = theValue;
        return this;
    }

    public Patient setBirthDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myBirthDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public Patient setBirthDateWithDayPrecision(Date theDate) {
        this.myBirthDate = new DateDt(theDate);
        return this;
    }

    public IDatatype getDeceased() {
        return this.myDeceased;
    }

    public Patient setDeceased(IDatatype theValue) {
        this.myDeceased = theValue;
        return this;
    }

    public List<AddressDt> getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public Patient setAddress(List<AddressDt> theValue) {
        this.myAddress = theValue;
        return this;
    }

    public AddressDt addAddress() {
        AddressDt newType = new AddressDt();
        this.getAddress().add(newType);
        return newType;
    }

    public Patient addAddress(AddressDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAddress().add(theValue);
        return this;
    }

    public AddressDt getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            return this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public BoundCodeableConceptDt<MaritalStatusCodesEnum> getMaritalStatus() {
        if (this.myMaritalStatus == null) {
            this.myMaritalStatus = new BoundCodeableConceptDt<MaritalStatusCodesEnum>(MaritalStatusCodesEnum.VALUESET_BINDER);
        }
        return this.myMaritalStatus;
    }

    public Patient setMaritalStatus(BoundCodeableConceptDt<MaritalStatusCodesEnum> theValue) {
        this.myMaritalStatus = theValue;
        return this;
    }

    public Patient setMaritalStatus(MaritalStatusCodesEnum theValue) {
        this.setMaritalStatus(new BoundCodeableConceptDt<MaritalStatusCodesEnum>(MaritalStatusCodesEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public IDatatype getMultipleBirth() {
        return this.myMultipleBirth;
    }

    public Patient setMultipleBirth(IDatatype theValue) {
        this.myMultipleBirth = theValue;
        return this;
    }

    public List<AttachmentDt> getPhoto() {
        if (this.myPhoto == null) {
            this.myPhoto = new ArrayList<AttachmentDt>();
        }
        return this.myPhoto;
    }

    public Patient setPhoto(List<AttachmentDt> theValue) {
        this.myPhoto = theValue;
        return this;
    }

    public AttachmentDt addPhoto() {
        AttachmentDt newType = new AttachmentDt();
        this.getPhoto().add(newType);
        return newType;
    }

    public Patient addPhoto(AttachmentDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPhoto().add(theValue);
        return this;
    }

    public AttachmentDt getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            return this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public Patient setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public Patient addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public Animal getAnimal() {
        if (this.myAnimal == null) {
            this.myAnimal = new Animal();
        }
        return this.myAnimal;
    }

    public Patient setAnimal(Animal theValue) {
        this.myAnimal = theValue;
        return this;
    }

    public List<Communication> getCommunication() {
        if (this.myCommunication == null) {
            this.myCommunication = new ArrayList<Communication>();
        }
        return this.myCommunication;
    }

    public Patient setCommunication(List<Communication> theValue) {
        this.myCommunication = theValue;
        return this;
    }

    public Communication addCommunication() {
        Communication newType = new Communication();
        this.getCommunication().add(newType);
        return newType;
    }

    public Patient addCommunication(Communication theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCommunication().add(theValue);
        return this;
    }

    public Communication getCommunicationFirstRep() {
        if (this.getCommunication().isEmpty()) {
            return this.addCommunication();
        }
        return this.getCommunication().get(0);
    }

    public List<ResourceReferenceDt> getCareProvider() {
        if (this.myCareProvider == null) {
            this.myCareProvider = new ArrayList<ResourceReferenceDt>();
        }
        return this.myCareProvider;
    }

    public Patient setCareProvider(List<ResourceReferenceDt> theValue) {
        this.myCareProvider = theValue;
        return this;
    }

    public ResourceReferenceDt addCareProvider() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getCareProvider().add(newType);
        return newType;
    }

    public ResourceReferenceDt getManagingOrganization() {
        if (this.myManagingOrganization == null) {
            this.myManagingOrganization = new ResourceReferenceDt();
        }
        return this.myManagingOrganization;
    }

    public Patient setManagingOrganization(ResourceReferenceDt theValue) {
        this.myManagingOrganization = theValue;
        return this;
    }

    public List<Link> getLink() {
        if (this.myLink == null) {
            this.myLink = new ArrayList<Link>();
        }
        return this.myLink;
    }

    public Patient setLink(List<Link> theValue) {
        this.myLink = theValue;
        return this;
    }

    public Link addLink() {
        Link newType = new Link();
        this.getLink().add(newType);
        return newType;
    }

    public Patient addLink(Link theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getLink().add(theValue);
        return this;
    }

    public Link getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            return this.addLink();
        }
        return this.getLink().get(0);
    }

    public String getResourceName() {
        return "Patient";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Link
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="other", order=0, min=1, max=1, summary=false, modifier=true, type={Patient.class})
        @Description(shortDefinition="", formalDefinition="The other patient resource that the link refers to")
        private ResourceReferenceDt myOther;
        @Child(name="type", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=true)
        @Description(shortDefinition="", formalDefinition="The type of link between this patient resource and another patient resource.")
        private BoundCodeDt<LinkTypeEnum> myType;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myOther, this.myType});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myOther, this.myType});
        }

        public ResourceReferenceDt getOther() {
            if (this.myOther == null) {
                this.myOther = new ResourceReferenceDt();
            }
            return this.myOther;
        }

        public Link setOther(ResourceReferenceDt theValue) {
            this.myOther = theValue;
            return this;
        }

        public BoundCodeDt<LinkTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(LinkTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public Link setType(BoundCodeDt<LinkTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Link setType(LinkTypeEnum theValue) {
            this.setType((BoundCodeDt<LinkTypeEnum>)new BoundCodeDt(LinkTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }
    }

    @Block
    public static class Communication
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="language", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English")
        private CodeableConceptDt myLanguage;
        @Child(name="preferred", type={BooleanDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates whether or not the patient prefers this language (over other languages he masters up a certain level)")
        private BooleanDt myPreferred;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLanguage, this.myPreferred});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLanguage, this.myPreferred});
        }

        public CodeableConceptDt getLanguage() {
            if (this.myLanguage == null) {
                this.myLanguage = new CodeableConceptDt();
            }
            return this.myLanguage;
        }

        public Communication setLanguage(CodeableConceptDt theValue) {
            this.myLanguage = theValue;
            return this;
        }

        public BooleanDt getPreferredElement() {
            if (this.myPreferred == null) {
                this.myPreferred = new BooleanDt();
            }
            return this.myPreferred;
        }

        public Boolean getPreferred() {
            return (Boolean)this.getPreferredElement().getValue();
        }

        public Communication setPreferred(BooleanDt theValue) {
            this.myPreferred = theValue;
            return this;
        }

        public Communication setPreferred(boolean theBoolean) {
            this.myPreferred = new BooleanDt(theBoolean);
            return this;
        }
    }

    @Block
    public static class Animal
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="species", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the high level taxonomic categorization of the kind of animal")
        private BoundCodeableConceptDt<AnimalSpeciesEnum> mySpecies;
        @Child(name="breed", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the detailed categorization of the kind of animal.")
        private CodeableConceptDt myBreed;
        @Child(name="genderStatus", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the current state of the animal's reproductive organs")
        private CodeableConceptDt myGenderStatus;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySpecies, this.myBreed, this.myGenderStatus});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySpecies, this.myBreed, this.myGenderStatus});
        }

        public BoundCodeableConceptDt<AnimalSpeciesEnum> getSpecies() {
            if (this.mySpecies == null) {
                this.mySpecies = new BoundCodeableConceptDt<AnimalSpeciesEnum>(AnimalSpeciesEnum.VALUESET_BINDER);
            }
            return this.mySpecies;
        }

        public Animal setSpecies(BoundCodeableConceptDt<AnimalSpeciesEnum> theValue) {
            this.mySpecies = theValue;
            return this;
        }

        public Animal setSpecies(AnimalSpeciesEnum theValue) {
            this.setSpecies(new BoundCodeableConceptDt<AnimalSpeciesEnum>(AnimalSpeciesEnum.VALUESET_BINDER, theValue));
            return this;
        }

        public CodeableConceptDt getBreed() {
            if (this.myBreed == null) {
                this.myBreed = new CodeableConceptDt();
            }
            return this.myBreed;
        }

        public Animal setBreed(CodeableConceptDt theValue) {
            this.myBreed = theValue;
            return this;
        }

        public CodeableConceptDt getGenderStatus() {
            if (this.myGenderStatus == null) {
                this.myGenderStatus = new CodeableConceptDt();
            }
            return this.myGenderStatus;
        }

        public Animal setGenderStatus(CodeableConceptDt theValue) {
            this.myGenderStatus = theValue;
            return this;
        }
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="relationship", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The nature of the relationship between the patient and the contact person")
        private List<CodeableConceptDt> myRelationship;
        @Child(name="name", type={HumanNameDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A name associated with the contact person")
        private HumanNameDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
        private List<ContactPointDt> myTelecom;
        @Child(name="address", type={AddressDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Address for the contact person")
        private AddressDt myAddress;
        @Child(name="gender", type={CodeDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Administrative Gender - the gender that the contact person is considered to have for administration and record keeping purposes.")
        private BoundCodeDt<AdministrativeGenderEnum> myGender;
        @Child(name="organization", order=5, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="", formalDefinition="Organization on behalf of which the contact is acting or for which the contact is working.")
        private ResourceReferenceDt myOrganization;
        @Child(name="period", type={PeriodDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The period during which this contact person or organization is valid to be contacted relating to this patient")
        private PeriodDt myPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myRelationship, this.myName, this.myTelecom, this.myAddress, this.myGender, this.myOrganization, this.myPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRelationship, this.myName, this.myTelecom, this.myAddress, this.myGender, this.myOrganization, this.myPeriod});
        }

        public List<CodeableConceptDt> getRelationship() {
            if (this.myRelationship == null) {
                this.myRelationship = new ArrayList<CodeableConceptDt>();
            }
            return this.myRelationship;
        }

        public Contact setRelationship(List<CodeableConceptDt> theValue) {
            this.myRelationship = theValue;
            return this;
        }

        public CodeableConceptDt addRelationship() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getRelationship().add(newType);
            return newType;
        }

        public Contact addRelationship(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getRelationship().add(theValue);
            return this;
        }

        public CodeableConceptDt getRelationshipFirstRep() {
            if (this.getRelationship().isEmpty()) {
                return this.addRelationship();
            }
            return this.getRelationship().get(0);
        }

        public HumanNameDt getName() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public Contact setName(HumanNameDt theValue) {
            this.myName = theValue;
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public AddressDt getAddress() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public Contact setAddress(AddressDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public BoundCodeDt<AdministrativeGenderEnum> getGenderElement() {
            if (this.myGender == null) {
                this.myGender = new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER);
            }
            return this.myGender;
        }

        public String getGender() {
            return (String)this.getGenderElement().getValue();
        }

        public Contact setGender(BoundCodeDt<AdministrativeGenderEnum> theValue) {
            this.myGender = theValue;
            return this;
        }

        public Contact setGender(AdministrativeGenderEnum theValue) {
            this.setGender((BoundCodeDt<AdministrativeGenderEnum>)new BoundCodeDt(AdministrativeGenderEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public ResourceReferenceDt getOrganization() {
            if (this.myOrganization == null) {
                this.myOrganization = new ResourceReferenceDt();
            }
            return this.myOrganization;
        }

        public Contact setOrganization(ResourceReferenceDt theValue) {
            this.myOrganization = theValue;
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Contact setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }
    }
}

