/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Order;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.OrderStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="OrderResponse", profile="http://hl7.org/fhir/profiles/OrderResponse", id="orderresponse")
public class OrderResponse
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="request", path="OrderResponse.request", description="", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    @SearchParamDefinition(name="date", path="OrderResponse.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="who", path="OrderResponse.who", description="", type="reference")
    public static final String SP_WHO = "who";
    public static final ReferenceClientParam WHO = new ReferenceClientParam("who");
    @SearchParamDefinition(name="code", path="OrderResponse.orderStatus", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="fulfillment", path="OrderResponse.fulfillment", description="", type="reference")
    public static final String SP_FULFILLMENT = "fulfillment";
    public static final ReferenceClientParam FULFILLMENT = new ReferenceClientParam("fulfillment");
    @SearchParamDefinition(name="identifier", path="OrderResponse.identifier", description="Identifiers assigned to this order by the orderer or by the receiver", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_FULFILLMENT = new Include("OrderResponse:fulfillment");
    public static final Include INCLUDE_REQUEST = new Include("OrderResponse:request");
    public static final Include INCLUDE_WHO = new Include("OrderResponse:who");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifiers assigned to this order. The identifiers are usually assigned by the system responding to the order, but they may be provided or added to by other systems")
    private List<IdentifierDt> myIdentifier;
    @Child(name="request", order=1, min=1, max=1, summary=false, modifier=false, type={Order.class})
    @Description(shortDefinition="", formalDefinition="A reference to the order that this is in response to")
    private ResourceReferenceDt myRequest;
    @Child(name="date", type={DateTimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date and time at which this order response was made (created/posted)")
    private DateTimeDt myDate;
    @Child(name="who", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class, Device.class})
    @Description(shortDefinition="who.actor", formalDefinition="The person, organization, or device credited with making the response")
    private ResourceReferenceDt myWho;
    @Child(name="orderStatus", type={CodeDt.class}, order=4, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="What this response says about the status of the original order")
    private BoundCodeDt<OrderStatusEnum> myOrderStatus;
    @Child(name="description", type={StringDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Additional description about the response - e.g. a text description provided by a human user when making decisions about the order")
    private StringDt myDescription;
    @Child(name="fulfillment", order=6, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Links to resources that provide details of the outcome of performing the order; e.g. Diagnostic Reports in a response that is made to an order that referenced a diagnostic order")
    private List<ResourceReferenceDt> myFulfillment;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRequest, this.myDate, this.myWho, this.myOrderStatus, this.myDescription, this.myFulfillment});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRequest, this.myDate, this.myWho, this.myOrderStatus, this.myDescription, this.myFulfillment});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public OrderResponse setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public OrderResponse addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public OrderResponse setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public OrderResponse setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public OrderResponse setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public OrderResponse setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getWho() {
        if (this.myWho == null) {
            this.myWho = new ResourceReferenceDt();
        }
        return this.myWho;
    }

    public OrderResponse setWho(ResourceReferenceDt theValue) {
        this.myWho = theValue;
        return this;
    }

    public BoundCodeDt<OrderStatusEnum> getOrderStatusElement() {
        if (this.myOrderStatus == null) {
            this.myOrderStatus = new BoundCodeDt(OrderStatusEnum.VALUESET_BINDER);
        }
        return this.myOrderStatus;
    }

    public String getOrderStatus() {
        return (String)this.getOrderStatusElement().getValue();
    }

    public OrderResponse setOrderStatus(BoundCodeDt<OrderStatusEnum> theValue) {
        this.myOrderStatus = theValue;
        return this;
    }

    public OrderResponse setOrderStatus(OrderStatusEnum theValue) {
        this.setOrderStatus((BoundCodeDt<OrderStatusEnum>)new BoundCodeDt(OrderStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public OrderResponse setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public OrderResponse setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<ResourceReferenceDt> getFulfillment() {
        if (this.myFulfillment == null) {
            this.myFulfillment = new ArrayList<ResourceReferenceDt>();
        }
        return this.myFulfillment;
    }

    public OrderResponse setFulfillment(List<ResourceReferenceDt> theValue) {
        this.myFulfillment = theValue;
        return this;
    }

    public ResourceReferenceDt addFulfillment() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getFulfillment().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "OrderResponse";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

