/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.RatioDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.AllergyIntolerance;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.EnteralFormulaTypeCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.FluidConsistencyTypeCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.NutrientModifierCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.NutritionOrderStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.SupplementTypeCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.TextureModifiedFoodTypeCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.TextureModifierCodesEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="NutritionOrder", profile="http://hl7.org/fhir/profiles/NutritionOrder", id="nutritionorder")
public class NutritionOrder
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="NutritionOrder.patient", description="The identity of the person who requires the diet, formula or nutritional supplement", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="provider", path="NutritionOrder.orderer", description="The identify of the provider who placed the nutrition order", type="reference")
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    @SearchParamDefinition(name="identifier", path="NutritionOrder.identifier", description="Return nutrition orders with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="encounter", path="NutritionOrder.encounter", description="Return nutrition orders with this encounter identifier", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="datetime", path="NutritionOrder.dateTime", description="Return nutrition orders requested on this date", type="date")
    public static final String SP_DATETIME = "datetime";
    public static final DateClientParam DATETIME = new DateClientParam("datetime");
    @SearchParamDefinition(name="status", path="NutritionOrder.status", description="Status of the nutrition order.", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="oraldiet", path="NutritionOrder.oralDiet.type", description="Type of diet that can be consumed orally (i.e., take via the mouth).", type="token")
    public static final String SP_ORALDIET = "oraldiet";
    public static final TokenClientParam ORALDIET = new TokenClientParam("oraldiet");
    @SearchParamDefinition(name="supplement", path="NutritionOrder.supplement.type", description="Type of supplement product requested", type="token")
    public static final String SP_SUPPLEMENT = "supplement";
    public static final TokenClientParam SUPPLEMENT = new TokenClientParam("supplement");
    @SearchParamDefinition(name="formula", path="NutritionOrder.enteralFormula.baseFormulaType", description="Type of enteral or infant formula", type="token")
    public static final String SP_FORMULA = "formula";
    public static final TokenClientParam FORMULA = new TokenClientParam("formula");
    @SearchParamDefinition(name="additive", path="NutritionOrder.enteralFormula.additiveType", description="Type of module component to add to the feeding", type="token")
    public static final String SP_ADDITIVE = "additive";
    public static final TokenClientParam ADDITIVE = new TokenClientParam("additive");
    public static final Include INCLUDE_ENCOUNTER = new Include("NutritionOrder:encounter");
    public static final Include INCLUDE_PATIENT = new Include("NutritionOrder:patient");
    public static final Include INCLUDE_PROVIDER = new Include("NutritionOrder:provider");
    @Child(name="patient", order=0, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The person (patient) who needs the nutrition order for an oral diet, nutritional supplement and/or enteral or formula feeding.")
    private ResourceReferenceDt myPatient;
    @Child(name="orderer", order=1, min=0, max=1, summary=true, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.author", formalDefinition="The practitioner that holds legal responsibility for ordering the diet, nutritional supplement, or formula feedings.")
    private ResourceReferenceDt myOrderer;
    @Child(name="identifier", type={IdentifierDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifiers assigned to this order by the order sender or by the order receiver")
    private List<IdentifierDt> myIdentifier;
    @Child(name="encounter", order=3, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="An encounter that provides additional information about the healthcare context in which this request is made")
    private ResourceReferenceDt myEncounter;
    @Child(name="dateTime", type={DateTimeDt.class}, order=4, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date and time that this nutrition order was requested.")
    private DateTimeDt myDateTime;
    @Child(name="status", type={CodeDt.class}, order=5, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The workflow status of the nutrition order/request.")
    private BoundCodeDt<NutritionOrderStatusEnum> myStatus;
    @Child(name="allergyIntolerance", order=6, min=0, max=-1, summary=false, modifier=false, type={AllergyIntolerance.class})
    @Description(shortDefinition="", formalDefinition="A link to a record of allergies or intolerances  which should be included in the nutrition order.")
    private List<ResourceReferenceDt> myAllergyIntolerance;
    @Child(name="foodPreferenceModifier", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="This modifier is used to convey order-specific modifiers about the type of food that should be given. These can be derived from patient allergies, intolerances, or preferences such as Halal, Vegan or Kosher. This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.")
    private List<CodeableConceptDt> myFoodPreferenceModifier;
    @Child(name="excludeFoodModifier", type={CodeableConceptDt.class}, order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="This modifier is used to convey order-specific modifiers about the type of food that should NOT be given. These can be derived from patient allergies, intolerances, or preferences such as No Red Meat, No Soy or No Wheat or  Gluten-Free.  While it should not be necessary to repeat allergy or intolerance information captured in the referenced allergyIntolerance resource in the excludeFoodModifier, this element may be used to convey additional specificity related to foods that should be eliminated from the patient\u2019s diet for any reason.  This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.")
    private List<CodeableConceptDt> myExcludeFoodModifier;
    @Child(name="oralDiet", order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Diet given orally in contrast to enteral (tube) feeding.")
    private OralDiet myOralDiet;
    @Child(name="supplement", order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Oral nutritional products given in order to add further nutritional value to the patient's diet.")
    private List<Supplement> mySupplement;
    @Child(name="enteralFormula", order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Feeding provided through the gastrointestinal tract via a tube, catheter, or stoma that delivers nutrition distal to the oral cavity.")
    private EnteralFormula myEnteralFormula;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPatient, this.myOrderer, this.myIdentifier, this.myEncounter, this.myDateTime, this.myStatus, this.myAllergyIntolerance, this.myFoodPreferenceModifier, this.myExcludeFoodModifier, this.myOralDiet, this.mySupplement, this.myEnteralFormula});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPatient, this.myOrderer, this.myIdentifier, this.myEncounter, this.myDateTime, this.myStatus, this.myAllergyIntolerance, this.myFoodPreferenceModifier, this.myExcludeFoodModifier, this.myOralDiet, this.mySupplement, this.myEnteralFormula});
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public NutritionOrder setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getOrderer() {
        if (this.myOrderer == null) {
            this.myOrderer = new ResourceReferenceDt();
        }
        return this.myOrderer;
    }

    public NutritionOrder setOrderer(ResourceReferenceDt theValue) {
        this.myOrderer = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public NutritionOrder setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public NutritionOrder addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public NutritionOrder setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public DateTimeDt getDateTimeElement() {
        if (this.myDateTime == null) {
            this.myDateTime = new DateTimeDt();
        }
        return this.myDateTime;
    }

    public Date getDateTime() {
        return (Date)this.getDateTimeElement().getValue();
    }

    public NutritionOrder setDateTime(DateTimeDt theValue) {
        this.myDateTime = theValue;
        return this;
    }

    public NutritionOrder setDateTime(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateTime = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public NutritionOrder setDateTimeWithSecondsPrecision(Date theDate) {
        this.myDateTime = new DateTimeDt(theDate);
        return this;
    }

    public BoundCodeDt<NutritionOrderStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(NutritionOrderStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public NutritionOrder setStatus(BoundCodeDt<NutritionOrderStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public NutritionOrder setStatus(NutritionOrderStatusEnum theValue) {
        this.setStatus((BoundCodeDt<NutritionOrderStatusEnum>)new BoundCodeDt(NutritionOrderStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<ResourceReferenceDt> getAllergyIntolerance() {
        if (this.myAllergyIntolerance == null) {
            this.myAllergyIntolerance = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAllergyIntolerance;
    }

    public NutritionOrder setAllergyIntolerance(List<ResourceReferenceDt> theValue) {
        this.myAllergyIntolerance = theValue;
        return this;
    }

    public ResourceReferenceDt addAllergyIntolerance() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAllergyIntolerance().add(newType);
        return newType;
    }

    public List<CodeableConceptDt> getFoodPreferenceModifier() {
        if (this.myFoodPreferenceModifier == null) {
            this.myFoodPreferenceModifier = new ArrayList<CodeableConceptDt>();
        }
        return this.myFoodPreferenceModifier;
    }

    public NutritionOrder setFoodPreferenceModifier(List<CodeableConceptDt> theValue) {
        this.myFoodPreferenceModifier = theValue;
        return this;
    }

    public CodeableConceptDt addFoodPreferenceModifier() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getFoodPreferenceModifier().add(newType);
        return newType;
    }

    public NutritionOrder addFoodPreferenceModifier(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getFoodPreferenceModifier().add(theValue);
        return this;
    }

    public CodeableConceptDt getFoodPreferenceModifierFirstRep() {
        if (this.getFoodPreferenceModifier().isEmpty()) {
            return this.addFoodPreferenceModifier();
        }
        return this.getFoodPreferenceModifier().get(0);
    }

    public List<CodeableConceptDt> getExcludeFoodModifier() {
        if (this.myExcludeFoodModifier == null) {
            this.myExcludeFoodModifier = new ArrayList<CodeableConceptDt>();
        }
        return this.myExcludeFoodModifier;
    }

    public NutritionOrder setExcludeFoodModifier(List<CodeableConceptDt> theValue) {
        this.myExcludeFoodModifier = theValue;
        return this;
    }

    public CodeableConceptDt addExcludeFoodModifier() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getExcludeFoodModifier().add(newType);
        return newType;
    }

    public NutritionOrder addExcludeFoodModifier(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getExcludeFoodModifier().add(theValue);
        return this;
    }

    public CodeableConceptDt getExcludeFoodModifierFirstRep() {
        if (this.getExcludeFoodModifier().isEmpty()) {
            return this.addExcludeFoodModifier();
        }
        return this.getExcludeFoodModifier().get(0);
    }

    public OralDiet getOralDiet() {
        if (this.myOralDiet == null) {
            this.myOralDiet = new OralDiet();
        }
        return this.myOralDiet;
    }

    public NutritionOrder setOralDiet(OralDiet theValue) {
        this.myOralDiet = theValue;
        return this;
    }

    public List<Supplement> getSupplement() {
        if (this.mySupplement == null) {
            this.mySupplement = new ArrayList<Supplement>();
        }
        return this.mySupplement;
    }

    public NutritionOrder setSupplement(List<Supplement> theValue) {
        this.mySupplement = theValue;
        return this;
    }

    public Supplement addSupplement() {
        Supplement newType = new Supplement();
        this.getSupplement().add(newType);
        return newType;
    }

    public NutritionOrder addSupplement(Supplement theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getSupplement().add(theValue);
        return this;
    }

    public Supplement getSupplementFirstRep() {
        if (this.getSupplement().isEmpty()) {
            return this.addSupplement();
        }
        return this.getSupplement().get(0);
    }

    public EnteralFormula getEnteralFormula() {
        if (this.myEnteralFormula == null) {
            this.myEnteralFormula = new EnteralFormula();
        }
        return this.myEnteralFormula;
    }

    public NutritionOrder setEnteralFormula(EnteralFormula theValue) {
        this.myEnteralFormula = theValue;
        return this;
    }

    public String getResourceName() {
        return "NutritionOrder";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class EnteralFormulaAdministration
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="schedule", type={TimingDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The time period and frequency at which the enteral formula should be delivered to the patient")
        private TimingDt mySchedule;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The volume of formula to provide to the patient per the specified administration schedule.")
        private SimpleQuantityDt myQuantity;
        @Child(name="rate", order=2, min=0, max=1, summary=false, modifier=false, type={SimpleQuantityDt.class, RatioDt.class})
        @Description(shortDefinition="", formalDefinition="The rate of administration of formula via a feeding pump, e.g. 60 mL per hour, according to the specified schedule.")
        private IDatatype myRate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySchedule, this.myQuantity, this.myRate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySchedule, this.myQuantity, this.myRate});
        }

        public TimingDt getSchedule() {
            if (this.mySchedule == null) {
                this.mySchedule = new TimingDt();
            }
            return this.mySchedule;
        }

        public EnteralFormulaAdministration setSchedule(TimingDt theValue) {
            this.mySchedule = theValue;
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public EnteralFormulaAdministration setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public IDatatype getRate() {
            return this.myRate;
        }

        public EnteralFormulaAdministration setRate(IDatatype theValue) {
            this.myRate = theValue;
            return this;
        }
    }

    @Block
    public static class EnteralFormula
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="baseFormulaType", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of enteral or infant formula such as an adult standard formula with fiber or a soy-based infant formula.")
        private BoundCodeableConceptDt<EnteralFormulaTypeCodesEnum> myBaseFormulaType;
        @Child(name="baseFormulaProductName", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The product or brand name of the enteral or infant formula product such as \"ACME Adult Standard Formula\".")
        private StringDt myBaseFormulaProductName;
        @Child(name="additiveType", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the type of modular component such as protein, carbohydrate, fat or fiber to be provided in addition to or mixed with the base formula.")
        private CodeableConceptDt myAdditiveType;
        @Child(name="additiveProductName", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The product or brand name of the type of modular component to be added to the formula.")
        private StringDt myAdditiveProductName;
        @Child(name="caloricDensity", type={SimpleQuantityDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The amount of energy (Calories) that the formula should provide per specified volume, typically per mL or fluid oz.  For example, an infant may require a formula that provides 24 Calories per fluid ounce or an adult may require an enteral formula that provides 1.5 Calorie/mL.")
        private SimpleQuantityDt myCaloricDensity;
        @Child(name="routeofAdministration", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The route or physiological path of administration into the patient's gastrointestinal  tract for purposes of providing the formula feeding, e.g. nasogastric tube.")
        private CodeableConceptDt myRouteofAdministration;
        @Child(name="administration", order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Formula administration instructions as structured data.  This repeating structure allows for changing the administration rate or volume over time for both bolus and continuous feeding.  An example of this would be an instruction to increase the rate of continuous feeding every 2 hours.")
        private List<EnteralFormulaAdministration> myAdministration;
        @Child(name="maxVolumeToDeliver", type={SimpleQuantityDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The maximum total quantity of formula that may be administered to a subject over the period of time, e.g. 1440 mL over 24 hours.")
        private SimpleQuantityDt myMaxVolumeToDeliver;
        @Child(name="administrationInstruction", type={StringDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Free text formula administration, feeding instructions or additional instructions or information.")
        private StringDt myAdministrationInstruction;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myBaseFormulaType, this.myBaseFormulaProductName, this.myAdditiveType, this.myAdditiveProductName, this.myCaloricDensity, this.myRouteofAdministration, this.myAdministration, this.myMaxVolumeToDeliver, this.myAdministrationInstruction});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myBaseFormulaType, this.myBaseFormulaProductName, this.myAdditiveType, this.myAdditiveProductName, this.myCaloricDensity, this.myRouteofAdministration, this.myAdministration, this.myMaxVolumeToDeliver, this.myAdministrationInstruction});
        }

        public BoundCodeableConceptDt<EnteralFormulaTypeCodesEnum> getBaseFormulaType() {
            if (this.myBaseFormulaType == null) {
                this.myBaseFormulaType = new BoundCodeableConceptDt<EnteralFormulaTypeCodesEnum>(EnteralFormulaTypeCodesEnum.VALUESET_BINDER);
            }
            return this.myBaseFormulaType;
        }

        public EnteralFormula setBaseFormulaType(BoundCodeableConceptDt<EnteralFormulaTypeCodesEnum> theValue) {
            this.myBaseFormulaType = theValue;
            return this;
        }

        public EnteralFormula setBaseFormulaType(EnteralFormulaTypeCodesEnum theValue) {
            this.setBaseFormulaType(new BoundCodeableConceptDt<EnteralFormulaTypeCodesEnum>(EnteralFormulaTypeCodesEnum.VALUESET_BINDER, theValue));
            return this;
        }

        public StringDt getBaseFormulaProductNameElement() {
            if (this.myBaseFormulaProductName == null) {
                this.myBaseFormulaProductName = new StringDt();
            }
            return this.myBaseFormulaProductName;
        }

        public String getBaseFormulaProductName() {
            return (String)this.getBaseFormulaProductNameElement().getValue();
        }

        public EnteralFormula setBaseFormulaProductName(StringDt theValue) {
            this.myBaseFormulaProductName = theValue;
            return this;
        }

        public EnteralFormula setBaseFormulaProductName(String theString) {
            this.myBaseFormulaProductName = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getAdditiveType() {
            if (this.myAdditiveType == null) {
                this.myAdditiveType = new CodeableConceptDt();
            }
            return this.myAdditiveType;
        }

        public EnteralFormula setAdditiveType(CodeableConceptDt theValue) {
            this.myAdditiveType = theValue;
            return this;
        }

        public StringDt getAdditiveProductNameElement() {
            if (this.myAdditiveProductName == null) {
                this.myAdditiveProductName = new StringDt();
            }
            return this.myAdditiveProductName;
        }

        public String getAdditiveProductName() {
            return (String)this.getAdditiveProductNameElement().getValue();
        }

        public EnteralFormula setAdditiveProductName(StringDt theValue) {
            this.myAdditiveProductName = theValue;
            return this;
        }

        public EnteralFormula setAdditiveProductName(String theString) {
            this.myAdditiveProductName = new StringDt(theString);
            return this;
        }

        public SimpleQuantityDt getCaloricDensity() {
            if (this.myCaloricDensity == null) {
                this.myCaloricDensity = new SimpleQuantityDt();
            }
            return this.myCaloricDensity;
        }

        public EnteralFormula setCaloricDensity(SimpleQuantityDt theValue) {
            this.myCaloricDensity = theValue;
            return this;
        }

        public CodeableConceptDt getRouteofAdministration() {
            if (this.myRouteofAdministration == null) {
                this.myRouteofAdministration = new CodeableConceptDt();
            }
            return this.myRouteofAdministration;
        }

        public EnteralFormula setRouteofAdministration(CodeableConceptDt theValue) {
            this.myRouteofAdministration = theValue;
            return this;
        }

        public List<EnteralFormulaAdministration> getAdministration() {
            if (this.myAdministration == null) {
                this.myAdministration = new ArrayList<EnteralFormulaAdministration>();
            }
            return this.myAdministration;
        }

        public EnteralFormula setAdministration(List<EnteralFormulaAdministration> theValue) {
            this.myAdministration = theValue;
            return this;
        }

        public EnteralFormulaAdministration addAdministration() {
            EnteralFormulaAdministration newType = new EnteralFormulaAdministration();
            this.getAdministration().add(newType);
            return newType;
        }

        public EnteralFormula addAdministration(EnteralFormulaAdministration theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAdministration().add(theValue);
            return this;
        }

        public EnteralFormulaAdministration getAdministrationFirstRep() {
            if (this.getAdministration().isEmpty()) {
                return this.addAdministration();
            }
            return this.getAdministration().get(0);
        }

        public SimpleQuantityDt getMaxVolumeToDeliver() {
            if (this.myMaxVolumeToDeliver == null) {
                this.myMaxVolumeToDeliver = new SimpleQuantityDt();
            }
            return this.myMaxVolumeToDeliver;
        }

        public EnteralFormula setMaxVolumeToDeliver(SimpleQuantityDt theValue) {
            this.myMaxVolumeToDeliver = theValue;
            return this;
        }

        public StringDt getAdministrationInstructionElement() {
            if (this.myAdministrationInstruction == null) {
                this.myAdministrationInstruction = new StringDt();
            }
            return this.myAdministrationInstruction;
        }

        public String getAdministrationInstruction() {
            return (String)this.getAdministrationInstructionElement().getValue();
        }

        public EnteralFormula setAdministrationInstruction(StringDt theValue) {
            this.myAdministrationInstruction = theValue;
            return this;
        }

        public EnteralFormula setAdministrationInstruction(String theString) {
            this.myAdministrationInstruction = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Supplement
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The kind of nutritional supplement product required such as a high protein or pediatric clear liquid supplement")
        private BoundCodeableConceptDt<SupplementTypeCodesEnum> myType;
        @Child(name="productName", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The product or brand name of the nutritional supplement such as \"Acme Protein Shake\".")
        private StringDt myProductName;
        @Child(name="schedule", type={TimingDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The time period and frequency at which the supplement(s) should be given")
        private List<TimingDt> mySchedule;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The amount of the nutritional supplement to be given")
        private SimpleQuantityDt myQuantity;
        @Child(name="instruction", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Free text or additional instructions or information pertaining to the oral supplement.")
        private StringDt myInstruction;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myProductName, this.mySchedule, this.myQuantity, this.myInstruction});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myProductName, this.mySchedule, this.myQuantity, this.myInstruction});
        }

        public BoundCodeableConceptDt<SupplementTypeCodesEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeableConceptDt<SupplementTypeCodesEnum>(SupplementTypeCodesEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public Supplement setType(BoundCodeableConceptDt<SupplementTypeCodesEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Supplement setType(SupplementTypeCodesEnum theValue) {
            this.setType(new BoundCodeableConceptDt<SupplementTypeCodesEnum>(SupplementTypeCodesEnum.VALUESET_BINDER, theValue));
            return this;
        }

        public StringDt getProductNameElement() {
            if (this.myProductName == null) {
                this.myProductName = new StringDt();
            }
            return this.myProductName;
        }

        public String getProductName() {
            return (String)this.getProductNameElement().getValue();
        }

        public Supplement setProductName(StringDt theValue) {
            this.myProductName = theValue;
            return this;
        }

        public Supplement setProductName(String theString) {
            this.myProductName = new StringDt(theString);
            return this;
        }

        public List<TimingDt> getSchedule() {
            if (this.mySchedule == null) {
                this.mySchedule = new ArrayList<TimingDt>();
            }
            return this.mySchedule;
        }

        public Supplement setSchedule(List<TimingDt> theValue) {
            this.mySchedule = theValue;
            return this;
        }

        public TimingDt addSchedule() {
            TimingDt newType = new TimingDt();
            this.getSchedule().add(newType);
            return newType;
        }

        public Supplement addSchedule(TimingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSchedule().add(theValue);
            return this;
        }

        public TimingDt getScheduleFirstRep() {
            if (this.getSchedule().isEmpty()) {
                return this.addSchedule();
            }
            return this.getSchedule().get(0);
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public Supplement setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public StringDt getInstructionElement() {
            if (this.myInstruction == null) {
                this.myInstruction = new StringDt();
            }
            return this.myInstruction;
        }

        public String getInstruction() {
            return (String)this.getInstructionElement().getValue();
        }

        public Supplement setInstruction(StringDt theValue) {
            this.myInstruction = theValue;
            return this;
        }

        public Supplement setInstruction(String theString) {
            this.myInstruction = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class OralDietTexture
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="modifier", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Any texture modifications (for solid foods) that should be made, e.g. easy to chew, chopped, ground, and pureed.")
        private BoundCodeableConceptDt<TextureModifierCodesEnum> myModifier;
        @Child(name="foodType", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The food type(s) (e.g. meats, all foods)  that the texture modification applies to.  This could be all foods types.")
        private BoundCodeableConceptDt<TextureModifiedFoodTypeCodesEnum> myFoodType;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myModifier, this.myFoodType});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myModifier, this.myFoodType});
        }

        public BoundCodeableConceptDt<TextureModifierCodesEnum> getModifier() {
            if (this.myModifier == null) {
                this.myModifier = new BoundCodeableConceptDt<TextureModifierCodesEnum>(TextureModifierCodesEnum.VALUESET_BINDER);
            }
            return this.myModifier;
        }

        public OralDietTexture setModifier(BoundCodeableConceptDt<TextureModifierCodesEnum> theValue) {
            this.myModifier = theValue;
            return this;
        }

        public OralDietTexture setModifier(TextureModifierCodesEnum theValue) {
            this.setModifier(new BoundCodeableConceptDt<TextureModifierCodesEnum>(TextureModifierCodesEnum.VALUESET_BINDER, theValue));
            return this;
        }

        public BoundCodeableConceptDt<TextureModifiedFoodTypeCodesEnum> getFoodType() {
            if (this.myFoodType == null) {
                this.myFoodType = new BoundCodeableConceptDt<TextureModifiedFoodTypeCodesEnum>(TextureModifiedFoodTypeCodesEnum.VALUESET_BINDER);
            }
            return this.myFoodType;
        }

        public OralDietTexture setFoodType(BoundCodeableConceptDt<TextureModifiedFoodTypeCodesEnum> theValue) {
            this.myFoodType = theValue;
            return this;
        }

        public OralDietTexture setFoodType(TextureModifiedFoodTypeCodesEnum theValue) {
            this.setFoodType(new BoundCodeableConceptDt<TextureModifiedFoodTypeCodesEnum>(TextureModifiedFoodTypeCodesEnum.VALUESET_BINDER, theValue));
            return this;
        }
    }

    @Block
    public static class OralDietNutrient
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="modifier", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The nutrient that is being modified such as carbohydrate or sodium.")
        private BoundCodeableConceptDt<NutrientModifierCodesEnum> myModifier;
        @Child(name="amount", type={SimpleQuantityDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The quantity of the specified nutrient to include in diet.")
        private SimpleQuantityDt myAmount;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myModifier, this.myAmount});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myModifier, this.myAmount});
        }

        public BoundCodeableConceptDt<NutrientModifierCodesEnum> getModifier() {
            if (this.myModifier == null) {
                this.myModifier = new BoundCodeableConceptDt<NutrientModifierCodesEnum>(NutrientModifierCodesEnum.VALUESET_BINDER);
            }
            return this.myModifier;
        }

        public OralDietNutrient setModifier(BoundCodeableConceptDt<NutrientModifierCodesEnum> theValue) {
            this.myModifier = theValue;
            return this;
        }

        public OralDietNutrient setModifier(NutrientModifierCodesEnum theValue) {
            this.setModifier(new BoundCodeableConceptDt<NutrientModifierCodesEnum>(NutrientModifierCodesEnum.VALUESET_BINDER, theValue));
            return this;
        }

        public SimpleQuantityDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new SimpleQuantityDt();
            }
            return this.myAmount;
        }

        public OralDietNutrient setAmount(SimpleQuantityDt theValue) {
            this.myAmount = theValue;
            return this;
        }
    }

    @Block
    public static class OralDiet
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The kind of diet or dietary restriction such as fiber restricted diet or diabetic diet.")
        private List<CodeableConceptDt> myType;
        @Child(name="schedule", type={TimingDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The time period and frequency at which the diet should be given")
        private List<TimingDt> mySchedule;
        @Child(name="nutrient", order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Class that defines the quantity and type of nutrient modifications required for the oral diet.")
        private List<OralDietNutrient> myNutrient;
        @Child(name="texture", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Class that describes any texture modifications required for the patient to safely consume various types of solid foods.")
        private List<OralDietTexture> myTexture;
        @Child(name="fluidConsistencyType", type={CodeableConceptDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The required consistency (e.g. honey-thick, nectar-thick, thin, thickened.) of liquids or fluids served to the patient.")
        private List<BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum>> myFluidConsistencyType;
        @Child(name="instruction", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Free text or additional instructions or information pertaining to the oral diet.")
        private StringDt myInstruction;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.mySchedule, this.myNutrient, this.myTexture, this.myFluidConsistencyType, this.myInstruction});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.mySchedule, this.myNutrient, this.myTexture, this.myFluidConsistencyType, this.myInstruction});
        }

        public List<CodeableConceptDt> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<CodeableConceptDt>();
            }
            return this.myType;
        }

        public OralDiet setType(List<CodeableConceptDt> theValue) {
            this.myType = theValue;
            return this;
        }

        public CodeableConceptDt addType() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getType().add(newType);
            return newType;
        }

        public OralDiet addType(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getType().add(theValue);
            return this;
        }

        public CodeableConceptDt getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                return this.addType();
            }
            return this.getType().get(0);
        }

        public List<TimingDt> getSchedule() {
            if (this.mySchedule == null) {
                this.mySchedule = new ArrayList<TimingDt>();
            }
            return this.mySchedule;
        }

        public OralDiet setSchedule(List<TimingDt> theValue) {
            this.mySchedule = theValue;
            return this;
        }

        public TimingDt addSchedule() {
            TimingDt newType = new TimingDt();
            this.getSchedule().add(newType);
            return newType;
        }

        public OralDiet addSchedule(TimingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSchedule().add(theValue);
            return this;
        }

        public TimingDt getScheduleFirstRep() {
            if (this.getSchedule().isEmpty()) {
                return this.addSchedule();
            }
            return this.getSchedule().get(0);
        }

        public List<OralDietNutrient> getNutrient() {
            if (this.myNutrient == null) {
                this.myNutrient = new ArrayList<OralDietNutrient>();
            }
            return this.myNutrient;
        }

        public OralDiet setNutrient(List<OralDietNutrient> theValue) {
            this.myNutrient = theValue;
            return this;
        }

        public OralDietNutrient addNutrient() {
            OralDietNutrient newType = new OralDietNutrient();
            this.getNutrient().add(newType);
            return newType;
        }

        public OralDiet addNutrient(OralDietNutrient theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getNutrient().add(theValue);
            return this;
        }

        public OralDietNutrient getNutrientFirstRep() {
            if (this.getNutrient().isEmpty()) {
                return this.addNutrient();
            }
            return this.getNutrient().get(0);
        }

        public List<OralDietTexture> getTexture() {
            if (this.myTexture == null) {
                this.myTexture = new ArrayList<OralDietTexture>();
            }
            return this.myTexture;
        }

        public OralDiet setTexture(List<OralDietTexture> theValue) {
            this.myTexture = theValue;
            return this;
        }

        public OralDietTexture addTexture() {
            OralDietTexture newType = new OralDietTexture();
            this.getTexture().add(newType);
            return newType;
        }

        public OralDiet addTexture(OralDietTexture theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTexture().add(theValue);
            return this;
        }

        public OralDietTexture getTextureFirstRep() {
            if (this.getTexture().isEmpty()) {
                return this.addTexture();
            }
            return this.getTexture().get(0);
        }

        public List<BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum>> getFluidConsistencyType() {
            if (this.myFluidConsistencyType == null) {
                this.myFluidConsistencyType = new ArrayList<BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum>>();
            }
            return this.myFluidConsistencyType;
        }

        public OralDiet setFluidConsistencyType(List<BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum>> theValue) {
            this.myFluidConsistencyType = theValue;
            return this;
        }

        public BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum> addFluidConsistencyType(FluidConsistencyTypeCodesEnum theValue) {
            BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum> retVal = new BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum>(FluidConsistencyTypeCodesEnum.VALUESET_BINDER, theValue);
            this.getFluidConsistencyType().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum> getFluidConsistencyTypeFirstRep() {
            if (this.getFluidConsistencyType().size() == 0) {
                this.addFluidConsistencyType();
            }
            return this.getFluidConsistencyType().get(0);
        }

        public BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum> addFluidConsistencyType() {
            BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum> retVal = new BoundCodeableConceptDt<FluidConsistencyTypeCodesEnum>(FluidConsistencyTypeCodesEnum.VALUESET_BINDER);
            this.getFluidConsistencyType().add(retVal);
            return retVal;
        }

        public OralDiet setFluidConsistencyType(FluidConsistencyTypeCodesEnum theValue) {
            this.getFluidConsistencyType().clear();
            this.addFluidConsistencyType(theValue);
            return this;
        }

        public StringDt getInstructionElement() {
            if (this.myInstruction == null) {
                this.myInstruction = new StringDt();
            }
            return this.myInstruction;
        }

        public String getInstruction() {
            return (String)this.getInstructionElement().getValue();
        }

        public OralDiet setInstruction(StringDt theValue) {
            this.myInstruction = theValue;
            return this;
        }

        public OralDiet setInstruction(String theString) {
            this.myInstruction = new StringDt(theString);
            return this;
        }
    }
}

