/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.OperationOutcome;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.ResponseTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="MessageHeader", profile="http://hl7.org/fhir/profiles/MessageHeader", id="messageheader")
public class MessageHeader
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="timestamp", path="MessageHeader.timestamp", description="", type="date")
    public static final String SP_TIMESTAMP = "timestamp";
    public static final DateClientParam TIMESTAMP = new DateClientParam("timestamp");
    @SearchParamDefinition(name="event", path="MessageHeader.event", description="", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="response-id", path="MessageHeader.response.identifier", description="", type="token")
    public static final String SP_RESPONSE_ID = "response-id";
    public static final TokenClientParam RESPONSE_ID = new TokenClientParam("response-id");
    @SearchParamDefinition(name="code", path="MessageHeader.response.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="source", path="MessageHeader.source.name", description="", type="string")
    public static final String SP_SOURCE = "source";
    public static final StringClientParam SOURCE = new StringClientParam("source");
    @SearchParamDefinition(name="source-uri", path="MessageHeader.source.endpoint", description="", type="uri")
    public static final String SP_SOURCE_URI = "source-uri";
    public static final UriClientParam SOURCE_URI = new UriClientParam("source-uri");
    @SearchParamDefinition(name="destination", path="MessageHeader.destination.name", description="", type="string")
    public static final String SP_DESTINATION = "destination";
    public static final StringClientParam DESTINATION = new StringClientParam("destination");
    @SearchParamDefinition(name="destination-uri", path="MessageHeader.destination.endpoint", description="", type="uri")
    public static final String SP_DESTINATION_URI = "destination-uri";
    public static final UriClientParam DESTINATION_URI = new UriClientParam("destination-uri");
    @SearchParamDefinition(name="data", path="MessageHeader.data", description="", type="reference")
    public static final String SP_DATA = "data";
    public static final ReferenceClientParam DATA = new ReferenceClientParam("data");
    @SearchParamDefinition(name="receiver", path="MessageHeader.receiver", description="", type="reference")
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    @SearchParamDefinition(name="author", path="MessageHeader.author", description="", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    @SearchParamDefinition(name="responsible", path="MessageHeader.responsible", description="", type="reference")
    public static final String SP_RESPONSIBLE = "responsible";
    public static final ReferenceClientParam RESPONSIBLE = new ReferenceClientParam("responsible");
    @SearchParamDefinition(name="enterer", path="MessageHeader.enterer", description="", type="reference")
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    @SearchParamDefinition(name="target", path="MessageHeader.destination.target", description="", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_AUTHOR = new Include("MessageHeader:author");
    public static final Include INCLUDE_DATA = new Include("MessageHeader:data");
    public static final Include INCLUDE_ENTERER = new Include("MessageHeader:enterer");
    public static final Include INCLUDE_RECEIVER = new Include("MessageHeader:receiver");
    public static final Include INCLUDE_RESPONSIBLE = new Include("MessageHeader:responsible");
    public static final Include INCLUDE_TARGET = new Include("MessageHeader:target");
    @Child(name="timestamp", type={InstantDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.init", formalDefinition="The time that the message was sent")
    private InstantDt myTimestamp;
    @Child(name="event", type={CodingDt.class}, order=1, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="what", formalDefinition="Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://hl7.org/fhir/message-events\"")
    private CodingDt myEvent;
    @Child(name="response", order=2, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="Information about the message that this message is a response to.  Only present if this message is a response.")
    private Response myResponse;
    @Child(name="source", order=3, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="who.actor", formalDefinition="The source application from which this message originated")
    private Source mySource;
    @Child(name="destination", order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="who.focus", formalDefinition="The destination application which the message is intended for")
    private List<Destination> myDestination;
    @Child(name="enterer", order=5, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.author", formalDefinition="The person or device that performed the data entry leading to this message. Where there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions")
    private ResourceReferenceDt myEnterer;
    @Child(name="author", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.author", formalDefinition="The logical author of the message - the person or device that decided the described event should happen. Where there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions")
    private ResourceReferenceDt myAuthor;
    @Child(name="receiver", order=7, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="who.focus", formalDefinition="Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.")
    private ResourceReferenceDt myReceiver;
    @Child(name="responsible", order=8, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="who.witness", formalDefinition="The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party")
    private ResourceReferenceDt myResponsible;
    @Child(name="reason", type={CodeableConceptDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="why", formalDefinition="Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message")
    private CodeableConceptDt myReason;
    @Child(name="data", order=10, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="The actual data of the message - a reference to the root/focus class of the event.")
    private List<ResourceReferenceDt> myData;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myTimestamp, this.myEvent, this.myResponse, this.mySource, this.myDestination, this.myEnterer, this.myAuthor, this.myReceiver, this.myResponsible, this.myReason, this.myData});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTimestamp, this.myEvent, this.myResponse, this.mySource, this.myDestination, this.myEnterer, this.myAuthor, this.myReceiver, this.myResponsible, this.myReason, this.myData});
    }

    public InstantDt getTimestampElement() {
        if (this.myTimestamp == null) {
            this.myTimestamp = new InstantDt();
        }
        return this.myTimestamp;
    }

    public Date getTimestamp() {
        return (Date)this.getTimestampElement().getValue();
    }

    public MessageHeader setTimestamp(InstantDt theValue) {
        this.myTimestamp = theValue;
        return this;
    }

    public MessageHeader setTimestampWithMillisPrecision(Date theDate) {
        this.myTimestamp = new InstantDt(theDate);
        return this;
    }

    public MessageHeader setTimestamp(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myTimestamp = new InstantDt(theDate, thePrecision);
        return this;
    }

    public CodingDt getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new CodingDt();
        }
        return this.myEvent;
    }

    public MessageHeader setEvent(CodingDt theValue) {
        this.myEvent = theValue;
        return this;
    }

    public Response getResponse() {
        if (this.myResponse == null) {
            this.myResponse = new Response();
        }
        return this.myResponse;
    }

    public MessageHeader setResponse(Response theValue) {
        this.myResponse = theValue;
        return this;
    }

    public Source getSource() {
        if (this.mySource == null) {
            this.mySource = new Source();
        }
        return this.mySource;
    }

    public MessageHeader setSource(Source theValue) {
        this.mySource = theValue;
        return this;
    }

    public List<Destination> getDestination() {
        if (this.myDestination == null) {
            this.myDestination = new ArrayList<Destination>();
        }
        return this.myDestination;
    }

    public MessageHeader setDestination(List<Destination> theValue) {
        this.myDestination = theValue;
        return this;
    }

    public Destination addDestination() {
        Destination newType = new Destination();
        this.getDestination().add(newType);
        return newType;
    }

    public MessageHeader addDestination(Destination theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDestination().add(theValue);
        return this;
    }

    public Destination getDestinationFirstRep() {
        if (this.getDestination().isEmpty()) {
            return this.addDestination();
        }
        return this.getDestination().get(0);
    }

    public ResourceReferenceDt getEnterer() {
        if (this.myEnterer == null) {
            this.myEnterer = new ResourceReferenceDt();
        }
        return this.myEnterer;
    }

    public MessageHeader setEnterer(ResourceReferenceDt theValue) {
        this.myEnterer = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public MessageHeader setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt getReceiver() {
        if (this.myReceiver == null) {
            this.myReceiver = new ResourceReferenceDt();
        }
        return this.myReceiver;
    }

    public MessageHeader setReceiver(ResourceReferenceDt theValue) {
        this.myReceiver = theValue;
        return this;
    }

    public ResourceReferenceDt getResponsible() {
        if (this.myResponsible == null) {
            this.myResponsible = new ResourceReferenceDt();
        }
        return this.myResponsible;
    }

    public MessageHeader setResponsible(ResourceReferenceDt theValue) {
        this.myResponsible = theValue;
        return this;
    }

    public CodeableConceptDt getReason() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public MessageHeader setReason(CodeableConceptDt theValue) {
        this.myReason = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getData() {
        if (this.myData == null) {
            this.myData = new ArrayList<ResourceReferenceDt>();
        }
        return this.myData;
    }

    public MessageHeader setData(List<ResourceReferenceDt> theValue) {
        this.myData = theValue;
        return this;
    }

    public ResourceReferenceDt addData() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getData().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "MessageHeader";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Destination
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Human-readable name for the target system")
        private StringDt myName;
        @Child(name="target", order=1, min=0, max=1, summary=false, modifier=false, type={Device.class})
        @Description(shortDefinition="", formalDefinition="Identifies the target end system in situations where the initial message transmission is to an intermediary system.")
        private ResourceReferenceDt myTarget;
        @Child(name="endpoint", type={UriDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates where the message should be routed to.")
        private UriDt myEndpoint;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myTarget, this.myEndpoint});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTarget, this.myEndpoint});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Destination setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Destination setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public Destination setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }

        public UriDt getEndpointElement() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public String getEndpoint() {
            return (String)this.getEndpointElement().getValue();
        }

        public Destination setEndpoint(UriDt theValue) {
            this.myEndpoint = theValue;
            return this;
        }

        public Destination setEndpoint(String theUri) {
            this.myEndpoint = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Source
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Human-readable name for the source system")
        private StringDt myName;
        @Child(name="software", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="May include configuration or other information useful in debugging.")
        private StringDt mySoftware;
        @Child(name="version", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Can convey versions of multiple systems in situations where a message passes through multiple hands.")
        private StringDt myVersion;
        @Child(name="contact", type={ContactPointDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An e-mail, phone, website or other contact point to use to resolve issues with message communications.")
        private ContactPointDt myContact;
        @Child(name="endpoint", type={UriDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the routing target to send acknowledgements to.")
        private UriDt myEndpoint;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.mySoftware, this.myVersion, this.myContact, this.myEndpoint});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.mySoftware, this.myVersion, this.myContact, this.myEndpoint});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Source setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Source setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getSoftwareElement() {
            if (this.mySoftware == null) {
                this.mySoftware = new StringDt();
            }
            return this.mySoftware;
        }

        public String getSoftware() {
            return (String)this.getSoftwareElement().getValue();
        }

        public Source setSoftware(StringDt theValue) {
            this.mySoftware = theValue;
            return this;
        }

        public Source setSoftware(String theString) {
            this.mySoftware = new StringDt(theString);
            return this;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public String getVersion() {
            return (String)this.getVersionElement().getValue();
        }

        public Source setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public Source setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public ContactPointDt getContact() {
            if (this.myContact == null) {
                this.myContact = new ContactPointDt();
            }
            return this.myContact;
        }

        public Source setContact(ContactPointDt theValue) {
            this.myContact = theValue;
            return this;
        }

        public UriDt getEndpointElement() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public String getEndpoint() {
            return (String)this.getEndpointElement().getValue();
        }

        public Source setEndpoint(UriDt theValue) {
            this.myEndpoint = theValue;
            return this;
        }

        public Source setEndpoint(String theUri) {
            this.myEndpoint = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Response
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The id of the message that this message is a response to")
        private IdDt myIdentifier;
        @Child(name="code", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=true)
        @Description(shortDefinition="", formalDefinition="Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not")
        private BoundCodeDt<ResponseTypeEnum> myCode;
        @Child(name="details", order=2, min=0, max=1, summary=false, modifier=false, type={OperationOutcome.class})
        @Description(shortDefinition="", formalDefinition="Full details of any issues found in the message")
        private ResourceReferenceDt myDetails;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myCode, this.myDetails});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCode, this.myDetails});
        }

        public IdDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdDt();
            }
            return this.myIdentifier;
        }

        public String getIdentifier() {
            return this.getIdentifierElement().getValue();
        }

        public Response setIdentifier(IdDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Response setIdentifier(String theId) {
            this.myIdentifier = new IdDt(theId);
            return this;
        }

        public BoundCodeDt<ResponseTypeEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(ResponseTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public Response setCode(BoundCodeDt<ResponseTypeEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public Response setCode(ResponseTypeEnum theValue) {
            this.setCode((BoundCodeDt<ResponseTypeEnum>)new BoundCodeDt(ResponseTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public ResourceReferenceDt getDetails() {
            if (this.myDetails == null) {
                this.myDetails = new ResourceReferenceDt();
            }
            return this.myDetails;
        }

        public Response setDetails(ResourceReferenceDt theValue) {
            this.myDetails = theValue;
            return this;
        }
    }
}

