/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.DurationDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.RatioDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.BodySite;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.MedicationOrderStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="MedicationOrder", profile="http://hl7.org/fhir/profiles/MedicationOrder", id="medicationorder")
public class MedicationOrder
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="datewritten", path="MedicationOrder.dateWritten", description="Return prescriptions written on this date", type="date")
    public static final String SP_DATEWRITTEN = "datewritten";
    public static final DateClientParam DATEWRITTEN = new DateClientParam("datewritten");
    @SearchParamDefinition(name="encounter", path="MedicationOrder.encounter", description="Return prescriptions with this encounter identifier", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="identifier", path="MedicationOrder.identifier", description="Return prescriptions with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medication", path="MedicationOrder.medicationReference", description="Return administrations of this medication reference", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    @SearchParamDefinition(name="code", path="MedicationOrder.medicationCodeableConcept", description="Return administrations of this medication code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="patient", path="MedicationOrder.patient", description="The identity of a patient to list orders  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="status", path="MedicationOrder.status", description="Status of the prescription", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="prescriber", path="MedicationOrder.prescriber", description="", type="reference")
    public static final String SP_PRESCRIBER = "prescriber";
    public static final ReferenceClientParam PRESCRIBER = new ReferenceClientParam("prescriber");
    public static final Include INCLUDE_ENCOUNTER = new Include("MedicationOrder:encounter");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationOrder:medication");
    public static final Include INCLUDE_PATIENT = new Include("MedicationOrder:patient");
    public static final Include INCLUDE_PRESCRIBER = new Include("MedicationOrder:prescriber");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="External identifier - one that would be used by another non-FHIR system - for example a re-imbursement system might issue its own id for each prescription that is created.  This is particularly important where FHIR only provides part of an entire workflow process where records have to be tracked through an entire system.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="dateWritten", type={DateTimeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date (and perhaps time) when the prescription was written")
    private DateTimeDt myDateWritten;
    @Child(name="status", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="A code specifying the state of the order.  Generally this will be active or completed state")
    private BoundCodeDt<MedicationOrderStatusEnum> myStatus;
    @Child(name="dateEnded", type={DateTimeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date (and perhaps time) when the prescription was stopped")
    private DateTimeDt myDateEnded;
    @Child(name="reasonEnded", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The reason why the prescription was stopped, if it was")
    private CodeableConceptDt myReasonEnded;
    @Child(name="patient", order=5, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="A link to a resource representing the person to whom the medication will be given.")
    private ResourceReferenceDt myPatient;
    @Child(name="prescriber", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.actor", formalDefinition="The healthcare professional responsible for authorizing the prescription")
    private ResourceReferenceDt myPrescriber;
    @Child(name="encounter", order=7, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="A link to a resource that identifies the particular occurrence of contact between patient and health care provider.")
    private ResourceReferenceDt myEncounter;
    @Child(name="reason", order=8, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Condition.class})
    @Description(shortDefinition="why", formalDefinition="Can be the reason or the indication for writing the prescription.")
    private IDatatype myReason;
    @Child(name="note", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Extra information about the prescription that could not be conveyed by the other attributes.")
    private StringDt myNote;
    @Child(name="medication", order=10, min=1, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Medication.class})
    @Description(shortDefinition="what", formalDefinition="Identifies the medication being administered. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.")
    private IDatatype myMedication;
    @Child(name="dosageInstruction", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates how the medication is to be used by the patient")
    private List<DosageInstruction> myDosageInstruction;
    @Child(name="dispenseRequest", order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the specific details for the dispense or medication supply part of a medication order (also known as a Medication Prescription).  Note that this information is NOT always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.")
    private DispenseRequest myDispenseRequest;
    @Child(name="substitution", order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates whether or not substitution can or should be part of the dispense. In some cases substitution must happen, in other cases substitution must not happen, and in others it does not matter. This block explains the prescriber's intent. If nothing is specified substitution may be done.")
    private Substitution mySubstitution;
    @Child(name="priorPrescription", order=14, min=0, max=1, summary=false, modifier=false, type={MedicationOrder.class})
    @Description(shortDefinition="", formalDefinition="A link to a resource representing an earlier order or prescription that this order supersedes")
    private ResourceReferenceDt myPriorPrescription;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDateWritten, this.myStatus, this.myDateEnded, this.myReasonEnded, this.myPatient, this.myPrescriber, this.myEncounter, this.myReason, this.myNote, this.myMedication, this.myDosageInstruction, this.myDispenseRequest, this.mySubstitution, this.myPriorPrescription});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDateWritten, this.myStatus, this.myDateEnded, this.myReasonEnded, this.myPatient, this.myPrescriber, this.myEncounter, this.myReason, this.myNote, this.myMedication, this.myDosageInstruction, this.myDispenseRequest, this.mySubstitution, this.myPriorPrescription});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public MedicationOrder setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public MedicationOrder addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DateTimeDt getDateWrittenElement() {
        if (this.myDateWritten == null) {
            this.myDateWritten = new DateTimeDt();
        }
        return this.myDateWritten;
    }

    public Date getDateWritten() {
        return (Date)this.getDateWrittenElement().getValue();
    }

    public MedicationOrder setDateWritten(DateTimeDt theValue) {
        this.myDateWritten = theValue;
        return this;
    }

    public MedicationOrder setDateWritten(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateWritten = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public MedicationOrder setDateWrittenWithSecondsPrecision(Date theDate) {
        this.myDateWritten = new DateTimeDt(theDate);
        return this;
    }

    public BoundCodeDt<MedicationOrderStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationOrderStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public MedicationOrder setStatus(BoundCodeDt<MedicationOrderStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public MedicationOrder setStatus(MedicationOrderStatusEnum theValue) {
        this.setStatus((BoundCodeDt<MedicationOrderStatusEnum>)new BoundCodeDt(MedicationOrderStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public DateTimeDt getDateEndedElement() {
        if (this.myDateEnded == null) {
            this.myDateEnded = new DateTimeDt();
        }
        return this.myDateEnded;
    }

    public Date getDateEnded() {
        return (Date)this.getDateEndedElement().getValue();
    }

    public MedicationOrder setDateEnded(DateTimeDt theValue) {
        this.myDateEnded = theValue;
        return this;
    }

    public MedicationOrder setDateEnded(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateEnded = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public MedicationOrder setDateEndedWithSecondsPrecision(Date theDate) {
        this.myDateEnded = new DateTimeDt(theDate);
        return this;
    }

    public CodeableConceptDt getReasonEnded() {
        if (this.myReasonEnded == null) {
            this.myReasonEnded = new CodeableConceptDt();
        }
        return this.myReasonEnded;
    }

    public MedicationOrder setReasonEnded(CodeableConceptDt theValue) {
        this.myReasonEnded = theValue;
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public MedicationOrder setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getPrescriber() {
        if (this.myPrescriber == null) {
            this.myPrescriber = new ResourceReferenceDt();
        }
        return this.myPrescriber;
    }

    public MedicationOrder setPrescriber(ResourceReferenceDt theValue) {
        this.myPrescriber = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public MedicationOrder setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public IDatatype getReason() {
        return this.myReason;
    }

    public MedicationOrder setReason(IDatatype theValue) {
        this.myReason = theValue;
        return this;
    }

    public StringDt getNoteElement() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public String getNote() {
        return (String)this.getNoteElement().getValue();
    }

    public MedicationOrder setNote(StringDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public MedicationOrder setNote(String theString) {
        this.myNote = new StringDt(theString);
        return this;
    }

    public IDatatype getMedication() {
        return this.myMedication;
    }

    public MedicationOrder setMedication(IDatatype theValue) {
        this.myMedication = theValue;
        return this;
    }

    public List<DosageInstruction> getDosageInstruction() {
        if (this.myDosageInstruction == null) {
            this.myDosageInstruction = new ArrayList<DosageInstruction>();
        }
        return this.myDosageInstruction;
    }

    public MedicationOrder setDosageInstruction(List<DosageInstruction> theValue) {
        this.myDosageInstruction = theValue;
        return this;
    }

    public DosageInstruction addDosageInstruction() {
        DosageInstruction newType = new DosageInstruction();
        this.getDosageInstruction().add(newType);
        return newType;
    }

    public MedicationOrder addDosageInstruction(DosageInstruction theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDosageInstruction().add(theValue);
        return this;
    }

    public DosageInstruction getDosageInstructionFirstRep() {
        if (this.getDosageInstruction().isEmpty()) {
            return this.addDosageInstruction();
        }
        return this.getDosageInstruction().get(0);
    }

    public DispenseRequest getDispenseRequest() {
        if (this.myDispenseRequest == null) {
            this.myDispenseRequest = new DispenseRequest();
        }
        return this.myDispenseRequest;
    }

    public MedicationOrder setDispenseRequest(DispenseRequest theValue) {
        this.myDispenseRequest = theValue;
        return this;
    }

    public Substitution getSubstitution() {
        if (this.mySubstitution == null) {
            this.mySubstitution = new Substitution();
        }
        return this.mySubstitution;
    }

    public MedicationOrder setSubstitution(Substitution theValue) {
        this.mySubstitution = theValue;
        return this;
    }

    public ResourceReferenceDt getPriorPrescription() {
        if (this.myPriorPrescription == null) {
            this.myPriorPrescription = new ResourceReferenceDt();
        }
        return this.myPriorPrescription;
    }

    public MedicationOrder setPriorPrescription(ResourceReferenceDt theValue) {
        this.myPriorPrescription = theValue;
        return this;
    }

    public String getResourceName() {
        return "MedicationOrder";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Substitution
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code signifying whether a different drug should be dispensed from what was prescribed.")
        private CodeableConceptDt myType;
        @Child(name="reason", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the reason for the substitution, or why substitution must or must not be performed.")
        private CodeableConceptDt myReason;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myReason});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myReason});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Substitution setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public CodeableConceptDt getReason() {
            if (this.myReason == null) {
                this.myReason = new CodeableConceptDt();
            }
            return this.myReason;
        }

        public Substitution setReason(CodeableConceptDt theValue) {
            this.myReason = theValue;
            return this;
        }
    }

    @Block
    public static class DispenseRequest
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="medication", order=0, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Medication.class})
        @Description(shortDefinition="", formalDefinition="Identifies the medication being administered. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.")
        private IDatatype myMedication;
        @Child(name="validityPeriod", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="This indicates the validity period of a prescription (stale dating the Prescription)")
        private PeriodDt myValidityPeriod;
        @Child(name="numberOfRepeatsAllowed", type={PositiveIntDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An integer indicating the number of additional times (aka refills or repeats) the patient can receive the prescribed medication.   Usage Notes: This integer does NOT include the original order dispense.   This means that if an order indicates dispense 30 tablets plus  \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.")
        private PositiveIntDt myNumberOfRepeatsAllowed;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The amount that is to be dispensed for one fill.")
        private SimpleQuantityDt myQuantity;
        @Child(name="expectedSupplyDuration", type={DurationDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.")
        private DurationDt myExpectedSupplyDuration;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myMedication, this.myValidityPeriod, this.myNumberOfRepeatsAllowed, this.myQuantity, this.myExpectedSupplyDuration});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMedication, this.myValidityPeriod, this.myNumberOfRepeatsAllowed, this.myQuantity, this.myExpectedSupplyDuration});
        }

        public IDatatype getMedication() {
            return this.myMedication;
        }

        public DispenseRequest setMedication(IDatatype theValue) {
            this.myMedication = theValue;
            return this;
        }

        public PeriodDt getValidityPeriod() {
            if (this.myValidityPeriod == null) {
                this.myValidityPeriod = new PeriodDt();
            }
            return this.myValidityPeriod;
        }

        public DispenseRequest setValidityPeriod(PeriodDt theValue) {
            this.myValidityPeriod = theValue;
            return this;
        }

        public PositiveIntDt getNumberOfRepeatsAllowedElement() {
            if (this.myNumberOfRepeatsAllowed == null) {
                this.myNumberOfRepeatsAllowed = new PositiveIntDt();
            }
            return this.myNumberOfRepeatsAllowed;
        }

        public Integer getNumberOfRepeatsAllowed() {
            return (Integer)this.getNumberOfRepeatsAllowedElement().getValue();
        }

        public DispenseRequest setNumberOfRepeatsAllowed(PositiveIntDt theValue) {
            this.myNumberOfRepeatsAllowed = theValue;
            return this;
        }

        public DispenseRequest setNumberOfRepeatsAllowed(int theInteger) {
            this.myNumberOfRepeatsAllowed = new PositiveIntDt(theInteger);
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public DispenseRequest setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public DurationDt getExpectedSupplyDuration() {
            if (this.myExpectedSupplyDuration == null) {
                this.myExpectedSupplyDuration = new DurationDt();
            }
            return this.myExpectedSupplyDuration;
        }

        public DispenseRequest setExpectedSupplyDuration(DurationDt theValue) {
            this.myExpectedSupplyDuration = theValue;
            return this;
        }
    }

    @Block
    public static class DosageInstruction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="text", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Free text dosage instructions can be used for cases where the instructions are too complex to code.  The content of this attribute does not include the name or description of the medication. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication. It is expected that the text instructions will always be populated.  If the dosage.timing attribute is also populated, then the dosage.text should reflect the same information as the timing.")
        private StringDt myText;
        @Child(name="additionalInstructions", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional instructions such as \"Swallow with plenty of water\" which may or may not be coded.")
        private CodeableConceptDt myAdditionalInstructions;
        @Child(name="timing", type={TimingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The timing schedule for giving the medication to the patient. The Schedule data type allows many different expressions. For example: \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
        private TimingDt myTiming;
        @Child(name="asNeeded", order=3, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, CodeableConceptDt.class})
        @Description(shortDefinition="", formalDefinition="Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).")
        private IDatatype myAsNeeded;
        @Child(name="site", order=4, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, BodySite.class})
        @Description(shortDefinition="", formalDefinition="A coded specification of the anatomic site where the medication first enters the body")
        private IDatatype mySite;
        @Child(name="route", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a patient's body.")
        private CodeableConceptDt myRoute;
        @Child(name="method", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  For examples, Slow Push; Deep IV.")
        private CodeableConceptDt myMethod;
        @Child(name="dose", order=7, min=0, max=1, summary=false, modifier=false, type={RangeDt.class, SimpleQuantityDt.class})
        @Description(shortDefinition="", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        private IDatatype myDose;
        @Child(name="rate", order=8, min=0, max=1, summary=false, modifier=false, type={RatioDt.class, RangeDt.class})
        @Description(shortDefinition="", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours")
        private IDatatype myRate;
        @Child(name="maxDosePerPeriod", type={RatioDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time.  For example, 1000mg in 24 hours.")
        private RatioDt myMaxDosePerPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myText, this.myAdditionalInstructions, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myDose, this.myRate, this.myMaxDosePerPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myText, this.myAdditionalInstructions, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myDose, this.myRate, this.myMaxDosePerPeriod});
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public DosageInstruction setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public DosageInstruction setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getAdditionalInstructions() {
            if (this.myAdditionalInstructions == null) {
                this.myAdditionalInstructions = new CodeableConceptDt();
            }
            return this.myAdditionalInstructions;
        }

        public DosageInstruction setAdditionalInstructions(CodeableConceptDt theValue) {
            this.myAdditionalInstructions = theValue;
            return this;
        }

        public TimingDt getTiming() {
            if (this.myTiming == null) {
                this.myTiming = new TimingDt();
            }
            return this.myTiming;
        }

        public DosageInstruction setTiming(TimingDt theValue) {
            this.myTiming = theValue;
            return this;
        }

        public IDatatype getAsNeeded() {
            return this.myAsNeeded;
        }

        public DosageInstruction setAsNeeded(IDatatype theValue) {
            this.myAsNeeded = theValue;
            return this;
        }

        public IDatatype getSite() {
            return this.mySite;
        }

        public DosageInstruction setSite(IDatatype theValue) {
            this.mySite = theValue;
            return this;
        }

        public CodeableConceptDt getRoute() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public DosageInstruction setRoute(CodeableConceptDt theValue) {
            this.myRoute = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public DosageInstruction setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public IDatatype getDose() {
            return this.myDose;
        }

        public DosageInstruction setDose(IDatatype theValue) {
            this.myDose = theValue;
            return this;
        }

        public IDatatype getRate() {
            return this.myRate;
        }

        public DosageInstruction setRate(IDatatype theValue) {
            this.myRate = theValue;
            return this;
        }

        public RatioDt getMaxDosePerPeriod() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public DosageInstruction setMaxDosePerPeriod(RatioDt theValue) {
            this.myMaxDosePerPeriod = theValue;
            return this;
        }
    }
}

