/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.RatioDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.BodySite;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.MedicationOrder;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.MedicationDispenseStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="MedicationDispense", profile="http://hl7.org/fhir/profiles/MedicationDispense", id="medicationdispense")
public class MedicationDispense
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="destination", path="MedicationDispense.destination", description="Return dispenses that should be sent to a specific destination", type="reference")
    public static final String SP_DESTINATION = "destination";
    public static final ReferenceClientParam DESTINATION = new ReferenceClientParam("destination");
    @SearchParamDefinition(name="dispenser", path="MedicationDispense.dispenser", description="Return all dispenses performed by a specific individual", type="reference")
    public static final String SP_DISPENSER = "dispenser";
    public static final ReferenceClientParam DISPENSER = new ReferenceClientParam("dispenser");
    @SearchParamDefinition(name="identifier", path="MedicationDispense.identifier", description="Return dispenses with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medication", path="MedicationDispense.medicationReference", description="Return dispenses of this medicine resource", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    @SearchParamDefinition(name="code", path="MedicationDispense.medicationCodeableConcept", description="Return dispenses of this medicine code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="patient", path="MedicationDispense.patient", description="The identity of a patient to list dispenses  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="prescription", path="MedicationDispense.authorizingPrescription", description="The identity of a prescription to list dispenses from", type="reference")
    public static final String SP_PRESCRIPTION = "prescription";
    public static final ReferenceClientParam PRESCRIPTION = new ReferenceClientParam("prescription");
    @SearchParamDefinition(name="responsibleparty", path="MedicationDispense.substitution.responsibleParty", description="Return all dispenses with the specified responsible party", type="reference")
    public static final String SP_RESPONSIBLEPARTY = "responsibleparty";
    public static final ReferenceClientParam RESPONSIBLEPARTY = new ReferenceClientParam("responsibleparty");
    @SearchParamDefinition(name="status", path="MedicationDispense.status", description="Status of the dispense", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="type", path="MedicationDispense.type", description="Return all dispenses of a specific type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="whenhandedover", path="MedicationDispense.whenHandedOver", description="Date when medication handed over to patient (outpatient setting), or supplied to ward or clinic (inpatient setting)", type="date")
    public static final String SP_WHENHANDEDOVER = "whenhandedover";
    public static final DateClientParam WHENHANDEDOVER = new DateClientParam("whenhandedover");
    @SearchParamDefinition(name="whenprepared", path="MedicationDispense.whenPrepared", description="Date when medication prepared", type="date")
    public static final String SP_WHENPREPARED = "whenprepared";
    public static final DateClientParam WHENPREPARED = new DateClientParam("whenprepared");
    @SearchParamDefinition(name="receiver", path="MedicationDispense.receiver", description="", type="reference")
    public static final String SP_RECEIVER = "receiver";
    public static final ReferenceClientParam RECEIVER = new ReferenceClientParam("receiver");
    public static final Include INCLUDE_DESTINATION = new Include("MedicationDispense:destination");
    public static final Include INCLUDE_DISPENSER = new Include("MedicationDispense:dispenser");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationDispense:medication");
    public static final Include INCLUDE_PATIENT = new Include("MedicationDispense:patient");
    public static final Include INCLUDE_PRESCRIPTION = new Include("MedicationDispense:prescription");
    public static final Include INCLUDE_RECEIVER = new Include("MedicationDispense:receiver");
    public static final Include INCLUDE_RESPONSIBLEPARTY = new Include("MedicationDispense:responsibleparty");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifier assigned by the dispensing facility - this is an identifier assigned outside FHIR.")
    private IdentifierDt myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="A code specifying the state of the set of dispense events.")
    private BoundCodeDt<MedicationDispenseStatusEnum> myStatus;
    @Child(name="patient", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="A link to a resource representing the person to whom the medication will be given.")
    private ResourceReferenceDt myPatient;
    @Child(name="dispenser", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.actor", formalDefinition="The individual responsible for dispensing the medication")
    private ResourceReferenceDt myDispenser;
    @Child(name="authorizingPrescription", order=4, min=0, max=-1, summary=false, modifier=false, type={MedicationOrder.class})
    @Description(shortDefinition="", formalDefinition="Indicates the medication order that is being dispensed against.")
    private List<ResourceReferenceDt> myAuthorizingPrescription;
    @Child(name="type", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.")
    private CodeableConceptDt myType;
    @Child(name="quantity", type={SimpleQuantityDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The amount of medication that has been dispensed. Includes unit of measure.")
    private SimpleQuantityDt myQuantity;
    @Child(name="daysSupply", type={SimpleQuantityDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The amount of medication expressed as a timing amount.")
    private SimpleQuantityDt myDaysSupply;
    @Child(name="medication", order=8, min=1, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Medication.class})
    @Description(shortDefinition="", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    private IDatatype myMedication;
    @Child(name="whenPrepared", type={DateTimeDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The time when the dispensed product was packaged and reviewed.")
    private DateTimeDt myWhenPrepared;
    @Child(name="whenHandedOver", type={DateTimeDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The time the dispensed product was provided to the patient or their representative.")
    private DateTimeDt myWhenHandedOver;
    @Child(name="destination", order=11, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="", formalDefinition="Identification of the facility/location where the medication was shipped to, as part of the dispense event.")
    private ResourceReferenceDt myDestination;
    @Child(name="receiver", order=12, min=0, max=-1, summary=false, modifier=false, type={Patient.class, Practitioner.class})
    @Description(shortDefinition="", formalDefinition="Identifies the person who picked up the medication.  This will usually be a patient or their caregiver, but some cases exist where it can be a healthcare professional")
    private List<ResourceReferenceDt> myReceiver;
    @Child(name="note", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Extra information about the dispense that could not be conveyed in the other attributes.")
    private StringDt myNote;
    @Child(name="dosageInstruction", order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates how the medication is to be used by the patient")
    private List<DosageInstruction> myDosageInstruction;
    @Child(name="substitution", order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates whether or not substitution was made as part of the dispense.  In some cases substitution will be expected but does not happen, in other cases substitution is not expected but does happen.  This block explains what substitution did or did not happen and why.")
    private Substitution mySubstitution;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myDispenser, this.myAuthorizingPrescription, this.myType, this.myQuantity, this.myDaysSupply, this.myMedication, this.myWhenPrepared, this.myWhenHandedOver, this.myDestination, this.myReceiver, this.myNote, this.myDosageInstruction, this.mySubstitution});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myDispenser, this.myAuthorizingPrescription, this.myType, this.myQuantity, this.myDaysSupply, this.myMedication, this.myWhenPrepared, this.myWhenHandedOver, this.myDestination, this.myReceiver, this.myNote, this.myDosageInstruction, this.mySubstitution});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public MedicationDispense setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public BoundCodeDt<MedicationDispenseStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationDispenseStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public MedicationDispense setStatus(BoundCodeDt<MedicationDispenseStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public MedicationDispense setStatus(MedicationDispenseStatusEnum theValue) {
        this.setStatus((BoundCodeDt<MedicationDispenseStatusEnum>)new BoundCodeDt(MedicationDispenseStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public MedicationDispense setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getDispenser() {
        if (this.myDispenser == null) {
            this.myDispenser = new ResourceReferenceDt();
        }
        return this.myDispenser;
    }

    public MedicationDispense setDispenser(ResourceReferenceDt theValue) {
        this.myDispenser = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthorizingPrescription() {
        if (this.myAuthorizingPrescription == null) {
            this.myAuthorizingPrescription = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthorizingPrescription;
    }

    public MedicationDispense setAuthorizingPrescription(List<ResourceReferenceDt> theValue) {
        this.myAuthorizingPrescription = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthorizingPrescription() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthorizingPrescription().add(newType);
        return newType;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public MedicationDispense setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public SimpleQuantityDt getQuantity() {
        if (this.myQuantity == null) {
            this.myQuantity = new SimpleQuantityDt();
        }
        return this.myQuantity;
    }

    public MedicationDispense setQuantity(SimpleQuantityDt theValue) {
        this.myQuantity = theValue;
        return this;
    }

    public SimpleQuantityDt getDaysSupply() {
        if (this.myDaysSupply == null) {
            this.myDaysSupply = new SimpleQuantityDt();
        }
        return this.myDaysSupply;
    }

    public MedicationDispense setDaysSupply(SimpleQuantityDt theValue) {
        this.myDaysSupply = theValue;
        return this;
    }

    public IDatatype getMedication() {
        return this.myMedication;
    }

    public MedicationDispense setMedication(IDatatype theValue) {
        this.myMedication = theValue;
        return this;
    }

    public DateTimeDt getWhenPreparedElement() {
        if (this.myWhenPrepared == null) {
            this.myWhenPrepared = new DateTimeDt();
        }
        return this.myWhenPrepared;
    }

    public Date getWhenPrepared() {
        return (Date)this.getWhenPreparedElement().getValue();
    }

    public MedicationDispense setWhenPrepared(DateTimeDt theValue) {
        this.myWhenPrepared = theValue;
        return this;
    }

    public MedicationDispense setWhenPrepared(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myWhenPrepared = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public MedicationDispense setWhenPreparedWithSecondsPrecision(Date theDate) {
        this.myWhenPrepared = new DateTimeDt(theDate);
        return this;
    }

    public DateTimeDt getWhenHandedOverElement() {
        if (this.myWhenHandedOver == null) {
            this.myWhenHandedOver = new DateTimeDt();
        }
        return this.myWhenHandedOver;
    }

    public Date getWhenHandedOver() {
        return (Date)this.getWhenHandedOverElement().getValue();
    }

    public MedicationDispense setWhenHandedOver(DateTimeDt theValue) {
        this.myWhenHandedOver = theValue;
        return this;
    }

    public MedicationDispense setWhenHandedOver(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myWhenHandedOver = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public MedicationDispense setWhenHandedOverWithSecondsPrecision(Date theDate) {
        this.myWhenHandedOver = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getDestination() {
        if (this.myDestination == null) {
            this.myDestination = new ResourceReferenceDt();
        }
        return this.myDestination;
    }

    public MedicationDispense setDestination(ResourceReferenceDt theValue) {
        this.myDestination = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getReceiver() {
        if (this.myReceiver == null) {
            this.myReceiver = new ArrayList<ResourceReferenceDt>();
        }
        return this.myReceiver;
    }

    public MedicationDispense setReceiver(List<ResourceReferenceDt> theValue) {
        this.myReceiver = theValue;
        return this;
    }

    public ResourceReferenceDt addReceiver() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getReceiver().add(newType);
        return newType;
    }

    public StringDt getNoteElement() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public String getNote() {
        return (String)this.getNoteElement().getValue();
    }

    public MedicationDispense setNote(StringDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public MedicationDispense setNote(String theString) {
        this.myNote = new StringDt(theString);
        return this;
    }

    public List<DosageInstruction> getDosageInstruction() {
        if (this.myDosageInstruction == null) {
            this.myDosageInstruction = new ArrayList<DosageInstruction>();
        }
        return this.myDosageInstruction;
    }

    public MedicationDispense setDosageInstruction(List<DosageInstruction> theValue) {
        this.myDosageInstruction = theValue;
        return this;
    }

    public DosageInstruction addDosageInstruction() {
        DosageInstruction newType = new DosageInstruction();
        this.getDosageInstruction().add(newType);
        return newType;
    }

    public MedicationDispense addDosageInstruction(DosageInstruction theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDosageInstruction().add(theValue);
        return this;
    }

    public DosageInstruction getDosageInstructionFirstRep() {
        if (this.getDosageInstruction().isEmpty()) {
            return this.addDosageInstruction();
        }
        return this.getDosageInstruction().get(0);
    }

    public Substitution getSubstitution() {
        if (this.mySubstitution == null) {
            this.mySubstitution = new Substitution();
        }
        return this.mySubstitution;
    }

    public MedicationDispense setSubstitution(Substitution theValue) {
        this.mySubstitution = theValue;
        return this;
    }

    public String getResourceName() {
        return "MedicationDispense";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Substitution
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code signifying whether a different drug was dispensed from what was prescribed.")
        private CodeableConceptDt myType;
        @Child(name="reason", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the reason for the substitution of (or lack of substitution) from what was prescribed.")
        private List<CodeableConceptDt> myReason;
        @Child(name="responsibleParty", order=2, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="", formalDefinition="The person or organization that has primary responsibility for the substitution")
        private List<ResourceReferenceDt> myResponsibleParty;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myReason, this.myResponsibleParty});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myReason, this.myResponsibleParty});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Substitution setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public List<CodeableConceptDt> getReason() {
            if (this.myReason == null) {
                this.myReason = new ArrayList<CodeableConceptDt>();
            }
            return this.myReason;
        }

        public Substitution setReason(List<CodeableConceptDt> theValue) {
            this.myReason = theValue;
            return this;
        }

        public CodeableConceptDt addReason() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getReason().add(newType);
            return newType;
        }

        public Substitution addReason(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getReason().add(theValue);
            return this;
        }

        public CodeableConceptDt getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                return this.addReason();
            }
            return this.getReason().get(0);
        }

        public List<ResourceReferenceDt> getResponsibleParty() {
            if (this.myResponsibleParty == null) {
                this.myResponsibleParty = new ArrayList<ResourceReferenceDt>();
            }
            return this.myResponsibleParty;
        }

        public Substitution setResponsibleParty(List<ResourceReferenceDt> theValue) {
            this.myResponsibleParty = theValue;
            return this;
        }

        public ResourceReferenceDt addResponsibleParty() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getResponsibleParty().add(newType);
            return newType;
        }
    }

    @Block
    public static class DosageInstruction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="text", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Free text dosage instructions can be used for cases where the instructions are too complex to code. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication.")
        private StringDt myText;
        @Child(name="additionalInstructions", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional instructions such as \"Swallow with plenty of water\" which may or may not be coded.")
        private CodeableConceptDt myAdditionalInstructions;
        @Child(name="timing", type={TimingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions.  For example, \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\"")
        private TimingDt myTiming;
        @Child(name="asNeeded", order=3, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, CodeableConceptDt.class})
        @Description(shortDefinition="", formalDefinition="Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).  Specifically if 'boolean' datatype is selected, then the following logic applies:  If set to True, this indicates that the medication is only taken when needed, within the specified schedule.")
        private IDatatype myAsNeeded;
        @Child(name="site", order=4, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, BodySite.class})
        @Description(shortDefinition="", formalDefinition="A coded specification of the anatomic site where the medication first enters the body")
        private IDatatype mySite;
        @Child(name="route", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.")
        private CodeableConceptDt myRoute;
        @Child(name="method", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.")
        private CodeableConceptDt myMethod;
        @Child(name="dose", order=7, min=0, max=1, summary=false, modifier=false, type={RangeDt.class, SimpleQuantityDt.class})
        @Description(shortDefinition="", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        private IDatatype myDose;
        @Child(name="rate", order=8, min=0, max=1, summary=false, modifier=false, type={RatioDt.class, RangeDt.class})
        @Description(shortDefinition="", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours")
        private IDatatype myRate;
        @Child(name="maxDosePerPeriod", type={RatioDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time,  e.g. 1000mg in 24 hours.")
        private RatioDt myMaxDosePerPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myText, this.myAdditionalInstructions, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myDose, this.myRate, this.myMaxDosePerPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myText, this.myAdditionalInstructions, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myDose, this.myRate, this.myMaxDosePerPeriod});
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public DosageInstruction setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public DosageInstruction setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getAdditionalInstructions() {
            if (this.myAdditionalInstructions == null) {
                this.myAdditionalInstructions = new CodeableConceptDt();
            }
            return this.myAdditionalInstructions;
        }

        public DosageInstruction setAdditionalInstructions(CodeableConceptDt theValue) {
            this.myAdditionalInstructions = theValue;
            return this;
        }

        public TimingDt getTiming() {
            if (this.myTiming == null) {
                this.myTiming = new TimingDt();
            }
            return this.myTiming;
        }

        public DosageInstruction setTiming(TimingDt theValue) {
            this.myTiming = theValue;
            return this;
        }

        public IDatatype getAsNeeded() {
            return this.myAsNeeded;
        }

        public DosageInstruction setAsNeeded(IDatatype theValue) {
            this.myAsNeeded = theValue;
            return this;
        }

        public IDatatype getSite() {
            return this.mySite;
        }

        public DosageInstruction setSite(IDatatype theValue) {
            this.mySite = theValue;
            return this;
        }

        public CodeableConceptDt getRoute() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public DosageInstruction setRoute(CodeableConceptDt theValue) {
            this.myRoute = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public DosageInstruction setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public IDatatype getDose() {
            return this.myDose;
        }

        public DosageInstruction setDose(IDatatype theValue) {
            this.myDose = theValue;
            return this;
        }

        public IDatatype getRate() {
            return this.myRate;
        }

        public DosageInstruction setRate(IDatatype theValue) {
            this.myRate = theValue;
            return this;
        }

        public RatioDt getMaxDosePerPeriod() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public DosageInstruction setMaxDosePerPeriod(RatioDt theValue) {
            this.myMaxDosePerPeriod = theValue;
            return this;
        }
    }
}

