/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.RatioDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.BodySite;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Medication;
import ca.uhn.fhir.model.dstu2.resource.MedicationOrder;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.MedicationAdministrationStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="MedicationAdministration", profile="http://hl7.org/fhir/profiles/MedicationAdministration", id="medicationadministration")
public class MedicationAdministration
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="device", path="MedicationAdministration.device", description="Return administrations with this administration device identity", type="reference")
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    @SearchParamDefinition(name="encounter", path="MedicationAdministration.encounter", description="Return administrations that share this encounter", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="identifier", path="MedicationAdministration.identifier", description="Return administrations with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medication", path="MedicationAdministration.medicationReference", description="Return administrations of this medication resource", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    @SearchParamDefinition(name="code", path="MedicationAdministration.medicationCodeableConcept", description="Return administrations of this medication code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="notgiven", path="MedicationAdministration.wasNotGiven", description="Administrations that were not made", type="token")
    public static final String SP_NOTGIVEN = "notgiven";
    public static final TokenClientParam NOTGIVEN = new TokenClientParam("notgiven");
    @SearchParamDefinition(name="patient", path="MedicationAdministration.patient", description="The identity of a patient to list administrations  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="prescription", path="MedicationAdministration.prescription", description="The identity of a prescription to list administrations from", type="reference")
    public static final String SP_PRESCRIPTION = "prescription";
    public static final ReferenceClientParam PRESCRIPTION = new ReferenceClientParam("prescription");
    @SearchParamDefinition(name="status", path="MedicationAdministration.status", description="MedicationAdministration event status (for example one of active/paused/completed/nullified)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="effectivetime", path="MedicationAdministration.effectiveTime[x]", description="Date administration happened (or did not happen)", type="date")
    public static final String SP_EFFECTIVETIME = "effectivetime";
    public static final DateClientParam EFFECTIVETIME = new DateClientParam("effectivetime");
    @SearchParamDefinition(name="practitioner", path="MedicationAdministration.practitioner", description="", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_DEVICE = new Include("MedicationAdministration:device");
    public static final Include INCLUDE_ENCOUNTER = new Include("MedicationAdministration:encounter");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationAdministration:medication");
    public static final Include INCLUDE_PATIENT = new Include("MedicationAdministration:patient");
    public static final Include INCLUDE_PRACTITIONER = new Include("MedicationAdministration:practitioner");
    public static final Include INCLUDE_PRESCRIPTION = new Include("MedicationAdministration:prescription");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="External identifier - FHIR will generate its own internal identifiers (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Will generally be set to show that the administration has been completed.  For some long running administrations such as infusions it is possible for an administration to be started but not completed or it may be paused while some other process is under way.")
    private BoundCodeDt<MedicationAdministrationStatusEnum> myStatus;
    @Child(name="patient", order=2, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The person or animal receiving the medication.")
    private ResourceReferenceDt myPatient;
    @Child(name="practitioner", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="who.actor", formalDefinition="The individual who was responsible for giving the medication to the patient.")
    private ResourceReferenceDt myPractitioner;
    @Child(name="encounter", order=4, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The visit, admission or other contact between patient and health care provider the medication administration was performed as part of.")
    private ResourceReferenceDt myEncounter;
    @Child(name="prescription", order=5, min=0, max=1, summary=false, modifier=false, type={MedicationOrder.class})
    @Description(shortDefinition="", formalDefinition="The original request, instruction or authority to perform the administration.")
    private ResourceReferenceDt myPrescription;
    @Child(name="wasNotGiven", type={BooleanDt.class}, order=6, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="Set this to true if the record is saying that the medication was NOT administered.")
    private BooleanDt myWasNotGiven;
    @Child(name="reasonNotGiven", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A code indicating why the administration was not performed.")
    private List<CodeableConceptDt> myReasonNotGiven;
    @Child(name="reasonGiven", type={CodeableConceptDt.class}, order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A code indicating why the medication was given.")
    private List<CodeableConceptDt> myReasonGiven;
    @Child(name="effectiveTime", order=9, min=1, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="when.done", formalDefinition="A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.")
    private IDatatype myEffectiveTime;
    @Child(name="medication", order=10, min=1, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, Medication.class})
    @Description(shortDefinition="", formalDefinition="Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    private IDatatype myMedication;
    @Child(name="device", order=11, min=0, max=-1, summary=false, modifier=false, type={Device.class})
    @Description(shortDefinition="", formalDefinition="The device used in administering the medication to the patient.  For example, a particular infusion pump")
    private List<ResourceReferenceDt> myDevice;
    @Child(name="note", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Extra information about the medication administration that is not conveyed by the other attributes.")
    private StringDt myNote;
    @Child(name="dosage", order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the medication dosage information details e.g. dose, rate, site, route, etc.")
    private Dosage myDosage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myPractitioner, this.myEncounter, this.myPrescription, this.myWasNotGiven, this.myReasonNotGiven, this.myReasonGiven, this.myEffectiveTime, this.myMedication, this.myDevice, this.myNote, this.myDosage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myPractitioner, this.myEncounter, this.myPrescription, this.myWasNotGiven, this.myReasonNotGiven, this.myReasonGiven, this.myEffectiveTime, this.myMedication, this.myDevice, this.myNote, this.myDosage});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public MedicationAdministration setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public MedicationAdministration addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<MedicationAdministrationStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationAdministrationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public MedicationAdministration setStatus(BoundCodeDt<MedicationAdministrationStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public MedicationAdministration setStatus(MedicationAdministrationStatusEnum theValue) {
        this.setStatus((BoundCodeDt<MedicationAdministrationStatusEnum>)new BoundCodeDt(MedicationAdministrationStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public MedicationAdministration setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getPractitioner() {
        if (this.myPractitioner == null) {
            this.myPractitioner = new ResourceReferenceDt();
        }
        return this.myPractitioner;
    }

    public MedicationAdministration setPractitioner(ResourceReferenceDt theValue) {
        this.myPractitioner = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public MedicationAdministration setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getPrescription() {
        if (this.myPrescription == null) {
            this.myPrescription = new ResourceReferenceDt();
        }
        return this.myPrescription;
    }

    public MedicationAdministration setPrescription(ResourceReferenceDt theValue) {
        this.myPrescription = theValue;
        return this;
    }

    public BooleanDt getWasNotGivenElement() {
        if (this.myWasNotGiven == null) {
            this.myWasNotGiven = new BooleanDt();
        }
        return this.myWasNotGiven;
    }

    public Boolean getWasNotGiven() {
        return (Boolean)this.getWasNotGivenElement().getValue();
    }

    public MedicationAdministration setWasNotGiven(BooleanDt theValue) {
        this.myWasNotGiven = theValue;
        return this;
    }

    public MedicationAdministration setWasNotGiven(boolean theBoolean) {
        this.myWasNotGiven = new BooleanDt(theBoolean);
        return this;
    }

    public List<CodeableConceptDt> getReasonNotGiven() {
        if (this.myReasonNotGiven == null) {
            this.myReasonNotGiven = new ArrayList<CodeableConceptDt>();
        }
        return this.myReasonNotGiven;
    }

    public MedicationAdministration setReasonNotGiven(List<CodeableConceptDt> theValue) {
        this.myReasonNotGiven = theValue;
        return this;
    }

    public CodeableConceptDt addReasonNotGiven() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReasonNotGiven().add(newType);
        return newType;
    }

    public MedicationAdministration addReasonNotGiven(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReasonNotGiven().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonNotGivenFirstRep() {
        if (this.getReasonNotGiven().isEmpty()) {
            return this.addReasonNotGiven();
        }
        return this.getReasonNotGiven().get(0);
    }

    public List<CodeableConceptDt> getReasonGiven() {
        if (this.myReasonGiven == null) {
            this.myReasonGiven = new ArrayList<CodeableConceptDt>();
        }
        return this.myReasonGiven;
    }

    public MedicationAdministration setReasonGiven(List<CodeableConceptDt> theValue) {
        this.myReasonGiven = theValue;
        return this;
    }

    public CodeableConceptDt addReasonGiven() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReasonGiven().add(newType);
        return newType;
    }

    public MedicationAdministration addReasonGiven(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReasonGiven().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonGivenFirstRep() {
        if (this.getReasonGiven().isEmpty()) {
            return this.addReasonGiven();
        }
        return this.getReasonGiven().get(0);
    }

    public IDatatype getEffectiveTime() {
        return this.myEffectiveTime;
    }

    public MedicationAdministration setEffectiveTime(IDatatype theValue) {
        this.myEffectiveTime = theValue;
        return this;
    }

    public IDatatype getMedication() {
        return this.myMedication;
    }

    public MedicationAdministration setMedication(IDatatype theValue) {
        this.myMedication = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getDevice() {
        if (this.myDevice == null) {
            this.myDevice = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDevice;
    }

    public MedicationAdministration setDevice(List<ResourceReferenceDt> theValue) {
        this.myDevice = theValue;
        return this;
    }

    public ResourceReferenceDt addDevice() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getDevice().add(newType);
        return newType;
    }

    public StringDt getNoteElement() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public String getNote() {
        return (String)this.getNoteElement().getValue();
    }

    public MedicationAdministration setNote(StringDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public MedicationAdministration setNote(String theString) {
        this.myNote = new StringDt(theString);
        return this;
    }

    public Dosage getDosage() {
        if (this.myDosage == null) {
            this.myDosage = new Dosage();
        }
        return this.myDosage;
    }

    public MedicationAdministration setDosage(Dosage theValue) {
        this.myDosage = theValue;
        return this;
    }

    public String getResourceName() {
        return "MedicationAdministration";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Dosage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="text", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Free text dosage instructions can be used for cases where the instructions are too complex to code. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication.")
        private StringDt myText;
        @Child(name="site", order=1, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, BodySite.class})
        @Description(shortDefinition="", formalDefinition="A coded specification of the anatomic site where the medication first entered the body.  For example, \"left arm\"")
        private IDatatype mySite;
        @Child(name="route", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto the patient.  For example, topical, intravenous, etc.")
        private CodeableConceptDt myRoute;
        @Child(name="method", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A coded value indicating the method by which the medication is intended to be or was introduced into or on the body.  This attribute will most often NOT be populated.  It is most commonly used for injections.  For example, Slow Push, Deep IV.")
        private CodeableConceptDt myMethod;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The amount of the medication given at one administration event.   Use this value when the administration is essentially an instantaneous event such as a swallowing a tablet or giving an injection.")
        private SimpleQuantityDt myQuantity;
        @Child(name="rate", order=5, min=0, max=1, summary=false, modifier=false, type={RatioDt.class, RangeDt.class})
        @Description(shortDefinition="", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient.  Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.  Currently we do not specify a default of '1' in the denominator, but this is being discussed.  Other examples:  200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.")
        private IDatatype myRate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myText, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myText, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate});
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public Dosage setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Dosage setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public IDatatype getSite() {
            return this.mySite;
        }

        public Dosage setSite(IDatatype theValue) {
            this.mySite = theValue;
            return this;
        }

        public CodeableConceptDt getRoute() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public Dosage setRoute(CodeableConceptDt theValue) {
            this.myRoute = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public Dosage setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public Dosage setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public IDatatype getRate() {
            return this.myRate;
        }

        public Dosage setRate(IDatatype theValue) {
            this.myRate = theValue;
            return this;
        }
    }
}

