/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.ImagingStudy;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.KOStitleEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.OidDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UnsignedIntDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ImagingObjectSelection", profile="http://hl7.org/fhir/profiles/ImagingObjectSelection", id="imagingobjectselection")
public class ImagingObjectSelection
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="ImagingObjectSelection.uid", description="UID of key DICOM object selection", type="uri")
    public static final String SP_IDENTIFIER = "identifier";
    public static final UriClientParam IDENTIFIER = new UriClientParam("identifier");
    @SearchParamDefinition(name="title", path="ImagingObjectSelection.title", description="Title of key DICOM object selection", type="token")
    public static final String SP_TITLE = "title";
    public static final TokenClientParam TITLE = new TokenClientParam("title");
    @SearchParamDefinition(name="author", path="ImagingObjectSelection.author", description="Author of key DICOM object selection", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    @SearchParamDefinition(name="authoring-time", path="ImagingObjectSelection.authoringTime", description="Time of key DICOM object selection authoring", type="date")
    public static final String SP_AUTHORING_TIME = "authoring-time";
    public static final DateClientParam AUTHORING_TIME = new DateClientParam("authoring-time");
    @SearchParamDefinition(name="patient", path="ImagingObjectSelection.patient", description="Subject of key DICOM object selection", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="selected-study", path="ImagingObjectSelection.study.uid", description="Study selected in key DICOM object selection", type="uri")
    public static final String SP_SELECTED_STUDY = "selected-study";
    public static final UriClientParam SELECTED_STUDY = new UriClientParam("selected-study");
    public static final Include INCLUDE_AUTHOR = new Include("ImagingObjectSelection:author");
    public static final Include INCLUDE_PATIENT = new Include("ImagingObjectSelection:patient");
    @Child(name="uid", type={OidDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Instance UID of the DICOM KOS SOP Instances represented in this resource.")
    private OidDt myUid;
    @Child(name="patient", order=1, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="A patient resource reference which is the patient subject of all DICOM SOP Instances in this ImagingObjectSelection.")
    private ResourceReferenceDt myPatient;
    @Child(name="title", type={CodeableConceptDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The reason for, or significance of, the selection of objects referenced in the resource")
    private BoundCodeableConceptDt<KOStitleEnum> myTitle;
    @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Text description of the DICOM SOP instances selected in the ImagingObjectSelection. This should be aligned with the content of the title element, and can provide further explanation of the SOP instances in the selection.")
    private StringDt myDescription;
    @Child(name="author", order=4, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Device.class, Organization.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="who.author", formalDefinition="Author of ImagingObjectSelection. It can be a human author or a device which made the decision of the SOP instances selected. For example, a radiologist selected a set of imaging SOP instances to attach in a diagnostic report, and a CAD application may author a selection to describe SOP instances it used to generate a detection conclusion.")
    private ResourceReferenceDt myAuthor;
    @Child(name="authoringTime", type={DateTimeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="Date and time when the selection of the referenced instances were made. It is (typically) different from the creation date of the selection resource, and from dates associated with the referenced instances (e.g. capture time of the referenced image).")
    private DateTimeDt myAuthoringTime;
    @Child(name="study", order=6, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Study identity and locating information of the DICOM SOP instances in the selection.")
    private List<Study> myStudy;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUid, this.myPatient, this.myTitle, this.myDescription, this.myAuthor, this.myAuthoringTime, this.myStudy});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUid, this.myPatient, this.myTitle, this.myDescription, this.myAuthor, this.myAuthoringTime, this.myStudy});
    }

    public OidDt getUidElement() {
        if (this.myUid == null) {
            this.myUid = new OidDt();
        }
        return this.myUid;
    }

    public String getUid() {
        return (String)this.getUidElement().getValue();
    }

    public ImagingObjectSelection setUid(OidDt theValue) {
        this.myUid = theValue;
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ImagingObjectSelection setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public BoundCodeableConceptDt<KOStitleEnum> getTitle() {
        if (this.myTitle == null) {
            this.myTitle = new BoundCodeableConceptDt<KOStitleEnum>(KOStitleEnum.VALUESET_BINDER);
        }
        return this.myTitle;
    }

    public ImagingObjectSelection setTitle(BoundCodeableConceptDt<KOStitleEnum> theValue) {
        this.myTitle = theValue;
        return this;
    }

    public ImagingObjectSelection setTitle(KOStitleEnum theValue) {
        this.setTitle(new BoundCodeableConceptDt<KOStitleEnum>(KOStitleEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public ImagingObjectSelection setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ImagingObjectSelection setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public ImagingObjectSelection setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public DateTimeDt getAuthoringTimeElement() {
        if (this.myAuthoringTime == null) {
            this.myAuthoringTime = new DateTimeDt();
        }
        return this.myAuthoringTime;
    }

    public Date getAuthoringTime() {
        return (Date)this.getAuthoringTimeElement().getValue();
    }

    public ImagingObjectSelection setAuthoringTime(DateTimeDt theValue) {
        this.myAuthoringTime = theValue;
        return this;
    }

    public ImagingObjectSelection setAuthoringTime(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myAuthoringTime = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ImagingObjectSelection setAuthoringTimeWithSecondsPrecision(Date theDate) {
        this.myAuthoringTime = new DateTimeDt(theDate);
        return this;
    }

    public List<Study> getStudy() {
        if (this.myStudy == null) {
            this.myStudy = new ArrayList<Study>();
        }
        return this.myStudy;
    }

    public ImagingObjectSelection setStudy(List<Study> theValue) {
        this.myStudy = theValue;
        return this;
    }

    public Study addStudy() {
        Study newType = new Study();
        this.getStudy().add(newType);
        return newType;
    }

    public ImagingObjectSelection addStudy(Study theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getStudy().add(theValue);
        return this;
    }

    public Study getStudyFirstRep() {
        if (this.getStudy().isEmpty()) {
            return this.addStudy();
        }
        return this.getStudy().get(0);
    }

    public String getResourceName() {
        return "ImagingObjectSelection";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class StudySeriesInstanceFrames
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="frameNumbers", type={UnsignedIntDt.class}, order=0, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The frame numbers in the frame set")
        private List<UnsignedIntDt> myFrameNumbers;
        @Child(name="url", type={UriDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="WADO-RS URL to retrieve the DICOM frames.")
        private UriDt myUrl;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myFrameNumbers, this.myUrl});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myFrameNumbers, this.myUrl});
        }

        public List<UnsignedIntDt> getFrameNumbers() {
            if (this.myFrameNumbers == null) {
                this.myFrameNumbers = new ArrayList<UnsignedIntDt>();
            }
            return this.myFrameNumbers;
        }

        public StudySeriesInstanceFrames setFrameNumbers(List<UnsignedIntDt> theValue) {
            this.myFrameNumbers = theValue;
            return this;
        }

        public UnsignedIntDt addFrameNumbers() {
            UnsignedIntDt newType = new UnsignedIntDt();
            this.getFrameNumbers().add(newType);
            return newType;
        }

        public StudySeriesInstanceFrames addFrameNumbers(UnsignedIntDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getFrameNumbers().add(theValue);
            return this;
        }

        public UnsignedIntDt getFrameNumbersFirstRep() {
            if (this.getFrameNumbers().isEmpty()) {
                return this.addFrameNumbers();
            }
            return this.getFrameNumbers().get(0);
        }

        public StudySeriesInstanceFrames addFrameNumbers(int theInteger) {
            if (this.myFrameNumbers == null) {
                this.myFrameNumbers = new ArrayList<UnsignedIntDt>();
            }
            this.myFrameNumbers.add(new UnsignedIntDt(theInteger));
            return this;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public StudySeriesInstanceFrames setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public StudySeriesInstanceFrames setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class StudySeriesInstance
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sopClass", type={OidDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="SOP class UID of the selected instance")
        private OidDt mySopClass;
        @Child(name="uid", type={OidDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="SOP Instance UID of the selected instance")
        private OidDt myUid;
        @Child(name="url", type={UriDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="WADO-RS URL to retrieve the DICOM SOP Instance.")
        private UriDt myUrl;
        @Child(name="frames", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identity and location information of the frames in the selected instance")
        private List<StudySeriesInstanceFrames> myFrames;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySopClass, this.myUid, this.myUrl, this.myFrames});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySopClass, this.myUid, this.myUrl, this.myFrames});
        }

        public OidDt getSopClassElement() {
            if (this.mySopClass == null) {
                this.mySopClass = new OidDt();
            }
            return this.mySopClass;
        }

        public String getSopClass() {
            return (String)this.getSopClassElement().getValue();
        }

        public StudySeriesInstance setSopClass(OidDt theValue) {
            this.mySopClass = theValue;
            return this;
        }

        public OidDt getUidElement() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public String getUid() {
            return (String)this.getUidElement().getValue();
        }

        public StudySeriesInstance setUid(OidDt theValue) {
            this.myUid = theValue;
            return this;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public StudySeriesInstance setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public StudySeriesInstance setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }

        public List<StudySeriesInstanceFrames> getFrames() {
            if (this.myFrames == null) {
                this.myFrames = new ArrayList<StudySeriesInstanceFrames>();
            }
            return this.myFrames;
        }

        public StudySeriesInstance setFrames(List<StudySeriesInstanceFrames> theValue) {
            this.myFrames = theValue;
            return this;
        }

        public StudySeriesInstanceFrames addFrames() {
            StudySeriesInstanceFrames newType = new StudySeriesInstanceFrames();
            this.getFrames().add(newType);
            return newType;
        }

        public StudySeriesInstance addFrames(StudySeriesInstanceFrames theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getFrames().add(theValue);
            return this;
        }

        public StudySeriesInstanceFrames getFramesFirstRep() {
            if (this.getFrames().isEmpty()) {
                return this.addFrames();
            }
            return this.getFrames().get(0);
        }
    }

    @Block
    public static class StudySeries
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="uid", type={OidDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Series instance UID of the SOP instances in the selection")
        private OidDt myUid;
        @Child(name="url", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="WADO-RS URL to retrieve the series. Note that this URL retrieves all SOP instances of the series not only those in the selection.")
        private UriDt myUrl;
        @Child(name="instance", order=2, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identity and locating information of the selected DICOM SOP instances")
        private List<StudySeriesInstance> myInstance;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUid, this.myUrl, this.myInstance});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUid, this.myUrl, this.myInstance});
        }

        public OidDt getUidElement() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public String getUid() {
            return (String)this.getUidElement().getValue();
        }

        public StudySeries setUid(OidDt theValue) {
            this.myUid = theValue;
            return this;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public StudySeries setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public StudySeries setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }

        public List<StudySeriesInstance> getInstance() {
            if (this.myInstance == null) {
                this.myInstance = new ArrayList<StudySeriesInstance>();
            }
            return this.myInstance;
        }

        public StudySeries setInstance(List<StudySeriesInstance> theValue) {
            this.myInstance = theValue;
            return this;
        }

        public StudySeriesInstance addInstance() {
            StudySeriesInstance newType = new StudySeriesInstance();
            this.getInstance().add(newType);
            return newType;
        }

        public StudySeries addInstance(StudySeriesInstance theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getInstance().add(theValue);
            return this;
        }

        public StudySeriesInstance getInstanceFirstRep() {
            if (this.getInstance().isEmpty()) {
                return this.addInstance();
            }
            return this.getInstance().get(0);
        }
    }

    @Block
    public static class Study
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="uid", type={OidDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Study instance UID of the SOP instances in the selection")
        private OidDt myUid;
        @Child(name="url", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="WADO-RS URL to retrieve the study. Note that this URL retrieves all SOP instances of the study, not only those in the selection.")
        private UriDt myUrl;
        @Child(name="imagingStudy", order=2, min=0, max=1, summary=false, modifier=false, type={ImagingStudy.class})
        @Description(shortDefinition="", formalDefinition="Reference to the Imaging Study in FHIR form.")
        private ResourceReferenceDt myImagingStudy;
        @Child(name="series", order=3, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Series identity and locating information of the DICOM SOP instances in the selection")
        private List<StudySeries> mySeries;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUid, this.myUrl, this.myImagingStudy, this.mySeries});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUid, this.myUrl, this.myImagingStudy, this.mySeries});
        }

        public OidDt getUidElement() {
            if (this.myUid == null) {
                this.myUid = new OidDt();
            }
            return this.myUid;
        }

        public String getUid() {
            return (String)this.getUidElement().getValue();
        }

        public Study setUid(OidDt theValue) {
            this.myUid = theValue;
            return this;
        }

        public UriDt getUrlElement() {
            if (this.myUrl == null) {
                this.myUrl = new UriDt();
            }
            return this.myUrl;
        }

        public String getUrl() {
            return (String)this.getUrlElement().getValue();
        }

        public Study setUrl(UriDt theValue) {
            this.myUrl = theValue;
            return this;
        }

        public Study setUrl(String theUri) {
            this.myUrl = new UriDt(theUri);
            return this;
        }

        public ResourceReferenceDt getImagingStudy() {
            if (this.myImagingStudy == null) {
                this.myImagingStudy = new ResourceReferenceDt();
            }
            return this.myImagingStudy;
        }

        public Study setImagingStudy(ResourceReferenceDt theValue) {
            this.myImagingStudy = theValue;
            return this;
        }

        public List<StudySeries> getSeries() {
            if (this.mySeries == null) {
                this.mySeries = new ArrayList<StudySeries>();
            }
            return this.mySeries;
        }

        public Study setSeries(List<StudySeries> theValue) {
            this.mySeries = theValue;
            return this;
        }

        public StudySeries addSeries() {
            StudySeries newType = new StudySeries();
            this.getSeries().add(newType);
            return newType;
        }

        public Study addSeries(StudySeries theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSeries().add(theValue);
            return this;
        }

        public StudySeries getSeriesFirstRep() {
            if (this.getSeries().isEmpty()) {
                return this.addSeries();
            }
            return this.getSeries().get(0);
        }
    }
}

