/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.FlagCategoryCodesEnum;
import ca.uhn.fhir.model.dstu2.valueset.FlagStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Flag", profile="http://hl7.org/fhir/profiles/Flag", id="flag")
public class Flag
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="Flag.subject", description="The identity of a subject to list flags for", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="Flag.subject", description="The identity of a subject to list flags for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="author", path="Flag.author", description="", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    @SearchParamDefinition(name="date", path="Flag.period", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="Flag.encounter", description="", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_AUTHOR = new Include("Flag:author");
    public static final Include INCLUDE_ENCOUNTER = new Include("Flag:encounter");
    public static final Include INCLUDE_PATIENT = new Include("Flag:patient");
    public static final Include INCLUDE_SUBJECT = new Include("Flag:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifier assigned to the flag for external use (outside the FHIR environment)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="category", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Allows an flag to be divided into different categories like clinical, administrative etc. Intended to be used as a means of filtering which flags are displayed to particular user or in a given context.")
    private BoundCodeableConceptDt<FlagCategoryCodesEnum> myCategory;
    @Child(name="status", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Supports basic workflow")
    private BoundCodeDt<FlagStatusEnum> myStatus;
    @Child(name="period", type={PeriodDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="context", formalDefinition="The period of time from the activation of the flag to inactivation of the flag. If the flag is active, the end of the period should be unspecified.")
    private PeriodDt myPeriod;
    @Child(name="subject", order=4, min=1, max=1, summary=true, modifier=false, type={Patient.class, Location.class, Group.class, Organization.class, Practitioner.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient, location, group , organization , or practitioner this is about record this flag is associated with")
    private ResourceReferenceDt mySubject;
    @Child(name="encounter", order=5, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="This alert is only relevant during the encounter")
    private ResourceReferenceDt myEncounter;
    @Child(name="author", order=6, min=0, max=1, summary=true, modifier=false, type={Device.class, Organization.class, Patient.class, Practitioner.class})
    @Description(shortDefinition="who.author", formalDefinition="The person, organization or device that created the flag")
    private ResourceReferenceDt myAuthor;
    @Child(name="code", type={CodeableConceptDt.class}, order=7, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="what", formalDefinition="The coded value or textual component of the flag to display to the user")
    private CodeableConceptDt myCode;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCategory, this.myStatus, this.myPeriod, this.mySubject, this.myEncounter, this.myAuthor, this.myCode});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCategory, this.myStatus, this.myPeriod, this.mySubject, this.myEncounter, this.myAuthor, this.myCode});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Flag setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Flag addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeableConceptDt<FlagCategoryCodesEnum> getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new BoundCodeableConceptDt<FlagCategoryCodesEnum>(FlagCategoryCodesEnum.VALUESET_BINDER);
        }
        return this.myCategory;
    }

    public Flag setCategory(BoundCodeableConceptDt<FlagCategoryCodesEnum> theValue) {
        this.myCategory = theValue;
        return this;
    }

    public Flag setCategory(FlagCategoryCodesEnum theValue) {
        this.setCategory(new BoundCodeableConceptDt<FlagCategoryCodesEnum>(FlagCategoryCodesEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public BoundCodeDt<FlagStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(FlagStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Flag setStatus(BoundCodeDt<FlagStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Flag setStatus(FlagStatusEnum theValue) {
        this.setStatus((BoundCodeDt<FlagStatusEnum>)new BoundCodeDt(FlagStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Flag setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Flag setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Flag setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public Flag setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Flag setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public String getResourceName() {
        return "Flag";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

