/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.DurationDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.Appointment;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Condition;
import ca.uhn.fhir.model.dstu2.resource.EpisodeOfCare;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.Procedure;
import ca.uhn.fhir.model.dstu2.resource.ReferralRequest;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.AdmitSourceEnum;
import ca.uhn.fhir.model.dstu2.valueset.EncounterClassEnum;
import ca.uhn.fhir.model.dstu2.valueset.EncounterLocationStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.EncounterStateEnum;
import ca.uhn.fhir.model.dstu2.valueset.EncounterTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.ParticipantTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.PriorityCodesEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Encounter", profile="http://hl7.org/fhir/profiles/Encounter", id="encounter")
public class Encounter
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Encounter.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="Encounter.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="Encounter.period", description="A date within the period the Encounter lasted", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="patient", path="Encounter.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="appointment", path="Encounter.appointment", description="", type="reference")
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    @SearchParamDefinition(name="length", path="Encounter.length", description="Length of encounter in days", type="number")
    public static final String SP_LENGTH = "length";
    public static final NumberClientParam LENGTH = new NumberClientParam("length");
    @SearchParamDefinition(name="reason", path="Encounter.reason", description="", type="token")
    public static final String SP_REASON = "reason";
    public static final TokenClientParam REASON = new TokenClientParam("reason");
    @SearchParamDefinition(name="indication", path="Encounter.indication", description="", type="reference")
    public static final String SP_INDICATION = "indication";
    public static final ReferenceClientParam INDICATION = new ReferenceClientParam("indication");
    @SearchParamDefinition(name="condition", path="Encounter.indication", description="", type="reference")
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    @SearchParamDefinition(name="procedure", path="Encounter.indication", description="", type="reference")
    public static final String SP_PROCEDURE = "procedure";
    public static final ReferenceClientParam PROCEDURE = new ReferenceClientParam("procedure");
    @SearchParamDefinition(name="location", path="Encounter.location.location", description="", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="location-period", path="Encounter.location.period", description="", type="date")
    public static final String SP_LOCATION_PERIOD = "location-period";
    public static final DateClientParam LOCATION_PERIOD = new DateClientParam("location-period");
    @SearchParamDefinition(name="type", path="Encounter.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="special-arrangement", path="Encounter.hospitalization.specialArrangement", description="", type="token")
    public static final String SP_SPECIAL_ARRANGEMENT = "special-arrangement";
    public static final TokenClientParam SPECIAL_ARRANGEMENT = new TokenClientParam("special-arrangement");
    @SearchParamDefinition(name="part-of", path="Encounter.partOf", description="", type="reference")
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    @SearchParamDefinition(name="participant", path="Encounter.participant.individual", description="", type="reference")
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    @SearchParamDefinition(name="participant-type", path="Encounter.participant.type", description="", type="token")
    public static final String SP_PARTICIPANT_TYPE = "participant-type";
    public static final TokenClientParam PARTICIPANT_TYPE = new TokenClientParam("participant-type");
    @SearchParamDefinition(name="episodeofcare", path="Encounter.episodeOfCare", description="", type="reference")
    public static final String SP_EPISODEOFCARE = "episodeofcare";
    public static final ReferenceClientParam EPISODEOFCARE = new ReferenceClientParam("episodeofcare");
    @SearchParamDefinition(name="incomingreferral", path="Encounter.incomingReferral", description="", type="reference")
    public static final String SP_INCOMINGREFERRAL = "incomingreferral";
    public static final ReferenceClientParam INCOMINGREFERRAL = new ReferenceClientParam("incomingreferral");
    @SearchParamDefinition(name="practitioner", path="Encounter.participant.individual", description="", type="reference")
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_APPOINTMENT = new Include("Encounter:appointment");
    public static final Include INCLUDE_CONDITION = new Include("Encounter:condition");
    public static final Include INCLUDE_EPISODEOFCARE = new Include("Encounter:episodeofcare");
    public static final Include INCLUDE_INCOMINGREFERRAL = new Include("Encounter:incomingreferral");
    public static final Include INCLUDE_INDICATION = new Include("Encounter:indication");
    public static final Include INCLUDE_LOCATION = new Include("Encounter:location");
    public static final Include INCLUDE_PART_OF = new Include("Encounter:part-of");
    public static final Include INCLUDE_PARTICIPANT = new Include("Encounter:participant");
    public static final Include INCLUDE_PATIENT = new Include("Encounter:patient");
    public static final Include INCLUDE_PRACTITIONER = new Include("Encounter:practitioner");
    public static final Include INCLUDE_PROCEDURE = new Include("Encounter:procedure");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="")
    private BoundCodeDt<EncounterStateEnum> myStatus;
    @Child(name="statusHistory", order=2, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them")
    private List<StatusHistory> myStatusHistory;
    @Child(name="class", type={CodeDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="")
    private BoundCodeDt<EncounterClassEnum> myClassElement;
    @Child(name="type", type={CodeableConceptDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation)")
    private List<BoundCodeableConceptDt<EncounterTypeEnum>> myType;
    @Child(name="priority", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="grade", formalDefinition="")
    private BoundCodeableConceptDt<PriorityCodesEnum> myPriority;
    @Child(name="patient", order=6, min=0, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="")
    private ResourceReferenceDt myPatient;
    @Child(name="episodeOfCare", order=7, min=0, max=-1, summary=true, modifier=false, type={EpisodeOfCare.class})
    @Description(shortDefinition="context", formalDefinition="Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care, and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years)")
    private List<ResourceReferenceDt> myEpisodeOfCare;
    @Child(name="incomingReferral", order=8, min=0, max=-1, summary=false, modifier=false, type={ReferralRequest.class})
    @Description(shortDefinition="", formalDefinition="The referral request this encounter satisfies (incoming referral)")
    private List<ResourceReferenceDt> myIncomingReferral;
    @Child(name="participant", order=9, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The\u00a0list of\u00a0people\u00a0responsible for providing the service")
    private List<Participant> myParticipant;
    @Child(name="appointment", order=10, min=0, max=1, summary=true, modifier=false, type={Appointment.class})
    @Description(shortDefinition="", formalDefinition="")
    private ResourceReferenceDt myAppointment;
    @Child(name="period", type={PeriodDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="The start and end time of the encounter")
    private PeriodDt myPeriod;
    @Child(name="length", type={DurationDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Quantity of time the encounter lasted. This excludes the time during leaves of absence.")
    private DurationDt myLength;
    @Child(name="reason", type={CodeableConceptDt.class}, order=13, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="why", formalDefinition="Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis")
    private List<CodeableConceptDt> myReason;
    @Child(name="indication", order=14, min=0, max=-1, summary=false, modifier=false, type={Condition.class, Procedure.class})
    @Description(shortDefinition="why", formalDefinition="Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure")
    private List<ResourceReferenceDt> myIndication;
    @Child(name="hospitalization", order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private Hospitalization myHospitalization;
    @Child(name="location", order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of locations where  the patient has been during this encounter")
    private List<Location> myLocation;
    @Child(name="serviceProvider", order=17, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="An organization that is in charge of maintaining the information of this Encounter (e.g. who maintains the report or the master service catalog item, etc.). This MAY be the same as the organization on the Patient record, however it could be different. This MAY not be not the Service Delivery Location's Organization.")
    private ResourceReferenceDt myServiceProvider;
    @Child(name="partOf", order=18, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="", formalDefinition="Another Encounter of which this encounter is a part of (administratively or in time).")
    private ResourceReferenceDt myPartOf;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myStatusHistory, this.myClassElement, this.myType, this.myPriority, this.myPatient, this.myEpisodeOfCare, this.myIncomingReferral, this.myParticipant, this.myAppointment, this.myPeriod, this.myLength, this.myReason, this.myIndication, this.myHospitalization, this.myLocation, this.myServiceProvider, this.myPartOf});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myStatusHistory, this.myClassElement, this.myType, this.myPriority, this.myPatient, this.myEpisodeOfCare, this.myIncomingReferral, this.myParticipant, this.myAppointment, this.myPeriod, this.myLength, this.myReason, this.myIndication, this.myHospitalization, this.myLocation, this.myServiceProvider, this.myPartOf});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Encounter setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Encounter addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<EncounterStateEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(EncounterStateEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Encounter setStatus(BoundCodeDt<EncounterStateEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Encounter setStatus(EncounterStateEnum theValue) {
        this.setStatus((BoundCodeDt<EncounterStateEnum>)new BoundCodeDt(EncounterStateEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<StatusHistory> getStatusHistory() {
        if (this.myStatusHistory == null) {
            this.myStatusHistory = new ArrayList<StatusHistory>();
        }
        return this.myStatusHistory;
    }

    public Encounter setStatusHistory(List<StatusHistory> theValue) {
        this.myStatusHistory = theValue;
        return this;
    }

    public StatusHistory addStatusHistory() {
        StatusHistory newType = new StatusHistory();
        this.getStatusHistory().add(newType);
        return newType;
    }

    public Encounter addStatusHistory(StatusHistory theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getStatusHistory().add(theValue);
        return this;
    }

    public StatusHistory getStatusHistoryFirstRep() {
        if (this.getStatusHistory().isEmpty()) {
            return this.addStatusHistory();
        }
        return this.getStatusHistory().get(0);
    }

    public BoundCodeDt<EncounterClassEnum> getClassElementElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new BoundCodeDt(EncounterClassEnum.VALUESET_BINDER);
        }
        return this.myClassElement;
    }

    public String getClassElement() {
        return (String)this.getClassElementElement().getValue();
    }

    public Encounter setClassElement(BoundCodeDt<EncounterClassEnum> theValue) {
        this.myClassElement = theValue;
        return this;
    }

    public Encounter setClassElement(EncounterClassEnum theValue) {
        this.setClassElement((BoundCodeDt<EncounterClassEnum>)new BoundCodeDt(EncounterClassEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<BoundCodeableConceptDt<EncounterTypeEnum>> getType() {
        if (this.myType == null) {
            this.myType = new ArrayList<BoundCodeableConceptDt<EncounterTypeEnum>>();
        }
        return this.myType;
    }

    public Encounter setType(List<BoundCodeableConceptDt<EncounterTypeEnum>> theValue) {
        this.myType = theValue;
        return this;
    }

    public BoundCodeableConceptDt<EncounterTypeEnum> addType(EncounterTypeEnum theValue) {
        BoundCodeableConceptDt<EncounterTypeEnum> retVal = new BoundCodeableConceptDt<EncounterTypeEnum>(EncounterTypeEnum.VALUESET_BINDER, theValue);
        this.getType().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<EncounterTypeEnum> getTypeFirstRep() {
        if (this.getType().size() == 0) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public BoundCodeableConceptDt<EncounterTypeEnum> addType() {
        BoundCodeableConceptDt<EncounterTypeEnum> retVal = new BoundCodeableConceptDt<EncounterTypeEnum>(EncounterTypeEnum.VALUESET_BINDER);
        this.getType().add(retVal);
        return retVal;
    }

    public Encounter setType(EncounterTypeEnum theValue) {
        this.getType().clear();
        this.addType(theValue);
        return this;
    }

    public BoundCodeableConceptDt<PriorityCodesEnum> getPriority() {
        if (this.myPriority == null) {
            this.myPriority = new BoundCodeableConceptDt<PriorityCodesEnum>(PriorityCodesEnum.VALUESET_BINDER);
        }
        return this.myPriority;
    }

    public Encounter setPriority(BoundCodeableConceptDt<PriorityCodesEnum> theValue) {
        this.myPriority = theValue;
        return this;
    }

    public Encounter setPriority(PriorityCodesEnum theValue) {
        this.setPriority(new BoundCodeableConceptDt<PriorityCodesEnum>(PriorityCodesEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public Encounter setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getEpisodeOfCare() {
        if (this.myEpisodeOfCare == null) {
            this.myEpisodeOfCare = new ArrayList<ResourceReferenceDt>();
        }
        return this.myEpisodeOfCare;
    }

    public Encounter setEpisodeOfCare(List<ResourceReferenceDt> theValue) {
        this.myEpisodeOfCare = theValue;
        return this;
    }

    public ResourceReferenceDt addEpisodeOfCare() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getEpisodeOfCare().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getIncomingReferral() {
        if (this.myIncomingReferral == null) {
            this.myIncomingReferral = new ArrayList<ResourceReferenceDt>();
        }
        return this.myIncomingReferral;
    }

    public Encounter setIncomingReferral(List<ResourceReferenceDt> theValue) {
        this.myIncomingReferral = theValue;
        return this;
    }

    public ResourceReferenceDt addIncomingReferral() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getIncomingReferral().add(newType);
        return newType;
    }

    public List<Participant> getParticipant() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public Encounter setParticipant(List<Participant> theValue) {
        this.myParticipant = theValue;
        return this;
    }

    public Participant addParticipant() {
        Participant newType = new Participant();
        this.getParticipant().add(newType);
        return newType;
    }

    public Encounter addParticipant(Participant theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getParticipant().add(theValue);
        return this;
    }

    public Participant getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            return this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public ResourceReferenceDt getAppointment() {
        if (this.myAppointment == null) {
            this.myAppointment = new ResourceReferenceDt();
        }
        return this.myAppointment;
    }

    public Encounter setAppointment(ResourceReferenceDt theValue) {
        this.myAppointment = theValue;
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Encounter setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public DurationDt getLength() {
        if (this.myLength == null) {
            this.myLength = new DurationDt();
        }
        return this.myLength;
    }

    public Encounter setLength(DurationDt theValue) {
        this.myLength = theValue;
        return this;
    }

    public List<CodeableConceptDt> getReason() {
        if (this.myReason == null) {
            this.myReason = new ArrayList<CodeableConceptDt>();
        }
        return this.myReason;
    }

    public Encounter setReason(List<CodeableConceptDt> theValue) {
        this.myReason = theValue;
        return this;
    }

    public CodeableConceptDt addReason() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReason().add(newType);
        return newType;
    }

    public Encounter addReason(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReason().add(theValue);
        return this;
    }

    public CodeableConceptDt getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            return this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<ResourceReferenceDt> getIndication() {
        if (this.myIndication == null) {
            this.myIndication = new ArrayList<ResourceReferenceDt>();
        }
        return this.myIndication;
    }

    public Encounter setIndication(List<ResourceReferenceDt> theValue) {
        this.myIndication = theValue;
        return this;
    }

    public ResourceReferenceDt addIndication() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getIndication().add(newType);
        return newType;
    }

    public Hospitalization getHospitalization() {
        if (this.myHospitalization == null) {
            this.myHospitalization = new Hospitalization();
        }
        return this.myHospitalization;
    }

    public Encounter setHospitalization(Hospitalization theValue) {
        this.myHospitalization = theValue;
        return this;
    }

    public List<Location> getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<Location>();
        }
        return this.myLocation;
    }

    public Encounter setLocation(List<Location> theValue) {
        this.myLocation = theValue;
        return this;
    }

    public Location addLocation() {
        Location newType = new Location();
        this.getLocation().add(newType);
        return newType;
    }

    public Encounter addLocation(Location theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getLocation().add(theValue);
        return this;
    }

    public Location getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            return this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public ResourceReferenceDt getServiceProvider() {
        if (this.myServiceProvider == null) {
            this.myServiceProvider = new ResourceReferenceDt();
        }
        return this.myServiceProvider;
    }

    public Encounter setServiceProvider(ResourceReferenceDt theValue) {
        this.myServiceProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getPartOf() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public Encounter setPartOf(ResourceReferenceDt theValue) {
        this.myPartOf = theValue;
        return this;
    }

    public String getResourceName() {
        return "Encounter";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Location
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="location", order=0, min=1, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu2.resource.Location.class})
        @Description(shortDefinition="where", formalDefinition="The location where the encounter takes place")
        private ResourceReferenceDt myLocation;
        @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The status of the participants' presence at the specified location during the period specified. If the participant is is no longer at the location, then the period will have an end date/time")
        private BoundCodeDt<EncounterLocationStatusEnum> myStatus;
        @Child(name="period", type={PeriodDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private PeriodDt myPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLocation, this.myStatus, this.myPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLocation, this.myStatus, this.myPeriod});
        }

        public ResourceReferenceDt getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new ResourceReferenceDt();
            }
            return this.myLocation;
        }

        public Location setLocation(ResourceReferenceDt theValue) {
            this.myLocation = theValue;
            return this;
        }

        public BoundCodeDt<EncounterLocationStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(EncounterLocationStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public String getStatus() {
            return (String)this.getStatusElement().getValue();
        }

        public Location setStatus(BoundCodeDt<EncounterLocationStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Location setStatus(EncounterLocationStatusEnum theValue) {
            this.setStatus((BoundCodeDt<EncounterLocationStatusEnum>)new BoundCodeDt(EncounterLocationStatusEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Location setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }
    }

    @Block
    public static class Hospitalization
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="preAdmissionIdentifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private IdentifierDt myPreAdmissionIdentifier;
        @Child(name="origin", order=1, min=0, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu2.resource.Location.class})
        @Description(shortDefinition="", formalDefinition="")
        private ResourceReferenceDt myOrigin;
        @Child(name="admitSource", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private BoundCodeableConceptDt<AdmitSourceEnum> myAdmitSource;
        @Child(name="admittingDiagnosis", order=3, min=0, max=-1, summary=false, modifier=false, type={Condition.class})
        @Description(shortDefinition="", formalDefinition="The admitting diagnosis field is used to record the diagnosis codes as reported by admitting practitioner. This could be different or in addition to the conditions reported as reason-condition(s) for the encounter")
        private List<ResourceReferenceDt> myAdmittingDiagnosis;
        @Child(name="reAdmission", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether this hospitalization is a readmission and why if known")
        private CodeableConceptDt myReAdmission;
        @Child(name="dietPreference", type={CodeableConceptDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private List<CodeableConceptDt> myDietPreference;
        @Child(name="specialCourtesy", type={CodeableConceptDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private List<CodeableConceptDt> mySpecialCourtesy;
        @Child(name="specialArrangement", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private List<CodeableConceptDt> mySpecialArrangement;
        @Child(name="destination", order=8, min=0, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu2.resource.Location.class})
        @Description(shortDefinition="", formalDefinition="")
        private ResourceReferenceDt myDestination;
        @Child(name="dischargeDisposition", type={CodeableConceptDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private CodeableConceptDt myDischargeDisposition;
        @Child(name="dischargeDiagnosis", order=10, min=0, max=-1, summary=false, modifier=false, type={Condition.class})
        @Description(shortDefinition="", formalDefinition="")
        private List<ResourceReferenceDt> myDischargeDiagnosis;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPreAdmissionIdentifier, this.myOrigin, this.myAdmitSource, this.myAdmittingDiagnosis, this.myReAdmission, this.myDietPreference, this.mySpecialCourtesy, this.mySpecialArrangement, this.myDestination, this.myDischargeDisposition, this.myDischargeDiagnosis});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPreAdmissionIdentifier, this.myOrigin, this.myAdmitSource, this.myAdmittingDiagnosis, this.myReAdmission, this.myDietPreference, this.mySpecialCourtesy, this.mySpecialArrangement, this.myDestination, this.myDischargeDisposition, this.myDischargeDiagnosis});
        }

        public IdentifierDt getPreAdmissionIdentifier() {
            if (this.myPreAdmissionIdentifier == null) {
                this.myPreAdmissionIdentifier = new IdentifierDt();
            }
            return this.myPreAdmissionIdentifier;
        }

        public Hospitalization setPreAdmissionIdentifier(IdentifierDt theValue) {
            this.myPreAdmissionIdentifier = theValue;
            return this;
        }

        public ResourceReferenceDt getOrigin() {
            if (this.myOrigin == null) {
                this.myOrigin = new ResourceReferenceDt();
            }
            return this.myOrigin;
        }

        public Hospitalization setOrigin(ResourceReferenceDt theValue) {
            this.myOrigin = theValue;
            return this;
        }

        public BoundCodeableConceptDt<AdmitSourceEnum> getAdmitSource() {
            if (this.myAdmitSource == null) {
                this.myAdmitSource = new BoundCodeableConceptDt<AdmitSourceEnum>(AdmitSourceEnum.VALUESET_BINDER);
            }
            return this.myAdmitSource;
        }

        public Hospitalization setAdmitSource(BoundCodeableConceptDt<AdmitSourceEnum> theValue) {
            this.myAdmitSource = theValue;
            return this;
        }

        public Hospitalization setAdmitSource(AdmitSourceEnum theValue) {
            this.setAdmitSource(new BoundCodeableConceptDt<AdmitSourceEnum>(AdmitSourceEnum.VALUESET_BINDER, theValue));
            return this;
        }

        public List<ResourceReferenceDt> getAdmittingDiagnosis() {
            if (this.myAdmittingDiagnosis == null) {
                this.myAdmittingDiagnosis = new ArrayList<ResourceReferenceDt>();
            }
            return this.myAdmittingDiagnosis;
        }

        public Hospitalization setAdmittingDiagnosis(List<ResourceReferenceDt> theValue) {
            this.myAdmittingDiagnosis = theValue;
            return this;
        }

        public ResourceReferenceDt addAdmittingDiagnosis() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getAdmittingDiagnosis().add(newType);
            return newType;
        }

        public CodeableConceptDt getReAdmission() {
            if (this.myReAdmission == null) {
                this.myReAdmission = new CodeableConceptDt();
            }
            return this.myReAdmission;
        }

        public Hospitalization setReAdmission(CodeableConceptDt theValue) {
            this.myReAdmission = theValue;
            return this;
        }

        public List<CodeableConceptDt> getDietPreference() {
            if (this.myDietPreference == null) {
                this.myDietPreference = new ArrayList<CodeableConceptDt>();
            }
            return this.myDietPreference;
        }

        public Hospitalization setDietPreference(List<CodeableConceptDt> theValue) {
            this.myDietPreference = theValue;
            return this;
        }

        public CodeableConceptDt addDietPreference() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getDietPreference().add(newType);
            return newType;
        }

        public Hospitalization addDietPreference(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDietPreference().add(theValue);
            return this;
        }

        public CodeableConceptDt getDietPreferenceFirstRep() {
            if (this.getDietPreference().isEmpty()) {
                return this.addDietPreference();
            }
            return this.getDietPreference().get(0);
        }

        public List<CodeableConceptDt> getSpecialCourtesy() {
            if (this.mySpecialCourtesy == null) {
                this.mySpecialCourtesy = new ArrayList<CodeableConceptDt>();
            }
            return this.mySpecialCourtesy;
        }

        public Hospitalization setSpecialCourtesy(List<CodeableConceptDt> theValue) {
            this.mySpecialCourtesy = theValue;
            return this;
        }

        public CodeableConceptDt addSpecialCourtesy() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getSpecialCourtesy().add(newType);
            return newType;
        }

        public Hospitalization addSpecialCourtesy(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSpecialCourtesy().add(theValue);
            return this;
        }

        public CodeableConceptDt getSpecialCourtesyFirstRep() {
            if (this.getSpecialCourtesy().isEmpty()) {
                return this.addSpecialCourtesy();
            }
            return this.getSpecialCourtesy().get(0);
        }

        public List<CodeableConceptDt> getSpecialArrangement() {
            if (this.mySpecialArrangement == null) {
                this.mySpecialArrangement = new ArrayList<CodeableConceptDt>();
            }
            return this.mySpecialArrangement;
        }

        public Hospitalization setSpecialArrangement(List<CodeableConceptDt> theValue) {
            this.mySpecialArrangement = theValue;
            return this;
        }

        public CodeableConceptDt addSpecialArrangement() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getSpecialArrangement().add(newType);
            return newType;
        }

        public Hospitalization addSpecialArrangement(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSpecialArrangement().add(theValue);
            return this;
        }

        public CodeableConceptDt getSpecialArrangementFirstRep() {
            if (this.getSpecialArrangement().isEmpty()) {
                return this.addSpecialArrangement();
            }
            return this.getSpecialArrangement().get(0);
        }

        public ResourceReferenceDt getDestination() {
            if (this.myDestination == null) {
                this.myDestination = new ResourceReferenceDt();
            }
            return this.myDestination;
        }

        public Hospitalization setDestination(ResourceReferenceDt theValue) {
            this.myDestination = theValue;
            return this;
        }

        public CodeableConceptDt getDischargeDisposition() {
            if (this.myDischargeDisposition == null) {
                this.myDischargeDisposition = new CodeableConceptDt();
            }
            return this.myDischargeDisposition;
        }

        public Hospitalization setDischargeDisposition(CodeableConceptDt theValue) {
            this.myDischargeDisposition = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getDischargeDiagnosis() {
            if (this.myDischargeDiagnosis == null) {
                this.myDischargeDiagnosis = new ArrayList<ResourceReferenceDt>();
            }
            return this.myDischargeDiagnosis;
        }

        public Hospitalization setDischargeDiagnosis(List<ResourceReferenceDt> theValue) {
            this.myDischargeDiagnosis = theValue;
            return this;
        }

        public ResourceReferenceDt addDischargeDiagnosis() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getDischargeDiagnosis().add(newType);
            return newType;
        }
    }

    @Block
    public static class Participant
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Role of participant in encounter")
        private List<BoundCodeableConceptDt<ParticipantTypeEnum>> myType;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The period of time that the specified participant was present during the encounter. These can overlap or be sub-sets of the overall encounters period")
        private PeriodDt myPeriod;
        @Child(name="individual", order=2, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, RelatedPerson.class})
        @Description(shortDefinition="who", formalDefinition="")
        private ResourceReferenceDt myIndividual;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myPeriod, this.myIndividual});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myPeriod, this.myIndividual});
        }

        public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
            }
            return this.myType;
        }

        public Participant setType(List<BoundCodeableConceptDt<ParticipantTypeEnum>> theValue) {
            this.myType = theValue;
            return this;
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> addType(ParticipantTypeEnum theValue) {
            BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER, theValue);
            this.getType().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> getTypeFirstRep() {
            if (this.getType().size() == 0) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> addType() {
            BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER);
            this.getType().add(retVal);
            return retVal;
        }

        public Participant setType(ParticipantTypeEnum theValue) {
            this.getType().clear();
            this.addType(theValue);
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Participant setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public ResourceReferenceDt getIndividual() {
            if (this.myIndividual == null) {
                this.myIndividual = new ResourceReferenceDt();
            }
            return this.myIndividual;
        }

        public Participant setIndividual(ResourceReferenceDt theValue) {
            this.myIndividual = theValue;
            return this;
        }
    }

    @Block
    public static class StatusHistory
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="status", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private BoundCodeDt<EncounterStateEnum> myStatus;
        @Child(name="period", type={PeriodDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private PeriodDt myPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStatus, this.myPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStatus, this.myPeriod});
        }

        public BoundCodeDt<EncounterStateEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(EncounterStateEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public String getStatus() {
            return (String)this.getStatusElement().getValue();
        }

        public StatusHistory setStatus(BoundCodeDt<EncounterStateEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public StatusHistory setStatus(EncounterStateEnum theValue) {
            this.setStatus((BoundCodeDt<EncounterStateEnum>)new BoundCodeDt(EncounterStateEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public StatusHistory setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }
    }
}

