/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.DocumentReferenceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.DocumentRelationshipTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DocumentReference", profile="http://hl7.org/fhir/profiles/DocumentReference", id="documentreference")
public class DocumentReference
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="DocumentReference.masterIdentifier | DocumentReference.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="DocumentReference.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="type", path="DocumentReference.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="class", path="DocumentReference.class", description="", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="author", path="DocumentReference.author", description="", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    @SearchParamDefinition(name="custodian", path="DocumentReference.custodian", description="", type="reference")
    public static final String SP_CUSTODIAN = "custodian";
    public static final ReferenceClientParam CUSTODIAN = new ReferenceClientParam("custodian");
    @SearchParamDefinition(name="authenticator", path="DocumentReference.authenticator", description="", type="reference")
    public static final String SP_AUTHENTICATOR = "authenticator";
    public static final ReferenceClientParam AUTHENTICATOR = new ReferenceClientParam("authenticator");
    @SearchParamDefinition(name="created", path="DocumentReference.created", description="", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="indexed", path="DocumentReference.indexed", description="", type="date")
    public static final String SP_INDEXED = "indexed";
    public static final DateClientParam INDEXED = new DateClientParam("indexed");
    @SearchParamDefinition(name="status", path="DocumentReference.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="relatesto", path="DocumentReference.relatesTo.target", description="", type="reference")
    public static final String SP_RELATESTO = "relatesto";
    public static final ReferenceClientParam RELATESTO = new ReferenceClientParam("relatesto");
    @SearchParamDefinition(name="relation", path="DocumentReference.relatesTo.code", description="", type="token")
    public static final String SP_RELATION = "relation";
    public static final TokenClientParam RELATION = new TokenClientParam("relation");
    @SearchParamDefinition(name="description", path="DocumentReference.description", description="", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="securitylabel", path="DocumentReference.securityLabel", description="", type="token")
    public static final String SP_SECURITYLABEL = "securitylabel";
    public static final TokenClientParam SECURITYLABEL = new TokenClientParam("securitylabel");
    @SearchParamDefinition(name="format", path="DocumentReference.content.format", description="", type="token")
    public static final String SP_FORMAT = "format";
    public static final TokenClientParam FORMAT = new TokenClientParam("format");
    @SearchParamDefinition(name="language", path="DocumentReference.content.attachment.language", description="", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="location", path="DocumentReference.content.attachment.url", description="", type="uri")
    public static final String SP_LOCATION = "location";
    public static final UriClientParam LOCATION = new UriClientParam("location");
    @SearchParamDefinition(name="event", path="DocumentReference.context.event", description="", type="token")
    public static final String SP_EVENT = "event";
    public static final TokenClientParam EVENT = new TokenClientParam("event");
    @SearchParamDefinition(name="period", path="DocumentReference.context.period", description="", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="facility", path="DocumentReference.context.facilityType", description="", type="token")
    public static final String SP_FACILITY = "facility";
    public static final TokenClientParam FACILITY = new TokenClientParam("facility");
    @SearchParamDefinition(name="patient", path="DocumentReference.subject", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="setting", path="DocumentReference.context.practiceSetting", description="", type="token")
    public static final String SP_SETTING = "setting";
    public static final TokenClientParam SETTING = new TokenClientParam("setting");
    @SearchParamDefinition(name="related-id", path="DocumentReference.context.related.identifier", description="", type="token")
    public static final String SP_RELATED_ID = "related-id";
    public static final TokenClientParam RELATED_ID = new TokenClientParam("related-id");
    @SearchParamDefinition(name="related-ref", path="DocumentReference.context.related.ref", description="", type="reference")
    public static final String SP_RELATED_REF = "related-ref";
    public static final ReferenceClientParam RELATED_REF = new ReferenceClientParam("related-ref");
    @SearchParamDefinition(name="encounter", path="DocumentReference.context.encounter", description="", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="relatesto-relation", path="relatesto & relation", description="Combination of relation and relatesTo", type="composite", compositeOf={"relatesto", "relation"})
    public static final String SP_RELATESTO_RELATION = "relatesto-relation";
    public static final CompositeClientParam<ReferenceClientParam, TokenClientParam> RELATESTO_RELATION = new CompositeClientParam("relatesto-relation");
    public static final Include INCLUDE_AUTHENTICATOR = new Include("DocumentReference:authenticator");
    public static final Include INCLUDE_AUTHOR = new Include("DocumentReference:author");
    public static final Include INCLUDE_CUSTODIAN = new Include("DocumentReference:custodian");
    public static final Include INCLUDE_ENCOUNTER = new Include("DocumentReference:encounter");
    public static final Include INCLUDE_PATIENT = new Include("DocumentReference:patient");
    public static final Include INCLUDE_RELATED_REF = new Include("DocumentReference:related-ref");
    public static final Include INCLUDE_RELATESTO = new Include("DocumentReference:relatesto");
    public static final Include INCLUDE_SUBJECT = new Include("DocumentReference:subject");
    @Child(name="masterIdentifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Document identifier as assigned by the source of the document. This identifier is specific to this version of the document. This unique identifier may be used elsewhere to identify this version of the document")
    private IdentifierDt myMasterIdentifier;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Other identifiers associated with the document, including version independent identifiers")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class, Practitioner.class, Group.class, Device.class})
    @Description(shortDefinition="who.focus", formalDefinition="Who or what the document is about. The document can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure)")
    private ResourceReferenceDt mySubject;
    @Child(name="type", type={CodeableConceptDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Specifies the particular kind of document referenced  (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the document referenced.")
    private CodeableConceptDt myType;
    @Child(name="class", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="A categorization for the type of document referenced - helps for indexing and searching. This may be implied by or derived from the code specified in the DocumentReference.type")
    private CodeableConceptDt myClassElement;
    @Child(name="author", order=5, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class, Organization.class, Device.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="who.author", formalDefinition="Identifies who is responsible for adding the information to the document")
    private List<ResourceReferenceDt> myAuthor;
    @Child(name="custodian", order=6, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the document")
    private ResourceReferenceDt myCustodian;
    @Child(name="authenticator", order=7, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="who.witness", formalDefinition="Which person or organization authenticates that this document is valid")
    private ResourceReferenceDt myAuthenticator;
    @Child(name="created", type={DateTimeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.done", formalDefinition="When the document was created")
    private DateTimeDt myCreated;
    @Child(name="indexed", type={InstantDt.class}, order=9, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="When the document reference was created")
    private InstantDt myIndexed;
    @Child(name="status", type={CodeDt.class}, order=10, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The status of this document reference")
    private BoundCodeDt<DocumentReferenceStatusEnum> myStatus;
    @Child(name="docStatus", type={CodeableConceptDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="status", formalDefinition="The status of the underlying document")
    private CodeableConceptDt myDocStatus;
    @Child(name="relatesTo", order=12, min=0, max=-1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="Relationships that this document has with other document references that already exist")
    private List<RelatesTo> myRelatesTo;
    @Child(name="description", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Human-readable description of the source document. This is sometimes known as the \"title\"")
    private StringDt myDescription;
    @Child(name="securityLabel", type={CodeableConceptDt.class}, order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A set of Security-Tag codes specifying the level of privacy/security of the Document. Note that DocumentReference.meta.security contains the security labels of the \"reference\" to the document, while DocumentReference.securityLabel contains a snapshot of the security labels on the document the reference refers to")
    private List<CodeableConceptDt> mySecurityLabel;
    @Child(name="content", order=15, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The document and format referenced. There may be multiple content element repetitions, each with a different format.")
    private List<Content> myContent;
    @Child(name="context", order=16, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The clinical context in which the document was prepared")
    private Context myContext;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMasterIdentifier, this.myIdentifier, this.mySubject, this.myType, this.myClassElement, this.myAuthor, this.myCustodian, this.myAuthenticator, this.myCreated, this.myIndexed, this.myStatus, this.myDocStatus, this.myRelatesTo, this.myDescription, this.mySecurityLabel, this.myContent, this.myContext});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMasterIdentifier, this.myIdentifier, this.mySubject, this.myType, this.myClassElement, this.myAuthor, this.myCustodian, this.myAuthenticator, this.myCreated, this.myIndexed, this.myStatus, this.myDocStatus, this.myRelatesTo, this.myDescription, this.mySecurityLabel, this.myContent, this.myContext});
    }

    public IdentifierDt getMasterIdentifier() {
        if (this.myMasterIdentifier == null) {
            this.myMasterIdentifier = new IdentifierDt();
        }
        return this.myMasterIdentifier;
    }

    public DocumentReference setMasterIdentifier(IdentifierDt theValue) {
        this.myMasterIdentifier = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DocumentReference setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public DocumentReference addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DocumentReference setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public DocumentReference setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public CodeableConceptDt getClassElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new CodeableConceptDt();
        }
        return this.myClassElement;
    }

    public DocumentReference setClassElement(CodeableConceptDt theValue) {
        this.myClassElement = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public DocumentReference setAuthor(List<ResourceReferenceDt> theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthor() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthor().add(newType);
        return newType;
    }

    public ResourceReferenceDt getCustodian() {
        if (this.myCustodian == null) {
            this.myCustodian = new ResourceReferenceDt();
        }
        return this.myCustodian;
    }

    public DocumentReference setCustodian(ResourceReferenceDt theValue) {
        this.myCustodian = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthenticator() {
        if (this.myAuthenticator == null) {
            this.myAuthenticator = new ResourceReferenceDt();
        }
        return this.myAuthenticator;
    }

    public DocumentReference setAuthenticator(ResourceReferenceDt theValue) {
        this.myAuthenticator = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public DocumentReference setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public DocumentReference setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DocumentReference setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public InstantDt getIndexedElement() {
        if (this.myIndexed == null) {
            this.myIndexed = new InstantDt();
        }
        return this.myIndexed;
    }

    public Date getIndexed() {
        return (Date)this.getIndexedElement().getValue();
    }

    public DocumentReference setIndexed(InstantDt theValue) {
        this.myIndexed = theValue;
        return this;
    }

    public DocumentReference setIndexedWithMillisPrecision(Date theDate) {
        this.myIndexed = new InstantDt(theDate);
        return this;
    }

    public DocumentReference setIndexed(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myIndexed = new InstantDt(theDate, thePrecision);
        return this;
    }

    public BoundCodeDt<DocumentReferenceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DocumentReferenceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public DocumentReference setStatus(BoundCodeDt<DocumentReferenceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DocumentReference setStatus(DocumentReferenceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<DocumentReferenceStatusEnum>)new BoundCodeDt(DocumentReferenceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeableConceptDt getDocStatus() {
        if (this.myDocStatus == null) {
            this.myDocStatus = new CodeableConceptDt();
        }
        return this.myDocStatus;
    }

    public DocumentReference setDocStatus(CodeableConceptDt theValue) {
        this.myDocStatus = theValue;
        return this;
    }

    public List<RelatesTo> getRelatesTo() {
        if (this.myRelatesTo == null) {
            this.myRelatesTo = new ArrayList<RelatesTo>();
        }
        return this.myRelatesTo;
    }

    public DocumentReference setRelatesTo(List<RelatesTo> theValue) {
        this.myRelatesTo = theValue;
        return this;
    }

    public RelatesTo addRelatesTo() {
        RelatesTo newType = new RelatesTo();
        this.getRelatesTo().add(newType);
        return newType;
    }

    public DocumentReference addRelatesTo(RelatesTo theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getRelatesTo().add(theValue);
        return this;
    }

    public RelatesTo getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            return this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public DocumentReference setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public DocumentReference setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getSecurityLabel() {
        if (this.mySecurityLabel == null) {
            this.mySecurityLabel = new ArrayList<CodeableConceptDt>();
        }
        return this.mySecurityLabel;
    }

    public DocumentReference setSecurityLabel(List<CodeableConceptDt> theValue) {
        this.mySecurityLabel = theValue;
        return this;
    }

    public CodeableConceptDt addSecurityLabel() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getSecurityLabel().add(newType);
        return newType;
    }

    public DocumentReference addSecurityLabel(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getSecurityLabel().add(theValue);
        return this;
    }

    public CodeableConceptDt getSecurityLabelFirstRep() {
        if (this.getSecurityLabel().isEmpty()) {
            return this.addSecurityLabel();
        }
        return this.getSecurityLabel().get(0);
    }

    public List<Content> getContent() {
        if (this.myContent == null) {
            this.myContent = new ArrayList<Content>();
        }
        return this.myContent;
    }

    public DocumentReference setContent(List<Content> theValue) {
        this.myContent = theValue;
        return this;
    }

    public Content addContent() {
        Content newType = new Content();
        this.getContent().add(newType);
        return newType;
    }

    public DocumentReference addContent(Content theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContent().add(theValue);
        return this;
    }

    public Content getContentFirstRep() {
        if (this.getContent().isEmpty()) {
            return this.addContent();
        }
        return this.getContent().get(0);
    }

    public Context getContext() {
        if (this.myContext == null) {
            this.myContext = new Context();
        }
        return this.myContext;
    }

    public DocumentReference setContext(Context theValue) {
        this.myContext = theValue;
        return this;
    }

    public String getResourceName() {
        return "DocumentReference";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class ContextRelated
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Related identifier to this DocumentReference. If both id and ref are present they shall refer to the same thing.")
        private IdentifierDt myIdentifier;
        @Child(name="ref", order=1, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="Related Resource to this DocumentReference. If both id and ref are present they shall refer to the same thing.")
        private ResourceReferenceDt myRef;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myRef});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRef});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public ContextRelated setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public ResourceReferenceDt getRef() {
            if (this.myRef == null) {
                this.myRef = new ResourceReferenceDt();
            }
            return this.myRef;
        }

        public ContextRelated setRef(ResourceReferenceDt theValue) {
            this.myRef = theValue;
            return this;
        }
    }

    @Block
    public static class Context
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="encounter", order=0, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
        @Description(shortDefinition="context", formalDefinition="Describes the clinical encounter or type of care that the document content is associated with")
        private ResourceReferenceDt myEncounter;
        @Child(name="event", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act")
        private List<CodeableConceptDt> myEvent;
        @Child(name="period", type={PeriodDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The time period over which the service that is described by the document was provided")
        private PeriodDt myPeriod;
        @Child(name="facilityType", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The kind of facility where the patient was seen")
        private CodeableConceptDt myFacilityType;
        @Child(name="practiceSetting", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="This property may convey specifics about the practice setting where the content was created, often reflecting the clinical specialty")
        private CodeableConceptDt myPracticeSetting;
        @Child(name="sourcePatientInfo", order=5, min=0, max=1, summary=false, modifier=false, type={Patient.class})
        @Description(shortDefinition="", formalDefinition="The Patient Information as known when the document was published. May be a reference to a version specific, or contained")
        private ResourceReferenceDt mySourcePatientInfo;
        @Child(name="related", order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Related identifiers or resources associated with the DocumentReference.")
        private List<ContextRelated> myRelated;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEncounter, this.myEvent, this.myPeriod, this.myFacilityType, this.myPracticeSetting, this.mySourcePatientInfo, this.myRelated});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEncounter, this.myEvent, this.myPeriod, this.myFacilityType, this.myPracticeSetting, this.mySourcePatientInfo, this.myRelated});
        }

        public ResourceReferenceDt getEncounter() {
            if (this.myEncounter == null) {
                this.myEncounter = new ResourceReferenceDt();
            }
            return this.myEncounter;
        }

        public Context setEncounter(ResourceReferenceDt theValue) {
            this.myEncounter = theValue;
            return this;
        }

        public List<CodeableConceptDt> getEvent() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<CodeableConceptDt>();
            }
            return this.myEvent;
        }

        public Context setEvent(List<CodeableConceptDt> theValue) {
            this.myEvent = theValue;
            return this;
        }

        public CodeableConceptDt addEvent() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getEvent().add(newType);
            return newType;
        }

        public Context addEvent(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getEvent().add(theValue);
            return this;
        }

        public CodeableConceptDt getEventFirstRep() {
            if (this.getEvent().isEmpty()) {
                return this.addEvent();
            }
            return this.getEvent().get(0);
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Context setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public CodeableConceptDt getFacilityType() {
            if (this.myFacilityType == null) {
                this.myFacilityType = new CodeableConceptDt();
            }
            return this.myFacilityType;
        }

        public Context setFacilityType(CodeableConceptDt theValue) {
            this.myFacilityType = theValue;
            return this;
        }

        public CodeableConceptDt getPracticeSetting() {
            if (this.myPracticeSetting == null) {
                this.myPracticeSetting = new CodeableConceptDt();
            }
            return this.myPracticeSetting;
        }

        public Context setPracticeSetting(CodeableConceptDt theValue) {
            this.myPracticeSetting = theValue;
            return this;
        }

        public ResourceReferenceDt getSourcePatientInfo() {
            if (this.mySourcePatientInfo == null) {
                this.mySourcePatientInfo = new ResourceReferenceDt();
            }
            return this.mySourcePatientInfo;
        }

        public Context setSourcePatientInfo(ResourceReferenceDt theValue) {
            this.mySourcePatientInfo = theValue;
            return this;
        }

        public List<ContextRelated> getRelated() {
            if (this.myRelated == null) {
                this.myRelated = new ArrayList<ContextRelated>();
            }
            return this.myRelated;
        }

        public Context setRelated(List<ContextRelated> theValue) {
            this.myRelated = theValue;
            return this;
        }

        public ContextRelated addRelated() {
            ContextRelated newType = new ContextRelated();
            this.getRelated().add(newType);
            return newType;
        }

        public Context addRelated(ContextRelated theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getRelated().add(theValue);
            return this;
        }

        public ContextRelated getRelatedFirstRep() {
            if (this.getRelated().isEmpty()) {
                return this.addRelated();
            }
            return this.getRelated().get(0);
        }
    }

    @Block
    public static class Content
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="attachment", type={AttachmentDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The document or url of the document along with critical metadata to prove content has integrity.")
        private AttachmentDt myAttachment;
        @Child(name="format", type={CodingDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An identifier of the document encoding, structure, and template that the document conforms to beyond the base format indicated in the mimeType")
        private List<CodingDt> myFormat;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myAttachment, this.myFormat});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAttachment, this.myFormat});
        }

        public AttachmentDt getAttachment() {
            if (this.myAttachment == null) {
                this.myAttachment = new AttachmentDt();
            }
            return this.myAttachment;
        }

        public Content setAttachment(AttachmentDt theValue) {
            this.myAttachment = theValue;
            return this;
        }

        public List<CodingDt> getFormat() {
            if (this.myFormat == null) {
                this.myFormat = new ArrayList<CodingDt>();
            }
            return this.myFormat;
        }

        public Content setFormat(List<CodingDt> theValue) {
            this.myFormat = theValue;
            return this;
        }

        public CodingDt addFormat() {
            CodingDt newType = new CodingDt();
            this.getFormat().add(newType);
            return newType;
        }

        public Content addFormat(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getFormat().add(theValue);
            return this;
        }

        public CodingDt getFormatFirstRep() {
            if (this.getFormat().isEmpty()) {
                return this.addFormat();
            }
            return this.getFormat().get(0);
        }
    }

    @Block
    public static class RelatesTo
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of relationship that this document has with anther document")
        private BoundCodeDt<DocumentRelationshipTypeEnum> myCode;
        @Child(name="target", order=1, min=1, max=1, summary=false, modifier=false, type={DocumentReference.class})
        @Description(shortDefinition="", formalDefinition="The target document of this relationship")
        private ResourceReferenceDt myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myTarget});
        }

        public BoundCodeDt<DocumentRelationshipTypeEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(DocumentRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public RelatesTo setCode(BoundCodeDt<DocumentRelationshipTypeEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public RelatesTo setCode(DocumentRelationshipTypeEnum theValue) {
            this.setCode((BoundCodeDt<DocumentRelationshipTypeEnum>)new BoundCodeDt(DocumentRelationshipTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public RelatesTo setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }
    }
}

