/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.DeviceComponent;
import ca.uhn.fhir.model.dstu2.valueset.DeviceMetricCalibrationStateEnum;
import ca.uhn.fhir.model.dstu2.valueset.DeviceMetricCalibrationTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.DeviceMetricCategoryEnum;
import ca.uhn.fhir.model.dstu2.valueset.DeviceMetricColorEnum;
import ca.uhn.fhir.model.dstu2.valueset.DeviceMetricOperationalStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DeviceMetric", profile="http://hl7.org/fhir/profiles/DeviceMetric", id="devicemetric")
public class DeviceMetric
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="parent", path="DeviceMetric.parent", description="The parent DeviceMetric resource", type="reference")
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    @SearchParamDefinition(name="type", path="DeviceMetric.type", description="The component type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="source", path="DeviceMetric.source", description="The device resource", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    @SearchParamDefinition(name="category", path="DeviceMetric.category", description="The category of the metric", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="identifier", path="DeviceMetric.identifier", description="The identifier of the metric", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_PARENT = new Include("DeviceMetric:parent");
    public static final Include INCLUDE_SOURCE = new Include("DeviceMetric:source");
    @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Type of metric", formalDefinition="Describes the type of the metric. For example: Heart Rate, PEEP Setting, etc.")
    private CodeableConceptDt myType;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Unique identifier of this DeviceMetric", formalDefinition="Describes the unique identification of this metric that has been assigned by the device or gateway software. For example: handle ID.  It should be noted that in order to make the identifier unique, the system element of the identifier should be set to the unique identifier of the device.")
    private IdentifierDt myIdentifier;
    @Child(name="unit", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Unit of metric", formalDefinition="Describes the unit that an observed value determined for this metric will have. For example: Percent, Seconds, etc.")
    private CodeableConceptDt myUnit;
    @Child(name="source", order=3, min=0, max=1, summary=false, modifier=false, type={Device.class})
    @Description(shortDefinition="Describes the link to the source Device", formalDefinition="Describes the link to the  Device that this DeviceMetric belongs to and that contains administrative device information such as manufacture, serial number, etc.")
    private ResourceReferenceDt mySource;
    @Child(name="parent", order=4, min=0, max=1, summary=false, modifier=false, type={DeviceComponent.class})
    @Description(shortDefinition="Describes the link to the parent DeviceComponent", formalDefinition="Describes the link to the  DeviceComponent that this DeviceMetric belongs to and that provide information about the location of this DeviceMetric in the containment structure of the parent Device. An example would be a DeviceComponent that represents a Channel. This reference can be used by a client application to distinguish DeviceMetrics that have the same type, but should be interpreted based on their containment location.")
    private ResourceReferenceDt myParent;
    @Child(name="operationalStatus", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="on | off | standby", formalDefinition="Indicates current operational state of the device. For example: On, Off, Standby, etc.")
    private BoundCodeDt<DeviceMetricOperationalStatusEnum> myOperationalStatus;
    @Child(name="color", type={CodeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="black | red | green | yellow | blue | magenta | cyan | white", formalDefinition="Describes the color representation for the metric. This is often used to aid clinicians to track and identify parameter types by color. In practice, consider a Patient Monitor that has ECG/HR and Pleth for example; the parameters are displayed in different characteristic colors, such as HR-blue, BP-green, and PR and SpO2- magenta.")
    private BoundCodeDt<DeviceMetricColorEnum> myColor;
    @Child(name="category", type={CodeDt.class}, order=7, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="measurement | setting | calculation | unspecified", formalDefinition="Indicates the category of the observation generation process. A DeviceMetric can be for example a setting, measurement, or calculation.")
    private BoundCodeDt<DeviceMetricCategoryEnum> myCategory;
    @Child(name="measurementPeriod", type={TimingDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Describes the measurement repetition time", formalDefinition="Describes the measurement repetition time. This is not necessarily the same as the update period. The measurement repetition time can range from milliseconds up to hours. An example for a measurement repetition time in the range of milliseconds is the sampling rate of an ECG. An example for a measurement repetition time in the range of hours is a NIBP that is triggered automatically every hour. The update period may be different than the measurement repetition time, if the device does not update the published observed value with the same frequency as it was measured.")
    private TimingDt myMeasurementPeriod;
    @Child(name="calibration", order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Describes the calibrations that have been performed or that are required to be performed", formalDefinition="Describes the calibrations that have been performed or that are required to be performed")
    private List<Calibration> myCalibration;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myIdentifier, this.myUnit, this.mySource, this.myParent, this.myOperationalStatus, this.myColor, this.myCategory, this.myMeasurementPeriod, this.myCalibration});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myIdentifier, this.myUnit, this.mySource, this.myParent, this.myOperationalStatus, this.myColor, this.myCategory, this.myMeasurementPeriod, this.myCalibration});
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public DeviceMetric setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public DeviceMetric setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public CodeableConceptDt getUnit() {
        if (this.myUnit == null) {
            this.myUnit = new CodeableConceptDt();
        }
        return this.myUnit;
    }

    public DeviceMetric setUnit(CodeableConceptDt theValue) {
        this.myUnit = theValue;
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public DeviceMetric setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public ResourceReferenceDt getParent() {
        if (this.myParent == null) {
            this.myParent = new ResourceReferenceDt();
        }
        return this.myParent;
    }

    public DeviceMetric setParent(ResourceReferenceDt theValue) {
        this.myParent = theValue;
        return this;
    }

    public BoundCodeDt<DeviceMetricOperationalStatusEnum> getOperationalStatusElement() {
        if (this.myOperationalStatus == null) {
            this.myOperationalStatus = new BoundCodeDt(DeviceMetricOperationalStatusEnum.VALUESET_BINDER);
        }
        return this.myOperationalStatus;
    }

    public String getOperationalStatus() {
        return (String)this.getOperationalStatusElement().getValue();
    }

    public DeviceMetric setOperationalStatus(BoundCodeDt<DeviceMetricOperationalStatusEnum> theValue) {
        this.myOperationalStatus = theValue;
        return this;
    }

    public DeviceMetric setOperationalStatus(DeviceMetricOperationalStatusEnum theValue) {
        this.setOperationalStatus((BoundCodeDt<DeviceMetricOperationalStatusEnum>)new BoundCodeDt(DeviceMetricOperationalStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BoundCodeDt<DeviceMetricColorEnum> getColorElement() {
        if (this.myColor == null) {
            this.myColor = new BoundCodeDt(DeviceMetricColorEnum.VALUESET_BINDER);
        }
        return this.myColor;
    }

    public String getColor() {
        return (String)this.getColorElement().getValue();
    }

    public DeviceMetric setColor(BoundCodeDt<DeviceMetricColorEnum> theValue) {
        this.myColor = theValue;
        return this;
    }

    public DeviceMetric setColor(DeviceMetricColorEnum theValue) {
        this.setColor((BoundCodeDt<DeviceMetricColorEnum>)new BoundCodeDt(DeviceMetricColorEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BoundCodeDt<DeviceMetricCategoryEnum> getCategoryElement() {
        if (this.myCategory == null) {
            this.myCategory = new BoundCodeDt(DeviceMetricCategoryEnum.VALUESET_BINDER);
        }
        return this.myCategory;
    }

    public String getCategory() {
        return (String)this.getCategoryElement().getValue();
    }

    public DeviceMetric setCategory(BoundCodeDt<DeviceMetricCategoryEnum> theValue) {
        this.myCategory = theValue;
        return this;
    }

    public DeviceMetric setCategory(DeviceMetricCategoryEnum theValue) {
        this.setCategory((BoundCodeDt<DeviceMetricCategoryEnum>)new BoundCodeDt(DeviceMetricCategoryEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public TimingDt getMeasurementPeriod() {
        if (this.myMeasurementPeriod == null) {
            this.myMeasurementPeriod = new TimingDt();
        }
        return this.myMeasurementPeriod;
    }

    public DeviceMetric setMeasurementPeriod(TimingDt theValue) {
        this.myMeasurementPeriod = theValue;
        return this;
    }

    public List<Calibration> getCalibration() {
        if (this.myCalibration == null) {
            this.myCalibration = new ArrayList<Calibration>();
        }
        return this.myCalibration;
    }

    public DeviceMetric setCalibration(List<Calibration> theValue) {
        this.myCalibration = theValue;
        return this;
    }

    public Calibration addCalibration() {
        Calibration newType = new Calibration();
        this.getCalibration().add(newType);
        return newType;
    }

    public DeviceMetric addCalibration(Calibration theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getCalibration().add(theValue);
        return this;
    }

    public Calibration getCalibrationFirstRep() {
        if (this.getCalibration().isEmpty()) {
            return this.addCalibration();
        }
        return this.getCalibration().get(0);
    }

    public String getResourceName() {
        return "DeviceMetric";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Calibration
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="unspecified | offset | gain | two-point", formalDefinition="Describes the type of the calibration method.")
        private BoundCodeDt<DeviceMetricCalibrationTypeEnum> myType;
        @Child(name="state", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="not-calibrated | calibration-required | calibrated | unspecified", formalDefinition="Describes the state of the calibration.")
        private BoundCodeDt<DeviceMetricCalibrationStateEnum> myState;
        @Child(name="time", type={InstantDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Describes the time last calibration has been performed", formalDefinition="Describes the time last calibration has been performed.")
        private InstantDt myTime;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myState, this.myTime});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myState, this.myTime});
        }

        public BoundCodeDt<DeviceMetricCalibrationTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(DeviceMetricCalibrationTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public Calibration setType(BoundCodeDt<DeviceMetricCalibrationTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Calibration setType(DeviceMetricCalibrationTypeEnum theValue) {
            this.setType((BoundCodeDt<DeviceMetricCalibrationTypeEnum>)new BoundCodeDt(DeviceMetricCalibrationTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public BoundCodeDt<DeviceMetricCalibrationStateEnum> getStateElement() {
            if (this.myState == null) {
                this.myState = new BoundCodeDt(DeviceMetricCalibrationStateEnum.VALUESET_BINDER);
            }
            return this.myState;
        }

        public String getState() {
            return (String)this.getStateElement().getValue();
        }

        public Calibration setState(BoundCodeDt<DeviceMetricCalibrationStateEnum> theValue) {
            this.myState = theValue;
            return this;
        }

        public Calibration setState(DeviceMetricCalibrationStateEnum theValue) {
            this.setState((BoundCodeDt<DeviceMetricCalibrationStateEnum>)new BoundCodeDt(DeviceMetricCalibrationStateEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public InstantDt getTimeElement() {
            if (this.myTime == null) {
                this.myTime = new InstantDt();
            }
            return this.myTime;
        }

        public Date getTime() {
            return (Date)this.getTimeElement().getValue();
        }

        public Calibration setTime(InstantDt theValue) {
            this.myTime = theValue;
            return this;
        }

        public Calibration setTimeWithMillisPrecision(Date theDate) {
            this.myTime = new InstantDt(theDate);
            return this;
        }

        public Calibration setTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myTime = new InstantDt(theDate, thePrecision);
            return this;
        }
    }
}

