/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.valueset.MeasmntPrincipleEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DeviceComponent", profile="http://hl7.org/fhir/profiles/DeviceComponent", id="devicecomponent")
public class DeviceComponent
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="parent", path="DeviceComponent.parent", description="The parent DeviceComponent resource", type="reference")
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    @SearchParamDefinition(name="type", path="DeviceComponent.type", description="The device component type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="source", path="DeviceComponent.source", description="The device source", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_PARENT = new Include("DeviceComponent:parent");
    public static final Include INCLUDE_SOURCE = new Include("DeviceComponent:source");
    @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the specific component type as defined in the object-oriented or metric nomenclature partition.")
    private CodeableConceptDt myType;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the local assigned unique identification by the software. For example: handle ID.")
    private IdentifierDt myIdentifier;
    @Child(name="lastSystemChange", type={InstantDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the timestamp for the most recent system change which includes device configuration or setting change.")
    private InstantDt myLastSystemChange;
    @Child(name="source", order=3, min=0, max=1, summary=false, modifier=false, type={Device.class})
    @Description(shortDefinition="", formalDefinition="Describes the link to the source Device that contains administrative device information such as manufacture, serial number, etc.")
    private ResourceReferenceDt mySource;
    @Child(name="parent", order=4, min=0, max=1, summary=false, modifier=false, type={DeviceComponent.class})
    @Description(shortDefinition="", formalDefinition="Describes the link to the parent resource. For example: Channel is linked to its VMD parent.")
    private ResourceReferenceDt myParent;
    @Child(name="operationalStatus", type={CodeableConceptDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates current operational status of the device. For example: On, Off, Standby, etc.")
    private List<CodeableConceptDt> myOperationalStatus;
    @Child(name="parameterGroup", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the parameter group supported by the current device component that is based on some nomenclature, e.g. cardiovascular.")
    private CodeableConceptDt myParameterGroup;
    @Child(name="measurementPrinciple", type={CodeDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the physical principle of the measurement. For example: thermal, chemical, acoustical, etc.")
    private BoundCodeDt<MeasmntPrincipleEnum> myMeasurementPrinciple;
    @Child(name="productionSpecification", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the production specification such as component revision, serial number, etc.")
    private List<ProductionSpecification> myProductionSpecification;
    @Child(name="languageCode", type={CodeableConceptDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Describes the language code for the human-readable text string produced by the device. This language code will follow the IETF language tag. Example: en-US.")
    private CodeableConceptDt myLanguageCode;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myIdentifier, this.myLastSystemChange, this.mySource, this.myParent, this.myOperationalStatus, this.myParameterGroup, this.myMeasurementPrinciple, this.myProductionSpecification, this.myLanguageCode});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myIdentifier, this.myLastSystemChange, this.mySource, this.myParent, this.myOperationalStatus, this.myParameterGroup, this.myMeasurementPrinciple, this.myProductionSpecification, this.myLanguageCode});
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public DeviceComponent setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public DeviceComponent setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public InstantDt getLastSystemChangeElement() {
        if (this.myLastSystemChange == null) {
            this.myLastSystemChange = new InstantDt();
        }
        return this.myLastSystemChange;
    }

    public Date getLastSystemChange() {
        return (Date)this.getLastSystemChangeElement().getValue();
    }

    public DeviceComponent setLastSystemChange(InstantDt theValue) {
        this.myLastSystemChange = theValue;
        return this;
    }

    public DeviceComponent setLastSystemChangeWithMillisPrecision(Date theDate) {
        this.myLastSystemChange = new InstantDt(theDate);
        return this;
    }

    public DeviceComponent setLastSystemChange(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myLastSystemChange = new InstantDt(theDate, thePrecision);
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public DeviceComponent setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public ResourceReferenceDt getParent() {
        if (this.myParent == null) {
            this.myParent = new ResourceReferenceDt();
        }
        return this.myParent;
    }

    public DeviceComponent setParent(ResourceReferenceDt theValue) {
        this.myParent = theValue;
        return this;
    }

    public List<CodeableConceptDt> getOperationalStatus() {
        if (this.myOperationalStatus == null) {
            this.myOperationalStatus = new ArrayList<CodeableConceptDt>();
        }
        return this.myOperationalStatus;
    }

    public DeviceComponent setOperationalStatus(List<CodeableConceptDt> theValue) {
        this.myOperationalStatus = theValue;
        return this;
    }

    public CodeableConceptDt addOperationalStatus() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getOperationalStatus().add(newType);
        return newType;
    }

    public DeviceComponent addOperationalStatus(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getOperationalStatus().add(theValue);
        return this;
    }

    public CodeableConceptDt getOperationalStatusFirstRep() {
        if (this.getOperationalStatus().isEmpty()) {
            return this.addOperationalStatus();
        }
        return this.getOperationalStatus().get(0);
    }

    public CodeableConceptDt getParameterGroup() {
        if (this.myParameterGroup == null) {
            this.myParameterGroup = new CodeableConceptDt();
        }
        return this.myParameterGroup;
    }

    public DeviceComponent setParameterGroup(CodeableConceptDt theValue) {
        this.myParameterGroup = theValue;
        return this;
    }

    public BoundCodeDt<MeasmntPrincipleEnum> getMeasurementPrincipleElement() {
        if (this.myMeasurementPrinciple == null) {
            this.myMeasurementPrinciple = new BoundCodeDt(MeasmntPrincipleEnum.VALUESET_BINDER);
        }
        return this.myMeasurementPrinciple;
    }

    public String getMeasurementPrinciple() {
        return (String)this.getMeasurementPrincipleElement().getValue();
    }

    public DeviceComponent setMeasurementPrinciple(BoundCodeDt<MeasmntPrincipleEnum> theValue) {
        this.myMeasurementPrinciple = theValue;
        return this;
    }

    public DeviceComponent setMeasurementPrinciple(MeasmntPrincipleEnum theValue) {
        this.setMeasurementPrinciple((BoundCodeDt<MeasmntPrincipleEnum>)new BoundCodeDt(MeasmntPrincipleEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<ProductionSpecification> getProductionSpecification() {
        if (this.myProductionSpecification == null) {
            this.myProductionSpecification = new ArrayList<ProductionSpecification>();
        }
        return this.myProductionSpecification;
    }

    public DeviceComponent setProductionSpecification(List<ProductionSpecification> theValue) {
        this.myProductionSpecification = theValue;
        return this;
    }

    public ProductionSpecification addProductionSpecification() {
        ProductionSpecification newType = new ProductionSpecification();
        this.getProductionSpecification().add(newType);
        return newType;
    }

    public DeviceComponent addProductionSpecification(ProductionSpecification theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getProductionSpecification().add(theValue);
        return this;
    }

    public ProductionSpecification getProductionSpecificationFirstRep() {
        if (this.getProductionSpecification().isEmpty()) {
            return this.addProductionSpecification();
        }
        return this.getProductionSpecification().get(0);
    }

    public CodeableConceptDt getLanguageCode() {
        if (this.myLanguageCode == null) {
            this.myLanguageCode = new CodeableConceptDt();
        }
        return this.myLanguageCode;
    }

    public DeviceComponent setLanguageCode(CodeableConceptDt theValue) {
        this.myLanguageCode = theValue;
        return this;
    }

    public String getResourceName() {
        return "DeviceComponent";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class ProductionSpecification
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="specType", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Describes the specification type, such as, serial number, part number, hardware revision, software revision, etc.")
        private CodeableConceptDt mySpecType;
        @Child(name="componentId", type={IdentifierDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Describes the internal component unique identification. This is a provision for manufacture specific standard components using a private OID. 11073-10101 has a partition for private OID semantic that the manufacture can make use of.")
        private IdentifierDt myComponentId;
        @Child(name="productionSpec", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Describes the printable string defining the component.")
        private StringDt myProductionSpec;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySpecType, this.myComponentId, this.myProductionSpec});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySpecType, this.myComponentId, this.myProductionSpec});
        }

        public CodeableConceptDt getSpecType() {
            if (this.mySpecType == null) {
                this.mySpecType = new CodeableConceptDt();
            }
            return this.mySpecType;
        }

        public ProductionSpecification setSpecType(CodeableConceptDt theValue) {
            this.mySpecType = theValue;
            return this;
        }

        public IdentifierDt getComponentId() {
            if (this.myComponentId == null) {
                this.myComponentId = new IdentifierDt();
            }
            return this.myComponentId;
        }

        public ProductionSpecification setComponentId(IdentifierDt theValue) {
            this.myComponentId = theValue;
            return this;
        }

        public StringDt getProductionSpecElement() {
            if (this.myProductionSpec == null) {
                this.myProductionSpec = new StringDt();
            }
            return this.myProductionSpec;
        }

        public String getProductionSpec() {
            return (String)this.getProductionSpecElement().getValue();
        }

        public ProductionSpecification setProductionSpec(StringDt theValue) {
            this.myProductionSpec = theValue;
            return this;
        }

        public ProductionSpecification setProductionSpec(String theString) {
            this.myProductionSpec = new StringDt(theString);
            return this;
        }
    }
}

