/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.DetectedIssueSeverityEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DetectedIssue", profile="http://hl7.org/fhir/profiles/DetectedIssue", id="detectedissue")
public class DetectedIssue
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="category", path="DetectedIssue.category", description="", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="date", path="DetectedIssue.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="DetectedIssue.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="DetectedIssue.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="implicated", path="DetectedIssue.implicated", description="", type="reference")
    public static final String SP_IMPLICATED = "implicated";
    public static final ReferenceClientParam IMPLICATED = new ReferenceClientParam("implicated");
    @SearchParamDefinition(name="author", path="DetectedIssue.author", description="", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DetectedIssue:author");
    public static final Include INCLUDE_IMPLICATED = new Include("DetectedIssue:implicated");
    public static final Include INCLUDE_PATIENT = new Include("DetectedIssue:patient");
    @Child(name="patient", order=0, min=0, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="Indicates the patient whose record the detected issue is associated with.")
    private ResourceReferenceDt myPatient;
    @Child(name="category", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the general type of issue identified.")
    private CodeableConceptDt myCategory;
    @Child(name="severity", type={CodeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the degree of importance associated with the identified issue based on the potential impact on the patient")
    private BoundCodeDt<DetectedIssueSeverityEnum> mySeverity;
    @Child(name="implicated", order=3, min=0, max=-1, summary=true, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Indicates the resource representing the current activity or proposed activity that is potentially problematic")
    private List<ResourceReferenceDt> myImplicated;
    @Child(name="detail", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A textual explanation of the detected issue")
    private StringDt myDetail;
    @Child(name="date", type={DateTimeDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date or date-time when the detected issue was initially identified.")
    private DateTimeDt myDate;
    @Child(name="author", order=6, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Device.class})
    @Description(shortDefinition="", formalDefinition="Individual or device responsible for the issue being raised.  For example, a decision support application or a pharmacist conducting a medication review")
    private ResourceReferenceDt myAuthor;
    @Child(name="identifier", type={IdentifierDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Business identifier associated with the detected issue record")
    private IdentifierDt myIdentifier;
    @Child(name="reference", type={UriDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified")
    private UriDt myReference;
    @Child(name="mitigation", order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates an action that has been taken or is committed to to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting.  Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.")
    private List<Mitigation> myMitigation;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPatient, this.myCategory, this.mySeverity, this.myImplicated, this.myDetail, this.myDate, this.myAuthor, this.myIdentifier, this.myReference, this.myMitigation});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPatient, this.myCategory, this.mySeverity, this.myImplicated, this.myDetail, this.myDate, this.myAuthor, this.myIdentifier, this.myReference, this.myMitigation});
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public DetectedIssue setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public CodeableConceptDt getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public DetectedIssue setCategory(CodeableConceptDt theValue) {
        this.myCategory = theValue;
        return this;
    }

    public BoundCodeDt<DetectedIssueSeverityEnum> getSeverityElement() {
        if (this.mySeverity == null) {
            this.mySeverity = new BoundCodeDt(DetectedIssueSeverityEnum.VALUESET_BINDER);
        }
        return this.mySeverity;
    }

    public String getSeverity() {
        return (String)this.getSeverityElement().getValue();
    }

    public DetectedIssue setSeverity(BoundCodeDt<DetectedIssueSeverityEnum> theValue) {
        this.mySeverity = theValue;
        return this;
    }

    public DetectedIssue setSeverity(DetectedIssueSeverityEnum theValue) {
        this.setSeverity((BoundCodeDt<DetectedIssueSeverityEnum>)new BoundCodeDt(DetectedIssueSeverityEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<ResourceReferenceDt> getImplicated() {
        if (this.myImplicated == null) {
            this.myImplicated = new ArrayList<ResourceReferenceDt>();
        }
        return this.myImplicated;
    }

    public DetectedIssue setImplicated(List<ResourceReferenceDt> theValue) {
        this.myImplicated = theValue;
        return this;
    }

    public ResourceReferenceDt addImplicated() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getImplicated().add(newType);
        return newType;
    }

    public StringDt getDetailElement() {
        if (this.myDetail == null) {
            this.myDetail = new StringDt();
        }
        return this.myDetail;
    }

    public String getDetail() {
        return (String)this.getDetailElement().getValue();
    }

    public DetectedIssue setDetail(StringDt theValue) {
        this.myDetail = theValue;
        return this;
    }

    public DetectedIssue setDetail(String theString) {
        this.myDetail = new StringDt(theString);
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public DetectedIssue setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public DetectedIssue setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DetectedIssue setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public DetectedIssue setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public DetectedIssue setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public UriDt getReferenceElement() {
        if (this.myReference == null) {
            this.myReference = new UriDt();
        }
        return this.myReference;
    }

    public String getReference() {
        return (String)this.getReferenceElement().getValue();
    }

    public DetectedIssue setReference(UriDt theValue) {
        this.myReference = theValue;
        return this;
    }

    public DetectedIssue setReference(String theUri) {
        this.myReference = new UriDt(theUri);
        return this;
    }

    public List<Mitigation> getMitigation() {
        if (this.myMitigation == null) {
            this.myMitigation = new ArrayList<Mitigation>();
        }
        return this.myMitigation;
    }

    public DetectedIssue setMitigation(List<Mitigation> theValue) {
        this.myMitigation = theValue;
        return this;
    }

    public Mitigation addMitigation() {
        Mitigation newType = new Mitigation();
        this.getMitigation().add(newType);
        return newType;
    }

    public DetectedIssue addMitigation(Mitigation theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getMitigation().add(theValue);
        return this;
    }

    public Mitigation getMitigationFirstRep() {
        if (this.getMitigation().isEmpty()) {
            return this.addMitigation();
        }
        return this.getMitigation().get(0);
    }

    public String getResourceName() {
        return "DetectedIssue";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Mitigation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="action", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Describes the action that was taken or the observation that was made that reduces/eliminates the risk associated with the identified issue")
        private CodeableConceptDt myAction;
        @Child(name="date", type={DateTimeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates when the mitigating action was documented")
        private DateTimeDt myDate;
        @Child(name="author", order=2, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="", formalDefinition="Identifies the practitioner who determined the mitigation and takes responsibility for the mitigation step occurring")
        private ResourceReferenceDt myAuthor;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myAction, this.myDate, this.myAuthor});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAction, this.myDate, this.myAuthor});
        }

        public CodeableConceptDt getAction() {
            if (this.myAction == null) {
                this.myAction = new CodeableConceptDt();
            }
            return this.myAction;
        }

        public Mitigation setAction(CodeableConceptDt theValue) {
            this.myAction = theValue;
            return this;
        }

        public DateTimeDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public Date getDate() {
            return (Date)this.getDateElement().getValue();
        }

        public Mitigation setDate(DateTimeDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Mitigation setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Mitigation setDateWithSecondsPrecision(Date theDate) {
            this.myDate = new DateTimeDt(theDate);
            return this;
        }

        public ResourceReferenceDt getAuthor() {
            if (this.myAuthor == null) {
                this.myAuthor = new ResourceReferenceDt();
            }
            return this.myAuthor;
        }

        public Mitigation setAuthor(ResourceReferenceDt theValue) {
            this.myAuthor = theValue;
            return this;
        }
    }
}

