/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="BodySite", profile="http://hl7.org/fhir/profiles/BodySite", id="bodysite")
public class BodySite
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="code", path="BodySite.code", description="Named anatomical location", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="patient", path="BodySite.patient", description="Patient to whom bodysite belongs", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="identifier", path="BodySite.identifier", description="Identifier for this instance of the anatomical location", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    public static final Include INCLUDE_PATIENT = new Include("BodySite:patient");
    @Child(name="patient", order=0, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="", formalDefinition="The person to which the body site belongs")
    private ResourceReferenceDt myPatient;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifier for this instance of the anatomical location.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="code", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Named anatomical location - ideally coded where possible.")
    private CodeableConceptDt myCode;
    @Child(name="modifier", type={CodeableConceptDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Modifier to refine the anatomical location.  These include modifiers for laterality, relative location, directionality, number, and plane.")
    private List<CodeableConceptDt> myModifier;
    @Child(name="description", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Description of anatomical location.")
    private StringDt myDescription;
    @Child(name="image", type={AttachmentDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Image or images used to identify a location.")
    private List<AttachmentDt> myImage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPatient, this.myIdentifier, this.myCode, this.myModifier, this.myDescription, this.myImage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPatient, this.myIdentifier, this.myCode, this.myModifier, this.myDescription, this.myImage});
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public BodySite setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public BodySite setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public BodySite addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public BodySite setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public List<CodeableConceptDt> getModifier() {
        if (this.myModifier == null) {
            this.myModifier = new ArrayList<CodeableConceptDt>();
        }
        return this.myModifier;
    }

    public BodySite setModifier(List<CodeableConceptDt> theValue) {
        this.myModifier = theValue;
        return this;
    }

    public CodeableConceptDt addModifier() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getModifier().add(newType);
        return newType;
    }

    public BodySite addModifier(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getModifier().add(theValue);
        return this;
    }

    public CodeableConceptDt getModifierFirstRep() {
        if (this.getModifier().isEmpty()) {
            return this.addModifier();
        }
        return this.getModifier().get(0);
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public BodySite setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public BodySite setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<AttachmentDt> getImage() {
        if (this.myImage == null) {
            this.myImage = new ArrayList<AttachmentDt>();
        }
        return this.myImage;
    }

    public BodySite setImage(List<AttachmentDt> theValue) {
        this.myImage = theValue;
        return this;
    }

    public AttachmentDt addImage() {
        AttachmentDt newType = new AttachmentDt();
        this.getImage().add(newType);
        return newType;
    }

    public BodySite addImage(AttachmentDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getImage().add(theValue);
        return this;
    }

    public AttachmentDt getImageFirstRep() {
        if (this.getImage().isEmpty()) {
            return this.addImage();
        }
        return this.getImage().get(0);
    }

    public String getResourceName() {
        return "BodySite";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

