/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.model.api.BaseElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.base.resource.ResourceMetadataMap;
import ca.uhn.fhir.model.dstu2.composite.ContainedDt;
import ca.uhn.fhir.model.dstu2.composite.NarrativeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IIdType;

public abstract class BaseResource
extends BaseElement
implements IResource {
    @SearchParamDefinition(name="_language", path="", description="The language of the resource", type="string")
    public static final String SP_RES_LANGUAGE = "_language";
    @SearchParamDefinition(name="_id", path="", description="The ID of the resource", type="string")
    public static final String SP_RES_ID = "_id";
    public static final StringClientParam RES_ID = new StringClientParam("_id");
    @Child(name="contained", order=2, min=0, max=1)
    private ContainedDt myContained;
    private IdDt myId;
    @Child(name="language", order=0, min=0, max=-1)
    private CodeDt myLanguage;
    private ResourceMetadataMap myResourceMetadata;
    @Child(name="text", order=1, min=0, max=1)
    private NarrativeDt myText;

    public ContainedDt getContained() {
        if (this.myContained == null) {
            this.myContained = new ContainedDt();
        }
        return this.myContained;
    }

    public IdDt getId() {
        if (this.myId == null) {
            this.myId = new IdDt();
        }
        return this.myId;
    }

    public IIdType getIdElement() {
        return this.getId();
    }

    public CodeDt getLanguage() {
        if (this.myLanguage == null) {
            this.myLanguage = new CodeDt();
        }
        return this.myLanguage;
    }

    public ResourceMetadataMap getResourceMetadata() {
        if (this.myResourceMetadata == null) {
            this.myResourceMetadata = new ResourceMetadataMap();
        }
        return this.myResourceMetadata;
    }

    public NarrativeDt getText() {
        if (this.myText == null) {
            this.myText = new NarrativeDt();
        }
        return this.myText;
    }

    public void setContained(ContainedDt theContained) {
        this.myContained = theContained;
    }

    public void setId(IdDt theId) {
        this.myId = theId;
    }

    public BaseResource setId(IIdType theId) {
        if (theId instanceof IdDt) {
            this.myId = (IdDt)theId;
        } else if (theId != null) {
            this.myId = new IdDt(theId.getValue());
        }
        return this;
    }

    public BaseResource setId(String theId) {
        this.myId = theId == null ? null : new IdDt(theId);
        return this;
    }

    public void setLanguage(CodeDt theLanguage) {
        this.myLanguage = theLanguage;
    }

    public void setResourceMetadata(ResourceMetadataMap theMap) {
        Validate.notNull((Object)theMap, (String)"The Map must not be null", (Object[])new Object[0]);
        this.myResourceMetadata = theMap;
    }

    public void setText(NarrativeDt theText) {
        this.myText = theText;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("id", (Object)this.getId().toUnqualified());
        return b.toString();
    }

    protected boolean isBaseEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLanguage, this.myText, this.myId});
    }
}

