/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.valueset.AuditEventActionEnum;
import ca.uhn.fhir.model.dstu2.valueset.AuditEventOutcomeEnum;
import ca.uhn.fhir.model.dstu2.valueset.AuditEventParticipantNetworkTypeEnum;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="AuditEvent", profile="http://hl7.org/fhir/profiles/AuditEvent", id="auditevent")
public class AuditEvent
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="AuditEvent.event.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="action", path="AuditEvent.event.action", description="", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    @SearchParamDefinition(name="date", path="AuditEvent.event.dateTime", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subtype", path="AuditEvent.event.subtype", description="", type="token")
    public static final String SP_SUBTYPE = "subtype";
    public static final TokenClientParam SUBTYPE = new TokenClientParam("subtype");
    @SearchParamDefinition(name="user", path="AuditEvent.participant.userId", description="", type="token")
    public static final String SP_USER = "user";
    public static final TokenClientParam USER = new TokenClientParam("user");
    @SearchParamDefinition(name="name", path="AuditEvent.participant.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="address", path="AuditEvent.participant.network.address", description="", type="token")
    public static final String SP_ADDRESS = "address";
    public static final TokenClientParam ADDRESS = new TokenClientParam("address");
    @SearchParamDefinition(name="source", path="AuditEvent.source.identifier", description="", type="token")
    public static final String SP_SOURCE = "source";
    public static final TokenClientParam SOURCE = new TokenClientParam("source");
    @SearchParamDefinition(name="site", path="AuditEvent.source.site", description="", type="token")
    public static final String SP_SITE = "site";
    public static final TokenClientParam SITE = new TokenClientParam("site");
    @SearchParamDefinition(name="object-type", path="AuditEvent.object.type", description="", type="token")
    public static final String SP_OBJECT_TYPE = "object-type";
    public static final TokenClientParam OBJECT_TYPE = new TokenClientParam("object-type");
    @SearchParamDefinition(name="identity", path="AuditEvent.object.identifier", description="", type="token")
    public static final String SP_IDENTITY = "identity";
    public static final TokenClientParam IDENTITY = new TokenClientParam("identity");
    @SearchParamDefinition(name="reference", path="AuditEvent.object.reference", description="", type="reference")
    public static final String SP_REFERENCE = "reference";
    public static final ReferenceClientParam REFERENCE = new ReferenceClientParam("reference");
    @SearchParamDefinition(name="desc", path="AuditEvent.object.name", description="", type="string")
    public static final String SP_DESC = "desc";
    public static final StringClientParam DESC = new StringClientParam("desc");
    @SearchParamDefinition(name="patient", path="AuditEvent.participant.reference | AuditEvent.object.reference", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="altid", path="AuditEvent.participant.altId", description="", type="token")
    public static final String SP_ALTID = "altid";
    public static final TokenClientParam ALTID = new TokenClientParam("altid");
    @SearchParamDefinition(name="participant", path="AuditEvent.participant.reference", description="", type="reference")
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    @SearchParamDefinition(name="policy", path="AuditEvent.participant.policy", description="", type="uri")
    public static final String SP_POLICY = "policy";
    public static final UriClientParam POLICY = new UriClientParam("policy");
    public static final Include INCLUDE_PARTICIPANT = new Include("AuditEvent:participant");
    public static final Include INCLUDE_PATIENT = new Include("AuditEvent:patient");
    public static final Include INCLUDE_REFERENCE = new Include("AuditEvent:reference");
    @Child(name="event", order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the name, action type, time, and disposition of the audited event")
    private Event myEvent;
    @Child(name="participant", order=1, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private List<Participant> myParticipant;
    @Child(name="source", order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private Source mySource;
    @Child(name="object", order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Specific instances of data or objects that have been accessed")
    private List<ObjectElement> myObject;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEvent, this.myParticipant, this.mySource, this.myObject});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEvent, this.myParticipant, this.mySource, this.myObject});
    }

    public Event getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new Event();
        }
        return this.myEvent;
    }

    public AuditEvent setEvent(Event theValue) {
        this.myEvent = theValue;
        return this;
    }

    public List<Participant> getParticipant() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public AuditEvent setParticipant(List<Participant> theValue) {
        this.myParticipant = theValue;
        return this;
    }

    public Participant addParticipant() {
        Participant newType = new Participant();
        this.getParticipant().add(newType);
        return newType;
    }

    public AuditEvent addParticipant(Participant theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getParticipant().add(theValue);
        return this;
    }

    public Participant getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            return this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public Source getSource() {
        if (this.mySource == null) {
            this.mySource = new Source();
        }
        return this.mySource;
    }

    public AuditEvent setSource(Source theValue) {
        this.mySource = theValue;
        return this;
    }

    public List<ObjectElement> getObject() {
        if (this.myObject == null) {
            this.myObject = new ArrayList<ObjectElement>();
        }
        return this.myObject;
    }

    public AuditEvent setObject(List<ObjectElement> theValue) {
        this.myObject = theValue;
        return this;
    }

    public ObjectElement addObject() {
        ObjectElement newType = new ObjectElement();
        this.getObject().add(newType);
        return newType;
    }

    public AuditEvent addObject(ObjectElement theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getObject().add(theValue);
        return this;
    }

    public ObjectElement getObjectFirstRep() {
        if (this.getObject().isEmpty()) {
            return this.addObject();
        }
        return this.getObject().get(0);
    }

    public String getResourceName() {
        return "AuditEvent";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class ObjectDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private StringDt myType;
        @Child(name="value", type={Base64BinaryDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private Base64BinaryDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myValue});
        }

        public StringDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new StringDt();
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public ObjectDetail setType(StringDt theValue) {
            this.myType = theValue;
            return this;
        }

        public ObjectDetail setType(String theString) {
            this.myType = new StringDt(theString);
            return this;
        }

        public Base64BinaryDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new Base64BinaryDt();
            }
            return this.myValue;
        }

        public byte[] getValue() {
            return (byte[])this.getValueElement().getValue();
        }

        public ObjectDetail setValue(Base64BinaryDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public ObjectDetail setValue(byte[] theBytes) {
            this.myValue = new Base64BinaryDt(theBytes);
            return this;
        }
    }

    @Block
    public static class ObjectElement
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies a specific instance of the participant object. The reference should always be version specific")
        private IdentifierDt myIdentifier;
        @Child(name="reference", order=1, min=0, max=1, summary=true, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="Identifies a specific instance of the participant object. The reference should always be version specific")
        private ResourceReferenceDt myReference;
        @Child(name="type", type={CodingDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type of the object that was involved in this audit event.")
        private CodingDt myType;
        @Child(name="role", type={CodingDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code representing the functional application role of Participant Object being audited")
        private CodingDt myRole;
        @Child(name="lifecycle", type={CodingDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifier for the data life-cycle stage for the participant object")
        private CodingDt myLifecycle;
        @Child(name="securityLabel", type={CodingDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Denotes security labels for the identified object.")
        private List<CodingDt> mySecurityLabel;
        @Child(name="name", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="An instance-specific descriptor of the Participant Object ID audited, such as a person's name")
        private StringDt myName;
        @Child(name="description", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Text that describes the object in more detail")
        private StringDt myDescription;
        @Child(name="query", type={Base64BinaryDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The actual query for a query-type participant object")
        private Base64BinaryDt myQuery;
        @Child(name="detail", order=9, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private List<ObjectDetail> myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myReference, this.myType, this.myRole, this.myLifecycle, this.mySecurityLabel, this.myName, this.myDescription, this.myQuery, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myReference, this.myType, this.myRole, this.myLifecycle, this.mySecurityLabel, this.myName, this.myDescription, this.myQuery, this.myDetail});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public ObjectElement setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public ResourceReferenceDt getReference() {
            if (this.myReference == null) {
                this.myReference = new ResourceReferenceDt();
            }
            return this.myReference;
        }

        public ObjectElement setReference(ResourceReferenceDt theValue) {
            this.myReference = theValue;
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public ObjectElement setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public CodingDt getRole() {
            if (this.myRole == null) {
                this.myRole = new CodingDt();
            }
            return this.myRole;
        }

        public ObjectElement setRole(CodingDt theValue) {
            this.myRole = theValue;
            return this;
        }

        public CodingDt getLifecycle() {
            if (this.myLifecycle == null) {
                this.myLifecycle = new CodingDt();
            }
            return this.myLifecycle;
        }

        public ObjectElement setLifecycle(CodingDt theValue) {
            this.myLifecycle = theValue;
            return this;
        }

        public List<CodingDt> getSecurityLabel() {
            if (this.mySecurityLabel == null) {
                this.mySecurityLabel = new ArrayList<CodingDt>();
            }
            return this.mySecurityLabel;
        }

        public ObjectElement setSecurityLabel(List<CodingDt> theValue) {
            this.mySecurityLabel = theValue;
            return this;
        }

        public CodingDt addSecurityLabel() {
            CodingDt newType = new CodingDt();
            this.getSecurityLabel().add(newType);
            return newType;
        }

        public ObjectElement addSecurityLabel(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSecurityLabel().add(theValue);
            return this;
        }

        public CodingDt getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                return this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public ObjectElement setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public ObjectElement setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public ObjectElement setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public ObjectElement setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public Base64BinaryDt getQueryElement() {
            if (this.myQuery == null) {
                this.myQuery = new Base64BinaryDt();
            }
            return this.myQuery;
        }

        public byte[] getQuery() {
            return (byte[])this.getQueryElement().getValue();
        }

        public ObjectElement setQuery(Base64BinaryDt theValue) {
            this.myQuery = theValue;
            return this;
        }

        public ObjectElement setQuery(byte[] theBytes) {
            this.myQuery = new Base64BinaryDt(theBytes);
            return this;
        }

        public List<ObjectDetail> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ObjectDetail>();
            }
            return this.myDetail;
        }

        public ObjectElement setDetail(List<ObjectDetail> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ObjectDetail addDetail() {
            ObjectDetail newType = new ObjectDetail();
            this.getDetail().add(newType);
            return newType;
        }

        public ObjectElement addDetail(ObjectDetail theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getDetail().add(theValue);
            return this;
        }

        public ObjectDetail getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                return this.addDetail();
            }
            return this.getDetail().get(0);
        }
    }

    @Block
    public static class Source
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="site", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group")
        private StringDt mySite;
        @Child(name="identifier", type={IdentifierDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifier of the source where the event was detected")
        private IdentifierDt myIdentifier;
        @Child(name="type", type={CodingDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code specifying the type of source where event originated")
        private List<CodingDt> myType;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySite, this.myIdentifier, this.myType});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySite, this.myIdentifier, this.myType});
        }

        public StringDt getSiteElement() {
            if (this.mySite == null) {
                this.mySite = new StringDt();
            }
            return this.mySite;
        }

        public String getSite() {
            return (String)this.getSiteElement().getValue();
        }

        public Source setSite(StringDt theValue) {
            this.mySite = theValue;
            return this;
        }

        public Source setSite(String theString) {
            this.mySite = new StringDt(theString);
            return this;
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Source setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public List<CodingDt> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<CodingDt>();
            }
            return this.myType;
        }

        public Source setType(List<CodingDt> theValue) {
            this.myType = theValue;
            return this;
        }

        public CodingDt addType() {
            CodingDt newType = new CodingDt();
            this.getType().add(newType);
            return newType;
        }

        public Source addType(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getType().add(theValue);
            return this;
        }

        public CodingDt getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                return this.addType();
            }
            return this.getType().get(0);
        }
    }

    @Block
    public static class ParticipantNetwork
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="address", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An identifier for the network access point of the user device for the audit event")
        private StringDt myAddress;
        @Child(name="type", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An identifier for the type of network access point that originated the audit event")
        private BoundCodeDt<AuditEventParticipantNetworkTypeEnum> myType;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myAddress, this.myType});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAddress, this.myType});
        }

        public StringDt getAddressElement() {
            if (this.myAddress == null) {
                this.myAddress = new StringDt();
            }
            return this.myAddress;
        }

        public String getAddress() {
            return (String)this.getAddressElement().getValue();
        }

        public ParticipantNetwork setAddress(StringDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public ParticipantNetwork setAddress(String theString) {
            this.myAddress = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<AuditEventParticipantNetworkTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(AuditEventParticipantNetworkTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public ParticipantNetwork setType(BoundCodeDt<AuditEventParticipantNetworkTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public ParticipantNetwork setType(AuditEventParticipantNetworkTypeEnum theValue) {
            this.setType((BoundCodeDt<AuditEventParticipantNetworkTypeEnum>)new BoundCodeDt(AuditEventParticipantNetworkTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }
    }

    @Block
    public static class Participant
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specification of the role(s) the user plays when performing the event. Usually the codes used in this element are local codes defined by the role-based access control security system used in the local context")
        private List<CodeableConceptDt> myRole;
        @Child(name="reference", order=1, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Organization.class, Device.class, Patient.class, RelatedPerson.class})
        @Description(shortDefinition="", formalDefinition="Direct reference to a resource that identifies the participant")
        private ResourceReferenceDt myReference;
        @Child(name="userId", type={IdentifierDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Unique identifier for the user actively participating in the event")
        private IdentifierDt myUserId;
        @Child(name="altId", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Alternative Participant Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g. single sign-on), if available")
        private StringDt myAltId;
        @Child(name="name", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Human-meaningful name for the user")
        private StringDt myName;
        @Child(name="requestor", type={BooleanDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicator that the user is or is not the requestor, or initiator, for the event being audited.")
        private BooleanDt myRequestor;
        @Child(name="location", order=6, min=0, max=1, summary=false, modifier=false, type={Location.class})
        @Description(shortDefinition="", formalDefinition="Where the event occurred")
        private ResourceReferenceDt myLocation;
        @Child(name="policy", type={UriDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The policy or plan that authorized the activity being recorded. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.")
        private List<UriDt> myPolicy;
        @Child(name="media", type={CodingDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Type of media involved. Used when the event is about exporting/importing onto media")
        private CodingDt myMedia;
        @Child(name="network", order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Logical network location for application activity, if the activity has a network location")
        private ParticipantNetwork myNetwork;
        @Child(name="purposeOfUse", type={CodingDt.class}, order=10, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The reason (purpose of use), specific to this participant, that was used during the event being recorded.")
        private List<CodingDt> myPurposeOfUse;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myRole, this.myReference, this.myUserId, this.myAltId, this.myName, this.myRequestor, this.myLocation, this.myPolicy, this.myMedia, this.myNetwork, this.myPurposeOfUse});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myReference, this.myUserId, this.myAltId, this.myName, this.myRequestor, this.myLocation, this.myPolicy, this.myMedia, this.myNetwork, this.myPurposeOfUse});
        }

        public List<CodeableConceptDt> getRole() {
            if (this.myRole == null) {
                this.myRole = new ArrayList<CodeableConceptDt>();
            }
            return this.myRole;
        }

        public Participant setRole(List<CodeableConceptDt> theValue) {
            this.myRole = theValue;
            return this;
        }

        public CodeableConceptDt addRole() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getRole().add(newType);
            return newType;
        }

        public Participant addRole(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getRole().add(theValue);
            return this;
        }

        public CodeableConceptDt getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                return this.addRole();
            }
            return this.getRole().get(0);
        }

        public ResourceReferenceDt getReference() {
            if (this.myReference == null) {
                this.myReference = new ResourceReferenceDt();
            }
            return this.myReference;
        }

        public Participant setReference(ResourceReferenceDt theValue) {
            this.myReference = theValue;
            return this;
        }

        public IdentifierDt getUserId() {
            if (this.myUserId == null) {
                this.myUserId = new IdentifierDt();
            }
            return this.myUserId;
        }

        public Participant setUserId(IdentifierDt theValue) {
            this.myUserId = theValue;
            return this;
        }

        public StringDt getAltIdElement() {
            if (this.myAltId == null) {
                this.myAltId = new StringDt();
            }
            return this.myAltId;
        }

        public String getAltId() {
            return (String)this.getAltIdElement().getValue();
        }

        public Participant setAltId(StringDt theValue) {
            this.myAltId = theValue;
            return this;
        }

        public Participant setAltId(String theString) {
            this.myAltId = new StringDt(theString);
            return this;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Participant setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Participant setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public BooleanDt getRequestorElement() {
            if (this.myRequestor == null) {
                this.myRequestor = new BooleanDt();
            }
            return this.myRequestor;
        }

        public Boolean getRequestor() {
            return (Boolean)this.getRequestorElement().getValue();
        }

        public Participant setRequestor(BooleanDt theValue) {
            this.myRequestor = theValue;
            return this;
        }

        public Participant setRequestor(boolean theBoolean) {
            this.myRequestor = new BooleanDt(theBoolean);
            return this;
        }

        public ResourceReferenceDt getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new ResourceReferenceDt();
            }
            return this.myLocation;
        }

        public Participant setLocation(ResourceReferenceDt theValue) {
            this.myLocation = theValue;
            return this;
        }

        public List<UriDt> getPolicy() {
            if (this.myPolicy == null) {
                this.myPolicy = new ArrayList<UriDt>();
            }
            return this.myPolicy;
        }

        public Participant setPolicy(List<UriDt> theValue) {
            this.myPolicy = theValue;
            return this;
        }

        public UriDt addPolicy() {
            UriDt newType = new UriDt();
            this.getPolicy().add(newType);
            return newType;
        }

        public Participant addPolicy(UriDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPolicy().add(theValue);
            return this;
        }

        public UriDt getPolicyFirstRep() {
            if (this.getPolicy().isEmpty()) {
                return this.addPolicy();
            }
            return this.getPolicy().get(0);
        }

        public Participant addPolicy(String theUri) {
            if (this.myPolicy == null) {
                this.myPolicy = new ArrayList<UriDt>();
            }
            this.myPolicy.add(new UriDt(theUri));
            return this;
        }

        public CodingDt getMedia() {
            if (this.myMedia == null) {
                this.myMedia = new CodingDt();
            }
            return this.myMedia;
        }

        public Participant setMedia(CodingDt theValue) {
            this.myMedia = theValue;
            return this;
        }

        public ParticipantNetwork getNetwork() {
            if (this.myNetwork == null) {
                this.myNetwork = new ParticipantNetwork();
            }
            return this.myNetwork;
        }

        public Participant setNetwork(ParticipantNetwork theValue) {
            this.myNetwork = theValue;
            return this;
        }

        public List<CodingDt> getPurposeOfUse() {
            if (this.myPurposeOfUse == null) {
                this.myPurposeOfUse = new ArrayList<CodingDt>();
            }
            return this.myPurposeOfUse;
        }

        public Participant setPurposeOfUse(List<CodingDt> theValue) {
            this.myPurposeOfUse = theValue;
            return this;
        }

        public CodingDt addPurposeOfUse() {
            CodingDt newType = new CodingDt();
            this.getPurposeOfUse().add(newType);
            return newType;
        }

        public Participant addPurposeOfUse(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPurposeOfUse().add(theValue);
            return this;
        }

        public CodingDt getPurposeOfUseFirstRep() {
            if (this.getPurposeOfUse().isEmpty()) {
                return this.addPurposeOfUse();
            }
            return this.getPurposeOfUse().get(0);
        }
    }

    @Block
    public static class Event
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodingDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifier for a family of the event.  For example, a menu item, program, rule, policy, function code, application name or URL. It identifies the performed function")
        private CodingDt myType;
        @Child(name="subtype", type={CodingDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifier for the category of event")
        private List<CodingDt> mySubtype;
        @Child(name="action", type={CodeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicator for type of action performed during the event that generated the audit")
        private BoundCodeDt<AuditEventActionEnum> myAction;
        @Child(name="dateTime", type={InstantDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The time when the event occurred on the source")
        private InstantDt myDateTime;
        @Child(name="outcome", type={CodeDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates whether the event succeeded or failed")
        private BoundCodeDt<AuditEventOutcomeEnum> myOutcome;
        @Child(name="outcomeDesc", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A free text description of the outcome of the event")
        private StringDt myOutcomeDesc;
        @Child(name="purposeOfEvent", type={CodingDt.class}, order=6, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The purposeOfUse (reason) that was used during the event being recorded.")
        private List<CodingDt> myPurposeOfEvent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.mySubtype, this.myAction, this.myDateTime, this.myOutcome, this.myOutcomeDesc, this.myPurposeOfEvent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.mySubtype, this.myAction, this.myDateTime, this.myOutcome, this.myOutcomeDesc, this.myPurposeOfEvent});
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Event setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public List<CodingDt> getSubtype() {
            if (this.mySubtype == null) {
                this.mySubtype = new ArrayList<CodingDt>();
            }
            return this.mySubtype;
        }

        public Event setSubtype(List<CodingDt> theValue) {
            this.mySubtype = theValue;
            return this;
        }

        public CodingDt addSubtype() {
            CodingDt newType = new CodingDt();
            this.getSubtype().add(newType);
            return newType;
        }

        public Event addSubtype(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getSubtype().add(theValue);
            return this;
        }

        public CodingDt getSubtypeFirstRep() {
            if (this.getSubtype().isEmpty()) {
                return this.addSubtype();
            }
            return this.getSubtype().get(0);
        }

        public BoundCodeDt<AuditEventActionEnum> getActionElement() {
            if (this.myAction == null) {
                this.myAction = new BoundCodeDt(AuditEventActionEnum.VALUESET_BINDER);
            }
            return this.myAction;
        }

        public String getAction() {
            return (String)this.getActionElement().getValue();
        }

        public Event setAction(BoundCodeDt<AuditEventActionEnum> theValue) {
            this.myAction = theValue;
            return this;
        }

        public Event setAction(AuditEventActionEnum theValue) {
            this.setAction((BoundCodeDt<AuditEventActionEnum>)new BoundCodeDt(AuditEventActionEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public InstantDt getDateTimeElement() {
            if (this.myDateTime == null) {
                this.myDateTime = new InstantDt();
            }
            return this.myDateTime;
        }

        public Date getDateTime() {
            return (Date)this.getDateTimeElement().getValue();
        }

        public Event setDateTime(InstantDt theValue) {
            this.myDateTime = theValue;
            return this;
        }

        public Event setDateTimeWithMillisPrecision(Date theDate) {
            this.myDateTime = new InstantDt(theDate);
            return this;
        }

        public Event setDateTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDateTime = new InstantDt(theDate, thePrecision);
            return this;
        }

        public BoundCodeDt<AuditEventOutcomeEnum> getOutcomeElement() {
            if (this.myOutcome == null) {
                this.myOutcome = new BoundCodeDt(AuditEventOutcomeEnum.VALUESET_BINDER);
            }
            return this.myOutcome;
        }

        public String getOutcome() {
            return (String)this.getOutcomeElement().getValue();
        }

        public Event setOutcome(BoundCodeDt<AuditEventOutcomeEnum> theValue) {
            this.myOutcome = theValue;
            return this;
        }

        public Event setOutcome(AuditEventOutcomeEnum theValue) {
            this.setOutcome((BoundCodeDt<AuditEventOutcomeEnum>)new BoundCodeDt(AuditEventOutcomeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public StringDt getOutcomeDescElement() {
            if (this.myOutcomeDesc == null) {
                this.myOutcomeDesc = new StringDt();
            }
            return this.myOutcomeDesc;
        }

        public String getOutcomeDesc() {
            return (String)this.getOutcomeDescElement().getValue();
        }

        public Event setOutcomeDesc(StringDt theValue) {
            this.myOutcomeDesc = theValue;
            return this;
        }

        public Event setOutcomeDesc(String theString) {
            this.myOutcomeDesc = new StringDt(theString);
            return this;
        }

        public List<CodingDt> getPurposeOfEvent() {
            if (this.myPurposeOfEvent == null) {
                this.myPurposeOfEvent = new ArrayList<CodingDt>();
            }
            return this.myPurposeOfEvent;
        }

        public Event setPurposeOfEvent(List<CodingDt> theValue) {
            this.myPurposeOfEvent = theValue;
            return this;
        }

        public CodingDt addPurposeOfEvent() {
            CodingDt newType = new CodingDt();
            this.getPurposeOfEvent().add(newType);
            return newType;
        }

        public Event addPurposeOfEvent(CodingDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPurposeOfEvent().add(theValue);
            return this;
        }

        public CodingDt getPurposeOfEventFirstRep() {
            if (this.getPurposeOfEvent().isEmpty()) {
                return this.addPurposeOfEvent();
            }
            return this.getPurposeOfEvent().get(0);
        }
    }
}

