/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.MoneyDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.HealthcareService;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.AccountStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Account", profile="http://hl7.org/fhir/profiles/Account", id="account")
public class Account
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Account.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Account.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="type", path="Account.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="status", path="Account.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="balance", path="Account.balance", description="", type="quantity")
    public static final String SP_BALANCE = "balance";
    public static final QuantityClientParam BALANCE = new QuantityClientParam("balance");
    @SearchParamDefinition(name="period", path="Account.coveragePeriod", description="", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="subject", path="Account.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="owner", path="Account.owner", description="", type="reference")
    public static final String SP_OWNER = "owner";
    public static final ReferenceClientParam OWNER = new ReferenceClientParam("owner");
    @SearchParamDefinition(name="patient", path="Account.subject", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_OWNER = new Include("Account:owner");
    public static final Include INCLUDE_PATIENT = new Include("Account:patient");
    public static final Include INCLUDE_SUBJECT = new Include("Account:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Unique identifier used to reference the account.  May or may not be intended for human use (e.g. credit card number)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="name", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Name used for the account when displaying it to humans in reports, etc.")
    private StringDt myName;
    @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Categorizes the account for reporting and searching purposes")
    private CodeableConceptDt myType;
    @Child(name="status", type={CodeDt.class}, order=3, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="", formalDefinition="Indicates whether the account is presently used/useable or not")
    private BoundCodeDt<AccountStatusEnum> myStatus;
    @Child(name="activePeriod", type={PeriodDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the period of time over which the account is allowed")
    private PeriodDt myActivePeriod;
    @Child(name="currency", type={CodingDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the currency to which transactions must be converted when crediting or debiting the account.")
    private CodingDt myCurrency;
    @Child(name="balance", type={MoneyDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Represents the sum of all credits less all debits associated with the account.  Might be positive, zero or negative.")
    private MoneyDt myBalance;
    @Child(name="coveragePeriod", type={PeriodDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies the period of time the account applies to; e.g. accounts created per fiscal year, quarter, etc.")
    private PeriodDt myCoveragePeriod;
    @Child(name="subject", order=8, min=0, max=1, summary=false, modifier=false, type={Patient.class, Device.class, Practitioner.class, Location.class, HealthcareService.class, Organization.class})
    @Description(shortDefinition="", formalDefinition="Identifies the patient, device, practitioner, location or other object the account is associated with")
    private ResourceReferenceDt mySubject;
    @Child(name="owner", order=9, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="Indicates the organization, department, etc. with responsibility for the account.")
    private ResourceReferenceDt myOwner;
    @Child(name="description", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Provides additional information about what the account tracks and how it is used")
    private StringDt myDescription;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myName, this.myType, this.myStatus, this.myActivePeriod, this.myCurrency, this.myBalance, this.myCoveragePeriod, this.mySubject, this.myOwner, this.myDescription});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myName, this.myType, this.myStatus, this.myActivePeriod, this.myCurrency, this.myBalance, this.myCoveragePeriod, this.mySubject, this.myOwner, this.myDescription});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Account setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Account addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public Account setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Account setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Account setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public BoundCodeDt<AccountStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(AccountStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Account setStatus(BoundCodeDt<AccountStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Account setStatus(AccountStatusEnum theValue) {
        this.setStatus((BoundCodeDt<AccountStatusEnum>)new BoundCodeDt(AccountStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public PeriodDt getActivePeriod() {
        if (this.myActivePeriod == null) {
            this.myActivePeriod = new PeriodDt();
        }
        return this.myActivePeriod;
    }

    public Account setActivePeriod(PeriodDt theValue) {
        this.myActivePeriod = theValue;
        return this;
    }

    public CodingDt getCurrency() {
        if (this.myCurrency == null) {
            this.myCurrency = new CodingDt();
        }
        return this.myCurrency;
    }

    public Account setCurrency(CodingDt theValue) {
        this.myCurrency = theValue;
        return this;
    }

    public MoneyDt getBalance() {
        if (this.myBalance == null) {
            this.myBalance = new MoneyDt();
        }
        return this.myBalance;
    }

    public Account setBalance(MoneyDt theValue) {
        this.myBalance = theValue;
        return this;
    }

    public PeriodDt getCoveragePeriod() {
        if (this.myCoveragePeriod == null) {
            this.myCoveragePeriod = new PeriodDt();
        }
        return this.myCoveragePeriod;
    }

    public Account setCoveragePeriod(PeriodDt theValue) {
        this.myCoveragePeriod = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Account setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getOwner() {
        if (this.myOwner == null) {
            this.myOwner = new ResourceReferenceDt();
        }
        return this.myOwner;
    }

    public Account setOwner(ResourceReferenceDt theValue) {
        this.myOwner = theValue;
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public Account setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Account setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "Account";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

