/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;

@DatatypeDef(name="PeriodDt")
public class PeriodDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="start", type={DateTimeDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The start of the period. The boundary is inclusive.")
    private DateTimeDt myStart;
    @Child(name="end", type={DateTimeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The end of the period. If the end of the period is missing, it means that the period is ongoing. The start may be in the past, and the end date in the future, which means that period is expected/planned to end at that time")
    private DateTimeDt myEnd;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStart, this.myEnd});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStart, this.myEnd});
    }

    public DateTimeDt getStartElement() {
        if (this.myStart == null) {
            this.myStart = new DateTimeDt();
        }
        return this.myStart;
    }

    public Date getStart() {
        return (Date)this.getStartElement().getValue();
    }

    public PeriodDt setStart(DateTimeDt theValue) {
        this.myStart = theValue;
        return this;
    }

    public PeriodDt setStart(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStart = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public PeriodDt setStartWithSecondsPrecision(Date theDate) {
        this.myStart = new DateTimeDt(theDate);
        return this;
    }

    public DateTimeDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new DateTimeDt();
        }
        return this.myEnd;
    }

    public Date getEnd() {
        return (Date)this.getEndElement().getValue();
    }

    public PeriodDt setEnd(DateTimeDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public PeriodDt setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myEnd = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public PeriodDt setEndWithSecondsPrecision(Date theDate) {
        this.myEnd = new DateTimeDt(theDate);
        return this;
    }
}

