/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import ca.uhn.fhir.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseMetaType;

@DatatypeDef(name="MetaDt")
public class MetaDt
extends BaseIdentifiableElement
implements ICompositeDatatype,
IBaseMetaType {
    @Child(name="versionId", type={IdDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version specific identifier, as it appears in the version portion of the URL. This values changes when the resource is created, updated, or deleted")
    private IdDt myVersionId;
    @Child(name="lastUpdated", type={InstantDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="When the resource last changed - e.g. when the version changed")
    private InstantDt myLastUpdated;
    @Child(name="profile", type={UriDt.class}, order=2, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A list of profiles [[[StructureDefinition]]]s that this resource claims to conform to. The URL is a reference to [[[StructureDefinition.url]]]")
    private List<UriDt> myProfile;
    @Child(name="security", type={CodingDt.class}, order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure")
    private List<CodingDt> mySecurity;
    @Child(name="tag", type={CodingDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource")
    private List<CodingDt> myTag;

    public MetaDt setLastUpdated(Date theHeaderDateValue) {
        return this.setLastUpdated(theHeaderDateValue, TemporalPrecisionEnum.SECOND);
    }

    public CodingDt getTag(String theSystem, String theCode) {
        for (CodingDt next : this.getTag()) {
            if (!ObjectUtil.equals((Object)next.getSystem(), (Object)theSystem) || !ObjectUtil.equals((Object)next.getCode(), (Object)theCode)) continue;
            return next;
        }
        return null;
    }

    public CodingDt getSecurity(String theSystem, String theCode) {
        for (CodingDt next : this.getTag()) {
            if (!ObjectUtil.equals((Object)next.getSystem(), (Object)theSystem) || !ObjectUtil.equals((Object)next.getCode(), (Object)theCode)) continue;
            return next;
        }
        return null;
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myVersionId, this.myLastUpdated, this.myProfile, this.mySecurity, this.myTag});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myVersionId, this.myLastUpdated, this.myProfile, this.mySecurity, this.myTag});
    }

    public IdDt getVersionIdElement() {
        if (this.myVersionId == null) {
            this.myVersionId = new IdDt();
        }
        return this.myVersionId;
    }

    public String getVersionId() {
        return this.getVersionIdElement().getValue();
    }

    public MetaDt setVersionId(IdDt theValue) {
        this.myVersionId = theValue;
        return this;
    }

    public MetaDt setVersionId(String theId) {
        this.myVersionId = new IdDt(theId);
        return this;
    }

    public InstantDt getLastUpdatedElement() {
        if (this.myLastUpdated == null) {
            this.myLastUpdated = new InstantDt();
        }
        return this.myLastUpdated;
    }

    public Date getLastUpdated() {
        return (Date)this.getLastUpdatedElement().getValue();
    }

    public MetaDt setLastUpdated(InstantDt theValue) {
        this.myLastUpdated = theValue;
        return this;
    }

    public MetaDt setLastUpdatedWithMillisPrecision(Date theDate) {
        this.myLastUpdated = new InstantDt(theDate);
        return this;
    }

    public MetaDt setLastUpdated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myLastUpdated = new InstantDt(theDate, thePrecision);
        return this;
    }

    public List<UriDt> getProfile() {
        if (this.myProfile == null) {
            this.myProfile = new ArrayList<UriDt>();
        }
        return this.myProfile;
    }

    public MetaDt setProfile(List<UriDt> theValue) {
        this.myProfile = theValue;
        return this;
    }

    public UriDt addProfile() {
        UriDt newType = new UriDt();
        this.getProfile().add(newType);
        return newType;
    }

    public MetaDt addProfile(UriDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getProfile().add(theValue);
        return this;
    }

    public UriDt getProfileFirstRep() {
        if (this.getProfile().isEmpty()) {
            return this.addProfile();
        }
        return this.getProfile().get(0);
    }

    public MetaDt addProfile(String theUri) {
        if (this.myProfile == null) {
            this.myProfile = new ArrayList<UriDt>();
        }
        this.myProfile.add(new UriDt(theUri));
        return this;
    }

    public List<CodingDt> getSecurity() {
        if (this.mySecurity == null) {
            this.mySecurity = new ArrayList<CodingDt>();
        }
        return this.mySecurity;
    }

    public MetaDt setSecurity(List<CodingDt> theValue) {
        this.mySecurity = theValue;
        return this;
    }

    public CodingDt addSecurity() {
        CodingDt newType = new CodingDt();
        this.getSecurity().add(newType);
        return newType;
    }

    public MetaDt addSecurity(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getSecurity().add(theValue);
        return this;
    }

    public CodingDt getSecurityFirstRep() {
        if (this.getSecurity().isEmpty()) {
            return this.addSecurity();
        }
        return this.getSecurity().get(0);
    }

    public List<CodingDt> getTag() {
        if (this.myTag == null) {
            this.myTag = new ArrayList<CodingDt>();
        }
        return this.myTag;
    }

    public MetaDt setTag(List<CodingDt> theValue) {
        this.myTag = theValue;
        return this;
    }

    public CodingDt addTag() {
        CodingDt newType = new CodingDt();
        this.getTag().add(newType);
        return newType;
    }

    public MetaDt addTag(CodingDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTag().add(theValue);
        return this;
    }

    public CodingDt getTagFirstRep() {
        if (this.getTag().isEmpty()) {
            return this.addTag();
        }
        return this.getTag().get(0);
    }
}

