/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;

@DatatypeDef(name="AnnotationDt")
public class AnnotationDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="author", order=0, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class, StringDt.class})
    @Description(shortDefinition="", formalDefinition="The individual responsible for making the annotation.")
    private IDatatype myAuthor;
    @Child(name="time", type={DateTimeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates when this particular annotation was made")
    private DateTimeDt myTime;
    @Child(name="text", type={StringDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The text of the annotation")
    private StringDt myText;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myAuthor, this.myTime, this.myText});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAuthor, this.myTime, this.myText});
    }

    public IDatatype getAuthor() {
        return this.myAuthor;
    }

    public AnnotationDt setAuthor(IDatatype theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public DateTimeDt getTimeElement() {
        if (this.myTime == null) {
            this.myTime = new DateTimeDt();
        }
        return this.myTime;
    }

    public Date getTime() {
        return (Date)this.getTimeElement().getValue();
    }

    public AnnotationDt setTime(DateTimeDt theValue) {
        this.myTime = theValue;
        return this;
    }

    public AnnotationDt setTime(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myTime = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public AnnotationDt setTimeWithSecondsPrecision(Date theDate) {
        this.myTime = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getTextElement() {
        if (this.myText == null) {
            this.myText = new StringDt();
        }
        return this.myText;
    }

    public String getText() {
        return (String)this.getTextElement().getValue();
    }

    public AnnotationDt setText(StringDt theValue) {
        this.myText = theValue;
        return this;
    }

    public AnnotationDt setText(String theString) {
        this.myText = new StringDt(theString);
        return this;
    }
}

