/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.resource.BaseSecurityEvent;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.SecurityEvent;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventActionEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectLifecycleEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventOutcomeEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventParticipantNetworkTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventSourceTypeEnum;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.audit.IResourceAuditor;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import ca.uhn.fhir.store.IAuditDataStore;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditingInterceptor
extends InterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(AuditingInterceptor.class);
    private IAuditDataStore myDataStore = null;
    private Map<String, Class<? extends IResourceAuditor<? extends IResource>>> myAuditableResources = new HashMap<String, Class<? extends IResourceAuditor<? extends IResource>>>();
    private boolean myClientParamsOptional = false;
    protected String mySiteId;

    public AuditingInterceptor() {
        this.mySiteId = "NONE";
        this.myClientParamsOptional = false;
    }

    public AuditingInterceptor(String theSiteId) {
        this.mySiteId = theSiteId;
        this.myClientParamsOptional = false;
    }

    public AuditingInterceptor(String theSiteId, boolean theClientParamsOptional) {
        this.mySiteId = theSiteId;
        this.myClientParamsOptional = theClientParamsOptional;
    }

    public boolean outgoingResponse(RequestDetails theRequestDetails, Bundle theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        if (this.myClientParamsOptional && this.myDataStore == null) {
            log.debug("No auditing configured.");
            return true;
        }
        if (theResponseObject == null || theResponseObject.isEmpty()) {
            log.debug("No bundle to audit");
            return true;
        }
        try {
            log.info("Auditing bundle: " + theResponseObject + " from request " + theRequestDetails);
            SecurityEvent auditEvent = new SecurityEvent();
            auditEvent.setEvent(this.getEventInfo(theRequestDetails));
            SecurityEvent.Participant participant = this.getParticipant(theServletRequest);
            if (participant == null) {
                log.debug("No participant to audit");
                return true;
            }
            ArrayList<SecurityEvent.Participant> participants = new ArrayList<SecurityEvent.Participant>(1);
            participants.add(participant);
            auditEvent.setParticipant(participants);
            SecurityEventObjectLifecycleEnum lifecycle = this.mapResourceTypeToSecurityLifecycle(theRequestDetails.getRestOperationType());
            byte[] query = this.getQueryFromRequestDetails(theRequestDetails);
            ArrayList<SecurityEvent.ObjectElement> auditableObjects = new ArrayList<SecurityEvent.ObjectElement>();
            for (BundleEntry entry : theResponseObject.getEntries()) {
                IResource resource = entry.getResource();
                SecurityEvent.ObjectElement auditableObject = this.getObjectElement(resource, lifecycle, query);
                if (auditableObject == null) continue;
                auditableObjects.add(auditableObject);
            }
            if (auditableObjects.isEmpty()) {
                log.debug("No auditable resources to audit.");
                return true;
            }
            log.debug("Auditing " + auditableObjects.size() + " resources.");
            auditEvent.setObject(auditableObjects);
            auditEvent.setSource(this.getSourceElement(theServletRequest));
            this.store(auditEvent);
            return true;
        }
        catch (Exception e) {
            log.error("Unable to audit resource: " + theResponseObject + " from request: " + theRequestDetails, (Throwable)e);
            throw new InternalErrorException("Auditing failed, unable to complete request", (Throwable)e);
        }
    }

    public boolean outgoingResponse(RequestDetails theRequestDetails, IBaseResource theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        if (this.myClientParamsOptional && this.myDataStore == null) {
            log.debug("No auditing configured.");
            return true;
        }
        if (theResponseObject == null) {
            log.debug("No object to audit");
            return true;
        }
        try {
            log.info("Auditing resource: " + theResponseObject + " from request: " + theRequestDetails);
            SecurityEvent auditEvent = new SecurityEvent();
            auditEvent.setEvent(this.getEventInfo(theRequestDetails));
            SecurityEvent.Participant participant = this.getParticipant(theServletRequest);
            if (participant == null) {
                log.debug("No participant to audit");
                return true;
            }
            ArrayList<SecurityEvent.Participant> participants = new ArrayList<SecurityEvent.Participant>(1);
            participants.add(participant);
            auditEvent.setParticipant(participants);
            byte[] query = this.getQueryFromRequestDetails(theRequestDetails);
            SecurityEventObjectLifecycleEnum lifecycle = this.mapResourceTypeToSecurityLifecycle(theRequestDetails.getRestOperationType());
            SecurityEvent.ObjectElement auditableObject = this.getObjectElement((IResource)theResponseObject, lifecycle, query);
            if (auditableObject == null) {
                log.debug("No auditable resources to audit");
                return true;
            }
            ArrayList<SecurityEvent.ObjectElement> auditableObjects = new ArrayList<SecurityEvent.ObjectElement>(1);
            auditableObjects.add(auditableObject);
            auditEvent.setObject(auditableObjects);
            auditEvent.setSource(this.getSourceElement(theServletRequest));
            log.debug("Auditing one resource.");
            this.store(auditEvent);
            return true;
        }
        catch (Exception e) {
            log.error("Unable to audit resource: " + theResponseObject + " from request: " + theRequestDetails, (Throwable)e);
            throw new InternalErrorException("Auditing failed, unable to complete request", (Throwable)e);
        }
    }

    protected void store(SecurityEvent auditEvent) throws Exception {
        if (this.myDataStore == null) {
            throw new InternalErrorException("No data store provided to persist audit events");
        }
        this.myDataStore.store((BaseSecurityEvent)auditEvent);
    }

    protected SecurityEvent.Event getEventInfo(RequestDetails theRequestDetails) {
        SecurityEvent.Event event = new SecurityEvent.Event();
        event.setAction(this.mapResourceTypeToSecurityEventAction(theRequestDetails.getRestOperationType()));
        event.setDateTimeWithMillisPrecision(new Date());
        event.setOutcome(SecurityEventOutcomeEnum.SUCCESS);
        return event;
    }

    protected byte[] getQueryFromRequestDetails(RequestDetails theRequestDetails) {
        byte[] query;
        try {
            query = theRequestDetails.getCompleteUrl().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.warn("Unable to encode URL to bytes in UTF-8, defaulting to platform default charset.", (Throwable)e1);
            query = theRequestDetails.getCompleteUrl().getBytes();
        }
        return query;
    }

    protected SecurityEvent.ObjectElement getObjectElement(IResource resource, SecurityEventObjectLifecycleEnum lifecycle, byte[] query) throws InstantiationException, IllegalAccessException {
        String resourceType = resource.getResourceName();
        if (this.myAuditableResources.containsKey(resourceType)) {
            log.debug("Found auditable resource of type: " + resourceType);
            IResourceAuditor<? extends IResource> auditableResource = this.myAuditableResources.get(resourceType).newInstance();
            auditableResource.setResource((IResource)resource);
            if (auditableResource.isAuditable()) {
                SecurityEvent.ObjectElement object = new SecurityEvent.ObjectElement();
                object.setReference(new ResourceReferenceDt((IIdType)resource.getId()));
                object.setLifecycle(lifecycle);
                object.setQuery(query);
                object.setName(auditableResource.getName());
                object.setIdentifier((IdentifierDt)auditableResource.getIdentifier());
                object.setType(auditableResource.getType());
                object.setDescription(auditableResource.getDescription());
                Map<String, String> detailMap = auditableResource.getDetail();
                if (detailMap != null && !detailMap.isEmpty()) {
                    ArrayList<SecurityEvent.ObjectDetail> details = new ArrayList<SecurityEvent.ObjectDetail>();
                    for (Map.Entry<String, String> entry : detailMap.entrySet()) {
                        SecurityEvent.ObjectDetail detail = this.makeObjectDetail(entry.getKey(), entry.getValue());
                        details.add(detail);
                    }
                    object.setDetail(details);
                }
                if (auditableResource.getSensitivity() != null) {
                    CodingDt coding = object.getSensitivity().addCoding();
                    coding.setSystem((String)auditableResource.getSensitivity().getSystemElement().getValue());
                    coding.setCode((String)auditableResource.getSensitivity().getCodeElement().getValue());
                    coding.setDisplay((String)auditableResource.getSensitivity().getDisplayElement().getValue());
                }
                return object;
            }
            log.debug("Resource is not auditable");
        } else {
            log.debug("No auditor configured for resource type " + resourceType);
        }
        return null;
    }

    protected SecurityEvent.ObjectDetail makeObjectDetail(String type, String value) {
        SecurityEvent.ObjectDetail detail = new SecurityEvent.ObjectDetail();
        if (type != null) {
            detail.setType(type);
        }
        if (value != null) {
            detail.setValue(value.getBytes());
        }
        return detail;
    }

    protected SecurityEvent.Participant getParticipant(HttpServletRequest theServletRequest) throws InvalidRequestException, NotImplementedException {
        if (theServletRequest.getHeader("Authorization") != null && theServletRequest.getHeader("Authorization").startsWith("OAuth")) {
            if (this.myClientParamsOptional) {
                log.debug("OAuth request received but no auditing required.");
                return null;
            }
            throw new NotImplementedException("OAuth user auditing not yet implemented.");
        }
        String userId = theServletRequest.getHeader("fhir-user-id");
        if (userId == null) {
            if (this.myClientParamsOptional) {
                return null;
            }
            throw new InvalidRequestException("fhir-user-id must be specified as an HTTP header to access PHI.");
        }
        String userName = theServletRequest.getHeader("fhir-user-name");
        if (userName == null) {
            userName = "Anonymous";
        }
        String userIp = theServletRequest.getRemoteAddr();
        SecurityEvent.Participant participant = new SecurityEvent.Participant();
        participant.setUserId(userId);
        participant.setName(userName);
        SecurityEvent.ParticipantNetwork network = participant.getNetwork();
        network.setType(SecurityEventParticipantNetworkTypeEnum.IP_ADDRESS);
        network.setIdentifier(userIp);
        return participant;
    }

    protected SecurityEvent.Source getSourceElement(HttpServletRequest theServletRequest) throws NotImplementedException {
        if (theServletRequest.getHeader("Authorization") != null && theServletRequest.getHeader("Authorization").startsWith("OAuth")) {
            if (this.myClientParamsOptional) {
                return null;
            }
            throw new NotImplementedException("OAuth auditing not yet implemented.");
        }
        String appId = theServletRequest.getHeader("fhir-app-name");
        SecurityEvent.Source source = new SecurityEvent.Source();
        source.setIdentifier(appId);
        source.setType(this.getAccessType(theServletRequest));
        source.setSite(this.getSiteId(theServletRequest));
        return source;
    }

    protected StringDt getSiteId(HttpServletRequest theServletRequest) {
        return new StringDt(this.mySiteId);
    }

    protected List<CodingDt> getAccessType(HttpServletRequest theServletRequest) {
        ArrayList<CodingDt> types = new ArrayList<CodingDt>();
        if (theServletRequest.getHeader("Authorization") != null && theServletRequest.getHeader("Authorization").startsWith("OAuth")) {
            types.add(new CodingDt(SecurityEventSourceTypeEnum.USER_DEVICE.getSystem(), SecurityEventSourceTypeEnum.USER_DEVICE.getCode()));
        } else {
            String userId = theServletRequest.getHeader("fhir-user-id");
            String appId = theServletRequest.getHeader("fhir-app-name");
            if (userId == null && appId != null) {
                types.add(new CodingDt(SecurityEventSourceTypeEnum.APPLICATION_SERVER.getSystem(), SecurityEventSourceTypeEnum.APPLICATION_SERVER.getCode()));
            } else {
                types.add(new CodingDt(SecurityEventSourceTypeEnum.USER_DEVICE.getSystem(), SecurityEventSourceTypeEnum.USER_DEVICE.getCode()));
            }
        }
        return types;
    }

    protected SecurityEventActionEnum mapResourceTypeToSecurityEventAction(RestOperationTypeEnum theRestfulOperationTypeEnum) {
        if (theRestfulOperationTypeEnum == null) {
            return null;
        }
        switch (theRestfulOperationTypeEnum) {
            case READ: {
                return SecurityEventActionEnum.READ_VIEW_PRINT;
            }
            case CREATE: {
                return SecurityEventActionEnum.CREATE;
            }
            case DELETE: {
                return SecurityEventActionEnum.DELETE;
            }
            case HISTORY_INSTANCE: {
                return SecurityEventActionEnum.READ_VIEW_PRINT;
            }
            case HISTORY_TYPE: {
                return SecurityEventActionEnum.READ_VIEW_PRINT;
            }
            case SEARCH_TYPE: {
                return SecurityEventActionEnum.READ_VIEW_PRINT;
            }
            case UPDATE: {
                return SecurityEventActionEnum.UPDATE;
            }
            case VALIDATE: {
                return SecurityEventActionEnum.READ_VIEW_PRINT;
            }
            case VREAD: {
                return SecurityEventActionEnum.READ_VIEW_PRINT;
            }
        }
        return SecurityEventActionEnum.READ_VIEW_PRINT;
    }

    protected SecurityEventObjectLifecycleEnum mapResourceTypeToSecurityLifecycle(RestOperationTypeEnum theRestfulOperationTypeEnum) {
        if (theRestfulOperationTypeEnum == null) {
            return null;
        }
        switch (theRestfulOperationTypeEnum) {
            case READ: {
                return SecurityEventObjectLifecycleEnum.ACCESS_OR_USE;
            }
            case CREATE: {
                return SecurityEventObjectLifecycleEnum.ORIGINATION_OR_CREATION;
            }
            case DELETE: {
                return SecurityEventObjectLifecycleEnum.LOGICAL_DELETION;
            }
            case HISTORY_INSTANCE: {
                return SecurityEventObjectLifecycleEnum.ACCESS_OR_USE;
            }
            case HISTORY_TYPE: {
                return SecurityEventObjectLifecycleEnum.ACCESS_OR_USE;
            }
            case SEARCH_TYPE: {
                return SecurityEventObjectLifecycleEnum.ACCESS_OR_USE;
            }
            case UPDATE: {
                return SecurityEventObjectLifecycleEnum.AMENDMENT;
            }
            case VALIDATE: {
                return SecurityEventObjectLifecycleEnum.VERIFICATION;
            }
            case VREAD: {
                return SecurityEventObjectLifecycleEnum.ACCESS_OR_USE;
            }
        }
        return SecurityEventObjectLifecycleEnum.ACCESS_OR_USE;
    }

    public void setDataStore(IAuditDataStore theDataStore) {
        this.myDataStore = theDataStore;
    }

    public Map<String, Class<? extends IResourceAuditor<? extends IResource>>> getAuditableResources() {
        return this.myAuditableResources;
    }

    public void setAuditableResources(Map<String, Class<? extends IResourceAuditor<? extends IResource>>> theAuditableResources) {
        this.myAuditableResources = theAuditableResources;
    }

    public void addAuditableResource(String resourceType, Class<? extends IResourceAuditor<? extends IResource>> auditableResource) {
        if (this.myAuditableResources == null) {
            this.myAuditableResources = new HashMap<String, Class<? extends IResourceAuditor<? extends IResource>>>();
        }
        this.myAuditableResources.put(resourceType, auditableResource);
    }
}

