/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.audit;

import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectTypeEnum;
import ca.uhn.fhir.rest.server.audit.IResourceAuditor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatientAuditor
implements IResourceAuditor<Patient> {
    private Patient myPatient;

    @Override
    public boolean isAuditable() {
        return this.myPatient != null;
    }

    @Override
    public Patient getResource() {
        return this.myPatient;
    }

    @Override
    public void setResource(Patient thePatient) {
        this.myPatient = thePatient;
    }

    @Override
    public String getName() {
        if (this.myPatient != null) {
            return "Patient: " + this.myPatient.getNameFirstRep().getNameAsSingleString();
        }
        return null;
    }

    @Override
    public IdentifierDt getIdentifier() {
        if (this.myPatient != null) {
            return this.myPatient.getIdentifierFirstRep();
        }
        return null;
    }

    @Override
    public SecurityEventObjectTypeEnum getType() {
        return SecurityEventObjectTypeEnum.PERSON;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Map<String, String> getDetail() {
        List<IdentifierDt> ids;
        if (this.myPatient != null && (ids = this.myPatient.getIdentifier()) != null && !ids.isEmpty()) {
            HashMap<String, String> detailMap = new HashMap<String, String>();
            for (IdentifierDt id : ids) {
                String key = id.getSystem().getValueAsString();
                String value = id.getValue().getValueAsString();
                detailMap.put(key, value);
            }
            return detailMap;
        }
        return null;
    }

    @Override
    public BaseCodingDt getSensitivity() {
        return null;
    }
}

