/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Substance;
import ca.uhn.fhir.model.dstu.valueset.HierarchicalRelationshipTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.dstu.valueset.SpecimenCollectionMethodEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Specimen", profile="http://hl7.org/fhir/profiles/Specimen", id="specimen")
public class Specimen
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="Specimen.subject", description="The subject of the specimen", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Specimen.subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="External Identifier", formalDefinition="Id for specimen")
    private List<IdentifierDt> myIdentifier;
    @Child(name="type", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Kind of material that forms the specimen", formalDefinition="Kind of material that forms the specimen")
    private CodeableConceptDt myType;
    @Child(name="source", order=2, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Parent of specimen", formalDefinition="Parent specimen from which the focal specimen was a component")
    private List<Source> mySource;
    @Child(name="subject", order=3, min=1, max=1, summary=false, modifier=false, type={Patient.class, Group.class, Device.class, Substance.class})
    @Description(shortDefinition="Where the specimen came from. This may be the patient(s) or from the environment or  a device", formalDefinition="")
    private ResourceReferenceDt mySubject;
    @Child(name="accessionIdentifier", type={IdentifierDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Identifier assigned by the lab", formalDefinition="The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.")
    private IdentifierDt myAccessionIdentifier;
    @Child(name="receivedTime", type={DateTimeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The time when specimen was received for processing", formalDefinition="Time when specimen was received for processing or testing")
    private DateTimeDt myReceivedTime;
    @Child(name="collection", order=6, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Collection details", formalDefinition="Details concerning the specimen collection")
    private Collection myCollection;
    @Child(name="treatment", order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Treatment and processing step details", formalDefinition="Details concerning treatment and processing steps for the specimen")
    private List<Treatment> myTreatment;
    @Child(name="container", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Direct container of specimen (tube/slide, etc)", formalDefinition="The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.")
    private List<Container> myContainer;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.mySource, this.mySubject, this.myAccessionIdentifier, this.myReceivedTime, this.myCollection, this.myTreatment, this.myContainer});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.mySource, this.mySubject, this.myAccessionIdentifier, this.myReceivedTime, this.myCollection, this.myTreatment, this.myContainer});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Specimen setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Specimen addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Specimen addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Specimen setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public List<Source> getSource() {
        if (this.mySource == null) {
            this.mySource = new ArrayList<Source>();
        }
        return this.mySource;
    }

    public List<Source> getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new ArrayList<Source>();
        }
        return this.mySource;
    }

    public Specimen setSource(List<Source> theValue) {
        this.mySource = theValue;
        return this;
    }

    public Source addSource() {
        Source newType = new Source();
        this.getSource().add(newType);
        return newType;
    }

    public Source getSourceFirstRep() {
        if (this.getSource().isEmpty()) {
            return this.addSource();
        }
        return this.getSource().get(0);
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Specimen setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public IdentifierDt getAccessionIdentifier() {
        if (this.myAccessionIdentifier == null) {
            this.myAccessionIdentifier = new IdentifierDt();
        }
        return this.myAccessionIdentifier;
    }

    public IdentifierDt getAccessionIdentifierElement() {
        if (this.myAccessionIdentifier == null) {
            this.myAccessionIdentifier = new IdentifierDt();
        }
        return this.myAccessionIdentifier;
    }

    public Specimen setAccessionIdentifier(IdentifierDt theValue) {
        this.myAccessionIdentifier = theValue;
        return this;
    }

    public Specimen setAccessionIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myAccessionIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Specimen setAccessionIdentifier(String theSystem, String theValue) {
        this.myAccessionIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public DateTimeDt getReceivedTime() {
        if (this.myReceivedTime == null) {
            this.myReceivedTime = new DateTimeDt();
        }
        return this.myReceivedTime;
    }

    public DateTimeDt getReceivedTimeElement() {
        if (this.myReceivedTime == null) {
            this.myReceivedTime = new DateTimeDt();
        }
        return this.myReceivedTime;
    }

    public Specimen setReceivedTime(DateTimeDt theValue) {
        this.myReceivedTime = theValue;
        return this;
    }

    public Specimen setReceivedTime(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myReceivedTime = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Specimen setReceivedTimeWithSecondsPrecision(Date theDate) {
        this.myReceivedTime = new DateTimeDt(theDate);
        return this;
    }

    public Collection getCollection() {
        if (this.myCollection == null) {
            this.myCollection = new Collection();
        }
        return this.myCollection;
    }

    public Collection getCollectionElement() {
        if (this.myCollection == null) {
            this.myCollection = new Collection();
        }
        return this.myCollection;
    }

    public Specimen setCollection(Collection theValue) {
        this.myCollection = theValue;
        return this;
    }

    public List<Treatment> getTreatment() {
        if (this.myTreatment == null) {
            this.myTreatment = new ArrayList<Treatment>();
        }
        return this.myTreatment;
    }

    public List<Treatment> getTreatmentElement() {
        if (this.myTreatment == null) {
            this.myTreatment = new ArrayList<Treatment>();
        }
        return this.myTreatment;
    }

    public Specimen setTreatment(List<Treatment> theValue) {
        this.myTreatment = theValue;
        return this;
    }

    public Treatment addTreatment() {
        Treatment newType = new Treatment();
        this.getTreatment().add(newType);
        return newType;
    }

    public Treatment getTreatmentFirstRep() {
        if (this.getTreatment().isEmpty()) {
            return this.addTreatment();
        }
        return this.getTreatment().get(0);
    }

    public List<Container> getContainer() {
        if (this.myContainer == null) {
            this.myContainer = new ArrayList<Container>();
        }
        return this.myContainer;
    }

    public List<Container> getContainerElement() {
        if (this.myContainer == null) {
            this.myContainer = new ArrayList<Container>();
        }
        return this.myContainer;
    }

    public Specimen setContainer(List<Container> theValue) {
        this.myContainer = theValue;
        return this;
    }

    public Container addContainer() {
        Container newType = new Container();
        this.getContainer().add(newType);
        return newType;
    }

    public Container getContainerFirstRep() {
        if (this.getContainer().isEmpty()) {
            return this.addContainer();
        }
        return this.getContainer().get(0);
    }

    public String getResourceName() {
        return "Specimen";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Container
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Id for the container", formalDefinition="Id for container. There may be multiple; a manufacturer's bar code, lab assigned identifier, etc. The container ID may differ from the specimen id in some circumstances")
        private List<IdentifierDt> myIdentifier;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Textual description of the container", formalDefinition="")
        private StringDt myDescription;
        @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Kind of container directly associated with specimen", formalDefinition="The type of container associated with the specimen (e.g. slide, aliquot, etc)")
        private CodeableConceptDt myType;
        @Child(name="capacity", type={QuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Container volume or size", formalDefinition="The capacity (volume or other measure) the container may contain.")
        private QuantityDt myCapacity;
        @Child(name="specimenQuantity", type={QuantityDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Quantity of specimen within container", formalDefinition="The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type")
        private QuantityDt mySpecimenQuantity;
        @Child(name="additive", order=5, min=0, max=1, summary=false, modifier=false, type={Substance.class})
        @Description(shortDefinition="Additive associated with container", formalDefinition="Additive associated with the container")
        private ResourceReferenceDt myAdditive;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDescription, this.myType, this.myCapacity, this.mySpecimenQuantity, this.myAdditive});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDescription, this.myType, this.myCapacity, this.mySpecimenQuantity, this.myAdditive});
        }

        public List<IdentifierDt> getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new ArrayList<IdentifierDt>();
            }
            return this.myIdentifier;
        }

        public List<IdentifierDt> getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new ArrayList<IdentifierDt>();
            }
            return this.myIdentifier;
        }

        public Container setIdentifier(List<IdentifierDt> theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public IdentifierDt addIdentifier() {
            IdentifierDt newType = new IdentifierDt();
            this.getIdentifier().add(newType);
            return newType;
        }

        public IdentifierDt getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                return this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public Container addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            if (this.myIdentifier == null) {
                this.myIdentifier = new ArrayList<IdentifierDt>();
            }
            this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
            return this;
        }

        public Container addIdentifier(String theSystem, String theValue) {
            if (this.myIdentifier == null) {
                this.myIdentifier = new ArrayList<IdentifierDt>();
            }
            this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
            return this;
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public Container setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Container setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public CodeableConceptDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Container setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public QuantityDt getCapacity() {
            if (this.myCapacity == null) {
                this.myCapacity = new QuantityDt();
            }
            return this.myCapacity;
        }

        public QuantityDt getCapacityElement() {
            if (this.myCapacity == null) {
                this.myCapacity = new QuantityDt();
            }
            return this.myCapacity;
        }

        public Container setCapacity(QuantityDt theValue) {
            this.myCapacity = theValue;
            return this;
        }

        public Container setCapacity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myCapacity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Container setCapacity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myCapacity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Container setCapacity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myCapacity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Container setCapacity(double theValue) {
            this.myCapacity = new QuantityDt(theValue);
            return this;
        }

        public Container setCapacity(long theValue) {
            this.myCapacity = new QuantityDt(theValue);
            return this;
        }

        public Container setCapacity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myCapacity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public QuantityDt getSpecimenQuantity() {
            if (this.mySpecimenQuantity == null) {
                this.mySpecimenQuantity = new QuantityDt();
            }
            return this.mySpecimenQuantity;
        }

        public QuantityDt getSpecimenQuantityElement() {
            if (this.mySpecimenQuantity == null) {
                this.mySpecimenQuantity = new QuantityDt();
            }
            return this.mySpecimenQuantity;
        }

        public Container setSpecimenQuantity(QuantityDt theValue) {
            this.mySpecimenQuantity = theValue;
            return this;
        }

        public Container setSpecimenQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.mySpecimenQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Container setSpecimenQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.mySpecimenQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Container setSpecimenQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.mySpecimenQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Container setSpecimenQuantity(double theValue) {
            this.mySpecimenQuantity = new QuantityDt(theValue);
            return this;
        }

        public Container setSpecimenQuantity(long theValue) {
            this.mySpecimenQuantity = new QuantityDt(theValue);
            return this;
        }

        public Container setSpecimenQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.mySpecimenQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public ResourceReferenceDt getAdditive() {
            if (this.myAdditive == null) {
                this.myAdditive = new ResourceReferenceDt();
            }
            return this.myAdditive;
        }

        public ResourceReferenceDt getAdditiveElement() {
            if (this.myAdditive == null) {
                this.myAdditive = new ResourceReferenceDt();
            }
            return this.myAdditive;
        }

        public Container setAdditive(ResourceReferenceDt theValue) {
            this.myAdditive = theValue;
            return this;
        }
    }

    @Block
    public static class Treatment
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="description", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Textual description of procedure", formalDefinition="")
        private StringDt myDescription;
        @Child(name="procedure", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Indicates the treatment or processing step  applied to the specimen", formalDefinition="A coded value specifying the procedure used to process the specimen")
        private CodeableConceptDt myProcedure;
        @Child(name="additive", order=2, min=0, max=-1, summary=false, modifier=false, type={Substance.class})
        @Description(shortDefinition="Material used in the processing step", formalDefinition="")
        private List<ResourceReferenceDt> myAdditive;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myDescription, this.myProcedure, this.myAdditive});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDescription, this.myProcedure, this.myAdditive});
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public Treatment setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Treatment setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getProcedure() {
            if (this.myProcedure == null) {
                this.myProcedure = new CodeableConceptDt();
            }
            return this.myProcedure;
        }

        public CodeableConceptDt getProcedureElement() {
            if (this.myProcedure == null) {
                this.myProcedure = new CodeableConceptDt();
            }
            return this.myProcedure;
        }

        public Treatment setProcedure(CodeableConceptDt theValue) {
            this.myProcedure = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getAdditive() {
            if (this.myAdditive == null) {
                this.myAdditive = new ArrayList<ResourceReferenceDt>();
            }
            return this.myAdditive;
        }

        public List<ResourceReferenceDt> getAdditiveElement() {
            if (this.myAdditive == null) {
                this.myAdditive = new ArrayList<ResourceReferenceDt>();
            }
            return this.myAdditive;
        }

        public Treatment setAdditive(List<ResourceReferenceDt> theValue) {
            this.myAdditive = theValue;
            return this;
        }

        public ResourceReferenceDt addAdditive() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getAdditive().add(newType);
            return newType;
        }
    }

    @Block
    public static class Collection
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="collector", order=0, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="Who collected the specimen", formalDefinition="Person who collected the specimen")
        private ResourceReferenceDt myCollector;
        @Child(name="comment", type={StringDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Collector comments", formalDefinition="To communicate any details or issues encountered during the specimen collection procedure.")
        private List<StringDt> myComment;
        @Child(name="collected", order=2, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class})
        @Description(shortDefinition="Collection time", formalDefinition="Time when specimen was collected from subject - the physiologically relevant time")
        private IDatatype myCollected;
        @Child(name="quantity", type={QuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The quantity of specimen collected", formalDefinition="The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample")
        private QuantityDt myQuantity;
        @Child(name="method", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Technique used to perform collection", formalDefinition="A coded value specifying the technique that is used to perform the procedure")
        private BoundCodeableConceptDt<SpecimenCollectionMethodEnum> myMethod;
        @Child(name="sourceSite", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Anatomical collection site", formalDefinition="Anatomical location from which the specimen should be collected (if subject is a patient). This element is not used for environmental specimens.")
        private CodeableConceptDt mySourceSite;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCollector, this.myComment, this.myCollected, this.myQuantity, this.myMethod, this.mySourceSite});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCollector, this.myComment, this.myCollected, this.myQuantity, this.myMethod, this.mySourceSite});
        }

        public ResourceReferenceDt getCollector() {
            if (this.myCollector == null) {
                this.myCollector = new ResourceReferenceDt();
            }
            return this.myCollector;
        }

        public ResourceReferenceDt getCollectorElement() {
            if (this.myCollector == null) {
                this.myCollector = new ResourceReferenceDt();
            }
            return this.myCollector;
        }

        public Collection setCollector(ResourceReferenceDt theValue) {
            this.myCollector = theValue;
            return this;
        }

        public List<StringDt> getComment() {
            if (this.myComment == null) {
                this.myComment = new ArrayList<StringDt>();
            }
            return this.myComment;
        }

        public List<StringDt> getCommentElement() {
            if (this.myComment == null) {
                this.myComment = new ArrayList<StringDt>();
            }
            return this.myComment;
        }

        public Collection setComment(List<StringDt> theValue) {
            this.myComment = theValue;
            return this;
        }

        public StringDt addComment() {
            StringDt newType = new StringDt();
            this.getComment().add(newType);
            return newType;
        }

        public StringDt getCommentFirstRep() {
            if (this.getComment().isEmpty()) {
                return this.addComment();
            }
            return this.getComment().get(0);
        }

        public Collection addComment(String theString) {
            if (this.myComment == null) {
                this.myComment = new ArrayList<StringDt>();
            }
            this.myComment.add(new StringDt(theString));
            return this;
        }

        public IDatatype getCollected() {
            return this.myCollected;
        }

        public IDatatype getCollectedElement() {
            return this.myCollected;
        }

        public Collection setCollected(IDatatype theValue) {
            this.myCollected = theValue;
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public Collection setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public Collection setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Collection setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Collection setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Collection setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Collection setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Collection setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public BoundCodeableConceptDt<SpecimenCollectionMethodEnum> getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new BoundCodeableConceptDt<SpecimenCollectionMethodEnum>(SpecimenCollectionMethodEnum.VALUESET_BINDER);
            }
            return this.myMethod;
        }

        public BoundCodeableConceptDt<SpecimenCollectionMethodEnum> getMethodElement() {
            if (this.myMethod == null) {
                this.myMethod = new BoundCodeableConceptDt<SpecimenCollectionMethodEnum>(SpecimenCollectionMethodEnum.VALUESET_BINDER);
            }
            return this.myMethod;
        }

        public Collection setMethod(BoundCodeableConceptDt<SpecimenCollectionMethodEnum> theValue) {
            this.myMethod = theValue;
            return this;
        }

        public Collection setMethod(SpecimenCollectionMethodEnum theValue) {
            this.getMethod().setValueAsEnum(theValue);
            return this;
        }

        public CodeableConceptDt getSourceSite() {
            if (this.mySourceSite == null) {
                this.mySourceSite = new CodeableConceptDt();
            }
            return this.mySourceSite;
        }

        public CodeableConceptDt getSourceSiteElement() {
            if (this.mySourceSite == null) {
                this.mySourceSite = new CodeableConceptDt();
            }
            return this.mySourceSite;
        }

        public Collection setSourceSite(CodeableConceptDt theValue) {
            this.mySourceSite = theValue;
            return this;
        }
    }

    @Block
    public static class Source
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="relationship", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="parent | child", formalDefinition="Whether this relationship is to a parent or to a child")
        private BoundCodeDt<HierarchicalRelationshipTypeEnum> myRelationship;
        @Child(name="target", order=1, min=0, max=-1, summary=false, modifier=false, type={Specimen.class})
        @Description(shortDefinition="The subject of the relationship", formalDefinition="The specimen resource that is the target of this relationship")
        private List<ResourceReferenceDt> myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myRelationship, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRelationship, this.myTarget});
        }

        public BoundCodeDt<HierarchicalRelationshipTypeEnum> getRelationship() {
            if (this.myRelationship == null) {
                this.myRelationship = new BoundCodeDt(HierarchicalRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myRelationship;
        }

        public BoundCodeDt<HierarchicalRelationshipTypeEnum> getRelationshipElement() {
            if (this.myRelationship == null) {
                this.myRelationship = new BoundCodeDt(HierarchicalRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myRelationship;
        }

        public Source setRelationship(BoundCodeDt<HierarchicalRelationshipTypeEnum> theValue) {
            this.myRelationship = theValue;
            return this;
        }

        public Source setRelationship(HierarchicalRelationshipTypeEnum theValue) {
            this.getRelationship().setValueAsEnum((Enum)theValue);
            return this;
        }

        public List<ResourceReferenceDt> getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ArrayList<ResourceReferenceDt>();
            }
            return this.myTarget;
        }

        public List<ResourceReferenceDt> getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new ArrayList<ResourceReferenceDt>();
            }
            return this.myTarget;
        }

        public Source setTarget(List<ResourceReferenceDt> theValue) {
            this.myTarget = theValue;
            return this;
        }

        public ResourceReferenceDt addTarget() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getTarget().add(newType);
            return newType;
        }
    }
}

