/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="SequencingLab", profile="http://hl7.org/fhir/profiles/SequencingLab", id="sequencinglab")
public class SequencingLab
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="SequencingLab.subject", description="Subject of the lab", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("SequencingLab.subject");
    @SearchParamDefinition(name="specimen", path="SequencingLab.specimen.type", description="Type of the specimen used for the lab", type="string")
    public static final String SP_SPECIMEN = "specimen";
    public static final StringClientParam SPECIMEN = new StringClientParam("specimen");
    @SearchParamDefinition(name="date", path="SequencingLab.date", description="Date when result of the lab is uploaded", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="organization", path="SequencingLab.organization", description="Organization that does the lab", type="string")
    public static final String SP_ORGANIZATION = "organization";
    public static final StringClientParam ORGANIZATION = new StringClientParam("organization");
    @SearchParamDefinition(name="system-class", path="SequencingLab.system.class", description="Class of the sequencing system", type="string")
    public static final String SP_SYSTEM_CLASS = "system-class";
    public static final StringClientParam SYSTEM_CLASS = new StringClientParam("system-class");
    @SearchParamDefinition(name="system-name", path="SequencingLab.system.name", description="Name of the sequencing system", type="string")
    public static final String SP_SYSTEM_NAME = "system-name";
    public static final StringClientParam SYSTEM_NAME = new StringClientParam("system-name");
    @Child(name="subject", order=0, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Subject", formalDefinition="Subject of the sequencing lab")
    private ResourceReferenceDt mySubject;
    @Child(name="organization", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Organization", formalDefinition="Organization that does the sequencing")
    private StringDt myOrganization;
    @Child(name="name", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Name", formalDefinition="Name of the lab")
    private StringDt myName;
    @Child(name="date", type={DateDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date", formalDefinition="Date when the result of the lab is uploaded")
    private DateDt myDate;
    @Child(name="type", type={CodeDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Type", formalDefinition="Type of the sequencing lab")
    private CodeDt myType;
    @Child(name="system", order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Sequencing System", formalDefinition="System of machine used for sequencing")
    private System mySystem;
    @Child(name="specimen", order=6, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Specimen of the lab", formalDefinition="Specimen of the lab")
    private Specimen mySpecimen;
    @Child(name="file", type={AttachmentDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="File", formalDefinition="Files uploaded as results of the lab")
    private List<AttachmentDt> myFile;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.myOrganization, this.myName, this.myDate, this.myType, this.mySystem, this.mySpecimen, this.myFile});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myOrganization, this.myName, this.myDate, this.myType, this.mySystem, this.mySpecimen, this.myFile});
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public SequencingLab setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public StringDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new StringDt();
        }
        return this.myOrganization;
    }

    public StringDt getOrganizationElement() {
        if (this.myOrganization == null) {
            this.myOrganization = new StringDt();
        }
        return this.myOrganization;
    }

    public SequencingLab setOrganization(StringDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public SequencingLab setOrganization(String theString) {
        this.myOrganization = new StringDt(theString);
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public SequencingLab setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public SequencingLab setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public DateDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public DateDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public SequencingLab setDate(DateDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public SequencingLab setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public SequencingLab setDateWithDayPrecision(Date theDate) {
        this.myDate = new DateDt(theDate);
        return this;
    }

    public CodeDt getType() {
        if (this.myType == null) {
            this.myType = new CodeDt();
        }
        return this.myType;
    }

    public CodeDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeDt();
        }
        return this.myType;
    }

    public SequencingLab setType(CodeDt theValue) {
        this.myType = theValue;
        return this;
    }

    public SequencingLab setType(String theCode) {
        this.myType = new CodeDt(theCode);
        return this;
    }

    public System getSystem() {
        if (this.mySystem == null) {
            this.mySystem = new System();
        }
        return this.mySystem;
    }

    public System getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new System();
        }
        return this.mySystem;
    }

    public SequencingLab setSystem(System theValue) {
        this.mySystem = theValue;
        return this;
    }

    public Specimen getSpecimen() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new Specimen();
        }
        return this.mySpecimen;
    }

    public Specimen getSpecimenElement() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new Specimen();
        }
        return this.mySpecimen;
    }

    public SequencingLab setSpecimen(Specimen theValue) {
        this.mySpecimen = theValue;
        return this;
    }

    public List<AttachmentDt> getFile() {
        if (this.myFile == null) {
            this.myFile = new ArrayList<AttachmentDt>();
        }
        return this.myFile;
    }

    public List<AttachmentDt> getFileElement() {
        if (this.myFile == null) {
            this.myFile = new ArrayList<AttachmentDt>();
        }
        return this.myFile;
    }

    public SequencingLab setFile(List<AttachmentDt> theValue) {
        this.myFile = theValue;
        return this;
    }

    public AttachmentDt addFile() {
        AttachmentDt newType = new AttachmentDt();
        this.getFile().add(newType);
        return newType;
    }

    public AttachmentDt getFileFirstRep() {
        if (this.getFile().isEmpty()) {
            return this.addFile();
        }
        return this.getFile().get(0);
    }

    public String getResourceName() {
        return "SequencingLab";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Specimen
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Class of the specimen", formalDefinition="Whether the specimen is from germline or somatic cells of the patient")
        private CodeDt myType;
        @Child(name="source", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Source of specimen", formalDefinition="Source of the specimen")
        private CodeableConceptDt mySource;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.mySource});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.mySource});
        }

        public CodeDt getType() {
            if (this.myType == null) {
                this.myType = new CodeDt();
            }
            return this.myType;
        }

        public CodeDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeDt();
            }
            return this.myType;
        }

        public Specimen setType(CodeDt theValue) {
            this.myType = theValue;
            return this;
        }

        public Specimen setType(String theCode) {
            this.myType = new CodeDt(theCode);
            return this;
        }

        public CodeableConceptDt getSource() {
            if (this.mySource == null) {
                this.mySource = new CodeableConceptDt();
            }
            return this.mySource;
        }

        public CodeableConceptDt getSourceElement() {
            if (this.mySource == null) {
                this.mySource = new CodeableConceptDt();
            }
            return this.mySource;
        }

        public Specimen setSource(CodeableConceptDt theValue) {
            this.mySource = theValue;
            return this;
        }
    }

    @Block
    public static class System
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="class", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Class of sequencing system", formalDefinition="Class of sequencing system")
        private CodeDt myClassElement;
        @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Version of sequencing system", formalDefinition="Version of sequencing system")
        private StringDt myVersion;
        @Child(name="name", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of sequencing system", formalDefinition="Name of sequencing system")
        private CodeDt myName;
        @Child(name="identity", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Id of sequencing system", formalDefinition="Id of sequencing system")
        private StringDt myIdentity;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myClassElement, this.myVersion, this.myName, this.myIdentity});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myClassElement, this.myVersion, this.myName, this.myIdentity});
        }

        public CodeDt getClassElement() {
            if (this.myClassElement == null) {
                this.myClassElement = new CodeDt();
            }
            return this.myClassElement;
        }

        public CodeDt getClassElementElement() {
            if (this.myClassElement == null) {
                this.myClassElement = new CodeDt();
            }
            return this.myClassElement;
        }

        public System setClassElement(CodeDt theValue) {
            this.myClassElement = theValue;
            return this;
        }

        public System setClassElement(String theCode) {
            this.myClassElement = new CodeDt(theCode);
            return this;
        }

        public StringDt getVersion() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public System setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public System setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public CodeDt getName() {
            if (this.myName == null) {
                this.myName = new CodeDt();
            }
            return this.myName;
        }

        public CodeDt getNameElement() {
            if (this.myName == null) {
                this.myName = new CodeDt();
            }
            return this.myName;
        }

        public System setName(CodeDt theValue) {
            this.myName = theValue;
            return this;
        }

        public System setName(String theCode) {
            this.myName = new CodeDt(theCode);
            return this;
        }

        public StringDt getIdentity() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public StringDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public System setIdentity(StringDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public System setIdentity(String theString) {
            this.myIdentity = new StringDt(theString);
            return this;
        }
    }
}

