/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.resource.ValueSet;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.QuestionnaireGroupNameEnum;
import ca.uhn.fhir.model.dstu.valueset.QuestionnaireNameEnum;
import ca.uhn.fhir.model.dstu.valueset.QuestionnaireStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Questionnaire", profile="http://hl7.org/fhir/profiles/Questionnaire", id="questionnaire")
public class Questionnaire
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="status", path="Questionnaire.status", description="The status of the questionnaire", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="authored", path="Questionnaire.authored", description="When the questionnaire was authored", type="date")
    public static final String SP_AUTHORED = "authored";
    public static final DateClientParam AUTHORED = new DateClientParam("authored");
    @SearchParamDefinition(name="subject", path="Questionnaire.subject", description="The subject of the questionnaire", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Questionnaire.subject");
    @SearchParamDefinition(name="author", path="Questionnaire.author", description="The author of the questionnaire", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Questionnaire.author");
    @SearchParamDefinition(name="identifier", path="Questionnaire.identifier", description="An identifier for the questionnaire", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Questionnaire.name", description="Name of the questionnaire", type="token")
    public static final String SP_NAME = "name";
    public static final TokenClientParam NAME = new TokenClientParam("name");
    @SearchParamDefinition(name="encounter", path="Questionnaire.encounter", description="Encounter during which questionnaire was authored", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Questionnaire.encounter");
    @Child(name="status", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="draft | published | retired | in progress | completed | amended", formalDefinition="The lifecycle status of the questionnaire as a whole.")
    private BoundCodeDt<QuestionnaireStatusEnum> myStatus;
    @Child(name="authored", type={DateTimeDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Date this version was authored", formalDefinition="The date and/or time that this version of the questionnaire was authored")
    private DateTimeDt myAuthored;
    @Child(name="subject", order=2, min=0, max=1, summary=true, modifier=false, type={Patient.class, RelatedPerson.class})
    @Description(shortDefinition="The subject of the questions", formalDefinition="The subject of the questionnaires: this is the patient that the answers apply to, but this person is not necessarily the source of information")
    private ResourceReferenceDt mySubject;
    @Child(name="author", order=3, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Person who received and recorded the answers", formalDefinition="Person who received the answers to the questions in the Questionnaire and recorded them in the system")
    private ResourceReferenceDt myAuthor;
    @Child(name="source", order=4, min=0, max=1, summary=true, modifier=false, type={Patient.class, Practitioner.class, RelatedPerson.class})
    @Description(shortDefinition="The person who answered the questions", formalDefinition="The person who answered the questions about the subject. Only used when this is not the subject him/herself")
    private ResourceReferenceDt mySource;
    @Child(name="name", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Name/code for a predefined list of questions", formalDefinition="Structured name for a predefined list of questions this questionnaire is responding to")
    private BoundCodeableConceptDt<QuestionnaireNameEnum> myName;
    @Child(name="identifier", type={IdentifierDt.class}, order=6, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="External Ids for this questionnaire", formalDefinition="This records identifiers associated with this question/answer set that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="encounter", order=7, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="Primary encounter during which the answers were collected", formalDefinition="Encounter during which this questionnaire answers were collected. When there were multiple encounters, this is the one considered most relevant to the context of the answers.")
    private ResourceReferenceDt myEncounter;
    @Child(name="group", order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Grouped questions", formalDefinition="A group of questions to a possibly similarly grouped set of questions in the questionnaire")
    private Group myGroup;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myStatus, this.myAuthored, this.mySubject, this.myAuthor, this.mySource, this.myName, this.myIdentifier, this.myEncounter, this.myGroup});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStatus, this.myAuthored, this.mySubject, this.myAuthor, this.mySource, this.myName, this.myIdentifier, this.myEncounter, this.myGroup});
    }

    public BoundCodeDt<QuestionnaireStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(QuestionnaireStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<QuestionnaireStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(QuestionnaireStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Questionnaire setStatus(BoundCodeDt<QuestionnaireStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Questionnaire setStatus(QuestionnaireStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public DateTimeDt getAuthored() {
        if (this.myAuthored == null) {
            this.myAuthored = new DateTimeDt();
        }
        return this.myAuthored;
    }

    public DateTimeDt getAuthoredElement() {
        if (this.myAuthored == null) {
            this.myAuthored = new DateTimeDt();
        }
        return this.myAuthored;
    }

    public Questionnaire setAuthored(DateTimeDt theValue) {
        this.myAuthored = theValue;
        return this;
    }

    public Questionnaire setAuthored(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myAuthored = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Questionnaire setAuthoredWithSecondsPrecision(Date theDate) {
        this.myAuthored = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Questionnaire setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public ResourceReferenceDt getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public Questionnaire setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public ResourceReferenceDt getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public Questionnaire setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public BoundCodeableConceptDt<QuestionnaireNameEnum> getName() {
        if (this.myName == null) {
            this.myName = new BoundCodeableConceptDt<QuestionnaireNameEnum>(QuestionnaireNameEnum.VALUESET_BINDER);
        }
        return this.myName;
    }

    public BoundCodeableConceptDt<QuestionnaireNameEnum> getNameElement() {
        if (this.myName == null) {
            this.myName = new BoundCodeableConceptDt<QuestionnaireNameEnum>(QuestionnaireNameEnum.VALUESET_BINDER);
        }
        return this.myName;
    }

    public Questionnaire setName(BoundCodeableConceptDt<QuestionnaireNameEnum> theValue) {
        this.myName = theValue;
        return this;
    }

    public Questionnaire setName(QuestionnaireNameEnum theValue) {
        this.getName().setValueAsEnum(theValue);
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Questionnaire setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Questionnaire addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Questionnaire addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ResourceReferenceDt getEncounterElement() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Questionnaire setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public Group getGroup() {
        if (this.myGroup == null) {
            this.myGroup = new Group();
        }
        return this.myGroup;
    }

    public Group getGroupElement() {
        if (this.myGroup == null) {
            this.myGroup = new Group();
        }
        return this.myGroup;
    }

    public Questionnaire setGroup(Group theValue) {
        this.myGroup = theValue;
        return this;
    }

    public String getResourceName() {
        return "Questionnaire";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class GroupQuestion
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Code or name of the question", formalDefinition="Structured name for the question that identifies this question within the Questionnaire or Group")
        private CodeableConceptDt myName;
        @Child(name="text", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Text of the question as it is shown to the user", formalDefinition="")
        private StringDt myText;
        @Child(name="answer", order=2, min=0, max=1, summary=false, modifier=false, type={DecimalDt.class, IntegerDt.class, BooleanDt.class, DateDt.class, StringDt.class, DateTimeDt.class, InstantDt.class})
        @Description(shortDefinition="Single-valued answer to the question", formalDefinition="Single-valued answer to the question")
        private IDatatype myAnswer;
        @Child(name="choice", type={CodingDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Selected options", formalDefinition="Selections made by the user from the list of options")
        private List<CodingDt> myChoice;
        @Child(name="options", order=4, min=0, max=1, summary=false, modifier=false, type={ValueSet.class})
        @Description(shortDefinition="Valueset containing the possible options", formalDefinition="Reference to a valueset containing the possible options")
        private ResourceReferenceDt myOptions;
        @Child(name="data", type={IDatatype.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Structured answer", formalDefinition="Structured answer in the form of a FHIR Resource or datatype")
        private IDatatype myData;
        @Child(name="remarks", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Remarks about the answer given", formalDefinition="The remark contains information about the answer given. This is additional information about the answer the author wishes to convey, but should not be used to contain information that is part of the answer itself.")
        private StringDt myRemarks;
        @Child(name="group", type={Group.class}, order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Nested questionnaire group", formalDefinition="Nested group, containing nested question for this question. The order of groups within the question is relevant")
        private List<Group> myGroup;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myText, this.myAnswer, this.myChoice, this.myOptions, this.myData, this.myRemarks, this.myGroup});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myText, this.myAnswer, this.myChoice, this.myOptions, this.myData, this.myRemarks, this.myGroup});
        }

        public CodeableConceptDt getName() {
            if (this.myName == null) {
                this.myName = new CodeableConceptDt();
            }
            return this.myName;
        }

        public CodeableConceptDt getNameElement() {
            if (this.myName == null) {
                this.myName = new CodeableConceptDt();
            }
            return this.myName;
        }

        public GroupQuestion setName(CodeableConceptDt theValue) {
            this.myName = theValue;
            return this;
        }

        public StringDt getText() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public GroupQuestion setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public GroupQuestion setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public IDatatype getAnswer() {
            return this.myAnswer;
        }

        public IDatatype getAnswerElement() {
            return this.myAnswer;
        }

        public GroupQuestion setAnswer(IDatatype theValue) {
            this.myAnswer = theValue;
            return this;
        }

        public List<CodingDt> getChoice() {
            if (this.myChoice == null) {
                this.myChoice = new ArrayList<CodingDt>();
            }
            return this.myChoice;
        }

        public List<CodingDt> getChoiceElement() {
            if (this.myChoice == null) {
                this.myChoice = new ArrayList<CodingDt>();
            }
            return this.myChoice;
        }

        public GroupQuestion setChoice(List<CodingDt> theValue) {
            this.myChoice = theValue;
            return this;
        }

        public CodingDt addChoice() {
            CodingDt newType = new CodingDt();
            this.getChoice().add(newType);
            return newType;
        }

        public CodingDt getChoiceFirstRep() {
            if (this.getChoice().isEmpty()) {
                return this.addChoice();
            }
            return this.getChoice().get(0);
        }

        public ResourceReferenceDt getOptions() {
            if (this.myOptions == null) {
                this.myOptions = new ResourceReferenceDt();
            }
            return this.myOptions;
        }

        public ResourceReferenceDt getOptionsElement() {
            if (this.myOptions == null) {
                this.myOptions = new ResourceReferenceDt();
            }
            return this.myOptions;
        }

        public GroupQuestion setOptions(ResourceReferenceDt theValue) {
            this.myOptions = theValue;
            return this;
        }

        public IDatatype getData() {
            return this.myData;
        }

        public IDatatype getDataElement() {
            return this.myData;
        }

        public GroupQuestion setData(IDatatype theValue) {
            this.myData = theValue;
            return this;
        }

        public StringDt getRemarks() {
            if (this.myRemarks == null) {
                this.myRemarks = new StringDt();
            }
            return this.myRemarks;
        }

        public StringDt getRemarksElement() {
            if (this.myRemarks == null) {
                this.myRemarks = new StringDt();
            }
            return this.myRemarks;
        }

        public GroupQuestion setRemarks(StringDt theValue) {
            this.myRemarks = theValue;
            return this;
        }

        public GroupQuestion setRemarks(String theString) {
            this.myRemarks = new StringDt(theString);
            return this;
        }

        public List<Group> getGroup() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Group>();
            }
            return this.myGroup;
        }

        public List<Group> getGroupElement() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Group>();
            }
            return this.myGroup;
        }

        public GroupQuestion setGroup(List<Group> theValue) {
            this.myGroup = theValue;
            return this;
        }

        public Group addGroup() {
            Group newType = new Group();
            this.getGroup().add(newType);
            return newType;
        }

        public Group getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                return this.addGroup();
            }
            return this.getGroup().get(0);
        }
    }

    @Block
    public static class Group
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Code or name of the section on a questionnaire", formalDefinition="Structured name for a section of a predefined list of questions this questionnaire is responding to.")
        private BoundCodeableConceptDt<QuestionnaireGroupNameEnum> myName;
        @Child(name="header", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Text that is displayed above the contents of the group", formalDefinition="")
        private StringDt myHeader;
        @Child(name="text", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Additional text for the group", formalDefinition="Additional text for the group, used for display purposes")
        private StringDt myText;
        @Child(name="subject", order=3, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="The subject this group's answers are about", formalDefinition="More specific subject this section's answers are about, details the subject given in Questionnaire")
        private ResourceReferenceDt mySubject;
        @Child(name="group", type={Group.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Nested questionnaire group", formalDefinition="A sub-group within a group. The ordering of groups within this group is relevant")
        private List<Group> myGroup;
        @Child(name="question", order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Questions in this group", formalDefinition="Set of questions within this group. The order of questions within the group is relevant")
        private List<GroupQuestion> myQuestion;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myHeader, this.myText, this.mySubject, this.myGroup, this.myQuestion});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myHeader, this.myText, this.mySubject, this.myGroup, this.myQuestion});
        }

        public BoundCodeableConceptDt<QuestionnaireGroupNameEnum> getName() {
            if (this.myName == null) {
                this.myName = new BoundCodeableConceptDt<QuestionnaireGroupNameEnum>(QuestionnaireGroupNameEnum.VALUESET_BINDER);
            }
            return this.myName;
        }

        public BoundCodeableConceptDt<QuestionnaireGroupNameEnum> getNameElement() {
            if (this.myName == null) {
                this.myName = new BoundCodeableConceptDt<QuestionnaireGroupNameEnum>(QuestionnaireGroupNameEnum.VALUESET_BINDER);
            }
            return this.myName;
        }

        public Group setName(BoundCodeableConceptDt<QuestionnaireGroupNameEnum> theValue) {
            this.myName = theValue;
            return this;
        }

        public Group setName(QuestionnaireGroupNameEnum theValue) {
            this.getName().setValueAsEnum(theValue);
            return this;
        }

        public StringDt getHeader() {
            if (this.myHeader == null) {
                this.myHeader = new StringDt();
            }
            return this.myHeader;
        }

        public StringDt getHeaderElement() {
            if (this.myHeader == null) {
                this.myHeader = new StringDt();
            }
            return this.myHeader;
        }

        public Group setHeader(StringDt theValue) {
            this.myHeader = theValue;
            return this;
        }

        public Group setHeader(String theString) {
            this.myHeader = new StringDt(theString);
            return this;
        }

        public StringDt getText() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public Group setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Group setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getSubject() {
            if (this.mySubject == null) {
                this.mySubject = new ResourceReferenceDt();
            }
            return this.mySubject;
        }

        public ResourceReferenceDt getSubjectElement() {
            if (this.mySubject == null) {
                this.mySubject = new ResourceReferenceDt();
            }
            return this.mySubject;
        }

        public Group setSubject(ResourceReferenceDt theValue) {
            this.mySubject = theValue;
            return this;
        }

        public List<Group> getGroup() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Group>();
            }
            return this.myGroup;
        }

        public List<Group> getGroupElement() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Group>();
            }
            return this.myGroup;
        }

        public Group setGroup(List<Group> theValue) {
            this.myGroup = theValue;
            return this;
        }

        public Group addGroup() {
            Group newType = new Group();
            this.getGroup().add(newType);
            return newType;
        }

        public Group getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                return this.addGroup();
            }
            return this.getGroup().get(0);
        }

        public List<GroupQuestion> getQuestion() {
            if (this.myQuestion == null) {
                this.myQuestion = new ArrayList<GroupQuestion>();
            }
            return this.myQuestion;
        }

        public List<GroupQuestion> getQuestionElement() {
            if (this.myQuestion == null) {
                this.myQuestion = new ArrayList<GroupQuestion>();
            }
            return this.myQuestion;
        }

        public Group setQuestion(List<GroupQuestion> theValue) {
            this.myQuestion = theValue;
            return this;
        }

        public GroupQuestion addQuestion() {
            GroupQuestion newType = new GroupQuestion();
            this.getQuestion().add(newType);
            return newType;
        }

        public GroupQuestion getQuestionFirstRep() {
            if (this.getQuestion().isEmpty()) {
                return this.addQuestion();
            }
            return this.getQuestion().get(0);
        }
    }
}

