/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.valueset.QueryOutcomeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Query", profile="http://hl7.org/fhir/profiles/Query", id="query")
public class Query
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Query.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="response", path="Query.response.identifier", description="", type="token")
    public static final String SP_RESPONSE = "response";
    public static final TokenClientParam RESPONSE = new TokenClientParam("response");
    @Child(name="identifier", type={UriDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Links query and its response(s)", formalDefinition="")
    private UriDt myIdentifier;
    @Child(name="parameter", type={ExtensionDt.class}, order=1, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Set of query parameters with values", formalDefinition="")
    private List<ExtensionDt> myParameter;
    @Child(name="response", order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="If this is a response to a query", formalDefinition="")
    private Response myResponse;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myParameter, this.myResponse});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myParameter, this.myResponse});
    }

    public UriDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new UriDt();
        }
        return this.myIdentifier;
    }

    public UriDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new UriDt();
        }
        return this.myIdentifier;
    }

    public Query setIdentifier(UriDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Query setIdentifier(String theUri) {
        this.myIdentifier = new UriDt(theUri);
        return this;
    }

    public List<ExtensionDt> getParameter() {
        if (this.myParameter == null) {
            this.myParameter = new ArrayList<ExtensionDt>();
        }
        return this.myParameter;
    }

    public List<ExtensionDt> getParameterElement() {
        if (this.myParameter == null) {
            this.myParameter = new ArrayList<ExtensionDt>();
        }
        return this.myParameter;
    }

    public Query setParameter(List<ExtensionDt> theValue) {
        this.myParameter = theValue;
        return this;
    }

    public ExtensionDt addParameter() {
        ExtensionDt newType = new ExtensionDt();
        this.getParameter().add(newType);
        return newType;
    }

    public ExtensionDt getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            return this.addParameter();
        }
        return this.getParameter().get(0);
    }

    public Response getResponse() {
        if (this.myResponse == null) {
            this.myResponse = new Response();
        }
        return this.myResponse;
    }

    public Response getResponseElement() {
        if (this.myResponse == null) {
            this.myResponse = new Response();
        }
        return this.myResponse;
    }

    public Query setResponse(Response theValue) {
        this.myResponse = theValue;
        return this;
    }

    public String getResourceName() {
        return "Query";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Response
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={UriDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Links response to source query", formalDefinition="")
        private UriDt myIdentifier;
        @Child(name="outcome", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="ok | limited | refused | error", formalDefinition="Outcome of processing the query")
        private BoundCodeDt<QueryOutcomeEnum> myOutcome;
        @Child(name="total", type={IntegerDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Total number of matching records", formalDefinition="")
        private IntegerDt myTotal;
        @Child(name="parameter", type={ExtensionDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Parameters server used", formalDefinition="")
        private List<ExtensionDt> myParameter;
        @Child(name="first", type={ExtensionDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="To get first page (if paged)", formalDefinition="")
        private List<ExtensionDt> myFirst;
        @Child(name="previous", type={ExtensionDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="To get previous page (if paged)", formalDefinition="")
        private List<ExtensionDt> myPrevious;
        @Child(name="next", type={ExtensionDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="To get next page (if paged)", formalDefinition="")
        private List<ExtensionDt> myNext;
        @Child(name="last", type={ExtensionDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="To get last page (if paged)", formalDefinition="")
        private List<ExtensionDt> myLast;
        @Child(name="reference", order=8, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="Resources that are the results of the search", formalDefinition="")
        private List<ResourceReferenceDt> myReference;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myOutcome, this.myTotal, this.myParameter, this.myFirst, this.myPrevious, this.myNext, this.myLast, this.myReference});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myOutcome, this.myTotal, this.myParameter, this.myFirst, this.myPrevious, this.myNext, this.myLast, this.myReference});
        }

        public UriDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new UriDt();
            }
            return this.myIdentifier;
        }

        public UriDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new UriDt();
            }
            return this.myIdentifier;
        }

        public Response setIdentifier(UriDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Response setIdentifier(String theUri) {
            this.myIdentifier = new UriDt(theUri);
            return this;
        }

        public BoundCodeDt<QueryOutcomeEnum> getOutcome() {
            if (this.myOutcome == null) {
                this.myOutcome = new BoundCodeDt(QueryOutcomeEnum.VALUESET_BINDER);
            }
            return this.myOutcome;
        }

        public BoundCodeDt<QueryOutcomeEnum> getOutcomeElement() {
            if (this.myOutcome == null) {
                this.myOutcome = new BoundCodeDt(QueryOutcomeEnum.VALUESET_BINDER);
            }
            return this.myOutcome;
        }

        public Response setOutcome(BoundCodeDt<QueryOutcomeEnum> theValue) {
            this.myOutcome = theValue;
            return this;
        }

        public Response setOutcome(QueryOutcomeEnum theValue) {
            this.getOutcome().setValueAsEnum((Enum)theValue);
            return this;
        }

        public IntegerDt getTotal() {
            if (this.myTotal == null) {
                this.myTotal = new IntegerDt();
            }
            return this.myTotal;
        }

        public IntegerDt getTotalElement() {
            if (this.myTotal == null) {
                this.myTotal = new IntegerDt();
            }
            return this.myTotal;
        }

        public Response setTotal(IntegerDt theValue) {
            this.myTotal = theValue;
            return this;
        }

        public Response setTotal(int theInteger) {
            this.myTotal = new IntegerDt(theInteger);
            return this;
        }

        public List<ExtensionDt> getParameter() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<ExtensionDt>();
            }
            return this.myParameter;
        }

        public List<ExtensionDt> getParameterElement() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<ExtensionDt>();
            }
            return this.myParameter;
        }

        public Response setParameter(List<ExtensionDt> theValue) {
            this.myParameter = theValue;
            return this;
        }

        public ExtensionDt addParameter() {
            ExtensionDt newType = new ExtensionDt();
            this.getParameter().add(newType);
            return newType;
        }

        public ExtensionDt getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                return this.addParameter();
            }
            return this.getParameter().get(0);
        }

        public List<ExtensionDt> getFirst() {
            if (this.myFirst == null) {
                this.myFirst = new ArrayList<ExtensionDt>();
            }
            return this.myFirst;
        }

        public List<ExtensionDt> getFirstElement() {
            if (this.myFirst == null) {
                this.myFirst = new ArrayList<ExtensionDt>();
            }
            return this.myFirst;
        }

        public Response setFirst(List<ExtensionDt> theValue) {
            this.myFirst = theValue;
            return this;
        }

        public ExtensionDt addFirst() {
            ExtensionDt newType = new ExtensionDt();
            this.getFirst().add(newType);
            return newType;
        }

        public ExtensionDt getFirstFirstRep() {
            if (this.getFirst().isEmpty()) {
                return this.addFirst();
            }
            return this.getFirst().get(0);
        }

        public List<ExtensionDt> getPrevious() {
            if (this.myPrevious == null) {
                this.myPrevious = new ArrayList<ExtensionDt>();
            }
            return this.myPrevious;
        }

        public List<ExtensionDt> getPreviousElement() {
            if (this.myPrevious == null) {
                this.myPrevious = new ArrayList<ExtensionDt>();
            }
            return this.myPrevious;
        }

        public Response setPrevious(List<ExtensionDt> theValue) {
            this.myPrevious = theValue;
            return this;
        }

        public ExtensionDt addPrevious() {
            ExtensionDt newType = new ExtensionDt();
            this.getPrevious().add(newType);
            return newType;
        }

        public ExtensionDt getPreviousFirstRep() {
            if (this.getPrevious().isEmpty()) {
                return this.addPrevious();
            }
            return this.getPrevious().get(0);
        }

        public List<ExtensionDt> getNext() {
            if (this.myNext == null) {
                this.myNext = new ArrayList<ExtensionDt>();
            }
            return this.myNext;
        }

        public List<ExtensionDt> getNextElement() {
            if (this.myNext == null) {
                this.myNext = new ArrayList<ExtensionDt>();
            }
            return this.myNext;
        }

        public Response setNext(List<ExtensionDt> theValue) {
            this.myNext = theValue;
            return this;
        }

        public ExtensionDt addNext() {
            ExtensionDt newType = new ExtensionDt();
            this.getNext().add(newType);
            return newType;
        }

        public ExtensionDt getNextFirstRep() {
            if (this.getNext().isEmpty()) {
                return this.addNext();
            }
            return this.getNext().get(0);
        }

        public List<ExtensionDt> getLast() {
            if (this.myLast == null) {
                this.myLast = new ArrayList<ExtensionDt>();
            }
            return this.myLast;
        }

        public List<ExtensionDt> getLastElement() {
            if (this.myLast == null) {
                this.myLast = new ArrayList<ExtensionDt>();
            }
            return this.myLast;
        }

        public Response setLast(List<ExtensionDt> theValue) {
            this.myLast = theValue;
            return this;
        }

        public ExtensionDt addLast() {
            ExtensionDt newType = new ExtensionDt();
            this.getLast().add(newType);
            return newType;
        }

        public ExtensionDt getLastFirstRep() {
            if (this.getLast().isEmpty()) {
                return this.addLast();
            }
            return this.getLast().get(0);
        }

        public List<ResourceReferenceDt> getReference() {
            if (this.myReference == null) {
                this.myReference = new ArrayList<ResourceReferenceDt>();
            }
            return this.myReference;
        }

        public List<ResourceReferenceDt> getReferenceElement() {
            if (this.myReference == null) {
                this.myReference = new ArrayList<ResourceReferenceDt>();
            }
            return this.myReference;
        }

        public Response setReference(List<ResourceReferenceDt> theValue) {
            this.myReference = theValue;
            return this;
        }

        public ResourceReferenceDt addReference() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getReference().add(newType);
            return newType;
        }
    }
}

