/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Microarray", profile="http://hl7.org/fhir/profiles/Microarray", id="microarray")
public class Microarray
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="Microarray.subject.patient", description="Patient described by the microarray", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_SUBJECT_PATIENT = new Include("Microarray.subject.patient");
    @SearchParamDefinition(name="gene", path="Microarray.sample.gene.identity", description="Gene studied in the microarray", type="string")
    public static final String SP_GENE = "gene";
    public static final StringClientParam GENE = new StringClientParam("gene");
    @SearchParamDefinition(name="coordinate", path="Microarray.sample.gene.coordinate", description="Coordinate of the gene", type="string")
    public static final String SP_COORDINATE = "coordinate";
    public static final StringClientParam COORDINATE = new StringClientParam("coordinate");
    @Child(name="subject", order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Subject of the microarray", formalDefinition="Subject of the microarray")
    private List<Subject> mySubject;
    @Child(name="organization", order=1, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="Organization", formalDefinition="Organization that does the microarray")
    private ResourceReferenceDt myOrganization;
    @Child(name="date", type={DateDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date", formalDefinition="Date when result of the microarray is updated")
    private DateDt myDate;
    @Child(name="scanner", order=3, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Scanner", formalDefinition="Scanner used in the microarray")
    private Scanner myScanner;
    @Child(name="sample", order=4, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Sample", formalDefinition="Sample of a grid on the chip")
    private List<Sample> mySample;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.myOrganization, this.myDate, this.myScanner, this.mySample});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myOrganization, this.myDate, this.myScanner, this.mySample});
    }

    public List<Subject> getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ArrayList<Subject>();
        }
        return this.mySubject;
    }

    public List<Subject> getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ArrayList<Subject>();
        }
        return this.mySubject;
    }

    public Microarray setSubject(List<Subject> theValue) {
        this.mySubject = theValue;
        return this;
    }

    public Subject addSubject() {
        Subject newType = new Subject();
        this.getSubject().add(newType);
        return newType;
    }

    public Subject getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            return this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public ResourceReferenceDt getOrganizationElement() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public Microarray setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public DateDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public DateDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public Microarray setDate(DateDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Microarray setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public Microarray setDateWithDayPrecision(Date theDate) {
        this.myDate = new DateDt(theDate);
        return this;
    }

    public Scanner getScanner() {
        if (this.myScanner == null) {
            this.myScanner = new Scanner();
        }
        return this.myScanner;
    }

    public Scanner getScannerElement() {
        if (this.myScanner == null) {
            this.myScanner = new Scanner();
        }
        return this.myScanner;
    }

    public Microarray setScanner(Scanner theValue) {
        this.myScanner = theValue;
        return this;
    }

    public List<Sample> getSample() {
        if (this.mySample == null) {
            this.mySample = new ArrayList<Sample>();
        }
        return this.mySample;
    }

    public List<Sample> getSampleElement() {
        if (this.mySample == null) {
            this.mySample = new ArrayList<Sample>();
        }
        return this.mySample;
    }

    public Microarray setSample(List<Sample> theValue) {
        this.mySample = theValue;
        return this;
    }

    public Sample addSample() {
        Sample newType = new Sample();
        this.getSample().add(newType);
        return newType;
    }

    public Sample getSampleFirstRep() {
        if (this.getSample().isEmpty()) {
            return this.addSample();
        }
        return this.getSample().get(0);
    }

    public String getResourceName() {
        return "Microarray";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class SampleGeneCoordinate
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="chromosome", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Chromosome", formalDefinition="Chromosome")
        private StringDt myChromosome;
        @Child(name="start", type={IntegerDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Start position", formalDefinition="Start position")
        private IntegerDt myStart;
        @Child(name="end", type={IntegerDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="End position", formalDefinition="End position")
        private IntegerDt myEnd;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myChromosome, this.myStart, this.myEnd});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myChromosome, this.myStart, this.myEnd});
        }

        public StringDt getChromosome() {
            if (this.myChromosome == null) {
                this.myChromosome = new StringDt();
            }
            return this.myChromosome;
        }

        public StringDt getChromosomeElement() {
            if (this.myChromosome == null) {
                this.myChromosome = new StringDt();
            }
            return this.myChromosome;
        }

        public SampleGeneCoordinate setChromosome(StringDt theValue) {
            this.myChromosome = theValue;
            return this;
        }

        public SampleGeneCoordinate setChromosome(String theString) {
            this.myChromosome = new StringDt(theString);
            return this;
        }

        public IntegerDt getStart() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public IntegerDt getStartElement() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public SampleGeneCoordinate setStart(IntegerDt theValue) {
            this.myStart = theValue;
            return this;
        }

        public SampleGeneCoordinate setStart(int theInteger) {
            this.myStart = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getEnd() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public IntegerDt getEndElement() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public SampleGeneCoordinate setEnd(IntegerDt theValue) {
            this.myEnd = theValue;
            return this;
        }

        public SampleGeneCoordinate setEnd(int theInteger) {
            this.myEnd = new IntegerDt(theInteger);
            return this;
        }
    }

    @Block
    public static class SampleGene
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identity", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifier of the gene", formalDefinition="Identifier of the gene")
        private StringDt myIdentity;
        @Child(name="coordinate", order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Coordinate of the gene", formalDefinition="Coordinate of the gene")
        private SampleGeneCoordinate myCoordinate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentity, this.myCoordinate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentity, this.myCoordinate});
        }

        public StringDt getIdentity() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public StringDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public SampleGene setIdentity(StringDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public SampleGene setIdentity(String theString) {
            this.myIdentity = new StringDt(theString);
            return this;
        }

        public SampleGeneCoordinate getCoordinate() {
            if (this.myCoordinate == null) {
                this.myCoordinate = new SampleGeneCoordinate();
            }
            return this.myCoordinate;
        }

        public SampleGeneCoordinate getCoordinateElement() {
            if (this.myCoordinate == null) {
                this.myCoordinate = new SampleGeneCoordinate();
            }
            return this.myCoordinate;
        }

        public SampleGene setCoordinate(SampleGeneCoordinate theValue) {
            this.myCoordinate = theValue;
            return this;
        }
    }

    @Block
    public static class SampleSpecimen
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Specimen type", formalDefinition="Type of the specimen")
        private StringDt myType;
        @Child(name="source", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Specimen source", formalDefinition="Source of the specimen")
        private CodeableConceptDt mySource;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.mySource});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.mySource});
        }

        public StringDt getType() {
            if (this.myType == null) {
                this.myType = new StringDt();
            }
            return this.myType;
        }

        public StringDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new StringDt();
            }
            return this.myType;
        }

        public SampleSpecimen setType(StringDt theValue) {
            this.myType = theValue;
            return this;
        }

        public SampleSpecimen setType(String theString) {
            this.myType = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getSource() {
            if (this.mySource == null) {
                this.mySource = new CodeableConceptDt();
            }
            return this.mySource;
        }

        public CodeableConceptDt getSourceElement() {
            if (this.mySource == null) {
                this.mySource = new CodeableConceptDt();
            }
            return this.mySource;
        }

        public SampleSpecimen setSource(CodeableConceptDt theValue) {
            this.mySource = theValue;
            return this;
        }
    }

    @Block
    public static class Sample
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identity", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Id of the sample", formalDefinition="Id of the sample")
        private StringDt myIdentity;
        @Child(name="organism", type={CodeableConceptDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Sample", formalDefinition="Organism that the sample belong s to")
        private CodeableConceptDt myOrganism;
        @Child(name="specimen", order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Organism", formalDefinition="Specimen used on the grid")
        private SampleSpecimen mySpecimen;
        @Child(name="gene", order=3, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Gene of study", formalDefinition="Gene of study")
        private SampleGene myGene;
        @Child(name="intensity", type={DecimalDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Intensity", formalDefinition="Intensity(expression) of the gene")
        private DecimalDt myIntensity;
        @Child(name="isControl", type={BooleanDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Control", formalDefinition="Whether the grid is a control in the experiment")
        private BooleanDt myIsControl;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentity, this.myOrganism, this.mySpecimen, this.myGene, this.myIntensity, this.myIsControl});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentity, this.myOrganism, this.mySpecimen, this.myGene, this.myIntensity, this.myIsControl});
        }

        public StringDt getIdentity() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public StringDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public Sample setIdentity(StringDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public Sample setIdentity(String theString) {
            this.myIdentity = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getOrganism() {
            if (this.myOrganism == null) {
                this.myOrganism = new CodeableConceptDt();
            }
            return this.myOrganism;
        }

        public CodeableConceptDt getOrganismElement() {
            if (this.myOrganism == null) {
                this.myOrganism = new CodeableConceptDt();
            }
            return this.myOrganism;
        }

        public Sample setOrganism(CodeableConceptDt theValue) {
            this.myOrganism = theValue;
            return this;
        }

        public SampleSpecimen getSpecimen() {
            if (this.mySpecimen == null) {
                this.mySpecimen = new SampleSpecimen();
            }
            return this.mySpecimen;
        }

        public SampleSpecimen getSpecimenElement() {
            if (this.mySpecimen == null) {
                this.mySpecimen = new SampleSpecimen();
            }
            return this.mySpecimen;
        }

        public Sample setSpecimen(SampleSpecimen theValue) {
            this.mySpecimen = theValue;
            return this;
        }

        public SampleGene getGene() {
            if (this.myGene == null) {
                this.myGene = new SampleGene();
            }
            return this.myGene;
        }

        public SampleGene getGeneElement() {
            if (this.myGene == null) {
                this.myGene = new SampleGene();
            }
            return this.myGene;
        }

        public Sample setGene(SampleGene theValue) {
            this.myGene = theValue;
            return this;
        }

        public DecimalDt getIntensity() {
            if (this.myIntensity == null) {
                this.myIntensity = new DecimalDt();
            }
            return this.myIntensity;
        }

        public DecimalDt getIntensityElement() {
            if (this.myIntensity == null) {
                this.myIntensity = new DecimalDt();
            }
            return this.myIntensity;
        }

        public Sample setIntensity(DecimalDt theValue) {
            this.myIntensity = theValue;
            return this;
        }

        public Sample setIntensity(long theValue) {
            this.myIntensity = new DecimalDt(theValue);
            return this;
        }

        public Sample setIntensity(double theValue) {
            this.myIntensity = new DecimalDt(theValue);
            return this;
        }

        public Sample setIntensity(BigDecimal theValue) {
            this.myIntensity = new DecimalDt(theValue);
            return this;
        }

        public BooleanDt getIsControl() {
            if (this.myIsControl == null) {
                this.myIsControl = new BooleanDt();
            }
            return this.myIsControl;
        }

        public BooleanDt getIsControlElement() {
            if (this.myIsControl == null) {
                this.myIsControl = new BooleanDt();
            }
            return this.myIsControl;
        }

        public Sample setIsControl(BooleanDt theValue) {
            this.myIsControl = theValue;
            return this;
        }

        public Sample setIsControl(boolean theBoolean) {
            this.myIsControl = new BooleanDt(theBoolean);
            return this;
        }
    }

    @Block
    public static class Scanner
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="manufacturer", order=0, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="Scanner manufacturer", formalDefinition="Manufactuerer of the scanner")
        private ResourceReferenceDt myManufacturer;
        @Child(name="name", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Scanner name", formalDefinition="Name of scanner model")
        private StringDt myName;
        @Child(name="version", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Scanner version", formalDefinition="Version of the model")
        private StringDt myVersion;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myManufacturer, this.myName, this.myVersion});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myManufacturer, this.myName, this.myVersion});
        }

        public ResourceReferenceDt getManufacturer() {
            if (this.myManufacturer == null) {
                this.myManufacturer = new ResourceReferenceDt();
            }
            return this.myManufacturer;
        }

        public ResourceReferenceDt getManufacturerElement() {
            if (this.myManufacturer == null) {
                this.myManufacturer = new ResourceReferenceDt();
            }
            return this.myManufacturer;
        }

        public Scanner setManufacturer(ResourceReferenceDt theValue) {
            this.myManufacturer = theValue;
            return this;
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Scanner setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Scanner setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getVersion() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public Scanner setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public Scanner setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Subject
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="patient", order=0, min=0, max=1, summary=false, modifier=false, type={Patient.class})
        @Description(shortDefinition="Resource that corresponds to the subject", formalDefinition="Resource that corresponds to the subject")
        private ResourceReferenceDt myPatient;
        @Child(name="sampleId", type={StringDt.class}, order=1, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Id of the sample that belongs to the subject", formalDefinition="Id of the sample that belongs to the subject")
        private List<StringDt> mySampleId;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPatient, this.mySampleId});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPatient, this.mySampleId});
        }

        public ResourceReferenceDt getPatient() {
            if (this.myPatient == null) {
                this.myPatient = new ResourceReferenceDt();
            }
            return this.myPatient;
        }

        public ResourceReferenceDt getPatientElement() {
            if (this.myPatient == null) {
                this.myPatient = new ResourceReferenceDt();
            }
            return this.myPatient;
        }

        public Subject setPatient(ResourceReferenceDt theValue) {
            this.myPatient = theValue;
            return this;
        }

        public List<StringDt> getSampleId() {
            if (this.mySampleId == null) {
                this.mySampleId = new ArrayList<StringDt>();
            }
            return this.mySampleId;
        }

        public List<StringDt> getSampleIdElement() {
            if (this.mySampleId == null) {
                this.mySampleId = new ArrayList<StringDt>();
            }
            return this.mySampleId;
        }

        public Subject setSampleId(List<StringDt> theValue) {
            this.mySampleId = theValue;
            return this;
        }

        public StringDt addSampleId() {
            StringDt newType = new StringDt();
            this.getSampleId().add(newType);
            return newType;
        }

        public StringDt getSampleIdFirstRep() {
            if (this.getSampleId().isEmpty()) {
                return this.addSampleId();
            }
            return this.getSampleId().get(0);
        }

        public Subject addSampleId(String theString) {
            if (this.mySampleId == null) {
                this.mySampleId = new ArrayList<StringDt>();
            }
            this.mySampleId.add(new StringDt(theString));
            return this;
        }
    }
}

