/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.OperationOutcome;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ResponseTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="MessageHeader", profile="http://hl7.org/fhir/profiles/MessageHeader", id="messageheader")
public class MessageHeader
extends BaseResource
implements IResource {
    @Child(name="identifier", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Id of this message", formalDefinition="The identifier of this message")
    private IdDt myIdentifier;
    @Child(name="timestamp", type={InstantDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Time that the message was sent", formalDefinition="The time that the message was sent")
    private InstantDt myTimestamp;
    @Child(name="event", type={CodingDt.class}, order=2, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="Code for the event this message represents", formalDefinition="Code that identifies the event this message represents and connects it with it's definition. Events defined as part of the FHIR specification have the system value \"http://hl7.org/fhir/message-type\"")
    private CodingDt myEvent;
    @Child(name="response", order=3, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="If this is a reply to prior message", formalDefinition="Information about the message that this message is a response to.  Only present if this message is a response.")
    private Response myResponse;
    @Child(name="source", order=4, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Message Source Application", formalDefinition="The source application from which this message originated")
    private Source mySource;
    @Child(name="destination", order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Message Destination Application(s)", formalDefinition="The destination application which the message is intended for")
    private List<Destination> myDestination;
    @Child(name="enterer", order=6, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="The source of the data entry", formalDefinition="The person or device that performed the data entry leading to this message. Where there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions")
    private ResourceReferenceDt myEnterer;
    @Child(name="author", order=7, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="The source of the decision", formalDefinition="The logical author of the message - the person or device that decided the described event should happen. Where there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions")
    private ResourceReferenceDt myAuthor;
    @Child(name="receiver", order=8, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="Intended \"real-world\" recipient for the data", formalDefinition="Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.")
    private ResourceReferenceDt myReceiver;
    @Child(name="responsible", order=9, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="Final responsibility for event", formalDefinition="The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party")
    private ResourceReferenceDt myResponsible;
    @Child(name="reason", type={CodeableConceptDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Cause of event", formalDefinition="Coded indication of the cause for the event - indicates  a reason for the occurance of the event that is a focus of this message")
    private CodeableConceptDt myReason;
    @Child(name="data", order=11, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="The actual content of the message", formalDefinition="The actual data of the message - a reference to the root/focus class of the event.")
    private List<ResourceReferenceDt> myData;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myTimestamp, this.myEvent, this.myResponse, this.mySource, this.myDestination, this.myEnterer, this.myAuthor, this.myReceiver, this.myResponsible, this.myReason, this.myData});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myTimestamp, this.myEvent, this.myResponse, this.mySource, this.myDestination, this.myEnterer, this.myAuthor, this.myReceiver, this.myResponsible, this.myReason, this.myData});
    }

    public IdDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdDt();
        }
        return this.myIdentifier;
    }

    public IdDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdDt();
        }
        return this.myIdentifier;
    }

    public MessageHeader setIdentifier(IdDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public MessageHeader setIdentifier(String theId) {
        this.myIdentifier = new IdDt(theId);
        return this;
    }

    public InstantDt getTimestamp() {
        if (this.myTimestamp == null) {
            this.myTimestamp = new InstantDt();
        }
        return this.myTimestamp;
    }

    public InstantDt getTimestampElement() {
        if (this.myTimestamp == null) {
            this.myTimestamp = new InstantDt();
        }
        return this.myTimestamp;
    }

    public MessageHeader setTimestamp(InstantDt theValue) {
        this.myTimestamp = theValue;
        return this;
    }

    public MessageHeader setTimestampWithMillisPrecision(Date theDate) {
        this.myTimestamp = new InstantDt(theDate);
        return this;
    }

    public MessageHeader setTimestamp(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myTimestamp = new InstantDt(theDate, thePrecision);
        return this;
    }

    public CodingDt getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new CodingDt();
        }
        return this.myEvent;
    }

    public CodingDt getEventElement() {
        if (this.myEvent == null) {
            this.myEvent = new CodingDt();
        }
        return this.myEvent;
    }

    public MessageHeader setEvent(CodingDt theValue) {
        this.myEvent = theValue;
        return this;
    }

    public Response getResponse() {
        if (this.myResponse == null) {
            this.myResponse = new Response();
        }
        return this.myResponse;
    }

    public Response getResponseElement() {
        if (this.myResponse == null) {
            this.myResponse = new Response();
        }
        return this.myResponse;
    }

    public MessageHeader setResponse(Response theValue) {
        this.myResponse = theValue;
        return this;
    }

    public Source getSource() {
        if (this.mySource == null) {
            this.mySource = new Source();
        }
        return this.mySource;
    }

    public Source getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new Source();
        }
        return this.mySource;
    }

    public MessageHeader setSource(Source theValue) {
        this.mySource = theValue;
        return this;
    }

    public List<Destination> getDestination() {
        if (this.myDestination == null) {
            this.myDestination = new ArrayList<Destination>();
        }
        return this.myDestination;
    }

    public List<Destination> getDestinationElement() {
        if (this.myDestination == null) {
            this.myDestination = new ArrayList<Destination>();
        }
        return this.myDestination;
    }

    public MessageHeader setDestination(List<Destination> theValue) {
        this.myDestination = theValue;
        return this;
    }

    public Destination addDestination() {
        Destination newType = new Destination();
        this.getDestination().add(newType);
        return newType;
    }

    public Destination getDestinationFirstRep() {
        if (this.getDestination().isEmpty()) {
            return this.addDestination();
        }
        return this.getDestination().get(0);
    }

    public ResourceReferenceDt getEnterer() {
        if (this.myEnterer == null) {
            this.myEnterer = new ResourceReferenceDt();
        }
        return this.myEnterer;
    }

    public ResourceReferenceDt getEntererElement() {
        if (this.myEnterer == null) {
            this.myEnterer = new ResourceReferenceDt();
        }
        return this.myEnterer;
    }

    public MessageHeader setEnterer(ResourceReferenceDt theValue) {
        this.myEnterer = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public ResourceReferenceDt getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public MessageHeader setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt getReceiver() {
        if (this.myReceiver == null) {
            this.myReceiver = new ResourceReferenceDt();
        }
        return this.myReceiver;
    }

    public ResourceReferenceDt getReceiverElement() {
        if (this.myReceiver == null) {
            this.myReceiver = new ResourceReferenceDt();
        }
        return this.myReceiver;
    }

    public MessageHeader setReceiver(ResourceReferenceDt theValue) {
        this.myReceiver = theValue;
        return this;
    }

    public ResourceReferenceDt getResponsible() {
        if (this.myResponsible == null) {
            this.myResponsible = new ResourceReferenceDt();
        }
        return this.myResponsible;
    }

    public ResourceReferenceDt getResponsibleElement() {
        if (this.myResponsible == null) {
            this.myResponsible = new ResourceReferenceDt();
        }
        return this.myResponsible;
    }

    public MessageHeader setResponsible(ResourceReferenceDt theValue) {
        this.myResponsible = theValue;
        return this;
    }

    public CodeableConceptDt getReason() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public CodeableConceptDt getReasonElement() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public MessageHeader setReason(CodeableConceptDt theValue) {
        this.myReason = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getData() {
        if (this.myData == null) {
            this.myData = new ArrayList<ResourceReferenceDt>();
        }
        return this.myData;
    }

    public List<ResourceReferenceDt> getDataElement() {
        if (this.myData == null) {
            this.myData = new ArrayList<ResourceReferenceDt>();
        }
        return this.myData;
    }

    public MessageHeader setData(List<ResourceReferenceDt> theValue) {
        this.myData = theValue;
        return this;
    }

    public ResourceReferenceDt addData() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getData().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "MessageHeader";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Destination
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of system", formalDefinition="Human-readable name for the source system")
        private StringDt myName;
        @Child(name="target", order=1, min=0, max=1, summary=false, modifier=false, type={Device.class})
        @Description(shortDefinition="Particular delivery destination within the destination", formalDefinition="Identifies the target end system in situations where the initial message transmission is to an intermediary system.")
        private ResourceReferenceDt myTarget;
        @Child(name="endpoint", type={UriDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Actual destination address or id", formalDefinition="Indicates where the message should be routed to.")
        private UriDt myEndpoint;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myTarget, this.myEndpoint});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTarget, this.myEndpoint});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Destination setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Destination setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public ResourceReferenceDt getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public Destination setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }

        public UriDt getEndpoint() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public UriDt getEndpointElement() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public Destination setEndpoint(UriDt theValue) {
            this.myEndpoint = theValue;
            return this;
        }

        public Destination setEndpoint(String theUri) {
            this.myEndpoint = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Source
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of system", formalDefinition="Human-readable name for the target system")
        private StringDt myName;
        @Child(name="software", type={StringDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of software running the system", formalDefinition="May include configuration or other information useful in debugging.")
        private StringDt mySoftware;
        @Child(name="version", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Version of software running", formalDefinition="Can convey versions of multiple systems in situations where a message passes through multiple hands.")
        private StringDt myVersion;
        @Child(name="contact", type={ContactDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Human contact for problems", formalDefinition="An e-mail, phone, website or other contact point to use to resolve issues with message communications.")
        private ContactDt myContact;
        @Child(name="endpoint", type={UriDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Actual message source address or id", formalDefinition="Identifies the routing target to send acknowledgements to.")
        private UriDt myEndpoint;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.mySoftware, this.myVersion, this.myContact, this.myEndpoint});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.mySoftware, this.myVersion, this.myContact, this.myEndpoint});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Source setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Source setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getSoftware() {
            if (this.mySoftware == null) {
                this.mySoftware = new StringDt();
            }
            return this.mySoftware;
        }

        public StringDt getSoftwareElement() {
            if (this.mySoftware == null) {
                this.mySoftware = new StringDt();
            }
            return this.mySoftware;
        }

        public Source setSoftware(StringDt theValue) {
            this.mySoftware = theValue;
            return this;
        }

        public Source setSoftware(String theString) {
            this.mySoftware = new StringDt(theString);
            return this;
        }

        public StringDt getVersion() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public Source setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public Source setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public ContactDt getContact() {
            if (this.myContact == null) {
                this.myContact = new ContactDt();
            }
            return this.myContact;
        }

        public ContactDt getContactElement() {
            if (this.myContact == null) {
                this.myContact = new ContactDt();
            }
            return this.myContact;
        }

        public Source setContact(ContactDt theValue) {
            this.myContact = theValue;
            return this;
        }

        public Source setContact(ContactUseEnum theContactUse, String theValue) {
            this.myContact = new ContactDt(theContactUse, theValue);
            return this;
        }

        public Source setContact(String theValue) {
            this.myContact = new ContactDt(theValue);
            return this;
        }

        public UriDt getEndpoint() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public UriDt getEndpointElement() {
            if (this.myEndpoint == null) {
                this.myEndpoint = new UriDt();
            }
            return this.myEndpoint;
        }

        public Source setEndpoint(UriDt theValue) {
            this.myEndpoint = theValue;
            return this;
        }

        public Source setEndpoint(String theUri) {
            this.myEndpoint = new UriDt(theUri);
            return this;
        }
    }

    @Block
    public static class Response
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Id of original message", formalDefinition="The id of the message that this message is a response to")
        private IdDt myIdentifier;
        @Child(name="code", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=true)
        @Description(shortDefinition="ok | transient-error | fatal-error", formalDefinition="Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not")
        private BoundCodeDt<ResponseTypeEnum> myCode;
        @Child(name="details", order=2, min=0, max=1, summary=false, modifier=false, type={OperationOutcome.class})
        @Description(shortDefinition="Specific list of hints/warnings/errors", formalDefinition="Full details of any issues found in the message")
        private ResourceReferenceDt myDetails;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myCode, this.myDetails});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCode, this.myDetails});
        }

        public IdDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdDt();
            }
            return this.myIdentifier;
        }

        public IdDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdDt();
            }
            return this.myIdentifier;
        }

        public Response setIdentifier(IdDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Response setIdentifier(String theId) {
            this.myIdentifier = new IdDt(theId);
            return this;
        }

        public BoundCodeDt<ResponseTypeEnum> getCode() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(ResponseTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public BoundCodeDt<ResponseTypeEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(ResponseTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public Response setCode(BoundCodeDt<ResponseTypeEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public Response setCode(ResponseTypeEnum theValue) {
            this.getCode().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getDetails() {
            if (this.myDetails == null) {
                this.myDetails = new ResourceReferenceDt();
            }
            return this.myDetails;
        }

        public ResourceReferenceDt getDetailsElement() {
            if (this.myDetails == null) {
                this.myDetails = new ResourceReferenceDt();
            }
            return this.myDetails;
        }

        public Response setDetails(ResourceReferenceDt theValue) {
            this.myDetails = theValue;
            return this;
        }
    }
}

