/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.RangeDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Substance;
import ca.uhn.fhir.model.dstu.valueset.GroupTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Group", profile="http://hl7.org/fhir/profiles/Group", id="group")
public class Group
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Group.type", description="The type of resources the group contains", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="code", path="Group.code", description="The kind of resources contained", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="actual", path="Group.actual", description="", type="token")
    public static final String SP_ACTUAL = "actual";
    public static final TokenClientParam ACTUAL = new TokenClientParam("actual");
    @SearchParamDefinition(name="identifier", path="Group.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="member", path="Group.member", description="", type="reference")
    public static final String SP_MEMBER = "member";
    public static final ReferenceClientParam MEMBER = new ReferenceClientParam("member");
    public static final Include INCLUDE_MEMBER = new Include("Group.member");
    @SearchParamDefinition(name="characteristic", path="Group.characteristic.code", description="", type="token")
    public static final String SP_CHARACTERISTIC = "characteristic";
    public static final TokenClientParam CHARACTERISTIC = new TokenClientParam("characteristic");
    @SearchParamDefinition(name="value", path="Group.characteristic.value[x]", description="", type="token")
    public static final String SP_VALUE = "value";
    public static final TokenClientParam VALUE = new TokenClientParam("value");
    @SearchParamDefinition(name="exclude", path="Group.characteristic.exclude", description="", type="token")
    public static final String SP_EXCLUDE = "exclude";
    public static final TokenClientParam EXCLUDE = new TokenClientParam("exclude");
    @SearchParamDefinition(name="characteristic-value", path="characteristic & value", description="A composite of both characteristic and value", type="composite", compositeOf={"characteristic", "value"})
    public static final String SP_CHARACTERISTIC_VALUE = "characteristic-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CHARACTERISTIC_VALUE = new CompositeClientParam("characteristic-value");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Unique id", formalDefinition="A unique business identifier for this group")
    private IdentifierDt myIdentifier;
    @Child(name="type", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="person | animal | practitioner | device | medication | substance", formalDefinition="Identifies the broad classification of the kind of resources the group includes")
    private BoundCodeDt<GroupTypeEnum> myType;
    @Child(name="actual", type={BooleanDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Descriptive or actual", formalDefinition="If true, indicates that the resource refers to a specific group of real individuals.  If false, the group defines a set of intended individuals")
    private BooleanDt myActual;
    @Child(name="code", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Kind of Group members", formalDefinition="Provides a specific type of resource the group includes.  E.g. \"cow\", \"syringe\", etc.")
    private CodeableConceptDt myCode;
    @Child(name="name", type={StringDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Label for Group", formalDefinition="A label assigned to the group for human identification and communication")
    private StringDt myName;
    @Child(name="quantity", type={IntegerDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Number of members", formalDefinition="A count of the number of resource instances that are part of the group")
    private IntegerDt myQuantity;
    @Child(name="characteristic", order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Trait of group members", formalDefinition="Identifies the traits shared by members of the group")
    private List<Characteristic> myCharacteristic;
    @Child(name="member", order=7, min=0, max=-1, summary=false, modifier=false, type={Patient.class, Practitioner.class, Device.class, Medication.class, Substance.class})
    @Description(shortDefinition="Who is in group", formalDefinition="Identifies the resource instances that are members of the group.")
    private List<ResourceReferenceDt> myMember;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.myActual, this.myCode, this.myName, this.myQuantity, this.myCharacteristic, this.myMember});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.myActual, this.myCode, this.myName, this.myQuantity, this.myCharacteristic, this.myMember});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Group setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Group setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Group setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public BoundCodeDt<GroupTypeEnum> getType() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(GroupTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public BoundCodeDt<GroupTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt(GroupTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public Group setType(BoundCodeDt<GroupTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Group setType(GroupTypeEnum theValue) {
        this.getType().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getActual() {
        if (this.myActual == null) {
            this.myActual = new BooleanDt();
        }
        return this.myActual;
    }

    public BooleanDt getActualElement() {
        if (this.myActual == null) {
            this.myActual = new BooleanDt();
        }
        return this.myActual;
    }

    public Group setActual(BooleanDt theValue) {
        this.myActual = theValue;
        return this;
    }

    public Group setActual(boolean theBoolean) {
        this.myActual = new BooleanDt(theBoolean);
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public CodeableConceptDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Group setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public Group setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Group setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public IntegerDt getQuantity() {
        if (this.myQuantity == null) {
            this.myQuantity = new IntegerDt();
        }
        return this.myQuantity;
    }

    public IntegerDt getQuantityElement() {
        if (this.myQuantity == null) {
            this.myQuantity = new IntegerDt();
        }
        return this.myQuantity;
    }

    public Group setQuantity(IntegerDt theValue) {
        this.myQuantity = theValue;
        return this;
    }

    public Group setQuantity(int theInteger) {
        this.myQuantity = new IntegerDt(theInteger);
        return this;
    }

    public List<Characteristic> getCharacteristic() {
        if (this.myCharacteristic == null) {
            this.myCharacteristic = new ArrayList<Characteristic>();
        }
        return this.myCharacteristic;
    }

    public List<Characteristic> getCharacteristicElement() {
        if (this.myCharacteristic == null) {
            this.myCharacteristic = new ArrayList<Characteristic>();
        }
        return this.myCharacteristic;
    }

    public Group setCharacteristic(List<Characteristic> theValue) {
        this.myCharacteristic = theValue;
        return this;
    }

    public Characteristic addCharacteristic() {
        Characteristic newType = new Characteristic();
        this.getCharacteristic().add(newType);
        return newType;
    }

    public Characteristic getCharacteristicFirstRep() {
        if (this.getCharacteristic().isEmpty()) {
            return this.addCharacteristic();
        }
        return this.getCharacteristic().get(0);
    }

    public List<ResourceReferenceDt> getMember() {
        if (this.myMember == null) {
            this.myMember = new ArrayList<ResourceReferenceDt>();
        }
        return this.myMember;
    }

    public List<ResourceReferenceDt> getMemberElement() {
        if (this.myMember == null) {
            this.myMember = new ArrayList<ResourceReferenceDt>();
        }
        return this.myMember;
    }

    public Group setMember(List<ResourceReferenceDt> theValue) {
        this.myMember = theValue;
        return this;
    }

    public ResourceReferenceDt addMember() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getMember().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "Group";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Characteristic
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Kind of characteristic", formalDefinition="A code that identifies the kind of trait being asserted")
        private CodeableConceptDt myCode;
        @Child(name="value", order=1, min=1, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, BooleanDt.class, QuantityDt.class, RangeDt.class})
        @Description(shortDefinition="Value held by characteristic", formalDefinition="The value of the trait that holds (or does not hold - see 'exclude') for members of the group")
        private IDatatype myValue;
        @Child(name="exclude", type={BooleanDt.class}, order=2, min=1, max=1, summary=false, modifier=true)
        @Description(shortDefinition="Group includes or excludes", formalDefinition="If true, indicates the characteristic is one that is NOT held by members of the group")
        private BooleanDt myExclude;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myValue, this.myExclude});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myValue, this.myExclude});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Characteristic setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public IDatatype getValue() {
            return this.myValue;
        }

        public IDatatype getValueElement() {
            return this.myValue;
        }

        public Characteristic setValue(IDatatype theValue) {
            this.myValue = theValue;
            return this;
        }

        public BooleanDt getExclude() {
            if (this.myExclude == null) {
                this.myExclude = new BooleanDt();
            }
            return this.myExclude;
        }

        public BooleanDt getExcludeElement() {
            if (this.myExclude == null) {
                this.myExclude = new BooleanDt();
            }
            return this.myExclude;
        }

        public Characteristic setExclude(BooleanDt theValue) {
            this.myExclude = theValue;
            return this;
        }

        public Characteristic setExclude(boolean theBoolean) {
            this.myExclude = new BooleanDt(theBoolean);
            return this;
        }
    }
}

