/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="GVFMeta", profile="http://hl7.org/fhir/profiles/GVFMeta", id="gvfmeta")
public class GVFMeta
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="GVFMeta.subject.patient", description="Patient being described in the file", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_SUBJECT_PATIENT = new Include("GVFMeta.subject.patient");
    @SearchParamDefinition(name="file", path="GVFMeta.sourceFile", description="URL to source file of the resource", type="string")
    public static final String SP_FILE = "file";
    public static final StringClientParam FILE = new StringClientParam("file");
    @Child(name="subject", order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Subject being described by the file", formalDefinition="Subject being described by the file")
    private List<Subject> mySubject;
    @Child(name="sourceFile", type={AttachmentDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Source GVF file", formalDefinition="GVF file from which data of the resource is extracted")
    private AttachmentDt mySourceFile;
    @Child(name="gvfVersion", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Version of the GVF file", formalDefinition="Valid version of the GVF file")
    private CodeDt myGvfVersion;
    @Child(name="referenceFasta", type={UriDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="FASTA file used as reference assembly", formalDefinition="URL to FASTA file used as reference assembly")
    private UriDt myReferenceFasta;
    @Child(name="featureGFF3", type={UriDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="GFF3 file containing feature being described in the file", formalDefinition="GFF3 file containing feature being described in the file")
    private UriDt myFeatureGFF3;
    @Child(name="fileDate", type={DateDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date when the file is updated", formalDefinition="Date when the file is updated")
    private DateDt myFileDate;
    @Child(name="individual", type={StringDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Id of individual being described in the file", formalDefinition="Id of individual being described in the file")
    private List<StringDt> myIndividual;
    @Child(name="population", type={CodeDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Code for population which the individual can be categorized into", formalDefinition="Code for population which the individual can be categorized into")
    private CodeDt myPopulation;
    @Child(name="platform", order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Sequencing platform", formalDefinition="Technology platform used in the sequencing")
    private Platform myPlatform;
    @Child(name="sequencingScope", type={CodeDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Sequencing scope", formalDefinition="Scope of the sequencing")
    private CodeDt mySequencingScope;
    @Child(name="captureMethod", type={CodeDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Capture method", formalDefinition="Capture method used in the sequencing")
    private CodeDt myCaptureMethod;
    @Child(name="captureRegions", type={UriDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Region captured in the file", formalDefinition="Region captured in the file")
    private UriDt myCaptureRegions;
    @Child(name="sequenceAlignment", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Sequence alignment algorithm/pipline used", formalDefinition="Sequence alignment algorithm/pipline used")
    private StringDt mySequenceAlignment;
    @Child(name="variantCalling", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Pipline used for variant calling", formalDefinition="Pipline used for variant calling")
    private StringDt myVariantCalling;
    @Child(name="sampleDescription", type={StringDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Description of sample used in the sequencing", formalDefinition="Description of sample used in the sequencing")
    private StringDt mySampleDescription;
    @Child(name="genomicSource", type={CodeDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Source of the sample", formalDefinition="Source of the sample")
    private CodeDt myGenomicSource;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.mySourceFile, this.myGvfVersion, this.myReferenceFasta, this.myFeatureGFF3, this.myFileDate, this.myIndividual, this.myPopulation, this.myPlatform, this.mySequencingScope, this.myCaptureMethod, this.myCaptureRegions, this.mySequenceAlignment, this.myVariantCalling, this.mySampleDescription, this.myGenomicSource});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.mySourceFile, this.myGvfVersion, this.myReferenceFasta, this.myFeatureGFF3, this.myFileDate, this.myIndividual, this.myPopulation, this.myPlatform, this.mySequencingScope, this.myCaptureMethod, this.myCaptureRegions, this.mySequenceAlignment, this.myVariantCalling, this.mySampleDescription, this.myGenomicSource});
    }

    public List<Subject> getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ArrayList<Subject>();
        }
        return this.mySubject;
    }

    public List<Subject> getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ArrayList<Subject>();
        }
        return this.mySubject;
    }

    public GVFMeta setSubject(List<Subject> theValue) {
        this.mySubject = theValue;
        return this;
    }

    public Subject addSubject() {
        Subject newType = new Subject();
        this.getSubject().add(newType);
        return newType;
    }

    public Subject getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            return this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public AttachmentDt getSourceFile() {
        if (this.mySourceFile == null) {
            this.mySourceFile = new AttachmentDt();
        }
        return this.mySourceFile;
    }

    public AttachmentDt getSourceFileElement() {
        if (this.mySourceFile == null) {
            this.mySourceFile = new AttachmentDt();
        }
        return this.mySourceFile;
    }

    public GVFMeta setSourceFile(AttachmentDt theValue) {
        this.mySourceFile = theValue;
        return this;
    }

    public CodeDt getGvfVersion() {
        if (this.myGvfVersion == null) {
            this.myGvfVersion = new CodeDt();
        }
        return this.myGvfVersion;
    }

    public CodeDt getGvfVersionElement() {
        if (this.myGvfVersion == null) {
            this.myGvfVersion = new CodeDt();
        }
        return this.myGvfVersion;
    }

    public GVFMeta setGvfVersion(CodeDt theValue) {
        this.myGvfVersion = theValue;
        return this;
    }

    public GVFMeta setGvfVersion(String theCode) {
        this.myGvfVersion = new CodeDt(theCode);
        return this;
    }

    public UriDt getReferenceFasta() {
        if (this.myReferenceFasta == null) {
            this.myReferenceFasta = new UriDt();
        }
        return this.myReferenceFasta;
    }

    public UriDt getReferenceFastaElement() {
        if (this.myReferenceFasta == null) {
            this.myReferenceFasta = new UriDt();
        }
        return this.myReferenceFasta;
    }

    public GVFMeta setReferenceFasta(UriDt theValue) {
        this.myReferenceFasta = theValue;
        return this;
    }

    public GVFMeta setReferenceFasta(String theUri) {
        this.myReferenceFasta = new UriDt(theUri);
        return this;
    }

    public UriDt getFeatureGFF3() {
        if (this.myFeatureGFF3 == null) {
            this.myFeatureGFF3 = new UriDt();
        }
        return this.myFeatureGFF3;
    }

    public UriDt getFeatureGFF3Element() {
        if (this.myFeatureGFF3 == null) {
            this.myFeatureGFF3 = new UriDt();
        }
        return this.myFeatureGFF3;
    }

    public GVFMeta setFeatureGFF3(UriDt theValue) {
        this.myFeatureGFF3 = theValue;
        return this;
    }

    public GVFMeta setFeatureGFF3(String theUri) {
        this.myFeatureGFF3 = new UriDt(theUri);
        return this;
    }

    public DateDt getFileDate() {
        if (this.myFileDate == null) {
            this.myFileDate = new DateDt();
        }
        return this.myFileDate;
    }

    public DateDt getFileDateElement() {
        if (this.myFileDate == null) {
            this.myFileDate = new DateDt();
        }
        return this.myFileDate;
    }

    public GVFMeta setFileDate(DateDt theValue) {
        this.myFileDate = theValue;
        return this;
    }

    public GVFMeta setFileDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myFileDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public GVFMeta setFileDateWithDayPrecision(Date theDate) {
        this.myFileDate = new DateDt(theDate);
        return this;
    }

    public List<StringDt> getIndividual() {
        if (this.myIndividual == null) {
            this.myIndividual = new ArrayList<StringDt>();
        }
        return this.myIndividual;
    }

    public List<StringDt> getIndividualElement() {
        if (this.myIndividual == null) {
            this.myIndividual = new ArrayList<StringDt>();
        }
        return this.myIndividual;
    }

    public GVFMeta setIndividual(List<StringDt> theValue) {
        this.myIndividual = theValue;
        return this;
    }

    public StringDt addIndividual() {
        StringDt newType = new StringDt();
        this.getIndividual().add(newType);
        return newType;
    }

    public StringDt getIndividualFirstRep() {
        if (this.getIndividual().isEmpty()) {
            return this.addIndividual();
        }
        return this.getIndividual().get(0);
    }

    public GVFMeta addIndividual(String theString) {
        if (this.myIndividual == null) {
            this.myIndividual = new ArrayList<StringDt>();
        }
        this.myIndividual.add(new StringDt(theString));
        return this;
    }

    public CodeDt getPopulation() {
        if (this.myPopulation == null) {
            this.myPopulation = new CodeDt();
        }
        return this.myPopulation;
    }

    public CodeDt getPopulationElement() {
        if (this.myPopulation == null) {
            this.myPopulation = new CodeDt();
        }
        return this.myPopulation;
    }

    public GVFMeta setPopulation(CodeDt theValue) {
        this.myPopulation = theValue;
        return this;
    }

    public GVFMeta setPopulation(String theCode) {
        this.myPopulation = new CodeDt(theCode);
        return this;
    }

    public Platform getPlatform() {
        if (this.myPlatform == null) {
            this.myPlatform = new Platform();
        }
        return this.myPlatform;
    }

    public Platform getPlatformElement() {
        if (this.myPlatform == null) {
            this.myPlatform = new Platform();
        }
        return this.myPlatform;
    }

    public GVFMeta setPlatform(Platform theValue) {
        this.myPlatform = theValue;
        return this;
    }

    public CodeDt getSequencingScope() {
        if (this.mySequencingScope == null) {
            this.mySequencingScope = new CodeDt();
        }
        return this.mySequencingScope;
    }

    public CodeDt getSequencingScopeElement() {
        if (this.mySequencingScope == null) {
            this.mySequencingScope = new CodeDt();
        }
        return this.mySequencingScope;
    }

    public GVFMeta setSequencingScope(CodeDt theValue) {
        this.mySequencingScope = theValue;
        return this;
    }

    public GVFMeta setSequencingScope(String theCode) {
        this.mySequencingScope = new CodeDt(theCode);
        return this;
    }

    public CodeDt getCaptureMethod() {
        if (this.myCaptureMethod == null) {
            this.myCaptureMethod = new CodeDt();
        }
        return this.myCaptureMethod;
    }

    public CodeDt getCaptureMethodElement() {
        if (this.myCaptureMethod == null) {
            this.myCaptureMethod = new CodeDt();
        }
        return this.myCaptureMethod;
    }

    public GVFMeta setCaptureMethod(CodeDt theValue) {
        this.myCaptureMethod = theValue;
        return this;
    }

    public GVFMeta setCaptureMethod(String theCode) {
        this.myCaptureMethod = new CodeDt(theCode);
        return this;
    }

    public UriDt getCaptureRegions() {
        if (this.myCaptureRegions == null) {
            this.myCaptureRegions = new UriDt();
        }
        return this.myCaptureRegions;
    }

    public UriDt getCaptureRegionsElement() {
        if (this.myCaptureRegions == null) {
            this.myCaptureRegions = new UriDt();
        }
        return this.myCaptureRegions;
    }

    public GVFMeta setCaptureRegions(UriDt theValue) {
        this.myCaptureRegions = theValue;
        return this;
    }

    public GVFMeta setCaptureRegions(String theUri) {
        this.myCaptureRegions = new UriDt(theUri);
        return this;
    }

    public StringDt getSequenceAlignment() {
        if (this.mySequenceAlignment == null) {
            this.mySequenceAlignment = new StringDt();
        }
        return this.mySequenceAlignment;
    }

    public StringDt getSequenceAlignmentElement() {
        if (this.mySequenceAlignment == null) {
            this.mySequenceAlignment = new StringDt();
        }
        return this.mySequenceAlignment;
    }

    public GVFMeta setSequenceAlignment(StringDt theValue) {
        this.mySequenceAlignment = theValue;
        return this;
    }

    public GVFMeta setSequenceAlignment(String theString) {
        this.mySequenceAlignment = new StringDt(theString);
        return this;
    }

    public StringDt getVariantCalling() {
        if (this.myVariantCalling == null) {
            this.myVariantCalling = new StringDt();
        }
        return this.myVariantCalling;
    }

    public StringDt getVariantCallingElement() {
        if (this.myVariantCalling == null) {
            this.myVariantCalling = new StringDt();
        }
        return this.myVariantCalling;
    }

    public GVFMeta setVariantCalling(StringDt theValue) {
        this.myVariantCalling = theValue;
        return this;
    }

    public GVFMeta setVariantCalling(String theString) {
        this.myVariantCalling = new StringDt(theString);
        return this;
    }

    public StringDt getSampleDescription() {
        if (this.mySampleDescription == null) {
            this.mySampleDescription = new StringDt();
        }
        return this.mySampleDescription;
    }

    public StringDt getSampleDescriptionElement() {
        if (this.mySampleDescription == null) {
            this.mySampleDescription = new StringDt();
        }
        return this.mySampleDescription;
    }

    public GVFMeta setSampleDescription(StringDt theValue) {
        this.mySampleDescription = theValue;
        return this;
    }

    public GVFMeta setSampleDescription(String theString) {
        this.mySampleDescription = new StringDt(theString);
        return this;
    }

    public CodeDt getGenomicSource() {
        if (this.myGenomicSource == null) {
            this.myGenomicSource = new CodeDt();
        }
        return this.myGenomicSource;
    }

    public CodeDt getGenomicSourceElement() {
        if (this.myGenomicSource == null) {
            this.myGenomicSource = new CodeDt();
        }
        return this.myGenomicSource;
    }

    public GVFMeta setGenomicSource(CodeDt theValue) {
        this.myGenomicSource = theValue;
        return this;
    }

    public GVFMeta setGenomicSource(String theCode) {
        this.myGenomicSource = new CodeDt(theCode);
        return this;
    }

    public String getResourceName() {
        return "GVFMeta";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Platform
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="class", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Platform class", formalDefinition="Class of the sequencing platform")
        private CodeDt myClassElement;
        @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Platform version", formalDefinition="Version of the platform being used")
        private StringDt myVersion;
        @Child(name="name", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Platform name", formalDefinition="Name of the platform being used")
        private CodeDt myName;
        @Child(name="identity", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Platform id", formalDefinition="Id of the platfrom being used")
        private StringDt myIdentity;
        @Child(name="readLength", type={IntegerDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Read length", formalDefinition="Read length of the technology")
        private IntegerDt myReadLength;
        @Child(name="readType", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Read type", formalDefinition="Read type of the technology")
        private CodeDt myReadType;
        @Child(name="readPairSpan", type={IntegerDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Read pair span", formalDefinition="Read pair span of the technology")
        private IntegerDt myReadPairSpan;
        @Child(name="averageCoverage", type={IntegerDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Average coverage", formalDefinition="Average coverage of the technology")
        private IntegerDt myAverageCoverage;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myClassElement, this.myVersion, this.myName, this.myIdentity, this.myReadLength, this.myReadType, this.myReadPairSpan, this.myAverageCoverage});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myClassElement, this.myVersion, this.myName, this.myIdentity, this.myReadLength, this.myReadType, this.myReadPairSpan, this.myAverageCoverage});
        }

        public CodeDt getClassElement() {
            if (this.myClassElement == null) {
                this.myClassElement = new CodeDt();
            }
            return this.myClassElement;
        }

        public CodeDt getClassElementElement() {
            if (this.myClassElement == null) {
                this.myClassElement = new CodeDt();
            }
            return this.myClassElement;
        }

        public Platform setClassElement(CodeDt theValue) {
            this.myClassElement = theValue;
            return this;
        }

        public Platform setClassElement(String theCode) {
            this.myClassElement = new CodeDt(theCode);
            return this;
        }

        public StringDt getVersion() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public Platform setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public Platform setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public CodeDt getName() {
            if (this.myName == null) {
                this.myName = new CodeDt();
            }
            return this.myName;
        }

        public CodeDt getNameElement() {
            if (this.myName == null) {
                this.myName = new CodeDt();
            }
            return this.myName;
        }

        public Platform setName(CodeDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Platform setName(String theCode) {
            this.myName = new CodeDt(theCode);
            return this;
        }

        public StringDt getIdentity() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public StringDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public Platform setIdentity(StringDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public Platform setIdentity(String theString) {
            this.myIdentity = new StringDt(theString);
            return this;
        }

        public IntegerDt getReadLength() {
            if (this.myReadLength == null) {
                this.myReadLength = new IntegerDt();
            }
            return this.myReadLength;
        }

        public IntegerDt getReadLengthElement() {
            if (this.myReadLength == null) {
                this.myReadLength = new IntegerDt();
            }
            return this.myReadLength;
        }

        public Platform setReadLength(IntegerDt theValue) {
            this.myReadLength = theValue;
            return this;
        }

        public Platform setReadLength(int theInteger) {
            this.myReadLength = new IntegerDt(theInteger);
            return this;
        }

        public CodeDt getReadType() {
            if (this.myReadType == null) {
                this.myReadType = new CodeDt();
            }
            return this.myReadType;
        }

        public CodeDt getReadTypeElement() {
            if (this.myReadType == null) {
                this.myReadType = new CodeDt();
            }
            return this.myReadType;
        }

        public Platform setReadType(CodeDt theValue) {
            this.myReadType = theValue;
            return this;
        }

        public Platform setReadType(String theCode) {
            this.myReadType = new CodeDt(theCode);
            return this;
        }

        public IntegerDt getReadPairSpan() {
            if (this.myReadPairSpan == null) {
                this.myReadPairSpan = new IntegerDt();
            }
            return this.myReadPairSpan;
        }

        public IntegerDt getReadPairSpanElement() {
            if (this.myReadPairSpan == null) {
                this.myReadPairSpan = new IntegerDt();
            }
            return this.myReadPairSpan;
        }

        public Platform setReadPairSpan(IntegerDt theValue) {
            this.myReadPairSpan = theValue;
            return this;
        }

        public Platform setReadPairSpan(int theInteger) {
            this.myReadPairSpan = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getAverageCoverage() {
            if (this.myAverageCoverage == null) {
                this.myAverageCoverage = new IntegerDt();
            }
            return this.myAverageCoverage;
        }

        public IntegerDt getAverageCoverageElement() {
            if (this.myAverageCoverage == null) {
                this.myAverageCoverage = new IntegerDt();
            }
            return this.myAverageCoverage;
        }

        public Platform setAverageCoverage(IntegerDt theValue) {
            this.myAverageCoverage = theValue;
            return this;
        }

        public Platform setAverageCoverage(int theInteger) {
            this.myAverageCoverage = new IntegerDt(theInteger);
            return this;
        }
    }

    @Block
    public static class Subject
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="patient", order=0, min=0, max=1, summary=false, modifier=false, type={Patient.class})
        @Description(shortDefinition="Identity of the subejct", formalDefinition="Identity of the subejct")
        private ResourceReferenceDt myPatient;
        @Child(name="fieldId", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Id of individual field of the file that correspond to the subject", formalDefinition="Id of individual field of the file that correspond to the subject")
        private StringDt myFieldId;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myPatient, this.myFieldId});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPatient, this.myFieldId});
        }

        public ResourceReferenceDt getPatient() {
            if (this.myPatient == null) {
                this.myPatient = new ResourceReferenceDt();
            }
            return this.myPatient;
        }

        public ResourceReferenceDt getPatientElement() {
            if (this.myPatient == null) {
                this.myPatient = new ResourceReferenceDt();
            }
            return this.myPatient;
        }

        public Subject setPatient(ResourceReferenceDt theValue) {
            this.myPatient = theValue;
            return this;
        }

        public StringDt getFieldId() {
            if (this.myFieldId == null) {
                this.myFieldId = new StringDt();
            }
            return this.myFieldId;
        }

        public StringDt getFieldIdElement() {
            if (this.myFieldId == null) {
                this.myFieldId = new StringDt();
            }
            return this.myFieldId;
        }

        public Subject setFieldId(StringDt theValue) {
            this.myFieldId = theValue;
            return this;
        }

        public Subject setFieldId(String theString) {
            this.myFieldId = new StringDt(theString);
            return this;
        }
    }
}

