/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.DiagnosticOrder;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.ImagingStudy;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Media;
import ca.uhn.fhir.model.dstu.resource.Observation;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Specimen;
import ca.uhn.fhir.model.dstu.valueset.DiagnosticReportStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DiagnosticReport", profile="http://hl7.org/fhir/profiles/DiagnosticReport", id="diagnosticreport")
public class DiagnosticReport
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="status", path="DiagnosticReport.status", description="The status of the report", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="issued", path="DiagnosticReport.issued", description="When the report was issued", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="subject", path="DiagnosticReport.subject", description="The subject of the report", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DiagnosticReport.subject");
    @SearchParamDefinition(name="performer", path="DiagnosticReport.performer", description="Who was the source of the report (organization)", type="reference")
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("DiagnosticReport.performer");
    @SearchParamDefinition(name="identifier", path="DiagnosticReport.identifier", description="An identifier for the report", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="service", path="DiagnosticReport.serviceCategory", description="Which diagnostic discipline/department created the report", type="token")
    public static final String SP_SERVICE = "service";
    public static final TokenClientParam SERVICE = new TokenClientParam("service");
    @SearchParamDefinition(name="date", path="DiagnosticReport.diagnostic[x]", description="The clinically relevant time of the report", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="specimen", path="DiagnosticReport.specimen", description="The specimen details", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("DiagnosticReport.specimen");
    @SearchParamDefinition(name="name", path="DiagnosticReport.name", description="The name of the report (e.g. the code for the report as a whole, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result)", type="token")
    public static final String SP_NAME = "name";
    public static final TokenClientParam NAME = new TokenClientParam("name");
    @SearchParamDefinition(name="result", path="DiagnosticReport.result", description="Link to an atomic result (observation resource)", type="reference")
    public static final String SP_RESULT = "result";
    public static final ReferenceClientParam RESULT = new ReferenceClientParam("result");
    public static final Include INCLUDE_RESULT = new Include("DiagnosticReport.result");
    @SearchParamDefinition(name="diagnosis", path="DiagnosticReport.codedDiagnosis", description="A coded diagnosis on the report", type="token")
    public static final String SP_DIAGNOSIS = "diagnosis";
    public static final TokenClientParam DIAGNOSIS = new TokenClientParam("diagnosis");
    @SearchParamDefinition(name="image", path="DiagnosticReport.image.link", description="", type="reference")
    public static final String SP_IMAGE = "image";
    public static final ReferenceClientParam IMAGE = new ReferenceClientParam("image");
    public static final Include INCLUDE_IMAGE_LINK = new Include("DiagnosticReport.image.link");
    @SearchParamDefinition(name="request", path="DiagnosticReport.requestDetail", description="", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUESTDETAIL = new Include("DiagnosticReport.requestDetail");
    @Child(name="name", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Name/Code for this diagnostic report", formalDefinition="A code or name that describes this diagnostic report")
    private CodeableConceptDt myName;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="registered | partial | final | corrected +", formalDefinition="The status of the diagnostic report as a whole")
    private BoundCodeDt<DiagnosticReportStatusEnum> myStatus;
    @Child(name="issued", type={DateTimeDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Date this version was released", formalDefinition="The date and/or time that this version of the report was released from the source diagnostic service")
    private DateTimeDt myIssued;
    @Child(name="subject", order=3, min=1, max=1, summary=true, modifier=false, type={Patient.class, Group.class, Device.class, Location.class})
    @Description(shortDefinition="The subject of the report, usually, but not always, the patient", formalDefinition="The subject of the report. Usually, but not always, this is a patient. However diagnostic services also perform analyses on specimens collected from a variety of other sources")
    private ResourceReferenceDt mySubject;
    @Child(name="performer", order=4, min=1, max=1, summary=true, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="Responsible Diagnostic Service", formalDefinition="The diagnostic service that is responsible for issuing the report")
    private ResourceReferenceDt myPerformer;
    @Child(name="identifier", type={IdentifierDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Id for external references to this report", formalDefinition="The local ID assigned to the report by the order filler, usually by the Information System of the diagnostic service provider")
    private IdentifierDt myIdentifier;
    @Child(name="requestDetail", order=6, min=0, max=-1, summary=false, modifier=false, type={DiagnosticOrder.class})
    @Description(shortDefinition="What was requested", formalDefinition="Details concerning a test requested.")
    private List<ResourceReferenceDt> myRequestDetail;
    @Child(name="serviceCategory", type={CodeableConceptDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Biochemistry, Hematology etc.", formalDefinition="The section of the diagnostic service that performs the examination e.g. biochemistry, hematology, MRI")
    private CodeableConceptDt myServiceCategory;
    @Child(name="diagnostic", order=8, min=1, max=1, summary=true, modifier=false, type={DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="Physiologically Relevant time/time-period for report", formalDefinition="The time or time-period the observed values are related to. This is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself")
    private IDatatype myDiagnostic;
    @Child(name="specimen", order=9, min=0, max=-1, summary=false, modifier=false, type={Specimen.class})
    @Description(shortDefinition="Specimens this report is based on", formalDefinition="Details about the specimens on which this Disagnostic report is based")
    private List<ResourceReferenceDt> mySpecimen;
    @Child(name="result", order=10, min=0, max=-1, summary=false, modifier=false, type={Observation.class})
    @Description(shortDefinition="Observations - simple, or complex nested groups", formalDefinition="Observations that are part of this diagnostic report. Observations can be simple name/value pairs (e.g. \"atomic\" results), or they can be grouping observations that include references to other members of the group (e.g. \"panels\")")
    private List<ResourceReferenceDt> myResult;
    @Child(name="imagingStudy", order=11, min=0, max=-1, summary=false, modifier=false, type={ImagingStudy.class})
    @Description(shortDefinition="Reference to full details of imaging associated with the diagnostic report", formalDefinition="One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images")
    private List<ResourceReferenceDt> myImagingStudy;
    @Child(name="image", order=12, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Key images associated with this report", formalDefinition="A list of key images associated with this report. The images are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest)")
    private List<Image> myImage;
    @Child(name="conclusion", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Clinical Interpretation of test results", formalDefinition="Concise and clinically contextualized narrative interpretation of the diagnostic report")
    private StringDt myConclusion;
    @Child(name="codedDiagnosis", type={CodeableConceptDt.class}, order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Codes for the conclusion", formalDefinition="")
    private List<CodeableConceptDt> myCodedDiagnosis;
    @Child(name="presentedForm", type={AttachmentDt.class}, order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Entire Report as issued", formalDefinition="Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.")
    private List<AttachmentDt> myPresentedForm;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myStatus, this.myIssued, this.mySubject, this.myPerformer, this.myIdentifier, this.myRequestDetail, this.myServiceCategory, this.myDiagnostic, this.mySpecimen, this.myResult, this.myImagingStudy, this.myImage, this.myConclusion, this.myCodedDiagnosis, this.myPresentedForm});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myStatus, this.myIssued, this.mySubject, this.myPerformer, this.myIdentifier, this.myRequestDetail, this.myServiceCategory, this.myDiagnostic, this.mySpecimen, this.myResult, this.myImagingStudy, this.myImage, this.myConclusion, this.myCodedDiagnosis, this.myPresentedForm});
    }

    public CodeableConceptDt getName() {
        if (this.myName == null) {
            this.myName = new CodeableConceptDt();
        }
        return this.myName;
    }

    public CodeableConceptDt getNameElement() {
        if (this.myName == null) {
            this.myName = new CodeableConceptDt();
        }
        return this.myName;
    }

    public DiagnosticReport setName(CodeableConceptDt theValue) {
        this.myName = theValue;
        return this;
    }

    public BoundCodeDt<DiagnosticReportStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DiagnosticReportStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<DiagnosticReportStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DiagnosticReportStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public DiagnosticReport setStatus(BoundCodeDt<DiagnosticReportStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DiagnosticReport setStatus(DiagnosticReportStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public DateTimeDt getIssued() {
        if (this.myIssued == null) {
            this.myIssued = new DateTimeDt();
        }
        return this.myIssued;
    }

    public DateTimeDt getIssuedElement() {
        if (this.myIssued == null) {
            this.myIssued = new DateTimeDt();
        }
        return this.myIssued;
    }

    public DiagnosticReport setIssued(DateTimeDt theValue) {
        this.myIssued = theValue;
        return this;
    }

    public DiagnosticReport setIssued(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myIssued = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DiagnosticReport setIssuedWithSecondsPrecision(Date theDate) {
        this.myIssued = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DiagnosticReport setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ResourceReferenceDt();
        }
        return this.myPerformer;
    }

    public ResourceReferenceDt getPerformerElement() {
        if (this.myPerformer == null) {
            this.myPerformer = new ResourceReferenceDt();
        }
        return this.myPerformer;
    }

    public DiagnosticReport setPerformer(ResourceReferenceDt theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public DiagnosticReport setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public DiagnosticReport setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public DiagnosticReport setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public List<ResourceReferenceDt> getRequestDetail() {
        if (this.myRequestDetail == null) {
            this.myRequestDetail = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRequestDetail;
    }

    public List<ResourceReferenceDt> getRequestDetailElement() {
        if (this.myRequestDetail == null) {
            this.myRequestDetail = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRequestDetail;
    }

    public DiagnosticReport setRequestDetail(List<ResourceReferenceDt> theValue) {
        this.myRequestDetail = theValue;
        return this;
    }

    public ResourceReferenceDt addRequestDetail() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getRequestDetail().add(newType);
        return newType;
    }

    public CodeableConceptDt getServiceCategory() {
        if (this.myServiceCategory == null) {
            this.myServiceCategory = new CodeableConceptDt();
        }
        return this.myServiceCategory;
    }

    public CodeableConceptDt getServiceCategoryElement() {
        if (this.myServiceCategory == null) {
            this.myServiceCategory = new CodeableConceptDt();
        }
        return this.myServiceCategory;
    }

    public DiagnosticReport setServiceCategory(CodeableConceptDt theValue) {
        this.myServiceCategory = theValue;
        return this;
    }

    public IDatatype getDiagnostic() {
        return this.myDiagnostic;
    }

    public IDatatype getDiagnosticElement() {
        return this.myDiagnostic;
    }

    public DiagnosticReport setDiagnostic(IDatatype theValue) {
        this.myDiagnostic = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getSpecimen() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySpecimen;
    }

    public List<ResourceReferenceDt> getSpecimenElement() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySpecimen;
    }

    public DiagnosticReport setSpecimen(List<ResourceReferenceDt> theValue) {
        this.mySpecimen = theValue;
        return this;
    }

    public ResourceReferenceDt addSpecimen() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSpecimen().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getResult() {
        if (this.myResult == null) {
            this.myResult = new ArrayList<ResourceReferenceDt>();
        }
        return this.myResult;
    }

    public List<ResourceReferenceDt> getResultElement() {
        if (this.myResult == null) {
            this.myResult = new ArrayList<ResourceReferenceDt>();
        }
        return this.myResult;
    }

    public DiagnosticReport setResult(List<ResourceReferenceDt> theValue) {
        this.myResult = theValue;
        return this;
    }

    public ResourceReferenceDt addResult() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getResult().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getImagingStudy() {
        if (this.myImagingStudy == null) {
            this.myImagingStudy = new ArrayList<ResourceReferenceDt>();
        }
        return this.myImagingStudy;
    }

    public List<ResourceReferenceDt> getImagingStudyElement() {
        if (this.myImagingStudy == null) {
            this.myImagingStudy = new ArrayList<ResourceReferenceDt>();
        }
        return this.myImagingStudy;
    }

    public DiagnosticReport setImagingStudy(List<ResourceReferenceDt> theValue) {
        this.myImagingStudy = theValue;
        return this;
    }

    public ResourceReferenceDt addImagingStudy() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getImagingStudy().add(newType);
        return newType;
    }

    public List<Image> getImage() {
        if (this.myImage == null) {
            this.myImage = new ArrayList<Image>();
        }
        return this.myImage;
    }

    public List<Image> getImageElement() {
        if (this.myImage == null) {
            this.myImage = new ArrayList<Image>();
        }
        return this.myImage;
    }

    public DiagnosticReport setImage(List<Image> theValue) {
        this.myImage = theValue;
        return this;
    }

    public Image addImage() {
        Image newType = new Image();
        this.getImage().add(newType);
        return newType;
    }

    public Image getImageFirstRep() {
        if (this.getImage().isEmpty()) {
            return this.addImage();
        }
        return this.getImage().get(0);
    }

    public StringDt getConclusion() {
        if (this.myConclusion == null) {
            this.myConclusion = new StringDt();
        }
        return this.myConclusion;
    }

    public StringDt getConclusionElement() {
        if (this.myConclusion == null) {
            this.myConclusion = new StringDt();
        }
        return this.myConclusion;
    }

    public DiagnosticReport setConclusion(StringDt theValue) {
        this.myConclusion = theValue;
        return this;
    }

    public DiagnosticReport setConclusion(String theString) {
        this.myConclusion = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getCodedDiagnosis() {
        if (this.myCodedDiagnosis == null) {
            this.myCodedDiagnosis = new ArrayList<CodeableConceptDt>();
        }
        return this.myCodedDiagnosis;
    }

    public List<CodeableConceptDt> getCodedDiagnosisElement() {
        if (this.myCodedDiagnosis == null) {
            this.myCodedDiagnosis = new ArrayList<CodeableConceptDt>();
        }
        return this.myCodedDiagnosis;
    }

    public DiagnosticReport setCodedDiagnosis(List<CodeableConceptDt> theValue) {
        this.myCodedDiagnosis = theValue;
        return this;
    }

    public CodeableConceptDt addCodedDiagnosis() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getCodedDiagnosis().add(newType);
        return newType;
    }

    public CodeableConceptDt getCodedDiagnosisFirstRep() {
        if (this.getCodedDiagnosis().isEmpty()) {
            return this.addCodedDiagnosis();
        }
        return this.getCodedDiagnosis().get(0);
    }

    public List<AttachmentDt> getPresentedForm() {
        if (this.myPresentedForm == null) {
            this.myPresentedForm = new ArrayList<AttachmentDt>();
        }
        return this.myPresentedForm;
    }

    public List<AttachmentDt> getPresentedFormElement() {
        if (this.myPresentedForm == null) {
            this.myPresentedForm = new ArrayList<AttachmentDt>();
        }
        return this.myPresentedForm;
    }

    public DiagnosticReport setPresentedForm(List<AttachmentDt> theValue) {
        this.myPresentedForm = theValue;
        return this;
    }

    public AttachmentDt addPresentedForm() {
        AttachmentDt newType = new AttachmentDt();
        this.getPresentedForm().add(newType);
        return newType;
    }

    public AttachmentDt getPresentedFormFirstRep() {
        if (this.getPresentedForm().isEmpty()) {
            return this.addPresentedForm();
        }
        return this.getPresentedForm().get(0);
    }

    public String getResourceName() {
        return "DiagnosticReport";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Image
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="comment", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Comment about the image (e.g. explanation)", formalDefinition="A comment about the image. Typically, this is used to provide an explanation for why the image is included, or to draw the viewer's attention to important features")
        private StringDt myComment;
        @Child(name="link", order=1, min=1, max=1, summary=true, modifier=false, type={Media.class})
        @Description(shortDefinition="Reference to the image source", formalDefinition="")
        private ResourceReferenceDt myLink;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myComment, this.myLink});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myComment, this.myLink});
        }

        public StringDt getComment() {
            if (this.myComment == null) {
                this.myComment = new StringDt();
            }
            return this.myComment;
        }

        public StringDt getCommentElement() {
            if (this.myComment == null) {
                this.myComment = new StringDt();
            }
            return this.myComment;
        }

        public Image setComment(StringDt theValue) {
            this.myComment = theValue;
            return this;
        }

        public Image setComment(String theString) {
            this.myComment = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getLink() {
            if (this.myLink == null) {
                this.myLink = new ResourceReferenceDt();
            }
            return this.myLink;
        }

        public ResourceReferenceDt getLinkElement() {
            if (this.myLink == null) {
                this.myLink = new ResourceReferenceDt();
            }
            return this.myLink;
        }

        public Image setLink(ResourceReferenceDt theValue) {
            this.myLink = theValue;
            return this;
        }
    }
}

