/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AgeDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.resource.Immunization;
import ca.uhn.fhir.model.dstu.resource.MedicationAdministration;
import ca.uhn.fhir.model.dstu.resource.MedicationStatement;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Procedure;
import ca.uhn.fhir.model.dstu.valueset.ConditionRelationshipTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.ConditionStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Condition", profile="http://hl7.org/fhir/profiles/Condition", id="condition")
public class Condition
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="code", path="Condition.code", description="Code for the condition", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="status", path="Condition.status", description="The status of the condition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="severity", path="Condition.severity", description="The severity of the condition", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="category", path="Condition.category", description="The category of the condition", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="onset", path="Condition.onset[x]", description="When the Condition started (if started on a date)", type="date")
    public static final String SP_ONSET = "onset";
    public static final DateClientParam ONSET = new DateClientParam("onset");
    @SearchParamDefinition(name="subject", path="Condition.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Condition.subject");
    @SearchParamDefinition(name="encounter", path="Condition.encounter", description="", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Condition.encounter");
    @SearchParamDefinition(name="asserter", path="Condition.asserter", description="", type="reference")
    public static final String SP_ASSERTER = "asserter";
    public static final ReferenceClientParam ASSERTER = new ReferenceClientParam("asserter");
    public static final Include INCLUDE_ASSERTER = new Include("Condition.asserter");
    @SearchParamDefinition(name="date-asserted", path="Condition.dateAsserted", description="", type="date")
    public static final String SP_DATE_ASSERTED = "date-asserted";
    public static final DateClientParam DATE_ASSERTED = new DateClientParam("date-asserted");
    @SearchParamDefinition(name="evidence", path="Condition.evidence.code", description="", type="token")
    public static final String SP_EVIDENCE = "evidence";
    public static final TokenClientParam EVIDENCE = new TokenClientParam("evidence");
    @SearchParamDefinition(name="location", path="Condition.location.code", description="", type="token")
    public static final String SP_LOCATION = "location";
    public static final TokenClientParam LOCATION = new TokenClientParam("location");
    @SearchParamDefinition(name="related-item", path="Condition.relatedItem.target", description="", type="reference")
    public static final String SP_RELATED_ITEM = "related-item";
    public static final ReferenceClientParam RELATED_ITEM = new ReferenceClientParam("related-item");
    public static final Include INCLUDE_RELATEDITEM_TARGET = new Include("Condition.relatedItem.target");
    @SearchParamDefinition(name="stage", path="Condition.stage.summary", description="", type="token")
    public static final String SP_STAGE = "stage";
    public static final TokenClientParam STAGE = new TokenClientParam("stage");
    @SearchParamDefinition(name="related-code", path="Condition.relatedItem.code", description="", type="token")
    public static final String SP_RELATED_CODE = "related-code";
    public static final TokenClientParam RELATED_CODE = new TokenClientParam("related-code");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="External Ids for this condition", formalDefinition="This records identifiers associated with this condition that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=1, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Who has the condition?", formalDefinition="Indicates the patient who the condition record is associated with")
    private ResourceReferenceDt mySubject;
    @Child(name="encounter", order=2, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="Encounter when condition first asserted", formalDefinition="Encounter during which the condition was first asserted")
    private ResourceReferenceDt myEncounter;
    @Child(name="asserter", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class})
    @Description(shortDefinition="Person who asserts this condition", formalDefinition="Person who takes responsibility for asserting the existence of the condition as part of the electronic record")
    private ResourceReferenceDt myAsserter;
    @Child(name="dateAsserted", type={DateDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="When first detected/suspected/entered", formalDefinition="Estimated or actual date the condition/problem/diagnosis was first detected/suspected")
    private DateDt myDateAsserted;
    @Child(name="code", type={CodeableConceptDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Identification of the condition, problem or diagnosis", formalDefinition="Identification of the condition, problem or diagnosis.")
    private CodeableConceptDt myCode;
    @Child(name="category", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="E.g. complaint | symptom | finding | diagnosis", formalDefinition="A category assigned to the condition. E.g. complaint | symptom | finding | diagnosis")
    private CodeableConceptDt myCategory;
    @Child(name="status", type={CodeDt.class}, order=7, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="provisional | working | confirmed | refuted", formalDefinition="The clinical status of the condition")
    private BoundCodeDt<ConditionStatusEnum> myStatus;
    @Child(name="certainty", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="Degree of confidence", formalDefinition="The degree of confidence that this condition is correct")
    private CodeableConceptDt myCertainty;
    @Child(name="severity", type={CodeableConceptDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Subjective severity of condition", formalDefinition="A subjective assessment of the severity of the condition as evaluated by the clinician.")
    private CodeableConceptDt mySeverity;
    @Child(name="onset", order=10, min=0, max=1, summary=false, modifier=false, type={DateDt.class, AgeDt.class})
    @Description(shortDefinition="Estimated or actual date, or age", formalDefinition="Estimated or actual date the condition began, in the opinion of the clinician")
    private IDatatype myOnset;
    @Child(name="abatement", order=11, min=0, max=1, summary=false, modifier=false, type={DateDt.class, AgeDt.class, BooleanDt.class})
    @Description(shortDefinition="If/when in resolution/remission", formalDefinition="The date or estimated date that the condition resolved or went into remission. This is called \"abatement\" because of the many overloaded connotations associated with \"remission\" or \"resolution\" - Conditions are never really resolved, but they can abate.")
    private IDatatype myAbatement;
    @Child(name="stage", order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Stage/grade, usually assessed formally", formalDefinition="Clinical stage or grade of a condition. May include formal severity assessments")
    private Stage myStage;
    @Child(name="evidence", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Supporting evidence", formalDefinition="Supporting Evidence / manifestations that are the basis on which this condition is suspected or confirmed")
    private List<Evidence> myEvidence;
    @Child(name="location", order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Anatomical location, if relevant", formalDefinition="The anatomical location where this condition manifests itself")
    private List<Location> myLocation;
    @Child(name="relatedItem", order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Causes or precedents for this Condition", formalDefinition="Further conditions, problems, diagnoses, procedures or events that are related in some way to this condition, or the substance that caused/triggered this Condition")
    private List<RelatedItem> myRelatedItem;
    @Child(name="notes", type={StringDt.class}, order=16, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Additional information about the Condition", formalDefinition="Additional information about the Condition. This is a general notes/comments entry  for description of the Condition, its diagnosis and prognosis")
    private StringDt myNotes;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.mySubject, this.myEncounter, this.myAsserter, this.myDateAsserted, this.myCode, this.myCategory, this.myStatus, this.myCertainty, this.mySeverity, this.myOnset, this.myAbatement, this.myStage, this.myEvidence, this.myLocation, this.myRelatedItem, this.myNotes});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.mySubject, this.myEncounter, this.myAsserter, this.myDateAsserted, this.myCode, this.myCategory, this.myStatus, this.myCertainty, this.mySeverity, this.myOnset, this.myAbatement, this.myStage, this.myEvidence, this.myLocation, this.myRelatedItem, this.myNotes});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Condition setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Condition addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Condition addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Condition setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ResourceReferenceDt getEncounterElement() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Condition setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getAsserter() {
        if (this.myAsserter == null) {
            this.myAsserter = new ResourceReferenceDt();
        }
        return this.myAsserter;
    }

    public ResourceReferenceDt getAsserterElement() {
        if (this.myAsserter == null) {
            this.myAsserter = new ResourceReferenceDt();
        }
        return this.myAsserter;
    }

    public Condition setAsserter(ResourceReferenceDt theValue) {
        this.myAsserter = theValue;
        return this;
    }

    public DateDt getDateAsserted() {
        if (this.myDateAsserted == null) {
            this.myDateAsserted = new DateDt();
        }
        return this.myDateAsserted;
    }

    public DateDt getDateAssertedElement() {
        if (this.myDateAsserted == null) {
            this.myDateAsserted = new DateDt();
        }
        return this.myDateAsserted;
    }

    public Condition setDateAsserted(DateDt theValue) {
        this.myDateAsserted = theValue;
        return this;
    }

    public Condition setDateAsserted(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateAsserted = new DateDt(theDate, thePrecision);
        return this;
    }

    public Condition setDateAssertedWithDayPrecision(Date theDate) {
        this.myDateAsserted = new DateDt(theDate);
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public CodeableConceptDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Condition setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public CodeableConceptDt getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public CodeableConceptDt getCategoryElement() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public Condition setCategory(CodeableConceptDt theValue) {
        this.myCategory = theValue;
        return this;
    }

    public BoundCodeDt<ConditionStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConditionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<ConditionStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConditionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Condition setStatus(BoundCodeDt<ConditionStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Condition setStatus(ConditionStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public CodeableConceptDt getCertainty() {
        if (this.myCertainty == null) {
            this.myCertainty = new CodeableConceptDt();
        }
        return this.myCertainty;
    }

    public CodeableConceptDt getCertaintyElement() {
        if (this.myCertainty == null) {
            this.myCertainty = new CodeableConceptDt();
        }
        return this.myCertainty;
    }

    public Condition setCertainty(CodeableConceptDt theValue) {
        this.myCertainty = theValue;
        return this;
    }

    public CodeableConceptDt getSeverity() {
        if (this.mySeverity == null) {
            this.mySeverity = new CodeableConceptDt();
        }
        return this.mySeverity;
    }

    public CodeableConceptDt getSeverityElement() {
        if (this.mySeverity == null) {
            this.mySeverity = new CodeableConceptDt();
        }
        return this.mySeverity;
    }

    public Condition setSeverity(CodeableConceptDt theValue) {
        this.mySeverity = theValue;
        return this;
    }

    public IDatatype getOnset() {
        return this.myOnset;
    }

    public IDatatype getOnsetElement() {
        return this.myOnset;
    }

    public Condition setOnset(IDatatype theValue) {
        this.myOnset = theValue;
        return this;
    }

    public IDatatype getAbatement() {
        return this.myAbatement;
    }

    public IDatatype getAbatementElement() {
        return this.myAbatement;
    }

    public Condition setAbatement(IDatatype theValue) {
        this.myAbatement = theValue;
        return this;
    }

    public Stage getStage() {
        if (this.myStage == null) {
            this.myStage = new Stage();
        }
        return this.myStage;
    }

    public Stage getStageElement() {
        if (this.myStage == null) {
            this.myStage = new Stage();
        }
        return this.myStage;
    }

    public Condition setStage(Stage theValue) {
        this.myStage = theValue;
        return this;
    }

    public List<Evidence> getEvidence() {
        if (this.myEvidence == null) {
            this.myEvidence = new ArrayList<Evidence>();
        }
        return this.myEvidence;
    }

    public List<Evidence> getEvidenceElement() {
        if (this.myEvidence == null) {
            this.myEvidence = new ArrayList<Evidence>();
        }
        return this.myEvidence;
    }

    public Condition setEvidence(List<Evidence> theValue) {
        this.myEvidence = theValue;
        return this;
    }

    public Evidence addEvidence() {
        Evidence newType = new Evidence();
        this.getEvidence().add(newType);
        return newType;
    }

    public Evidence getEvidenceFirstRep() {
        if (this.getEvidence().isEmpty()) {
            return this.addEvidence();
        }
        return this.getEvidence().get(0);
    }

    public List<Location> getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<Location>();
        }
        return this.myLocation;
    }

    public List<Location> getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<Location>();
        }
        return this.myLocation;
    }

    public Condition setLocation(List<Location> theValue) {
        this.myLocation = theValue;
        return this;
    }

    public Location addLocation() {
        Location newType = new Location();
        this.getLocation().add(newType);
        return newType;
    }

    public Location getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            return this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public List<RelatedItem> getRelatedItem() {
        if (this.myRelatedItem == null) {
            this.myRelatedItem = new ArrayList<RelatedItem>();
        }
        return this.myRelatedItem;
    }

    public List<RelatedItem> getRelatedItemElement() {
        if (this.myRelatedItem == null) {
            this.myRelatedItem = new ArrayList<RelatedItem>();
        }
        return this.myRelatedItem;
    }

    public Condition setRelatedItem(List<RelatedItem> theValue) {
        this.myRelatedItem = theValue;
        return this;
    }

    public RelatedItem addRelatedItem() {
        RelatedItem newType = new RelatedItem();
        this.getRelatedItem().add(newType);
        return newType;
    }

    public RelatedItem getRelatedItemFirstRep() {
        if (this.getRelatedItem().isEmpty()) {
            return this.addRelatedItem();
        }
        return this.getRelatedItem().get(0);
    }

    public StringDt getNotes() {
        if (this.myNotes == null) {
            this.myNotes = new StringDt();
        }
        return this.myNotes;
    }

    public StringDt getNotesElement() {
        if (this.myNotes == null) {
            this.myNotes = new StringDt();
        }
        return this.myNotes;
    }

    public Condition setNotes(StringDt theValue) {
        this.myNotes = theValue;
        return this;
    }

    public Condition setNotes(String theString) {
        this.myNotes = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "Condition";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class RelatedItem
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="due-to | following", formalDefinition="The type of relationship that this condition has to the related item")
        private BoundCodeDt<ConditionRelationshipTypeEnum> myType;
        @Child(name="code", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Relationship target by means of a predefined code", formalDefinition="Code that identifies the target of this relationship. The code takes the place of a detailed instance target")
        private CodeableConceptDt myCode;
        @Child(name="target", order=2, min=0, max=1, summary=false, modifier=false, type={Condition.class, Procedure.class, MedicationAdministration.class, Immunization.class, MedicationStatement.class})
        @Description(shortDefinition="Relationship target resource", formalDefinition="Target of the relationship")
        private ResourceReferenceDt myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myCode, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myCode, this.myTarget});
        }

        public BoundCodeDt<ConditionRelationshipTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ConditionRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<ConditionRelationshipTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ConditionRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public RelatedItem setType(BoundCodeDt<ConditionRelationshipTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public RelatedItem setType(ConditionRelationshipTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public RelatedItem setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public ResourceReferenceDt getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public RelatedItem setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }
    }

    @Block
    public static class Location
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Location - may include laterality", formalDefinition="Code that identifies the structural location")
        private CodeableConceptDt myCode;
        @Child(name="detail", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Precise location details", formalDefinition="Detailed anatomical location information")
        private StringDt myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDetail});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Location setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public StringDt getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new StringDt();
            }
            return this.myDetail;
        }

        public StringDt getDetailElement() {
            if (this.myDetail == null) {
                this.myDetail = new StringDt();
            }
            return this.myDetail;
        }

        public Location setDetail(StringDt theValue) {
            this.myDetail = theValue;
            return this;
        }

        public Location setDetail(String theString) {
            this.myDetail = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Evidence
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Manifestation/symptom", formalDefinition="A manifestation or symptom that led to the recording of this condition")
        private CodeableConceptDt myCode;
        @Child(name="detail", order=1, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="Supporting information found elsewhere", formalDefinition="Links to other relevant information, including pathology reports")
        private List<ResourceReferenceDt> myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDetail});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Evidence setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ResourceReferenceDt>();
            }
            return this.myDetail;
        }

        public List<ResourceReferenceDt> getDetailElement() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ResourceReferenceDt>();
            }
            return this.myDetail;
        }

        public Evidence setDetail(List<ResourceReferenceDt> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ResourceReferenceDt addDetail() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getDetail().add(newType);
            return newType;
        }
    }

    @Block
    public static class Stage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="summary", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Simple summary (disease specific)", formalDefinition="A simple summary of the stage such as \"Stage 3\". The determination of the stage is disease-specific")
        private CodeableConceptDt mySummary;
        @Child(name="assessment", order=1, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="Formal record of assessment", formalDefinition="Reference to a formal record of the evidence on which the staging assessment is based")
        private List<ResourceReferenceDt> myAssessment;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySummary, this.myAssessment});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySummary, this.myAssessment});
        }

        public CodeableConceptDt getSummary() {
            if (this.mySummary == null) {
                this.mySummary = new CodeableConceptDt();
            }
            return this.mySummary;
        }

        public CodeableConceptDt getSummaryElement() {
            if (this.mySummary == null) {
                this.mySummary = new CodeableConceptDt();
            }
            return this.mySummary;
        }

        public Stage setSummary(CodeableConceptDt theValue) {
            this.mySummary = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getAssessment() {
            if (this.myAssessment == null) {
                this.myAssessment = new ArrayList<ResourceReferenceDt>();
            }
            return this.myAssessment;
        }

        public List<ResourceReferenceDt> getAssessmentElement() {
            if (this.myAssessment == null) {
                this.myAssessment = new ArrayList<ResourceReferenceDt>();
            }
            return this.myAssessment;
        }

        public Stage setAssessment(List<ResourceReferenceDt> theValue) {
            this.myAssessment = theValue;
            return this;
        }

        public ResourceReferenceDt addAssessment() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getAssessment().add(newType);
            return newType;
        }
    }
}

