/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AddressDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Claim", profile="http://hl7.org/fhir/profiles/Claim", id="claim")
public class Claim
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="number", path="Claim.number", description="", type="token")
    public static final String SP_NUMBER = "number";
    public static final TokenClientParam NUMBER = new TokenClientParam("number");
    @Child(name="number", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Claim/Invoice number", formalDefinition="The claim issuer and claim number")
    private IdentifierDt myNumber;
    @Child(name="servicedate", type={DateDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date of Service", formalDefinition="The date when the enclosed suite of services were performed or completed")
    private DateDt myServicedate;
    @Child(name="provider", order=2, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient")
    private ResourceReferenceDt myProvider;
    @Child(name="billingProvider", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Provider who is the payee", formalDefinition="The provider who is to be reimbursed for the claim (the party to whom any benefit is assigned)")
    private ResourceReferenceDt myBillingProvider;
    @Child(name="referrer", order=4, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Provider who is the payee", formalDefinition="")
    private ResourceReferenceDt myReferrer;
    @Child(name="reason", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Referal Reason", formalDefinition="The reason code for the referral")
    private CodeableConceptDt myReason;
    @Child(name="patient", order=6, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Patient Details", formalDefinition="Patient Details.")
    private Patient myPatient;
    @Child(name="coverage", order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care")
    private Coverage myCoverage;
    @Child(name="exception", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Eligibility exceptions", formalDefinition="Factors which may influence the appicability of coverage")
    private CodeableConceptDt myException;
    @Child(name="relationship", type={CodeableConceptDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Patient relationship to subscriber", formalDefinition="The relationship of the patient to the subscriber")
    private CodeableConceptDt myRelationship;
    @Child(name="school", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Name of School", formalDefinition="Name of school")
    private StringDt mySchool;
    @Child(name="service", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Service Details", formalDefinition="")
    private List<Service> myService;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myNumber, this.myServicedate, this.myProvider, this.myBillingProvider, this.myReferrer, this.myReason, this.myPatient, this.myCoverage, this.myException, this.myRelationship, this.mySchool, this.myService});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myNumber, this.myServicedate, this.myProvider, this.myBillingProvider, this.myReferrer, this.myReason, this.myPatient, this.myCoverage, this.myException, this.myRelationship, this.mySchool, this.myService});
    }

    public IdentifierDt getNumber() {
        if (this.myNumber == null) {
            this.myNumber = new IdentifierDt();
        }
        return this.myNumber;
    }

    public IdentifierDt getNumberElement() {
        if (this.myNumber == null) {
            this.myNumber = new IdentifierDt();
        }
        return this.myNumber;
    }

    public Claim setNumber(IdentifierDt theValue) {
        this.myNumber = theValue;
        return this;
    }

    public Claim setNumber(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myNumber = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Claim setNumber(String theSystem, String theValue) {
        this.myNumber = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public DateDt getServicedate() {
        if (this.myServicedate == null) {
            this.myServicedate = new DateDt();
        }
        return this.myServicedate;
    }

    public DateDt getServicedateElement() {
        if (this.myServicedate == null) {
            this.myServicedate = new DateDt();
        }
        return this.myServicedate;
    }

    public Claim setServicedate(DateDt theValue) {
        this.myServicedate = theValue;
        return this;
    }

    public Claim setServicedate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myServicedate = new DateDt(theDate, thePrecision);
        return this;
    }

    public Claim setServicedateWithDayPrecision(Date theDate) {
        this.myServicedate = new DateDt(theDate);
        return this;
    }

    public ResourceReferenceDt getProvider() {
        if (this.myProvider == null) {
            this.myProvider = new ResourceReferenceDt();
        }
        return this.myProvider;
    }

    public ResourceReferenceDt getProviderElement() {
        if (this.myProvider == null) {
            this.myProvider = new ResourceReferenceDt();
        }
        return this.myProvider;
    }

    public Claim setProvider(ResourceReferenceDt theValue) {
        this.myProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getBillingProvider() {
        if (this.myBillingProvider == null) {
            this.myBillingProvider = new ResourceReferenceDt();
        }
        return this.myBillingProvider;
    }

    public ResourceReferenceDt getBillingProviderElement() {
        if (this.myBillingProvider == null) {
            this.myBillingProvider = new ResourceReferenceDt();
        }
        return this.myBillingProvider;
    }

    public Claim setBillingProvider(ResourceReferenceDt theValue) {
        this.myBillingProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getReferrer() {
        if (this.myReferrer == null) {
            this.myReferrer = new ResourceReferenceDt();
        }
        return this.myReferrer;
    }

    public ResourceReferenceDt getReferrerElement() {
        if (this.myReferrer == null) {
            this.myReferrer = new ResourceReferenceDt();
        }
        return this.myReferrer;
    }

    public Claim setReferrer(ResourceReferenceDt theValue) {
        this.myReferrer = theValue;
        return this;
    }

    public CodeableConceptDt getReason() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public CodeableConceptDt getReasonElement() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public Claim setReason(CodeableConceptDt theValue) {
        this.myReason = theValue;
        return this;
    }

    public Patient getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new Patient();
        }
        return this.myPatient;
    }

    public Patient getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new Patient();
        }
        return this.myPatient;
    }

    public Claim setPatient(Patient theValue) {
        this.myPatient = theValue;
        return this;
    }

    public Coverage getCoverage() {
        if (this.myCoverage == null) {
            this.myCoverage = new Coverage();
        }
        return this.myCoverage;
    }

    public Coverage getCoverageElement() {
        if (this.myCoverage == null) {
            this.myCoverage = new Coverage();
        }
        return this.myCoverage;
    }

    public Claim setCoverage(Coverage theValue) {
        this.myCoverage = theValue;
        return this;
    }

    public CodeableConceptDt getException() {
        if (this.myException == null) {
            this.myException = new CodeableConceptDt();
        }
        return this.myException;
    }

    public CodeableConceptDt getExceptionElement() {
        if (this.myException == null) {
            this.myException = new CodeableConceptDt();
        }
        return this.myException;
    }

    public Claim setException(CodeableConceptDt theValue) {
        this.myException = theValue;
        return this;
    }

    public CodeableConceptDt getRelationship() {
        if (this.myRelationship == null) {
            this.myRelationship = new CodeableConceptDt();
        }
        return this.myRelationship;
    }

    public CodeableConceptDt getRelationshipElement() {
        if (this.myRelationship == null) {
            this.myRelationship = new CodeableConceptDt();
        }
        return this.myRelationship;
    }

    public Claim setRelationship(CodeableConceptDt theValue) {
        this.myRelationship = theValue;
        return this;
    }

    public StringDt getSchool() {
        if (this.mySchool == null) {
            this.mySchool = new StringDt();
        }
        return this.mySchool;
    }

    public StringDt getSchoolElement() {
        if (this.mySchool == null) {
            this.mySchool = new StringDt();
        }
        return this.mySchool;
    }

    public Claim setSchool(StringDt theValue) {
        this.mySchool = theValue;
        return this;
    }

    public Claim setSchool(String theString) {
        this.mySchool = new StringDt(theString);
        return this;
    }

    public List<Service> getService() {
        if (this.myService == null) {
            this.myService = new ArrayList<Service>();
        }
        return this.myService;
    }

    public List<Service> getServiceElement() {
        if (this.myService == null) {
            this.myService = new ArrayList<Service>();
        }
        return this.myService;
    }

    public Claim setService(List<Service> theValue) {
        this.myService = theValue;
        return this;
    }

    public Service addService() {
        Service newType = new Service();
        this.getService().add(newType);
        return newType;
    }

    public Service getServiceFirstRep() {
        if (this.getService().isEmpty()) {
            return this.addService();
        }
        return this.getService().get(0);
    }

    public String getResourceName() {
        return "Claim";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class ServiceLab
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="service", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Lab service code", formalDefinition="The code for the lab service provided.")
        private CodeableConceptDt myService;
        @Child(name="fee", type={DecimalDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Lab fee", formalDefinition="The amount to reimbuse for a laboratory service.")
        private DecimalDt myFee;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myService, this.myFee});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myService, this.myFee});
        }

        public CodeableConceptDt getService() {
            if (this.myService == null) {
                this.myService = new CodeableConceptDt();
            }
            return this.myService;
        }

        public CodeableConceptDt getServiceElement() {
            if (this.myService == null) {
                this.myService = new CodeableConceptDt();
            }
            return this.myService;
        }

        public ServiceLab setService(CodeableConceptDt theValue) {
            this.myService = theValue;
            return this;
        }

        public DecimalDt getFee() {
            if (this.myFee == null) {
                this.myFee = new DecimalDt();
            }
            return this.myFee;
        }

        public DecimalDt getFeeElement() {
            if (this.myFee == null) {
                this.myFee = new DecimalDt();
            }
            return this.myFee;
        }

        public ServiceLab setFee(DecimalDt theValue) {
            this.myFee = theValue;
            return this;
        }

        public ServiceLab setFee(long theValue) {
            this.myFee = new DecimalDt(theValue);
            return this;
        }

        public ServiceLab setFee(double theValue) {
            this.myFee = new DecimalDt(theValue);
            return this;
        }

        public ServiceLab setFee(BigDecimal theValue) {
            this.myFee = new DecimalDt(theValue);
            return this;
        }
    }

    @Block
    public static class Service
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="service", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Professional service code", formalDefinition="The code for the professional service provided.")
        private CodeableConceptDt myService;
        @Child(name="instance", type={IntegerDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Service instance", formalDefinition="A service line item.")
        private IntegerDt myInstance;
        @Child(name="fee", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Professional fee", formalDefinition="")
        private DecimalDt myFee;
        @Child(name="location", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Service Location", formalDefinition="Code for the oral cavity, tooth, quadrant, sextant or arch.")
        private CodeableConceptDt myLocation;
        @Child(name="surface", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Tooth surface", formalDefinition="Tooth surface(s) involved in the restoration.")
        private CodeableConceptDt mySurface;
        @Child(name="lab", order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Lab Details", formalDefinition="")
        private ServiceLab myLab;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myService, this.myInstance, this.myFee, this.myLocation, this.mySurface, this.myLab});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myService, this.myInstance, this.myFee, this.myLocation, this.mySurface, this.myLab});
        }

        public CodeableConceptDt getService() {
            if (this.myService == null) {
                this.myService = new CodeableConceptDt();
            }
            return this.myService;
        }

        public CodeableConceptDt getServiceElement() {
            if (this.myService == null) {
                this.myService = new CodeableConceptDt();
            }
            return this.myService;
        }

        public Service setService(CodeableConceptDt theValue) {
            this.myService = theValue;
            return this;
        }

        public IntegerDt getInstance() {
            if (this.myInstance == null) {
                this.myInstance = new IntegerDt();
            }
            return this.myInstance;
        }

        public IntegerDt getInstanceElement() {
            if (this.myInstance == null) {
                this.myInstance = new IntegerDt();
            }
            return this.myInstance;
        }

        public Service setInstance(IntegerDt theValue) {
            this.myInstance = theValue;
            return this;
        }

        public Service setInstance(int theInteger) {
            this.myInstance = new IntegerDt(theInteger);
            return this;
        }

        public DecimalDt getFee() {
            if (this.myFee == null) {
                this.myFee = new DecimalDt();
            }
            return this.myFee;
        }

        public DecimalDt getFeeElement() {
            if (this.myFee == null) {
                this.myFee = new DecimalDt();
            }
            return this.myFee;
        }

        public Service setFee(DecimalDt theValue) {
            this.myFee = theValue;
            return this;
        }

        public Service setFee(long theValue) {
            this.myFee = new DecimalDt(theValue);
            return this;
        }

        public Service setFee(double theValue) {
            this.myFee = new DecimalDt(theValue);
            return this;
        }

        public Service setFee(BigDecimal theValue) {
            this.myFee = new DecimalDt(theValue);
            return this;
        }

        public CodeableConceptDt getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new CodeableConceptDt();
            }
            return this.myLocation;
        }

        public CodeableConceptDt getLocationElement() {
            if (this.myLocation == null) {
                this.myLocation = new CodeableConceptDt();
            }
            return this.myLocation;
        }

        public Service setLocation(CodeableConceptDt theValue) {
            this.myLocation = theValue;
            return this;
        }

        public CodeableConceptDt getSurface() {
            if (this.mySurface == null) {
                this.mySurface = new CodeableConceptDt();
            }
            return this.mySurface;
        }

        public CodeableConceptDt getSurfaceElement() {
            if (this.mySurface == null) {
                this.mySurface = new CodeableConceptDt();
            }
            return this.mySurface;
        }

        public Service setSurface(CodeableConceptDt theValue) {
            this.mySurface = theValue;
            return this;
        }

        public ServiceLab getLab() {
            if (this.myLab == null) {
                this.myLab = new ServiceLab();
            }
            return this.myLab;
        }

        public ServiceLab getLabElement() {
            if (this.myLab == null) {
                this.myLab = new ServiceLab();
            }
            return this.myLab;
        }

        public Service setLab(ServiceLab theValue) {
            this.myLab = theValue;
            return this;
        }
    }

    @Block
    public static class CoverageSubscriber
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={HumanNameDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="PolicyHolder name", formalDefinition="The name of the PolicyHolder")
        private HumanNameDt myName;
        @Child(name="address", type={AddressDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="PolicyHolder address", formalDefinition="The mailing address, typically home, of the PolicyHolder")
        private AddressDt myAddress;
        @Child(name="birthdate", type={DateDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="PolicyHolder date of birth", formalDefinition="The date of birth of the PolicyHolder")
        private DateDt myBirthdate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myAddress, this.myBirthdate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myAddress, this.myBirthdate});
        }

        public HumanNameDt getName() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public HumanNameDt getNameElement() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public CoverageSubscriber setName(HumanNameDt theValue) {
            this.myName = theValue;
            return this;
        }

        public AddressDt getAddress() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public AddressDt getAddressElement() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public CoverageSubscriber setAddress(AddressDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public DateDt getBirthdate() {
            if (this.myBirthdate == null) {
                this.myBirthdate = new DateDt();
            }
            return this.myBirthdate;
        }

        public DateDt getBirthdateElement() {
            if (this.myBirthdate == null) {
                this.myBirthdate = new DateDt();
            }
            return this.myBirthdate;
        }

        public CoverageSubscriber setBirthdate(DateDt theValue) {
            this.myBirthdate = theValue;
            return this;
        }

        public CoverageSubscriber setBirthdate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myBirthdate = new DateDt(theDate, thePrecision);
            return this;
        }

        public CoverageSubscriber setBirthdateWithDayPrecision(Date theDate) {
            this.myBirthdate = new DateDt(theDate);
            return this;
        }
    }

    @Block
    public static class Coverage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="issuer", order=0, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="An identifier for the plan issuer", formalDefinition="The program or plan underwriter or payor.")
        private ResourceReferenceDt myIssuer;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Coverage start and end dates", formalDefinition="Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.")
        private PeriodDt myPeriod;
        @Child(name="type", type={CodingDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type of coverage", formalDefinition="The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health.")
        private CodingDt myType;
        @Child(name="identifier", type={IdentifierDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The primary coverage ID", formalDefinition="The main (and possibly only) identifier for the coverage - often referred to as a Subscriber Id, Certificate number or Personal Health Number or Case ID.")
        private IdentifierDt myIdentifier;
        @Child(name="group", type={IdentifierDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="An identifier for the group", formalDefinition="Todo")
        private IdentifierDt myGroup;
        @Child(name="plan", type={IdentifierDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="An identifier for the plan", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.")
        private IdentifierDt myPlan;
        @Child(name="subplan", type={IdentifierDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="An identifier for the subsection of the plan", formalDefinition="Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a specific employer group within a class of employers. May be referred to as a Section or Division ID.")
        private IdentifierDt mySubplan;
        @Child(name="dependent", type={IntegerDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The dependent number", formalDefinition="A unique identifier for a dependent under the coverage.")
        private IntegerDt myDependent;
        @Child(name="sequence", type={IntegerDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The plan instance or sequence counter", formalDefinition="An optional counter for a particular instance of the identified coverage which increments upon each renewal.")
        private IntegerDt mySequence;
        @Child(name="subscriber", order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Planholder information", formalDefinition="Th demographics for the individual in whose name the insurance coverage is issued.")
        private CoverageSubscriber mySubscriber;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIssuer, this.myPeriod, this.myType, this.myIdentifier, this.myGroup, this.myPlan, this.mySubplan, this.myDependent, this.mySequence, this.mySubscriber});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIssuer, this.myPeriod, this.myType, this.myIdentifier, this.myGroup, this.myPlan, this.mySubplan, this.myDependent, this.mySequence, this.mySubscriber});
        }

        public ResourceReferenceDt getIssuer() {
            if (this.myIssuer == null) {
                this.myIssuer = new ResourceReferenceDt();
            }
            return this.myIssuer;
        }

        public ResourceReferenceDt getIssuerElement() {
            if (this.myIssuer == null) {
                this.myIssuer = new ResourceReferenceDt();
            }
            return this.myIssuer;
        }

        public Coverage setIssuer(ResourceReferenceDt theValue) {
            this.myIssuer = theValue;
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public PeriodDt getPeriodElement() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Coverage setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public CodingDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Coverage setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public IdentifierDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Coverage setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Coverage setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Coverage setIdentifier(String theSystem, String theValue) {
            this.myIdentifier = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public IdentifierDt getGroup() {
            if (this.myGroup == null) {
                this.myGroup = new IdentifierDt();
            }
            return this.myGroup;
        }

        public IdentifierDt getGroupElement() {
            if (this.myGroup == null) {
                this.myGroup = new IdentifierDt();
            }
            return this.myGroup;
        }

        public Coverage setGroup(IdentifierDt theValue) {
            this.myGroup = theValue;
            return this;
        }

        public Coverage setGroup(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myGroup = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Coverage setGroup(String theSystem, String theValue) {
            this.myGroup = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public IdentifierDt getPlan() {
            if (this.myPlan == null) {
                this.myPlan = new IdentifierDt();
            }
            return this.myPlan;
        }

        public IdentifierDt getPlanElement() {
            if (this.myPlan == null) {
                this.myPlan = new IdentifierDt();
            }
            return this.myPlan;
        }

        public Coverage setPlan(IdentifierDt theValue) {
            this.myPlan = theValue;
            return this;
        }

        public Coverage setPlan(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myPlan = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Coverage setPlan(String theSystem, String theValue) {
            this.myPlan = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public IdentifierDt getSubplan() {
            if (this.mySubplan == null) {
                this.mySubplan = new IdentifierDt();
            }
            return this.mySubplan;
        }

        public IdentifierDt getSubplanElement() {
            if (this.mySubplan == null) {
                this.mySubplan = new IdentifierDt();
            }
            return this.mySubplan;
        }

        public Coverage setSubplan(IdentifierDt theValue) {
            this.mySubplan = theValue;
            return this;
        }

        public Coverage setSubplan(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.mySubplan = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Coverage setSubplan(String theSystem, String theValue) {
            this.mySubplan = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public IntegerDt getDependent() {
            if (this.myDependent == null) {
                this.myDependent = new IntegerDt();
            }
            return this.myDependent;
        }

        public IntegerDt getDependentElement() {
            if (this.myDependent == null) {
                this.myDependent = new IntegerDt();
            }
            return this.myDependent;
        }

        public Coverage setDependent(IntegerDt theValue) {
            this.myDependent = theValue;
            return this;
        }

        public Coverage setDependent(int theInteger) {
            this.myDependent = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getSequence() {
            if (this.mySequence == null) {
                this.mySequence = new IntegerDt();
            }
            return this.mySequence;
        }

        public IntegerDt getSequenceElement() {
            if (this.mySequence == null) {
                this.mySequence = new IntegerDt();
            }
            return this.mySequence;
        }

        public Coverage setSequence(IntegerDt theValue) {
            this.mySequence = theValue;
            return this;
        }

        public Coverage setSequence(int theInteger) {
            this.mySequence = new IntegerDt(theInteger);
            return this;
        }

        public CoverageSubscriber getSubscriber() {
            if (this.mySubscriber == null) {
                this.mySubscriber = new CoverageSubscriber();
            }
            return this.mySubscriber;
        }

        public CoverageSubscriber getSubscriberElement() {
            if (this.mySubscriber == null) {
                this.mySubscriber = new CoverageSubscriber();
            }
            return this.mySubscriber;
        }

        public Coverage setSubscriber(CoverageSubscriber theValue) {
            this.mySubscriber = theValue;
            return this;
        }
    }

    @Block
    public static class Patient
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={HumanNameDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Patient name", formalDefinition="The name of the PolicyHolder")
        private HumanNameDt myName;
        @Child(name="address", type={AddressDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Patient address", formalDefinition="The mailing address, typically home, of the PolicyHolder")
        private AddressDt myAddress;
        @Child(name="birthdate", type={DateDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Patient date of birth", formalDefinition="The date of birth of the PolicyHolder")
        private DateDt myBirthdate;
        @Child(name="gender", type={CodingDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Gender", formalDefinition="Gender.")
        private CodingDt myGender;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myAddress, this.myBirthdate, this.myGender});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myAddress, this.myBirthdate, this.myGender});
        }

        public HumanNameDt getName() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public HumanNameDt getNameElement() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public Patient setName(HumanNameDt theValue) {
            this.myName = theValue;
            return this;
        }

        public AddressDt getAddress() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public AddressDt getAddressElement() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public Patient setAddress(AddressDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public DateDt getBirthdate() {
            if (this.myBirthdate == null) {
                this.myBirthdate = new DateDt();
            }
            return this.myBirthdate;
        }

        public DateDt getBirthdateElement() {
            if (this.myBirthdate == null) {
                this.myBirthdate = new DateDt();
            }
            return this.myBirthdate;
        }

        public Patient setBirthdate(DateDt theValue) {
            this.myBirthdate = theValue;
            return this;
        }

        public Patient setBirthdate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myBirthdate = new DateDt(theDate, thePrecision);
            return this;
        }

        public Patient setBirthdateWithDayPrecision(Date theDate) {
            this.myBirthdate = new DateDt(theDate);
            return this;
        }

        public CodingDt getGender() {
            if (this.myGender == null) {
                this.myGender = new CodingDt();
            }
            return this.myGender;
        }

        public CodingDt getGenderElement() {
            if (this.myGender == null) {
                this.myGender = new CodingDt();
            }
            return this.myGender;
        }

        public Patient setGender(CodingDt theValue) {
            this.myGender = theValue;
            return this;
        }
    }
}

