/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBinary;

@ResourceDef(name="Binary", profile="http://hl7.org/fhir/profiles/Binary", id="binary")
public class Binary
extends BaseResource
implements IBaseBinary {
    @Child(name="content", order=1)
    private Base64BinaryDt myContent = new Base64BinaryDt();
    @Child(name="contentType", order=0)
    private StringDt myContentType;

    public Binary() {
    }

    public Binary(String theContentType, byte[] theContent) {
        this.setContentType(theContentType);
        this.setContent(theContent);
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return Collections.emptyList();
    }

    public byte[] getContent() {
        return (byte[])this.myContent.getValue();
    }

    public String getContentAsBase64() {
        return this.myContent.getValueAsString();
    }

    public String getContentType() {
        if (this.myContentType == null) {
            return null;
        }
        return (String)this.myContentType.getValue();
    }

    public boolean isEmpty() {
        return this.myContent.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContentType});
    }

    public Binary setContent(byte[] theContent) {
        this.myContent.setValue((Object)theContent);
        return this;
    }

    public Binary setContentAsBase64(String theContent) {
        this.myContent.setValueAsString(theContent);
        return this;
    }

    public Binary setContentType(String theContentType) {
        this.myContentType = new StringDt(theContentType);
        return this;
    }

    public String getResourceName() {
        return Binary.class.getName();
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

