/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.ScheduleDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Observation;
import ca.uhn.fhir.model.dstu.resource.Order;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.resource.Slot;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ParticipantTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Appointment", profile="http://hl7.org/fhir/profiles/Appointment", id="appointment")
public class Appointment
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="date", path="Appointment.start", description="Appointment date/time.", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="status", path="Appointment.status", description="The overall status of the appointment", type="string")
    public static final String SP_STATUS = "status";
    public static final StringClientParam STATUS = new StringClientParam("status");
    @SearchParamDefinition(name="subject", path="Appointment.participant.individual", description="The subject that the sensitivity is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_PARTICIPANT_INDIVIDUAL = new Include("Appointment.participant.individual");
    @SearchParamDefinition(name="partstatus", path="Appointment.participant.status", description="The Participation status of the subject, or other participant on the appointment", type="token")
    public static final String SP_PARTSTATUS = "partstatus";
    public static final TokenClientParam PARTSTATUS = new TokenClientParam("partstatus");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this appointment concern that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="priority", type={IntegerDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority) (Need to change back to CodeableConcept)", formalDefinition="")
    private IntegerDt myPriority;
    @Child(name="status", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The overall status of the Appointment", formalDefinition="Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status")
    private CodeDt myStatus;
    @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the comment field", formalDefinition="")
    private StringDt myDescription;
    @Child(name="start", type={InstantDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date/Time that the appointment is to take place", formalDefinition="")
    private InstantDt myStart;
    @Child(name="end", type={InstantDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date/Time that the appointment is to conclude", formalDefinition="")
    private InstantDt myEnd;
    @Child(name="schedule", type={ScheduleDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The recurrence schedule for the appointment. The end date in the schedule marks the end of the recurrence(s), not the end of an individual appointment", formalDefinition="")
    private ScheduleDt mySchedule;
    @Child(name="timezone", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The timezone that the times are to be converted to. Required for recurring appointments to remain accurate where the schedule makes the appointment cross a daylight saving boundry", formalDefinition="The timezone should be a value referenced from a timezone database")
    private StringDt myTimezone;
    @Child(name="slot", order=8, min=0, max=-1, summary=false, modifier=false, type={Slot.class})
    @Description(shortDefinition="The slot that this appointment is filling. If provided then the schedule will not be provided as slots are not recursive, and the start/end values MUST be the same as from the slot", formalDefinition="")
    private List<ResourceReferenceDt> mySlot;
    @Child(name="location", order=9, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="The primary location that this appointment is to take place", formalDefinition="")
    private ResourceReferenceDt myLocation;
    @Child(name="comment", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Additional comments about the appointment", formalDefinition="")
    private StringDt myComment;
    @Child(name="order", order=11, min=0, max=1, summary=false, modifier=false, type={Order.class})
    @Description(shortDefinition="An Order that lead to the creation of this appointment", formalDefinition="")
    private ResourceReferenceDt myOrder;
    @Child(name="participant", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="List of participants involved in the appointment", formalDefinition="")
    private List<Participant> myParticipant;
    @Child(name="recorder", order=13, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Who recorded the appointment", formalDefinition="")
    private ResourceReferenceDt myRecorder;
    @Child(name="recordedDate", type={DateTimeDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date when the sensitivity was recorded", formalDefinition="")
    private DateTimeDt myRecordedDate;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myPriority, this.myStatus, this.myDescription, this.myStart, this.myEnd, this.mySchedule, this.myTimezone, this.mySlot, this.myLocation, this.myComment, this.myOrder, this.myParticipant, this.myRecorder, this.myRecordedDate});
    }

    @Override
    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myPriority, this.myStatus, this.myDescription, this.myStart, this.myEnd, this.mySchedule, this.myTimezone, this.mySlot, this.myLocation, this.myComment, this.myOrder, this.myParticipant, this.myRecorder, this.myRecordedDate});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Appointment setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Appointment addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Appointment addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public IntegerDt getPriority() {
        if (this.myPriority == null) {
            this.myPriority = new IntegerDt();
        }
        return this.myPriority;
    }

    public IntegerDt getPriorityElement() {
        if (this.myPriority == null) {
            this.myPriority = new IntegerDt();
        }
        return this.myPriority;
    }

    public Appointment setPriority(IntegerDt theValue) {
        this.myPriority = theValue;
        return this;
    }

    public Appointment setPriority(int theInteger) {
        this.myPriority = new IntegerDt(theInteger);
        return this;
    }

    public CodeDt getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new CodeDt();
        }
        return this.myStatus;
    }

    public CodeDt getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new CodeDt();
        }
        return this.myStatus;
    }

    public Appointment setStatus(CodeDt theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Appointment setStatus(String theCode) {
        this.myStatus = new CodeDt(theCode);
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public Appointment setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Appointment setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public InstantDt getStart() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public InstantDt getStartElement() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public Appointment setStart(InstantDt theValue) {
        this.myStart = theValue;
        return this;
    }

    public Appointment setStartWithMillisPrecision(Date theDate) {
        this.myStart = new InstantDt(theDate);
        return this;
    }

    public Appointment setStart(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStart = new InstantDt(theDate, thePrecision);
        return this;
    }

    public InstantDt getEnd() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public InstantDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public Appointment setEnd(InstantDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public Appointment setEndWithMillisPrecision(Date theDate) {
        this.myEnd = new InstantDt(theDate);
        return this;
    }

    public Appointment setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myEnd = new InstantDt(theDate, thePrecision);
        return this;
    }

    public ScheduleDt getSchedule() {
        if (this.mySchedule == null) {
            this.mySchedule = new ScheduleDt();
        }
        return this.mySchedule;
    }

    public ScheduleDt getScheduleElement() {
        if (this.mySchedule == null) {
            this.mySchedule = new ScheduleDt();
        }
        return this.mySchedule;
    }

    public Appointment setSchedule(ScheduleDt theValue) {
        this.mySchedule = theValue;
        return this;
    }

    public StringDt getTimezone() {
        if (this.myTimezone == null) {
            this.myTimezone = new StringDt();
        }
        return this.myTimezone;
    }

    public StringDt getTimezoneElement() {
        if (this.myTimezone == null) {
            this.myTimezone = new StringDt();
        }
        return this.myTimezone;
    }

    public Appointment setTimezone(StringDt theValue) {
        this.myTimezone = theValue;
        return this;
    }

    public Appointment setTimezone(String theString) {
        this.myTimezone = new StringDt(theString);
        return this;
    }

    public List<ResourceReferenceDt> getSlot() {
        if (this.mySlot == null) {
            this.mySlot = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySlot;
    }

    public List<ResourceReferenceDt> getSlotElement() {
        if (this.mySlot == null) {
            this.mySlot = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySlot;
    }

    public Appointment setSlot(List<ResourceReferenceDt> theValue) {
        this.mySlot = theValue;
        return this;
    }

    public ResourceReferenceDt addSlot() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSlot().add(newType);
        return newType;
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public ResourceReferenceDt getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public Appointment setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public StringDt getComment() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public Appointment setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public Appointment setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getOrder() {
        if (this.myOrder == null) {
            this.myOrder = new ResourceReferenceDt();
        }
        return this.myOrder;
    }

    public ResourceReferenceDt getOrderElement() {
        if (this.myOrder == null) {
            this.myOrder = new ResourceReferenceDt();
        }
        return this.myOrder;
    }

    public Appointment setOrder(ResourceReferenceDt theValue) {
        this.myOrder = theValue;
        return this;
    }

    public List<Participant> getParticipant() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public List<Participant> getParticipantElement() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public Appointment setParticipant(List<Participant> theValue) {
        this.myParticipant = theValue;
        return this;
    }

    public Participant addParticipant() {
        Participant newType = new Participant();
        this.getParticipant().add(newType);
        return newType;
    }

    public Participant getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            return this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public ResourceReferenceDt getRecorder() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public ResourceReferenceDt getRecorderElement() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public Appointment setRecorder(ResourceReferenceDt theValue) {
        this.myRecorder = theValue;
        return this;
    }

    public DateTimeDt getRecordedDate() {
        if (this.myRecordedDate == null) {
            this.myRecordedDate = new DateTimeDt();
        }
        return this.myRecordedDate;
    }

    public DateTimeDt getRecordedDateElement() {
        if (this.myRecordedDate == null) {
            this.myRecordedDate = new DateTimeDt();
        }
        return this.myRecordedDate;
    }

    public Appointment setRecordedDate(DateTimeDt theValue) {
        this.myRecordedDate = theValue;
        return this;
    }

    public Appointment setRecordedDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRecordedDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Appointment setRecordedDateWithSecondsPrecision(Date theDate) {
        this.myRecordedDate = new DateTimeDt(theDate);
        return this;
    }

    public String getResourceName() {
        return "Appointment";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Participant
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Role of participant in the appointment", formalDefinition="")
        private List<BoundCodeableConceptDt<ParticipantTypeEnum>> myType;
        @Child(name="individual", order=1, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class, Device.class})
        @Description(shortDefinition="A Person of device that is participating in the appointment", formalDefinition="")
        private List<ResourceReferenceDt> myIndividual;
        @Child(name="required", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="required | optional | information-only", formalDefinition="Is this participant required to be present at the meeting. This covers a use-case where 2 doctors need to meet to discuss the results for a specific patient, and the patient is not required to be present.")
        private CodeDt myRequired;
        @Child(name="status", type={CodeDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="accepted | declined | tentative | in-process | completed | needs-action", formalDefinition="Participation status of the Patient")
        private CodeDt myStatus;
        @Child(name="observation", order=4, min=0, max=-1, summary=false, modifier=false, type={Observation.class})
        @Description(shortDefinition="Observations that lead to the creation of this appointment. (Is this 80%)", formalDefinition="")
        private List<ResourceReferenceDt> myObservation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myIndividual, this.myRequired, this.myStatus, this.myObservation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myIndividual, this.myRequired, this.myStatus, this.myObservation});
        }

        public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
            }
            return this.myType;
        }

        public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getTypeElement() {
            if (this.myType == null) {
                this.myType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
            }
            return this.myType;
        }

        public Participant setType(List<BoundCodeableConceptDt<ParticipantTypeEnum>> theValue) {
            this.myType = theValue;
            return this;
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> addType(ParticipantTypeEnum theValue) {
            BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER, theValue);
            this.getType().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> getTypeFirstRep() {
            if (this.getType().size() == 0) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> addType() {
            BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER);
            this.getType().add(retVal);
            return retVal;
        }

        public Participant setType(ParticipantTypeEnum theValue) {
            this.getType().clear();
            this.addType(theValue);
            return this;
        }

        public List<ResourceReferenceDt> getIndividual() {
            if (this.myIndividual == null) {
                this.myIndividual = new ArrayList<ResourceReferenceDt>();
            }
            return this.myIndividual;
        }

        public List<ResourceReferenceDt> getIndividualElement() {
            if (this.myIndividual == null) {
                this.myIndividual = new ArrayList<ResourceReferenceDt>();
            }
            return this.myIndividual;
        }

        public Participant setIndividual(List<ResourceReferenceDt> theValue) {
            this.myIndividual = theValue;
            return this;
        }

        public ResourceReferenceDt addIndividual() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getIndividual().add(newType);
            return newType;
        }

        public CodeDt getRequired() {
            if (this.myRequired == null) {
                this.myRequired = new CodeDt();
            }
            return this.myRequired;
        }

        public CodeDt getRequiredElement() {
            if (this.myRequired == null) {
                this.myRequired = new CodeDt();
            }
            return this.myRequired;
        }

        public Participant setRequired(CodeDt theValue) {
            this.myRequired = theValue;
            return this;
        }

        public Participant setRequired(String theCode) {
            this.myRequired = new CodeDt(theCode);
            return this;
        }

        public CodeDt getStatus() {
            if (this.myStatus == null) {
                this.myStatus = new CodeDt();
            }
            return this.myStatus;
        }

        public CodeDt getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new CodeDt();
            }
            return this.myStatus;
        }

        public Participant setStatus(CodeDt theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Participant setStatus(String theCode) {
            this.myStatus = new CodeDt(theCode);
            return this;
        }

        public List<ResourceReferenceDt> getObservation() {
            if (this.myObservation == null) {
                this.myObservation = new ArrayList<ResourceReferenceDt>();
            }
            return this.myObservation;
        }

        public List<ResourceReferenceDt> getObservationElement() {
            if (this.myObservation == null) {
                this.myObservation = new ArrayList<ResourceReferenceDt>();
            }
            return this.myObservation;
        }

        public Participant setObservation(List<ResourceReferenceDt> theValue) {
            this.myObservation = theValue;
            return this;
        }

        public ResourceReferenceDt addObservation() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getObservation().add(newType);
            return newType;
        }
    }
}

