/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.base.composite.BaseQuantityDt;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;

@DatatypeDef(name="QuantityDt")
public class QuantityDt
extends BaseQuantityDt
implements ICompositeDatatype {
    @Child(name="value", type={DecimalDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Numerical value (with implicit precision)", formalDefinition="The value of the measured amount. The value includes an implicit precision in the presentation of the value")
    private DecimalDt myValue;
    @Child(name="comparator", type={CodeDt.class}, order=1, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="< | <= | >= | > - how to understand the value", formalDefinition="How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues. E.g. if the comparator is \"<\" , then the real value is < stated value")
    private BoundCodeDt<QuantityCompararatorEnum> myComparator;
    @Child(name="units", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Unit representation", formalDefinition="A human-readable form of the units")
    private StringDt myUnits;
    @Child(name="system", type={UriDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="System that defines coded unit form", formalDefinition="The identification of the system that provides the coded form of the unit")
    private UriDt mySystem;
    @Child(name="code", type={CodeDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Coded form of the unit", formalDefinition="A computer processable form of the units in some unit representation system")
    private CodeDt myCode;

    public QuantityDt() {
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theValue") double theValue) {
        this.setValue(theValue);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theValue") long theValue) {
        this.setValue(theValue);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityCompararatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") double theValue, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityCompararatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") long theValue, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityCompararatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") double theValue, @SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    @SimpleSetter
    public QuantityDt(@SimpleSetter.Parameter(name="theComparator") QuantityCompararatorEnum theComparator, @SimpleSetter.Parameter(name="theValue") long theValue, @SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theUnits") String theUnits) {
        this.setValue(theValue);
        this.setComparator(theComparator);
        this.setSystem(theSystem);
        this.setUnits(theUnits);
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myValue, this.myComparator, this.myUnits, this.mySystem, this.myCode});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myValue, this.myComparator, this.myUnits, this.mySystem, this.myCode});
    }

    public DecimalDt getValue() {
        if (this.myValue == null) {
            this.myValue = new DecimalDt();
        }
        return this.myValue;
    }

    public DecimalDt getValueElement() {
        if (this.myValue == null) {
            this.myValue = new DecimalDt();
        }
        return this.myValue;
    }

    public QuantityDt setValue(DecimalDt theValue) {
        this.myValue = theValue;
        return this;
    }

    public QuantityDt setValue(long theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    public QuantityDt setValue(double theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    public QuantityDt setValue(BigDecimal theValue) {
        this.myValue = new DecimalDt(theValue);
        return this;
    }

    public BoundCodeDt<QuantityCompararatorEnum> getComparator() {
        if (this.myComparator == null) {
            this.myComparator = new BoundCodeDt(QuantityCompararatorEnum.VALUESET_BINDER);
        }
        return this.myComparator;
    }

    public BoundCodeDt<QuantityCompararatorEnum> getComparatorElement() {
        if (this.myComparator == null) {
            this.myComparator = new BoundCodeDt(QuantityCompararatorEnum.VALUESET_BINDER);
        }
        return this.myComparator;
    }

    public QuantityDt setComparator(BoundCodeDt<QuantityCompararatorEnum> theValue) {
        this.myComparator = theValue;
        return this;
    }

    public QuantityDt setComparator(QuantityCompararatorEnum theValue) {
        this.getComparator().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getUnits() {
        if (this.myUnits == null) {
            this.myUnits = new StringDt();
        }
        return this.myUnits;
    }

    public StringDt getUnitsElement() {
        if (this.myUnits == null) {
            this.myUnits = new StringDt();
        }
        return this.myUnits;
    }

    public QuantityDt setUnits(StringDt theValue) {
        this.myUnits = theValue;
        return this;
    }

    public QuantityDt setUnits(String theString) {
        this.myUnits = new StringDt(theString);
        return this;
    }

    public UriDt getSystem() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public UriDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public QuantityDt setSystem(UriDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    public QuantityDt setSystem(String theUri) {
        this.mySystem = new UriDt(theUri);
        return this;
    }

    public CodeDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public CodeDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public QuantityDt setCode(CodeDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public QuantityDt setCode(String theCode) {
        this.myCode = new CodeDt(theCode);
        return this;
    }
}

