/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ResponseTypeEnum {
    OK("ok", "http://hl7.org/fhir/response-code"),
    TRANSIENT_ERROR("transient-error", "http://hl7.org/fhir/response-code"),
    FATAL_ERROR("fatal-error", "http://hl7.org/fhir/response-code");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/response-code";
    public static final String VALUESET_NAME = "ResponseType";
    private static Map<String, ResponseTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ResponseTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ResponseTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ResponseTypeEnum forCode(String theCode) {
        ResponseTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ResponseTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ResponseTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ResponseTypeEnum>>();
        for (ResponseTypeEnum next : ResponseTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ResponseTypeEnum>(){

            public String toCodeString(ResponseTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ResponseTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public ResponseTypeEnum fromCodeString(String theCodeString) {
                return (ResponseTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ResponseTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ResponseTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

