/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum OrderOutcomeStatusEnum {
    PENDING("pending", "http://hl7.org/fhir/order-outcome-code"),
    REVIEW("review", "http://hl7.org/fhir/order-outcome-code"),
    REJECTED("rejected", "http://hl7.org/fhir/order-outcome-code"),
    ERROR("error", "http://hl7.org/fhir/order-outcome-code"),
    ACCEPTED("accepted", "http://hl7.org/fhir/order-outcome-code"),
    CANCELLED("cancelled", "http://hl7.org/fhir/order-outcome-code"),
    REPLACED("replaced", "http://hl7.org/fhir/order-outcome-code"),
    ABORTED("aborted", "http://hl7.org/fhir/order-outcome-code"),
    COMPLETE("complete", "http://hl7.org/fhir/order-outcome-code");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/order-outcome-code";
    public static final String VALUESET_NAME = "OrderOutcomeStatus";
    private static Map<String, OrderOutcomeStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, OrderOutcomeStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<OrderOutcomeStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static OrderOutcomeStatusEnum forCode(String theCode) {
        OrderOutcomeStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private OrderOutcomeStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, OrderOutcomeStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, OrderOutcomeStatusEnum>>();
        for (OrderOutcomeStatusEnum next : OrderOutcomeStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<OrderOutcomeStatusEnum>(){

            public String toCodeString(OrderOutcomeStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(OrderOutcomeStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public OrderOutcomeStatusEnum fromCodeString(String theCodeString) {
                return (OrderOutcomeStatusEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public OrderOutcomeStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (OrderOutcomeStatusEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

