/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum EncounterTypeEnum {
    ANNUAL_DIABETES_MELLITUS_SCREENING("ADMS", "http://hl7.org/fhir/encounter-type"),
    BONE_DRILLING_BONE_MARROW_PUNCTION_IN_CLINIC("BD/BM-clin", "http://hl7.org/fhir/encounter-type"),
    INFANT_COLON_SCREENING___60_MINUTES("CCS60", "http://hl7.org/fhir/encounter-type"),
    OUTPATIENT_KENACORT_INJECTION("OKI", "http://hl7.org/fhir/encounter-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/encounter-type";
    public static final String VALUESET_NAME = "EncounterType";
    private static Map<String, EncounterTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, EncounterTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<EncounterTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static EncounterTypeEnum forCode(String theCode) {
        EncounterTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private EncounterTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, EncounterTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, EncounterTypeEnum>>();
        for (EncounterTypeEnum next : EncounterTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<EncounterTypeEnum>(){

            public String toCodeString(EncounterTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(EncounterTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public EncounterTypeEnum fromCodeString(String theCodeString) {
                return (EncounterTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public EncounterTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (EncounterTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

