/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum EncounterStateEnum {
    PLANNED("planned", "http://hl7.org/fhir/encounter-state"),
    IN_PROGRESS("in progress", "http://hl7.org/fhir/encounter-state"),
    ONLEAVE("onleave", "http://hl7.org/fhir/encounter-state"),
    FINISHED("finished", "http://hl7.org/fhir/encounter-state"),
    CANCELLED("cancelled", "http://hl7.org/fhir/encounter-state");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/encounter-state";
    public static final String VALUESET_NAME = "EncounterState";
    private static Map<String, EncounterStateEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, EncounterStateEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<EncounterStateEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static EncounterStateEnum forCode(String theCode) {
        EncounterStateEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private EncounterStateEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, EncounterStateEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, EncounterStateEnum>>();
        for (EncounterStateEnum next : EncounterStateEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<EncounterStateEnum>(){

            public String toCodeString(EncounterStateEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(EncounterStateEnum theEnum) {
                return theEnum.getSystem();
            }

            public EncounterStateEnum fromCodeString(String theCodeString) {
                return (EncounterStateEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public EncounterStateEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (EncounterStateEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

